/*
 * Decompiled with CFR 0.152.
 */
import datasets.Destination;
import datasets.DisplayData;
import datasets.SpeakerData;
import java.io.File;

public class Call
implements UserInterface {
    private Destination destination;
    private String toegang;
    private String mediaFile;
    private String dataDir = "data/";
    private String soundsDir = this.dataDir + "sounds/";
    private boolean debugging = false;
    SoftPhone softphone;
    private Thread softphoneThread;
    private AudioTool audioTool;
    private Vergunning vergunning;
    private Call mySoftPhoneCLI;
    private File file;
    private String vergunningDir;
    private String databasesDir;
    private String configDir;
    private String binDir;
    private String logDir;
    private String fileSeparator;
    private String lineTerminator;
    private String platform;
    public static final int SIPSTATE_OFF = 0;
    public static final int SIPSTATE_ON = 1;
    public static final int SIPSTATE_IDLE = 2;
    public static final int SIPSTATE_WAIT_PROV = 3;
    public static final int SIPSTATE_WAIT_FINAL = 4;
    public static final int SIPSTATE_WAIT_ACK = 5;
    public static final int SIPSTATE_RINGING = 6;
    public static final int SIPSTATE_ESTABLISHED = 7;
    public static final int SIPSTATE_TRANSITION_LOCALCANCEL = 8;
    public static final int SIPSTATE_TRANSITION_REMOTECANCEL = 9;
    public static final int SIPSTATE_TRANSITION_LOCALBUSY = 10;
    public static final int SIPSTATE_TRANSITION_REMOTEBUSY = 11;
    public static final int SIPSTATE_TRANSITION_LOCALBYE = 12;
    public static final int SIPSTATE_TRANSITION_REMOTEBYE = 13;
    public static final int SIPSTATE_TRANSITION_CONFIG = 14;
    public static final String[] SIPSTATE_DESCRIPTION = new String[]{"SIPSTATE_OFF", "SIPSTATE_ON", "SIPSTATE_IDLE", "SIPSTATE_WAIT_PROV", "SIPSTATE_WAIT_FINAL", "SIPSTATE_WAIT_ACK", "SIPSTATE_RINGING", "SIPSTATE_ESTABLISHED", "SIPSTATE_TRANSITION_LOCALCANCEL", "SIPSTATE_TRANSITION_REMOTECANCEL", "SIPSTATE_TRANSITION_LOCALBUSY", "SIPSTATE_TRANSITION_REMOTEBUSY", "SIPSTATE_TRANSITION_LOCALBYE", "SIPSTATE_TRANSITION_REMOTEBYE", "SIPSTATE_TRANSITION_CONFIG"};
    public static final int SOFTPHONE_ACTIVITY_NORMAL = 0;
    public static final int SOFTPHONE_ACTIVITY_REGISTRATION = 1;
    public static final int SOFTPHONE_ACTIVITY_MAINTENANCE = 2;
    public static final int SOFTPHONE_ACTIVITY_REFRESH = 3;
    public static final int LOGINSTATE_UNREGISTERED = 0;
    public static final int LOGINSTATE_REGISTERED = 1;
    private final int LINE1BUTTON = 0;
    private final int LINE2BUTTON = 1;
    private final int SAVEBUTTON = 2;
    private final int REGISTERBUTTON = 3;
    private final int ANSWERBUTTON = 4;
    private final int CANCELBUTTON = 5;
    private final int RANDOMRINGRESPONSEBUTTON = 6;
    private final int ENDTIMERBUTTON = 7;
    private final int MUTEAUDIOBUTTON = 8;
    private final int DEBUGBUTTON = 9;
    private final int CALLBUTTON = 10;
    private final int ENDBUTTON = 11;
    private final DisplayData displayData;
    private final SpeakerData speakerData;

    public Call(String phoneNumberParam, String soundfileParam, boolean debuggingParam) {
        this.debugging = debuggingParam;
        String[] status = new String[]{"0", ""};
        this.platform = System.getProperty("os.name").toLowerCase();
        if (this.platform.indexOf("windows") != -1) {
            this.fileSeparator = "\\";
            this.lineTerminator = "\r\n";
        } else {
            this.fileSeparator = "/";
            this.lineTerminator = "\r\n";
        }
        this.dataDir = "data" + this.fileSeparator;
        this.soundsDir = this.dataDir + "sounds" + this.fileSeparator;
        this.vergunningDir = this.dataDir + "license" + this.fileSeparator;
        this.databasesDir = this.dataDir + "databases" + this.fileSeparator;
        this.configDir = this.dataDir + "config" + this.fileSeparator;
        this.binDir = this.dataDir + "bin" + this.fileSeparator;
        this.logDir = this.dataDir + "log" + this.fileSeparator;
        this.file = new File(this.dataDir);
        if (!this.file.exists() && new File(this.dataDir).mkdir()) {
            System.out.println("Warning:  Creating Directory: " + this.dataDir);
        }
        this.file = new File(this.soundsDir);
        if (!this.file.exists() && new File(this.soundsDir).mkdir()) {
            System.out.println("Critical: Creating Directory: " + this.soundsDir);
        }
        this.file = new File(this.vergunningDir);
        if (!this.file.exists() && new File(this.vergunningDir).mkdir()) {
            System.out.println("Info:     Creating Directory: " + this.vergunningDir);
        }
        this.file = new File(this.databasesDir);
        if (!this.file.exists() && new File(this.databasesDir).mkdir()) {
            System.out.println("Info:     Creating Directory: " + this.databasesDir);
        }
        this.file = new File(this.configDir);
        if (!this.file.exists() && new File(this.configDir).mkdir()) {
            System.out.println("Info:     Creating Directory: " + this.configDir);
        }
        this.file = new File(this.binDir);
        if (!this.file.exists() && new File(this.binDir).mkdir()) {
            System.out.println("Critical: Creating Directory: " + this.binDir);
        }
        this.file = new File(this.logDir);
        if (!this.file.exists() && new File(this.logDir).mkdir()) {
            System.out.println("Info:     Creating Directory: " + this.logDir);
        }
        this.audioTool = new AudioTool();
        this.displayData = new DisplayData();
        this.speakerData = new SpeakerData();
        this.destination = new Destination();
        this.destination.setDestination(phoneNumberParam);
        this.mediaFile = "file:" + soundfileParam;
        this.power();
        this.call();
    }

    private void power() {
        String[] status = new String[]{"0", ""};
        this.softphoneThread = new Thread();
        this.softphoneThread = new SoftPhone(this, 0, this.debugging);
        this.softphoneThread.setDaemon(true);
        this.softphoneThread.setPriority(9);
        this.softphoneThread.start();
        this.softphone = (SoftPhone)this.softphoneThread;
        this.softphone.setDestination(this.destination);
        this.softphone.setDebugging(this.debugging, 1);
        status = this.softphone.userInput(0, "1", "1", "");
        if (status[0].equals("1")) {
            this.audioTool.play(this.audioTool.getFailuretoneClip());
            this.showStatus("Line1 Error: " + status[1], true, true);
        } else {
            this.audioTool.play(this.audioTool.getSuccesstoneClip());
        }
    }

    private void call() {
        String[] status = new String[]{"0", ""};
        this.showStatus("Calling: " + VoipStormTools.validateSIPAddress(this.destination.getDestination()) + " playing: " + this.mediaFile, false, false);
        status = this.softphone.userInput(10, VoipStormTools.validateSIPAddress(this.destination.getDestination()), this.mediaFile, "");
        if (status[0].equals("1")) {
            this.showStatus("Call Failure: " + status[1], false, false);
        }
    }

    @Override
    public synchronized void speaker(SpeakerData speakerParam) {
        if (speakerParam.getDialToneFlag()) {
            this.audioTool.play(this.audioTool.getDialtoneClip());
        }
        if (speakerParam.getCallToneFlag()) {
            this.audioTool.playLoop(this.audioTool.getCalltoneClip());
        } else {
            this.audioTool.stop(this.audioTool.getCalltoneClip());
        }
        if (speakerParam.getBusyToneFlag()) {
            this.audioTool.stop(this.audioTool.getCalltoneClip());
            this.audioTool.play(this.audioTool.getBusytoneClip());
        }
        if (speakerParam.getDeadToneFlag()) {
            this.audioTool.stop(this.audioTool.getCalltoneClip());
            this.audioTool.play(this.audioTool.getDeadtoneClip());
        }
        if (speakerParam.getErrorToneFlag()) {
            this.audioTool.stop(this.audioTool.getCalltoneClip());
            this.audioTool.play(this.audioTool.getErrortoneClip());
        }
        if (speakerParam.getRingToneFlag()) {
            this.audioTool.playLoop(this.audioTool.getRingtoneClip());
        } else {
            this.audioTool.stop(this.audioTool.getRingtoneClip());
        }
        if (speakerParam.getRegisterEnabledToneFlag()) {
            this.audioTool.play(this.audioTool.getRegisterenabledtoneClip());
        }
        if (speakerParam.getRegisterDisabledToneFlag()) {
            this.audioTool.play(this.audioTool.getRegisterdisabledtoneClip());
        }
        if (speakerParam.getAnswerEnabledToneFlag()) {
            this.audioTool.play(this.audioTool.getAnswerenabledtoneClip());
        }
        if (speakerParam.getAnswerDisabledToneFlag()) {
            this.audioTool.play(this.audioTool.getAnswerdisabledtoneClip());
        }
        if (speakerParam.getCancelEnabledToneFlag()) {
            this.audioTool.play(this.audioTool.getCancelenabledClip());
        }
        if (speakerParam.getCancelDisabledToneFlag()) {
            this.audioTool.play(this.audioTool.getCanceldisabledClip());
        }
        if (speakerParam.getMuteEnabledToneFlag()) {
            this.audioTool.play(this.audioTool.getMuteenabledClip());
        }
        if (speakerParam.getMuteDisabledToneFlag()) {
            this.audioTool.play(this.audioTool.getMutedisabledClip());
        }
    }

    @Override
    public void phoneDisplay(DisplayData displayParam) {
    }

    @Override
    public void showStatus(String messageParam, boolean logToApplicationParam, boolean logToFileParam) {
        System.out.println(messageParam);
    }

    @Override
    public void logToApplication(String message) {
        System.out.println(message);
    }

    @Override
    public void logToFile(String message) {
    }

    @Override
    public void resetLog() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void sipstateUpdate(int sipstateParam, int lastsipstateParam, int loginstateParam, int softphoneActivityParam, int softPhoneInstanceIdParam, Destination destinationParam) {
        if (sipstateParam == 2 && lastsipstateParam == 13) {
            System.out.println("Call Ended Remotely. Exiting");
            System.exit(0);
        }
    }

    @Override
    public void responseUpdate(int responseCodeParam, String responseReasonPhraseParam, int softPhoneInstanceIdParam, Destination destinationParam) {
    }

    public static void main(String[] args) throws CloneNotSupportedException {
        if (args.length != 2 && args.length != 3) {
            System.out.println("Usage: java -cp VoipStorm.jar Call \"phonenumber\" \"data/sounds/voipstorm.wav\" [debugging]\n");
            System.out.println("Example: java -cp VoipStorm.jar Call 2000 \"data/sounds/voipstorm.wav\" &\n");
            System.out.println("Example: perl -e 'for ( $length=2000; $length < 2020; $length++) { print \"$length\\n\"; }' | while read phonenumber;do (java -cp VoipStorm.jar Call \"$phonenumber\" \"data/sounds/voipstorm.wav\" & ) ; done");
        } else {
            String destination = args[0];
            String mediaFile = args[1];
            boolean debugging = false;
            if (args.length == 3) {
                debugging = args[2].equals("debugging");
            }
            Call call = new Call(destination, mediaFile, debugging);
        }
    }

    @Override
    public void feedback(String messageParam, int valueParam) {
    }
}

