/*
 * Decompiled with CFR 0.152.
 */
import datasets.TimeTool;
import datechooser.beans.DateChooserPanel;
import datechooser.events.SelectionChangedEvent;
import datechooser.events.SelectionChangedListener;
import datechooser.model.multiple.MultyModelBehavior;
import datechooser.view.appearance.AppearancesList;
import datechooser.view.appearance.ViewAppearance;
import datechooser.view.appearance.swing.ButtonPainter;
import datechooser.view.appearance.swing.LabelPainter;
import datechooser.view.appearance.swing.SwingCellAppearance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class CampaignCalendar
extends JFrame {
    private TimeTool timeTool;
    private Calendar calendar;
    private Manager manager;
    public DateChooserPanel dateChooserPanel;
    private JPanel dateSelectorPanel;
    private JButton doneButton;
    JSlider hourSlider;
    JSlider minuteSlider;
    private JTextField timeField;
    private JPanel timeSelectorPanel;

    public CampaignCalendar() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        this.initComponents();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.timeTool = new TimeTool();
        this.calendar = Calendar.getInstance();
        this.hourSlider.setValue(this.calendar.get(11));
        this.minuteSlider.setValue(this.calendar.get(12));
        this.setTimeField(this.calendar);
    }

    public CampaignCalendar(Manager eCallCenterGUIParam) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        this.initComponents();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.timeTool = new TimeTool();
        this.calendar = Calendar.getInstance();
        this.manager = eCallCenterGUIParam;
        this.hourSlider.setValue(this.calendar.get(11));
        this.minuteSlider.setValue(this.calendar.get(12));
        this.setTimeField(this.calendar);
    }

    public CampaignCalendar(Manager eCallCenterGUIParam, Long epochParam) {
        this(eCallCenterGUIParam);
        this.calendar.setTimeInMillis(epochParam);
        this.dateChooserPanel.setSelectedDate(this.calendar);
        this.hourSlider.setValue(this.calendar.get(11));
        this.minuteSlider.setValue(this.calendar.get(12));
    }

    private void initComponents() {
        this.dateSelectorPanel = new JPanel();
        this.dateChooserPanel = new DateChooserPanel();
        this.timeSelectorPanel = new JPanel();
        this.hourSlider = new JSlider();
        this.minuteSlider = new JSlider();
        this.timeField = new JTextField();
        this.doneButton = new JButton();
        this.setBackground(new Color(216, 216, 222));
        this.setCursor(new Cursor(0));
        this.dateSelectorPanel.setBorder(BorderFactory.createTitledBorder(null, "Start Date Selector", 2, 2, new Font("STHeiti", 0, 14)));
        this.dateSelectorPanel.setFont(new Font("STHeiti", 0, 12));
        this.dateChooserPanel.setCurrentView(new AppearancesList("Bordered", new ViewAppearance("custom", new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(0, 0, 0), new Color(0, 0, 255), false, true, new ButtonPainter()), new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(0, 0, 0), new Color(0, 0, 255), true, true, new ButtonPainter()), new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(0, 0, 255), new Color(0, 0, 255), false, true, new ButtonPainter()), new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(128, 128, 128), new Color(0, 0, 255), false, true, new LabelPainter()), new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(0, 0, 0), new Color(0, 0, 255), false, true, new LabelPainter()), new SwingCellAppearance(new Font("Lucida Grande", 0, 13), new Color(0, 0, 0), new Color(255, 0, 0), false, false, new ButtonPainter()), null, false, true)));
        this.dateChooserPanel.setLocale(new Locale("en", "", ""));
        this.dateChooserPanel.setNavigateFont(new Font("STHeiti", 0, 10));
        this.dateChooserPanel.setBehavior(MultyModelBehavior.SELECT_SINGLE);
        this.dateChooserPanel.addSelectionChangedListener(new SelectionChangedListener(){

            @Override
            public void onSelectionChange(SelectionChangedEvent evt) {
                CampaignCalendar.this.dateChooserPanelOnSelectionChange(evt);
            }
        });
        GroupLayout dateSelectorPanelLayout = new GroupLayout((Container)this.dateSelectorPanel);
        this.dateSelectorPanel.setLayout((LayoutManager)dateSelectorPanelLayout);
        dateSelectorPanelLayout.setHorizontalGroup((GroupLayout.Group)dateSelectorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dateSelectorPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.dateChooserPanel, -2, 282, -2).addContainerGap()));
        dateSelectorPanelLayout.setVerticalGroup((GroupLayout.Group)dateSelectorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)dateSelectorPanelLayout.createSequentialGroup().add((Component)this.dateChooserPanel, -2, 226, -2).addContainerGap()));
        this.timeSelectorPanel.setBorder(BorderFactory.createTitledBorder(null, "Start Time Selector", 2, 2, new Font("STHeiti", 0, 14)));
        this.timeSelectorPanel.setFont(new Font("STHeiti", 0, 13));
        this.hourSlider.setFont(new Font("STHeiti", 0, 10));
        this.hourSlider.setMajorTickSpacing(1);
        this.hourSlider.setMaximum(23);
        this.hourSlider.setMinorTickSpacing(1);
        this.hourSlider.setOrientation(1);
        this.hourSlider.setPaintLabels(true);
        this.hourSlider.setPaintTicks(true);
        this.hourSlider.setSnapToTicks(true);
        this.hourSlider.setValue(12);
        this.hourSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CampaignCalendar.this.hourSliderStateChanged(evt);
            }
        });
        this.minuteSlider.setFont(new Font("STHeiti", 0, 10));
        this.minuteSlider.setMajorTickSpacing(5);
        this.minuteSlider.setMaximum(59);
        this.minuteSlider.setMinorTickSpacing(1);
        this.minuteSlider.setOrientation(1);
        this.minuteSlider.setPaintLabels(true);
        this.minuteSlider.setPaintTicks(true);
        this.minuteSlider.setSnapToTicks(true);
        this.minuteSlider.setValue(30);
        this.minuteSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CampaignCalendar.this.minuteSliderStateChanged(evt);
            }
        });
        this.timeField.setBackground(new Color(0, 0, 0));
        this.timeField.setFont(new Font("Synchro LET", 0, 24));
        this.timeField.setForeground(new Color(255, 204, 0));
        this.timeField.setText("TIME");
        this.timeField.setHorizontalAlignment(0);
        GroupLayout timeSelectorPanelLayout = new GroupLayout((Container)this.timeSelectorPanel);
        this.timeSelectorPanel.setLayout((LayoutManager)timeSelectorPanelLayout);
        timeSelectorPanelLayout.setHorizontalGroup((GroupLayout.Group)timeSelectorPanelLayout.createParallelGroup(1).add((GroupLayout.Group)timeSelectorPanelLayout.createSequentialGroup().add((GroupLayout.Group)timeSelectorPanelLayout.createParallelGroup(2).add(1, (GroupLayout.Group)timeSelectorPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.timeField, -1, 176, Short.MAX_VALUE)).add(1, (GroupLayout.Group)timeSelectorPanelLayout.createSequentialGroup().add(41, 41, 41).add((Component)this.hourSlider, -2, -1, -2).addPreferredGap(1).add((Component)this.minuteSlider, -2, -1, -2))).addContainerGap()));
        timeSelectorPanelLayout.setVerticalGroup((GroupLayout.Group)timeSelectorPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)timeSelectorPanelLayout.createSequentialGroup().add((Component)this.timeField, -2, 35, -2).addPreferredGap(0).add((GroupLayout.Group)timeSelectorPanelLayout.createParallelGroup(1).add((Component)this.minuteSlider, -1, 191, Short.MAX_VALUE).add((Component)this.hourSlider, -1, 191, Short.MAX_VALUE))));
        this.doneButton.setFont(new Font("STHeiti", 1, 18));
        this.doneButton.setText("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CampaignCalendar.this.doneButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.doneButton, -1, 512, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dateSelectorPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.timeSelectorPanel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.timeSelectorPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.dateSelectorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.doneButton, -2, 55, -2).addContainerGap()));
        this.pack();
    }

    private void dateChooserPanelOnSelectionChange(SelectionChangedEvent evt) {
        this.calendar = this.dateChooserPanel.getSelectedDate();
        this.calendar.set(11, this.hourSlider.getValue());
        this.calendar.set(12, this.minuteSlider.getValue());
        this.calendar.set(13, 0);
        this.setTimeField(this.calendar);
    }

    private void hourSliderStateChanged(ChangeEvent evt) {
        this.calendar.set(11, this.hourSlider.getValue());
        this.calendar.set(12, this.minuteSlider.getValue());
        this.calendar.set(13, 0);
        this.setTimeField(this.calendar);
    }

    private void minuteSliderStateChanged(ChangeEvent evt) {
        this.calendar.set(11, this.hourSlider.getValue());
        this.calendar.set(12, this.minuteSlider.getValue());
        this.calendar.set(13, 0);
        this.setTimeField(this.calendar);
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.manager.orderButtonsControl();
    }

    private void setTimeField(Calendar calendarParam) {
        this.timeField.setText(String.format("%02d", this.hourSlider.getValue()) + ":" + String.format("%02d", this.minuteSlider.getValue()));
        this.manager.orderDateField.setText(Long.toString(this.calendar.getTimeInMillis()));
        if (this.calendar.getTimeInMillis() <= Calendar.getInstance().getTimeInMillis() + (long)Math.round((float)Integer.parseInt(this.manager.orderDestinationsQuantityField.getText()) * this.manager.preparationFactor)) {
            this.manager.confirmOrderButton.setEnabled(false);
        } else if (this.manager.destinationTextArea.isEnabled() && this.manager.destinationTextArea.getLineCount() > 1) {
            this.manager.confirmOrderButton.setEnabled(true);
        }
    }

    public void setStartTimeWindow(int earliestTimewindowIndexParam) {
        TimeTool timeTool = new TimeTool();
        this.hourSlider.setMinimum(timeTool.getTimeWindow(earliestTimewindowIndexParam).getStartHour());
        this.hourSlider.setMaximum(timeTool.getTimeWindow(earliestTimewindowIndexParam).getEndHour());
    }
}

