/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class DashboardMeter
implements ChangeListener {
    private ChartPanel chartPanel;
    protected JFreeChart chart;
    private StandardDialScale standardDialScale;
    private DialPlot dialPlot;
    private StandardDialRange standardDialRangeRed;
    private StandardDialRange standardDialRangeOrange;
    private StandardDialRange standardDialRangeGreen;
    private DefaultValueDataset dataset = new DefaultValueDataset(0.0);
    private DefaultValueDataset vmUsageDataset;
    private int vmUsageScaleRange = 100;

    public DashboardMeter(String title, String annotation, double startValue, double endValue, double majorTickIncrement, boolean systemLoad) {
        if (systemLoad) {
            this.vmUsageDataset = new DefaultValueDataset(50.0);
        }
        this.dialPlot = new DialPlot();
        this.dialPlot.setDataset((ValueDataset)this.dataset);
        if (systemLoad) {
            this.dialPlot.setDataset(1, (ValueDataset)this.vmUsageDataset);
        }
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setRadius(0.97);
        dialFrame.setForegroundPaint((Paint)Color.darkGray);
        dialFrame.setStroke((Stroke)new BasicStroke(1.0f));
        this.dialPlot.setDialFrame((DialFrame)dialFrame);
        GradientPaint gp = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 170));
        DialBackground sdb = new DialBackground((Paint)gp);
        sdb.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        this.dialPlot.addLayer((DialLayer)sdb);
        DialValueIndicator dialValueIndicator = new DialValueIndicator(0);
        dialValueIndicator.setFont(new Font("STHeiti", 0, 16));
        dialValueIndicator.setOutlinePaint((Paint)Color.BLACK);
        dialValueIndicator.setRadius(0.73);
        dialValueIndicator.setAngle(-90.0);
        this.dialPlot.addLayer((DialLayer)dialValueIndicator);
        this.standardDialScale = new StandardDialScale(startValue, endValue, -120.0, -300.0, 10.0, 10);
        this.standardDialScale.setTickRadius(0.88);
        this.standardDialScale.setTickLabelOffset(0.2);
        this.standardDialScale.setMajorTickIncrement(majorTickIncrement);
        this.standardDialScale.setTickLabelPaint((Paint)Color.BLACK);
        this.standardDialScale.setMajorTickPaint((Paint)Color.BLUE);
        this.standardDialScale.setTickLabelFont(new Font("STHeiti", 0, 16));
        this.dialPlot.addScale(0, (DialScale)this.standardDialScale);
        if (systemLoad) {
            StandardDialScale vmUsageScale = new StandardDialScale(0.0, (double)this.vmUsageScaleRange, -120.0, -300.0, 10.0, 10);
            vmUsageScale.setMajorTickPaint((Paint)Color.red);
            vmUsageScale.setTickRadius(0.5);
            vmUsageScale.setTickLabelOffset(0.15);
            vmUsageScale.setTickLabelFont(new Font("STHeiti", 0, 11));
            this.dialPlot.addScale(1, (DialScale)vmUsageScale);
            this.dialPlot.mapDatasetToScale(1, 1);
        }
        this.addColorScale(startValue, endValue * 0.333, endValue * 0.333, endValue * 0.666, endValue * 0.666, endValue);
        DialTextAnnotation annotation1 = new DialTextAnnotation(annotation);
        annotation1.setFont(new Font("Courier", 0, 18));
        annotation1.setRadius(0.4);
        this.dialPlot.addLayer((DialLayer)annotation1);
        DialPointer.Pointer needle = new DialPointer.Pointer(0);
        needle.setRadius(0.8);
        this.dialPlot.addLayer((DialLayer)needle);
        DialPointer.Pin vmUsageNeedle = new DialPointer.Pin(1);
        vmUsageNeedle.setRadius(0.55);
        this.dialPlot.addLayer((DialLayer)vmUsageNeedle);
        DialCap cap = new DialCap();
        cap.setRadius(0.1);
        this.dialPlot.setCap((DialLayer)cap);
        this.chart = new JFreeChart((Plot)this.dialPlot);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setFont(new Font("STHeiti", 0, 10));
        this.chartPanel.setPreferredSize(new Dimension(100, 115));
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.chartPanel);
    }

    public Number getValue() {
        return this.dataset.getValue();
    }

    public Number getVMUsageValue() {
        return this.vmUsageDataset.getValue();
    }

    public void setValue(Number valueParam) {
        this.dataset.setValue(valueParam);
    }

    public void setVMUsageValue(Number valueParam) {
        this.vmUsageDataset.setValue(valueParam);
    }

    public void setScale(double startValue, double endValue, double majorTickIncrement) {
        this.standardDialScale.setLowerBound(startValue);
        this.standardDialScale.setUpperBound(endValue);
        this.standardDialScale.setMajorTickIncrement(majorTickIncrement);
    }

    public void addColorScale(double redStart, double redEnd, double orangeStart, double orangeEnd, double greenStart, double greenEnd) {
        double innerRadius = 0.0;
        double outerRadius = 0.5;
        this.standardDialRangeRed = new StandardDialRange(redStart, redEnd, (Paint)Color.red);
        this.standardDialRangeRed.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
        this.standardDialRangeOrange = new StandardDialRange(orangeStart, orangeEnd, (Paint)Color.orange);
        this.standardDialRangeOrange.setInnerRadius(innerRadius);
        this.standardDialRangeOrange.setOuterRadius(outerRadius);
        this.standardDialRangeGreen = new StandardDialRange(greenStart, greenEnd, (Paint)Color.green);
        this.standardDialRangeGreen.setInnerRadius(innerRadius);
        this.standardDialRangeGreen.setOuterRadius(outerRadius);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeRed);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeOrange);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeGreen);
    }

    public void setColorScale(double redStart, double redEnd, double orangeStart, double orangeEnd, double greenStart, double greenEnd) {
        double innerRadius = 0.0;
        double outerRadius = 0.5;
        this.standardDialRangeRed.setBounds(redStart, redEnd);
        this.standardDialRangeOrange.setBounds(orangeStart, orangeEnd);
        this.standardDialRangeGreen.setBounds(greenStart, greenEnd);
        this.standardDialRangeGreen.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
        this.standardDialRangeOrange.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
        this.standardDialRangeRed.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
    }

    public void removeColorScale() {
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeRed);
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeOrange);
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeGreen);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

