/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.jdesktop.layout.GroupLayout;

public class FileBrowser
extends JFrame {
    private String platform;
    private String fileSeparator;
    private File file;
    private File directory;
    private Manager manager;
    private ExtensionFilter extensionFilter;
    private JFileChooser fileChooser;

    public FileBrowser() {
        this.initComponents();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = this.getWidth();
        int winHeight = this.getHeight();
        int posX = Math.round(screenDim.width / 2 - winWidth / 2);
        int posY = Math.round(screenDim.height / 2 - winHeight / 2);
        this.setLocation(posX, posY);
        this.file = new File("");
        this.directory = new File("");
        this.platform = System.getProperty("os.name").toLowerCase();
        this.fileSeparator = this.platform.indexOf("windows") != -1 ? "\\" : "/";
        try {
            this.directory = new File(new File(".").getCanonicalPath() + this.fileSeparator + "data" + this.fileSeparator + "sounds");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileChooser.setCurrentDirectory(this.directory);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.extensionFilter = new ExtensionFilter(".wav", "Sound files (*.wav)");
        this.fileChooser.addChoosableFileFilter(this.extensionFilter);
        this.fileChooser.setFileFilter(this.extensionFilter);
    }

    public FileBrowser(Manager eCallCenterManagerParam) {
        this();
        this.manager = eCallCenterManagerParam;
    }

    private void initComponents() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(null);
        this.fileChooser.setDialogTitle("Select SoundFile (*.wav)");
        this.fileChooser.setFileFilter(null);
        this.fileChooser.setFont(new Font("STHeiti", 0, 13));
        this.fileChooser.setToolTipText("");
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileBrowser.this.fileChooserActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fileChooser, -2, -1, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.fileChooser, -2, 394, -2));
        this.pack();
    }

    private void fileChooserActionPerformed(ActionEvent evt) {
        this.manager.setSoundFile(this.fileChooser.getCurrentDirectory() + File.separator + this.fileChooser.getName(this.fileChooser.getSelectedFile()));
        this.setVisible(false);
        this.manager.updateOrder();
        this.manager.orderButtonsControl();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileBrowser().setVisible(true);
            }
        });
    }
}

