/*
 * Decompiled with CFR 0.152.
 */
import datasets.Campaign;
import datasets.CampaignStat;
import datasets.Configuration;
import datasets.Customer;
import datasets.Destination;
import datasets.Invoice;
import datasets.Order;
import datasets.Pricelist;
import datasets.Reseller;
import datasets.TimeTool;
import datechooser.model.multiple.Period;
import datechooser.model.multiple.PeriodSet;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;

public class JavaDBClient {
    private boolean dbServerTest = true;
    private UserInterface userInterface;
    private Manager managerReference;
    public static final String DERBY_CLIENT_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    private static final String DERBY_CLIENT_DS = "org.apache.derby.jdbc.ClientDataSource";
    String jdbcDriver = "org.apache.derby.jdbc.ClientDriver";
    String jdbcDataSource = "org.apache.derby.jdbc.ClientDataSource";
    private ArrayList statements = new ArrayList();
    private PreparedStatement psInsertCustomer = null;
    private PreparedStatement psUpdateCustomer = null;
    private PreparedStatement psInsertReseller = null;
    private PreparedStatement psUpdateReseller = null;
    private PreparedStatement psInsertOrder = null;
    private PreparedStatement psUpdateOrder = null;
    private PreparedStatement psInsertInvoice = null;
    private PreparedStatement psUpdateInvoice = null;
    private PreparedStatement psInsertCampaign = null;
    private PreparedStatement psUpdateCampaign = null;
    private PreparedStatement psInsertDestination = null;
    private PreparedStatement psUpdateDestination = null;
    private PreparedStatement psInsertCampaignStat = null;
    private PreparedStatement psUpdateCampaignStat = null;
    private PreparedStatement psInsertPricelist = null;
    private PreparedStatement psUpdatePricelist = null;
    private final String protocol = "jdbc:derby:";
    private final String dbServerAddress = "//127.0.0.1:1527/";
    private String database = "";
    private final String attributes = ";create=false";
    private final String url = "jdbc:derby://127.0.0.1:1527/" + this.database + ";create=false";
    private final String user = "dbadmin";
    private final String toegang = "IsNwtNp4DB";
    private Thread dbServerThread;
    private ResultSetMetaData resultsetmetadata = null;
    boolean runThreadsAsDaemons = true;
    private Connection connection = null;
    private int destinationLoadLimit = 250000;
    private Properties props;

    public JavaDBClient(UserInterface userInterfaceParam, String databaseParam) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, Exception {
        this.userInterface = userInterfaceParam;
        String[] status = new String[2];
        status = new String[2];
        this.database = databaseParam;
        System.setProperty("derby.system.home", Configuration.getDatabasesDir());
        this.props = new Properties();
        this.props.setProperty("derby.system.home", Configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.database);
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        this.loadDriver();
        this.connection = this.initDatabaseClientServer();
        this.userInterface.feedback("db_client_connecting", 0);
        this.test(this.connection);
        this.connection.setAutoCommit(false);
        this.userInterface.feedback("db_client_connected", 0);
        this.checkTables();
        this.initPrepareStatements();
    }

    public void loadDriver() {
        try {
            Class.forName(this.jdbcDriver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.userInterface.showStatus("JavaDB Database Client Failed Loading Driver " + this.jdbcDriver, true, true);
            cnfe.printStackTrace(System.err);
        }
        catch (InstantiationException ie) {
            this.userInterface.showStatus("JavaDB Database Client Failed Instantiate JDBC driver " + this.jdbcDriver, true, true);
            ie.printStackTrace(System.err);
        }
        catch (IllegalAccessException iae) {
            this.userInterface.showStatus("JavaDB Database Client NOT Allowed Access to JDBC Driver " + this.jdbcDriver, true, true);
            iae.printStackTrace(System.err);
        }
    }

    public Connection initDatabaseClientServer() {
        Connection tmpConnection = null;
        boolean dbServerStarted = false;
        boolean dbServerRunning = true;
        do {
            dbServerRunning = true;
            try {
                tmpConnection = DriverManager.getConnection(this.url, this.props);
            }
            catch (SQLException ex) {
                dbServerRunning = false;
                if (!dbServerStarted) {
                    try {
                        new JavaDBServer(this.userInterface, this.database, this.dbServerTest);
                    }
                    catch (Exception ex2) {
                        this.userInterface.showStatus("JavaDB Database Server Failed to Start: " + ex2.getMessage(), true, true);
                    }
                    dbServerStarted = true;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!dbServerRunning);
        this.userInterface.showStatus("JavaDB Database Client Connection Opened", true, true);
        try {
            tmpConnection.clearWarnings();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: tmpConnection.clearWarnings()", true, true);
        }
        return tmpConnection;
    }

    public Connection getDriverClientConnection() {
        this.loadDriver();
        boolean notConnected = false;
        Connection tmpConnection = null;
        do {
            try {
                tmpConnection = DriverManager.getConnection(this.url, this.props);
            }
            catch (SQLException ex) {
                notConnected = true;
                this.userInterface.showStatus("JavaDB Database Client Connection Failed: " + ex.getMessage(), true, true);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (notConnected);
        return tmpConnection;
    }

    public void test(Connection conn) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select count(*) from sys.systables");
            while (rs.next()) {
                this.userInterface.showStatus("JavaDB Database Client Connection Established", true, true);
            }
        }
        catch (SQLException sqle) {
            this.userInterface.showStatus("JavaDB Database Client Connection NOT Established: " + sqle.getMessage(), true, true);
            throw sqle;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void shutdownDB(String databaseParam) {
        try {
            DriverManager.getConnection("jdbc:derby:" + databaseParam + ";password=" + "IsNwtNp4DB" + ";shutdown=true");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("JavaDB Database Server Failed to Shutdown: " + ex.getMessage(), true, true);
        }
    }

    public void dropDatabase(String databaseParam) {
        Statement statement = null;
        Object resultset = null;
        this.shutdownDB(databaseParam);
        try {
            statement.execute("DROP DATABASE " + databaseParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("JavaDB Database Client Failed to Drop Database: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void createCustomerTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: createCustomerTable(): connection.createStatement(): " + ex.getMessage());
            this.loadDriver();
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Customer( Id INT generated by default as identity (START WITH 0, INCREMENT BY 1),Timestamp BIGINT,CompanyName VARCHAR(100),Address VARCHAR(100),AddressNr VARCHAR(20),Postcode VARCHAR(20),City VARCHAR(100),Country VARCHAR(100),ContactName VARCHAR(100),PhoneNr VARCHAR(20),MobileNr VARCHAR(20),Email VARCHAR(100),Password VARCHAR(100),CustomerDiscount INT,Comment VARCHAR(4096) )");
        }
        catch (SQLException ex1) {
            this.userInterface.showStatus("Error: JavaDBClient.createCustomerTable(): " + ex1.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getCustomerCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.CUSTOMER");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerCount() resultset = statement.executeQuery(: " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient..getCustomerCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Customer selectCustomer(int idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Customer customer = new Customer();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Customer WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomer(int idParam): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                customer.setId(resultset.getInt(1));
                customer.setTimestamp(resultset.getLong(2));
                customer.setCompanyName(resultset.getString(3));
                customer.setAddress(resultset.getString(4));
                customer.setAddressNr(resultset.getString(5));
                customer.setpostcode(resultset.getString(6));
                customer.setCity(resultset.getString(7));
                customer.setCountry(resultset.getString(8));
                customer.setContactName(resultset.getString(9));
                customer.setPhoneNr(resultset.getString(10));
                customer.setMobileNr(resultset.getString(11));
                customer.setEmail(resultset.getString(12));
                customer.setPassword(resultset.getString(13));
                customer.setCustomerDiscount(resultset.getInt(14));
                customer.setComment(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomer(int idParam) while (resultset.next(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomer(int idParam) : connection.commit(): " + ex.getMessage(), true, true);
        }
        return customer;
    }

    public synchronized Customer selectLastCustomer() {
        Statement statement = null;
        ResultSet resultset = null;
        Customer customer = new Customer();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Customer ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomer(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                customer.setId(resultset.getInt(1));
                customer.setTimestamp(resultset.getLong(2));
                customer.setCompanyName(resultset.getString(3));
                customer.setAddress(resultset.getString(4));
                customer.setAddressNr(resultset.getString(5));
                customer.setpostcode(resultset.getString(6));
                customer.setCity(resultset.getString(7));
                customer.setCountry(resultset.getString(8));
                customer.setContactName(resultset.getString(9));
                customer.setPhoneNr(resultset.getString(10));
                customer.setMobileNr(resultset.getString(11));
                customer.setEmail(resultset.getString(12));
                customer.setPassword(resultset.getString(13));
                customer.setCustomerDiscount(resultset.getInt(14));
                customer.setComment(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomer(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomer() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return customer;
    }

    public synchronized String[] getCustomers() {
        Statement statement = null;
        ResultSet resultset = null;
        String[] customers = null;
        int numberOfCustomers = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Customer");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomers(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfCustomers = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomers(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomers() : connection.commit(): " + ex.getMessage(), true, true);
        }
        if (numberOfCustomers > 0) {
            int customerCounter = 0;
            customers = new String[numberOfCustomers];
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery("SELECT Id FROM APP.Customer");
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getCustomers(): " + ex.getMessage(), true, true);
            }
            try {
                while (resultset.next()) {
                    customers[customerCounter] = Integer.toString(resultset.getInt(1));
                    ++customerCounter;
                }
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getCustomers(): " + ex.getMessage(), true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
            }
        }
        return customers;
    }

    public synchronized void insertCustomer(Customer customerParam) {
        try {
            this.psInsertCustomer.setLong(1, customerParam.getTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(2, customerParam.getCompanyName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(3, customerParam.getAddress());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(4, customerParam.getAddressNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(5, customerParam.getpostcode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(6, customerParam.getCity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(7, customerParam.getCountry());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(8, customerParam.getContactName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(9, customerParam.getPhoneNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(10, customerParam.getMobileNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(11, customerParam.getEmail());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(12, customerParam.getPassword());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setInt(13, customerParam.getCustomerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().13: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.setString(14, customerParam.getComment());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer.execute();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomer().15: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateCustomer(Customer customerParam) {
        try {
            this.psUpdateCustomer.setString(1, customerParam.getCompanyName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(2, customerParam.getAddress());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(3, customerParam.getAddressNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(4, customerParam.getpostcode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(5, customerParam.getCity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(6, customerParam.getCountry());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(7, customerParam.getContactName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(8, customerParam.getPhoneNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(9, customerParam.getMobileNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(10, customerParam.getEmail());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(11, customerParam.getPassword());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setInt(12, customerParam.getCustomerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setString(13, customerParam.getComment());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().13: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.setInt(14, customerParam.getId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomer().15: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteCustomer(int idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: deleteCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Customer WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCustomer(int idParam): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropCustomerTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: dropCustomerTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Customer");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCustomerTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCustomerTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createResellerTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: createResellerTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Reseller( Id INT generated by default as identity (START WITH 0, INCREMENT BY 1),Timestamp BIGINT,CompanyName VARCHAR(100),Address VARCHAR(100),AddressNr VARCHAR(20),Postcode VARCHAR(20),City VARCHAR(100),Country VARCHAR(100),ContactName VARCHAR(100),PhoneNr VARCHAR(20),MobileNr VARCHAR(20),Email VARCHAR(100),Password VARCHAR(100),ResellerDiscount INT,Comment VARCHAR(4096) )");
        }
        catch (SQLException ex1) {
            this.userInterface.showStatus("Error: JavaDBClient.createResellerTable(): " + ex1.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createResellerTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized Reseller selectReseller(int idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Reseller reseller = new Reseller();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectReseller(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Reseller WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectReseller(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                reseller.setId(resultset.getInt(1));
                reseller.setTimestamp(resultset.getLong(2));
                reseller.setCompanyName(resultset.getString(3));
                reseller.setAddress(resultset.getString(4));
                reseller.setAddressNr(resultset.getString(5));
                reseller.setpostcode(resultset.getString(6));
                reseller.setCity(resultset.getString(7));
                reseller.setCountry(resultset.getString(8));
                reseller.setContactName(resultset.getString(9));
                reseller.setPhoneNr(resultset.getString(10));
                reseller.setMobileNr(resultset.getString(11));
                reseller.setEmail(resultset.getString(12));
                reseller.setPassword(resultset.getString(13));
                reseller.setResellerDiscount(resultset.getInt(14));
                reseller.setComment(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectReseller(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectReseller() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return reseller;
    }

    public synchronized int getResellerCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectCustomer(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Reseller");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getResellerCount() statement.executeQuery: " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getResellerCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Reseller selectLastReseller() {
        Statement statement = null;
        ResultSet resultset = null;
        Reseller reseller = new Reseller();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: selectReseller(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Reseller ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastReseller() statement.executeQuery: " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                reseller.setId(resultset.getInt(1));
                reseller.setTimestamp(resultset.getLong(2));
                reseller.setCompanyName(resultset.getString(3));
                reseller.setAddress(resultset.getString(4));
                reseller.setAddressNr(resultset.getString(5));
                reseller.setpostcode(resultset.getString(6));
                reseller.setCity(resultset.getString(7));
                reseller.setCountry(resultset.getString(8));
                reseller.setContactName(resultset.getString(9));
                reseller.setPhoneNr(resultset.getString(10));
                reseller.setMobileNr(resultset.getString(11));
                reseller.setEmail(resultset.getString(12));
                reseller.setPassword(resultset.getString(13));
                reseller.setResellerDiscount(resultset.getInt(14));
                reseller.setComment(resultset.getString(15));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastReseller(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastReseller() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return reseller;
    }

    public synchronized void insertReseller(Reseller resellerParam) {
        try {
            this.psInsertReseller.setLong(1, resellerParam.getTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(2, resellerParam.getCompanyName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(3, resellerParam.getAddress());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(4, resellerParam.getAddressNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(5, resellerParam.getpostcode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(6, resellerParam.getCity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(7, resellerParam.getCountry());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(8, resellerParam.getContactName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(9, resellerParam.getPhoneNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(10, resellerParam.getMobileNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(11, resellerParam.getEmail());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(12, resellerParam.getPassword());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setInt(13, resellerParam.getResellerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().13: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.setString(14, resellerParam.getComment());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller.execute();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller().15: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertReseller() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateReseller(Reseller resellerParam) {
        try {
            this.psUpdateReseller.setString(1, resellerParam.getCompanyName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(2, resellerParam.getAddress());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(3, resellerParam.getAddressNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(4, resellerParam.getpostcode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(5, resellerParam.getCity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(6, resellerParam.getCountry());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(7, resellerParam.getContactName());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(8, resellerParam.getPhoneNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(9, resellerParam.getMobileNr());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(10, resellerParam.getEmail());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(11, resellerParam.getPassword());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setInt(12, resellerParam.getResellerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setString(13, resellerParam.getComment());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().13: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.setInt(14, resellerParam.getId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateReseller().15: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteReseller(int idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteReseller(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Reseller WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteReseller(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteReseller() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropResellerTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropResellerTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Reseller");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropResellerTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropResellerTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createCustomerOrderTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createCustomerOrderTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.CustomerOrder( Id INT generated by default as identity (START WITH 0, INCREMENT BY 1),Timestamp BIGINT,CustomerId INT,Recipients VARCHAR(20),Timewindow0 INT,Timewindow1 INT,Timewindow2 INT,TargetTransactionQuantity INT,MessageFilename VARCHAR(1000),MessageDuration INT,MessageRatePerSecond FLOAT,MessageRate FLOAT,SubTotal FLOAT)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCustomerOrderTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCustomerOrderTable(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getCustomerOrderCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getCustomerOrderCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.CustomerOrder");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.: " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrderCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrderCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Order selectCustomerOrder(int idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Order order = new Order();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectCustomerOrder(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.CustomerOrder WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomerOrder(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                order.setOrderId(resultset.getInt(1));
                order.setOrderTimestamp(resultset.getLong(2));
                order.setCustomerId(resultset.getInt(3));
                order.setRecipientsCategory(resultset.getString(4));
                order.setTimeWindow0(resultset.getInt(5));
                order.setTimeWindow1(resultset.getInt(6));
                order.setTimeWindow2(resultset.getInt(7));
                order.setTargetTransactionQuantity(resultset.getInt(8));
                order.setMessageFilename(resultset.getString(9));
                order.setMessageDuration(resultset.getInt(10));
                order.setMessageRatePerSecond(resultset.getFloat(11));
                order.setMessageRate(resultset.getFloat(12));
                order.setSubTotal(resultset.getFloat(13));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomerOrder(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCustomerOrder() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return order;
    }

    public synchronized Order selectLastCustomerOrder() {
        Statement statement = null;
        ResultSet resultset = null;
        Order order = new Order();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectLastCustomerOrder(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.CustomerOrder ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomerOrder(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                order.setOrderId(resultset.getInt(1));
                order.setOrderTimestamp(resultset.getLong(2));
                order.setCustomerId(resultset.getInt(3));
                order.setRecipientsCategory(resultset.getString(4));
                order.setTimeWindow0(resultset.getInt(5));
                order.setTimeWindow1(resultset.getInt(6));
                order.setTimeWindow2(resultset.getInt(7));
                order.setTargetTransactionQuantity(resultset.getInt(8));
                order.setMessageFilename(resultset.getString(9));
                order.setMessageDuration(resultset.getInt(10));
                order.setMessageRatePerSecond(resultset.getFloat(11));
                order.setMessageRate(resultset.getFloat(12));
                order.setSubTotal(resultset.getFloat(13));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomerOrder(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCustomerOrder() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return order;
    }

    public synchronized String[] getCustomerOrders() {
        Statement statement = null;
        ResultSet resultset = null;
        String[] customerOrders = null;
        int numberOfCustomerOrders = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getCustomerOrders(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.CustomerOrder");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfCustomerOrders = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders() : connection.commit(): " + ex.getMessage(), true, true);
        }
        if (numberOfCustomerOrders > 0) {
            int customerOrderCounter = 0;
            customerOrders = new String[numberOfCustomerOrders];
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                System.out.println("Error: JavaDBClient.getCustomerOrders()(): connection.createStatement(): " + ex.getMessage());
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery("SELECT Id FROM APP.CustomerOrder");
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders(): " + ex.getMessage(), true, true);
            }
            try {
                while (resultset.next()) {
                    customerOrders[customerOrderCounter] = Integer.toString(resultset.getInt(1));
                    ++customerOrderCounter;
                }
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders(): " + ex.getMessage(), true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getCustomerOrders() : connection.commit(): " + ex.getMessage(), true, true);
            }
        }
        return customerOrders;
    }

    public synchronized String[] getOrders() {
        Statement statement = null;
        ResultSet resultset = null;
        String[] orders = null;
        int numberOfCustomerOrders = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: getOrders(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.CustomerOrder");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOrders(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfCustomerOrders = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOrders(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOrders() : connection.commit(): " + ex.getMessage(), true, true);
        }
        if (numberOfCustomerOrders > 0) {
            int customerOrderCounter = 0;
            orders = new String[numberOfCustomerOrders];
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                System.out.println("Error: JavaDBClient.selectCustomer(): connection.createStatement(): " + ex.getMessage());
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery("SELECT Id FROM APP.CustomerOrder");
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOrders(): " + ex.getMessage(), true, true);
            }
            try {
                while (resultset.next()) {
                    orders[customerOrderCounter] = Integer.toString(resultset.getInt(1));
                    ++customerOrderCounter;
                }
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOrders(): " + ex.getMessage(), true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOrders() : connection.commit(): " + ex.getMessage(), true, true);
            }
        }
        return orders;
    }

    public synchronized void insertCustomerOrder(Order orderParam) {
        try {
            this.psInsertOrder.setLong(1, orderParam.getOrderTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(2, orderParam.getCustomerId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setString(3, orderParam.getRecipientsCategory());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(4, orderParam.getTimeWindow0());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(5, orderParam.getTimeWindow1());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(6, orderParam.getTimeWindow2());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(7, orderParam.getTargetTransactionQuantity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setString(8, orderParam.getMessageFilename());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setInt(9, orderParam.getMessageDuration());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setFloat(10, orderParam.getMessageRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setFloat(11, orderParam.getMessageRate());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.setFloat(12, orderParam.getSubTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder() executeUpdate: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCustomerOrder() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateCustomerOrder(Order orderParam) {
        Order currentOrder = new Order();
        currentOrder = this.selectCustomerOrder(orderParam.getOrderId());
        try {
            this.psUpdateOrder.setInt(1, orderParam.getCustomerId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setString(2, orderParam.getRecipientsCategory());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(3, orderParam.getTimeWindow0());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(4, orderParam.getTimeWindow1());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(5, orderParam.getTimeWindow2());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(6, currentOrder.getTargetTransactionQuantity());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setString(7, orderParam.getMessageFilename());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(8, orderParam.getMessageDuration());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setFloat(9, orderParam.getMessageRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setFloat(10, orderParam.getMessageRate());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setFloat(11, orderParam.getSubTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.setInt(12, orderParam.getCustomerId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder() executeUpdate(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCustomerOrder() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteCustomerOrder(int idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteCustomerOrder(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.CustomerOrder WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCustomerOrder(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCustomerOrder() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropCustomerOrderTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropCustomerOrderTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.CustomerOrder");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCustomerOrderTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCustomerOrderTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createInvoiceTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createInvoiceTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Invoice( Id INT generated by default as identity (START WITH 0, INCREMENT BY 1),Timestamp BIGINT,OrderId INT,QuantityItem INT,ItemDesc VARCHAR(256),ItemUnitPrice FLOAT,ItemVATPercentage FLOAT,ItemQuantityPrice FLOAT,SubTotalB4Discount FLOAT,CustomerDiscount INT,SubTotal FLOAT,VAT FLOAT,Total FLOAT,Paid FLOAT)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createInvoiceTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createInvoiceTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getInvoiceCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getInvoiceCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Invoice");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getInvoiceCount(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getInvoiceCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getInvoiceCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Invoice selectInvoice(int idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Invoice invoice = new Invoice();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectInvoice(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Invoice WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                invoice.setId(resultset.getInt(1));
                invoice.setTimestamp(resultset.getLong(2));
                invoice.setOrderId(resultset.getInt(3));
                invoice.setQuantityItem(resultset.getInt(4));
                invoice.setItemDesc(resultset.getString(5));
                invoice.setItemUnitPrice(resultset.getFloat(6));
                invoice.setItemVATPercentage(resultset.getFloat(7));
                invoice.setItemQuantityPrice(resultset.getFloat(8));
                invoice.setSubTotalB4Discount(resultset.getFloat(9));
                invoice.setCustomerDiscount(resultset.getInt(10));
                invoice.setSubTotal(resultset.getFloat(11));
                invoice.setVAT(resultset.getFloat(12));
                invoice.setTotal(resultset.getFloat(13));
                invoice.setPaid(resultset.getFloat(14));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectInvoice() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return invoice;
    }

    public synchronized Invoice selectLastInvoice() {
        Statement statement = null;
        ResultSet resultset = null;
        Invoice invoice = new Invoice();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectLastInvoice(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Invoice ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                invoice.setId(resultset.getInt(1));
                invoice.setTimestamp(resultset.getLong(2));
                invoice.setOrderId(resultset.getInt(3));
                invoice.setQuantityItem(resultset.getInt(4));
                invoice.setItemDesc(resultset.getString(5));
                invoice.setItemUnitPrice(resultset.getFloat(6));
                invoice.setItemVATPercentage(resultset.getFloat(7));
                invoice.setItemQuantityPrice(resultset.getFloat(8));
                invoice.setSubTotalB4Discount(resultset.getFloat(9));
                invoice.setCustomerDiscount(resultset.getInt(10));
                invoice.setSubTotal(resultset.getFloat(11));
                invoice.setVAT(resultset.getFloat(12));
                invoice.setTotal(resultset.getFloat(13));
                invoice.setPaid(resultset.getFloat(14));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastInvoice() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return invoice;
    }

    public synchronized void insertInvoice(Invoice invoiceParam) {
        try {
            this.psInsertInvoice.setLong(1, invoiceParam.getTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setInt(2, invoiceParam.getOrderId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setInt(3, invoiceParam.getQuantityItem());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setString(4, invoiceParam.getItemDesc());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(5, invoiceParam.getItemUnitPrice());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(6, invoiceParam.getItemVATPercentage());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(7, invoiceParam.getItemQuantityPrice());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(8, invoiceParam.getSubTotalB4Discount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setInt(9, invoiceParam.getCustomerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(10, invoiceParam.getSubTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(11, invoiceParam.getVAT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(12, invoiceParam.getTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.setFloat(13, invoiceParam.getPaid());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertInvoice() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateInvoice(Invoice invoiceParam) {
        try {
            this.psUpdateInvoice.setInt(1, invoiceParam.getOrderId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setInt(2, invoiceParam.getQuantityItem());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setString(3, invoiceParam.getItemDesc());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(4, invoiceParam.getItemUnitPrice());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(5, invoiceParam.getItemVATPercentage());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(6, invoiceParam.getItemQuantityPrice());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(7, invoiceParam.getSubTotalB4Discount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setInt(8, invoiceParam.getCustomerDiscount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(9, invoiceParam.getSubTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(10, invoiceParam.getVAT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(11, invoiceParam.getTotal());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setFloat(12, invoiceParam.getPaid());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.setInt(13, invoiceParam.getId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateInvoice() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteInvoice(int idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteInvoice(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Invoice WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteInvoice(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteInvoice() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropInvoiceTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropInvoiceTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Invoice");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropInvoiceTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropInvoiceTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createCampaignTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createCampaignTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Campaign(Id INT generated by default as identity (START WITH 0, INCREMENT BY 1),Timestamp BIGINT,OrderId INT,TimeScheduledStart BIGINT,TimeScheduledEnd BIGINT,TimeExpectedStart BIGINT,TimeExpectedEnd BIGINT,TimeRegisteredStart BIGINT,TimeRegisteredEnd BIGINT,TestCampaign INT)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCampaignTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCampaignTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getCampaignCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getCampaignCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Campaign");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.: " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCampaignCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCampaignCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Campaign selectCampaign(int orderIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        this.userInterface.showStatus("Loading Campaign: " + orderIdParam, true, true);
        Campaign campaign = new Campaign();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectCampaign(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Campaign WHERE OrderId = " + orderIdParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaign.setId(resultset.getInt(1));
                campaign.setCalendarCampaignCreatedEpoch(resultset.getLong(2));
                campaign.setOrderId(resultset.getInt(3));
                campaign.setCalendarScheduledStartEpoch(resultset.getLong(4));
                campaign.setCalendarScheduledEndEpoch(resultset.getLong(5));
                campaign.setCalendarExpectedStartEpoch(resultset.getLong(6));
                campaign.setCalendarExpectedEndEpoch(resultset.getLong(7));
                campaign.setCalendarRegisteredStartEpoch(resultset.getLong(8));
                campaign.setCalendarRegisteredEndEpoch(resultset.getLong(9));
                campaign.setTestCampaignNumber(resultset.getInt(10));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaign() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaign;
    }

    public synchronized Campaign selectLastCampaign() {
        Statement statement = null;
        ResultSet resultset = null;
        Campaign campaign = new Campaign();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectLastCampaign(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Campaign ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaign.setId(resultset.getInt(1));
                campaign.setCalendarCampaignCreatedEpoch(resultset.getLong(2));
                campaign.setOrderId(resultset.getInt(3));
                campaign.setCalendarScheduledStartEpoch(resultset.getLong(4));
                campaign.setCalendarScheduledEndEpoch(resultset.getLong(5));
                campaign.setCalendarExpectedStartEpoch(resultset.getLong(6));
                campaign.setCalendarExpectedEndEpoch(resultset.getLong(7));
                campaign.setCalendarRegisteredStartEpoch(resultset.getLong(8));
                campaign.setCalendarRegisteredEndEpoch(resultset.getLong(9));
                campaign.setTestCampaignNumber(resultset.getInt(10));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaign() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaign;
    }

    public synchronized Campaign loadCampaignFromOrderId(int orderIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Campaign campaign = new Campaign();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.loadCampaignFromOrderId(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Campaign WHERE OrderId = " + orderIdParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.loadCampaignFromOrderId(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaign.setId(resultset.getInt(1));
                campaign.setCalendarCampaignCreatedEpoch(resultset.getLong(2));
                campaign.setOrderId(resultset.getInt(3));
                campaign.setCalendarScheduledStartEpoch(resultset.getLong(4));
                campaign.setCalendarScheduledEndEpoch(resultset.getLong(5));
                campaign.setCalendarExpectedStartEpoch(resultset.getLong(6));
                campaign.setCalendarExpectedEndEpoch(resultset.getLong(7));
                campaign.setCalendarRegisteredStartEpoch(resultset.getLong(8));
                campaign.setCalendarRegisteredEndEpoch(resultset.getLong(9));
                campaign.setTestCampaignNumber(resultset.getInt(10));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.loadCampaignFromOrderId(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.loadCampaignFromOrderId() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaign;
    }

    public synchronized String[] getOpenCampaigns() {
        Statement statement = null;
        ResultSet resultset = null;
        String[] openCampaigns = null;
        int numberOfOpenCampaigns = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getOpenCampaigns(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Campaign WHERE TimeRegisteredEnd = 0");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfOpenCampaigns = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns() : connection.commit(): " + ex.getMessage(), true, true);
        }
        if (numberOfOpenCampaigns > 0) {
            int openCampaignsCounter = 0;
            openCampaigns = new String[numberOfOpenCampaigns];
            try {
                statement = this.connection.createStatement();
            }
            catch (SQLException ex) {
                System.out.println("Error: JavaDBClient.getOpenCampaigns(): connection.createStatement(): " + ex.getMessage());
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.connection = this.initDatabaseClientServer();
            }
            try {
                resultset = statement.executeQuery("SELECT Id FROM APP.Campaign WHERE TimeRegisteredEnd = 0");
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns(): " + ex.getMessage(), true, true);
            }
            try {
                while (resultset.next()) {
                    openCampaigns[openCampaignsCounter] = Integer.toString(resultset.getInt(1));
                    ++openCampaignsCounter;
                }
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns(): " + ex.getMessage(), true, true);
            }
            try {
                this.connection.commit();
            }
            catch (SQLException ex) {
                this.userInterface.showStatus("Error: JavaDBClient.getOpenCampaigns() : connection.commit(): " + ex.getMessage(), true, true);
            }
        }
        return openCampaigns;
    }

    public synchronized PeriodSet getForbiddenCampaignPeriodSet(int[] timeWindowIndexArrayParam) {
        Statement statement = null;
        ResultSet resultset = null;
        PeriodSet periodSet = new PeriodSet();
        Calendar currentTimeCalendar = Calendar.getInstance();
        Calendar expectedStartCalendar = Calendar.getInstance();
        Calendar expectedEndCalendar = Calendar.getInstance();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT APP.Campaign.TimeExpectedStart, APP.Campaign.TimeExpectedEnd FROM APP.Campaign INNER JOIN APP.CustomerOrder ON APP.Campaign.OrderId=APP.CustomerOrder.Id WHERE APP.Campaign.TimeExpectedStart > " + currentTimeCalendar.getTimeInMillis() + "AND (APP.CustomerOrder.Timewindow0 = " + timeWindowIndexArrayParam[0] + "AND APP.CustomerOrder.Timewindow0 > -1) OR  (APP.CustomerOrder.Timewindow1 = " + timeWindowIndexArrayParam[1] + "AND APP.CustomerOrder.Timewindow1 > -1) OR  (APP.CustomerOrder.Timewindow2 = " + timeWindowIndexArrayParam[2] + "AND APP.CustomerOrder.Timewindow2 > -1) ");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                expectedStartCalendar.setTimeInMillis(resultset.getLong(1));
                expectedEndCalendar.setTimeInMillis(resultset.getLong(2));
                Period period = new Period(expectedStartCalendar, expectedEndCalendar);
                periodSet.add(period);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return periodSet;
    }

    public synchronized Campaign getNextOpenCampaign() {
        Statement statement = null;
        ResultSet resultset = null;
        Campaign campaign = new Campaign();
        TimeTool timeTool = new TimeTool();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(1);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT APP.Campaign.* FROM APP.Campaign INNER JOIN APP.CustomerOrder ON APP.Campaign.OrderId=APP.CustomerOrder.Id WHERE APP.Campaign.TimeRegisteredEnd = 0 AND APP.CustomerOrder.Timewindow0 = " + timeTool.getCurrentTimeWindowIndex() + " OR  APP.CustomerOrder.Timewindow1 = " + timeTool.getCurrentTimeWindowIndex() + " OR  APP.CustomerOrder.Timewindow2 = " + timeTool.getCurrentTimeWindowIndex() + " ORDER BY APP.Campaign.TimeExpectedStart ASC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaign.setId(resultset.getInt(1));
                campaign.setCalendarCampaignCreatedEpoch(resultset.getLong(2));
                campaign.setOrderId(resultset.getInt(3));
                campaign.setCalendarScheduledStartEpoch(resultset.getLong(4));
                campaign.setCalendarScheduledEndEpoch(resultset.getLong(5));
                campaign.setCalendarExpectedStartEpoch(resultset.getLong(6));
                campaign.setCalendarExpectedEndEpoch(resultset.getLong(7));
                campaign.setCalendarRegisteredStartEpoch(resultset.getLong(8));
                campaign.setCalendarRegisteredEndEpoch(resultset.getLong(9));
                campaign.setTestCampaignNumber(resultset.getInt(10));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getForbiddenCampaignPeriodSet(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaign;
    }

    public synchronized void insertCampaign(Campaign campaignParam) {
        try {
            this.psInsertCampaign.setLong(1, campaignParam.getCalendarCampaignCreated().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setInt(2, campaignParam.getOrderId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.: " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(3, campaignParam.getCalendarScheduledStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(4, campaignParam.getCalendarScheduledEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(5, campaignParam.getCalendarExpectedStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(6, campaignParam.getCalendarExpectedEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(7, campaignParam.getCalendarRegisteredStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setLong(8, campaignParam.getCalendarRegisteredEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.setInt(9, campaignParam.getTestCampaignNumber());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaign() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateCampaign(Campaign campaignParam) {
        try {
            this.psUpdateCampaign.setLong(1, campaignParam.getCalendarCampaignCreated().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setInt(2, campaignParam.getOrderId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(3, campaignParam.getCalendarScheduledStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(4, campaignParam.getCalendarScheduledEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(5, campaignParam.getCalendarExpectedStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(6, campaignParam.getCalendarExpectedEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(7, campaignParam.getCalendarRegisteredStart().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setLong(8, campaignParam.getCalendarRegisteredEnd().getTimeInMillis());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setInt(9, campaignParam.getTestCampaignNumber());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.setInt(10, campaignParam.getId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaign() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteCampaign(int campaignIdParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteCampaign(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Campaign WHERE Id = " + campaignIdParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCampaign(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCampaign() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropCampaignTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropCampaignTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Campaign");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCampaignTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCampaignTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createDestinationTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createDestinationTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Destination(Id BIGINT generated by default as identity (START WITH 0, INCREMENT BY 1),CampaignId INT,DestinationCount INT,Destination VARCHAR(100),ConnectingTimestamp BIGINT,TryingTimestamp BIGINT,CallingTimestamp BIGINT,CallingAttempts INT,RingingTimestamp BIGINT,LocalCancelingTimestamp BIGINT,RemoteCancelingTimestamp BIGINT,LocalBusyTimestamp BIGINT,RemoteBusyTimestamp BIGINT,AcceptingTimestamp BIGINT,TalkingTimestamp BIGINT,LocalByeTimestamp BIGINT,RemoteByeTimestamp BIGINT,ResponseStatusCode BIGINT,ResponseStatusDesc VARCHAR(100))");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createDestinationTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createDestinationTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createDestinationTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE INDEX DestinationIndex ON APP.Destination(Id,CampaignId,Destination)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createDestinationTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createDestinationTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getDestinationCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getDestinationCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Destination");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getDestinationCount(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getDestinationCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getDestinationCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Destination selectDestination(int idParam) {
        Statement statement = null;
        ResultSet resultset = null;
        Destination destination = new Destination();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectDestination(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Destination WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectDestination(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                destination.setId(resultset.getLong(1));
                destination.setCampaignId(resultset.getInt(2));
                destination.setDestinationCount(resultset.getInt(3));
                destination.setDestination(resultset.getString(4));
                destination.setConnectingTimestamp(resultset.getLong(5));
                destination.setTryingTimestamp(resultset.getLong(6));
                destination.setCallingTimestamp(resultset.getLong(7));
                destination.setCallingAttempts(resultset.getInt(8));
                destination.setRingingTimestamp(resultset.getLong(9));
                destination.setLocalCancelingTimestamp(resultset.getLong(10));
                destination.setRemoteCancelingTimestamp(resultset.getLong(11));
                destination.setLocalBusyTimestamp(resultset.getLong(12));
                destination.setRemoteBusyTimestamp(resultset.getLong(13));
                destination.setAcceptingTimestamp(resultset.getLong(14));
                destination.setTalkingTimestamp(resultset.getLong(15));
                destination.setLocalByeTimestamp(resultset.getLong(16));
                destination.setRemoteByeTimestamp(resultset.getLong(17));
                destination.setResponseStatusCode(resultset.getLong(18));
                destination.setResponseStatusDesc(resultset.getString(19));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectDestination() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return destination;
    }

    public synchronized Destination selectLastDestination() {
        Statement statement = null;
        ResultSet resultset = null;
        Destination destination = new Destination();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectLastDestination(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Destination ORDER BY Id DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastDestination(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                destination.setId(resultset.getLong(1));
                destination.setCampaignId(resultset.getInt(2));
                destination.setDestinationCount(resultset.getInt(3));
                destination.setDestination(resultset.getString(4));
                destination.setConnectingTimestamp(resultset.getLong(5));
                destination.setTryingTimestamp(resultset.getLong(6));
                destination.setCallingTimestamp(resultset.getLong(7));
                destination.setCallingAttempts(resultset.getInt(8));
                destination.setRingingTimestamp(resultset.getLong(9));
                destination.setLocalCancelingTimestamp(resultset.getLong(10));
                destination.setRemoteCancelingTimestamp(resultset.getLong(11));
                destination.setLocalBusyTimestamp(resultset.getLong(12));
                destination.setRemoteBusyTimestamp(resultset.getLong(13));
                destination.setAcceptingTimestamp(resultset.getLong(14));
                destination.setTalkingTimestamp(resultset.getLong(15));
                destination.setLocalByeTimestamp(resultset.getLong(16));
                destination.setRemoteByeTimestamp(resultset.getLong(17));
                destination.setResponseStatusCode(resultset.getLong(18));
                destination.setResponseStatusDesc(resultset.getString(19));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastDestination() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return destination;
    }

    public synchronized int getNumberOfAllOpenCampaignDestinations(int campaignIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        this.userInterface.showStatus("Loading Destinations for Campaign: " + campaignIdParam, true, true);
        int numberOfDestinations = 0;
        boolean destinationCounter = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(this.destinationLoadLimit);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() statement.setMaxRows(destinationLoadLimit): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Destination WHERE (CampaignId = " + campaignIdParam + " AND ResponseStatusCode        <> 404 AND LocalCancelingTimestamp    = 0 AND RemoteCancelingTimestamp   = 0 AND LocalBusyTimestamp         = 0 AND RemoteBusyTimestamp        = 0 AND ConnectingTimestamp       >= 0 AND TryingTimestamp           >= 0 AND CallingTimestamp          >= 0 AND CallingAttempts           <= 3 AND AcceptingTimestamp         = 0 AND TalkingTimestamp           = 0 AND LocalByeTimestamp          = 0 AND RemoteByeTimestamp         = 0 OR RemoteBusyTimestamp         > 0) ");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfDestinations = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfDestinations;
    }

    public synchronized Destination[] selectAllOpenCampaignDestinations(int campaignIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        this.userInterface.showStatus("Loading Destinations for Campaign: " + campaignIdParam, true, true);
        int numberOfDestinations = 0;
        int destinationCounter = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(this.destinationLoadLimit);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() statement.setMaxRows(destinationLoadLimit): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Destination WHERE (CampaignId = " + campaignIdParam + " AND ResponseStatusCode        <> 404 AND LocalCancelingTimestamp    = 0 AND RemoteCancelingTimestamp   = 0 AND LocalBusyTimestamp         = 0 AND RemoteBusyTimestamp        = 0 AND ConnectingTimestamp       >= 0 AND TryingTimestamp           >= 0 AND CallingTimestamp          >= 0 AND CallingAttempts           <= 3 AND AcceptingTimestamp         = 0 AND TalkingTimestamp           = 0 AND LocalByeTimestamp          = 0 AND RemoteByeTimestamp         = 0 OR RemoteBusyTimestamp         > 0) ");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfDestinations = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        Destination destination = new Destination();
        Destination[] destinationArray = new Destination[numberOfDestinations];
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(this.destinationLoadLimit);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() statement.setMaxRows(destinationLoadLimit): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Destination WHERE (CampaignId = " + campaignIdParam + " AND ResponseStatusCode        <> 404 AND LocalCancelingTimestamp    = 0 AND RemoteCancelingTimestamp   = 0 AND LocalBusyTimestamp         = 0 AND RemoteBusyTimestamp        = 0 AND ConnectingTimestamp       >= 0 AND TryingTimestamp           >= 0 AND CallingTimestamp          >= 0 AND CallingAttempts           <= 3 AND AcceptingTimestamp         = 0 AND TalkingTimestamp           = 0 AND LocalByeTimestamp          = 0 AND RemoteByeTimestamp         = 0 OR RemoteBusyTimestamp         > 0) ORDER BY Id+CallingAttempts ");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                destination.setId(resultset.getLong(1));
                destination.setCampaignId(resultset.getInt(2));
                destination.setDestinationCount(resultset.getInt(3));
                destination.setDestination(resultset.getString(4));
                destination.setConnectingTimestamp(resultset.getLong(5));
                destination.setTryingTimestamp(resultset.getLong(6));
                destination.setCallingTimestamp(resultset.getLong(7));
                destination.setCallingAttempts(resultset.getInt(8));
                destination.setRingingTimestamp(resultset.getLong(9));
                destination.setLocalCancelingTimestamp(resultset.getLong(10));
                destination.setRemoteCancelingTimestamp(resultset.getLong(11));
                destination.setLocalBusyTimestamp(resultset.getLong(12));
                destination.setRemoteBusyTimestamp(resultset.getLong(13));
                destination.setAcceptingTimestamp(resultset.getLong(14));
                destination.setTalkingTimestamp(resultset.getLong(15));
                destination.setLocalByeTimestamp(resultset.getLong(16));
                destination.setRemoteByeTimestamp(resultset.getLong(17));
                destination.setResponseStatusCode(resultset.getLong(18));
                destination.setResponseStatusDesc(resultset.getString(19));
                try {
                    destinationArray[destinationCounter] = (Destination)destination.clone();
                }
                catch (CloneNotSupportedException ex) {
                    System.out.println("Forget about cloning your Destination!");
                }
                ++destinationCounter;
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getNumberOfAllOpenCampaignDestinations() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return destinationArray;
    }

    public synchronized double selectAverageAnswerDelay(int campaignIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        long averageAnswerDelay = 0L;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectAverageAnswerDelay(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(1000);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageAnswerDelay() statement.setMaxRows(destinationLoadLimit): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT AVG((TalkingTimestamp - CallingTimestamp)) FROM APP.Destination WHERE CampaignId = " + campaignIdParam + " AND CallingTimestamp > 0 AND TalkingTimestamp > 0");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageAnswerDelay(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                averageAnswerDelay = resultset.getLong(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageAnswerDelay(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        return averageAnswerDelay / 1000L;
    }

    public synchronized double selectAverageCallDuration(int campaignIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        long averageCallDuration = 0L;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectAverageCallDuration(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.setMaxRows(1000);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageCallDuration() statement.setMaxRows(destinationLoadLimit): " + ex.getMessage(), true, true);
        }
        try {
            resultset = statement.executeQuery("SELECT AVG((LocalbyeTimestamp + RemotebyeTimestamp) - TalkingTimestamp)FROM APP.Destination WHERE CampaignId = " + campaignIdParam + " AND TalkingTimestamp > 0 AND (LocalbyeTimestamp = 0 AND RemotebyeTimestamp > 0) OR (LocalbyeTimestamp > 0 AND RemotebyeTimestamp = 0)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageCallDuration(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                averageCallDuration = resultset.getLong(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageCallDuration(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectAverageCallDuration() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return averageCallDuration / 1000L;
    }

    public synchronized void insertDestination(Destination destinationParam) {
        try {
            this.psInsertDestination.setInt(1, destinationParam.getCampaignId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setInt(2, destinationParam.getDestinationCount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setString(3, destinationParam.getDestination());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(4, destinationParam.getConnectingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(5, destinationParam.getTryingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(6, destinationParam.getCallingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(7, destinationParam.getCallingAttempts());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(8, destinationParam.getRingingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(9, destinationParam.getLocalCancelingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(10, destinationParam.getRemoteCancelingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(11, destinationParam.getLocalBusyTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(12, destinationParam.getRemoteBusyTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(13, destinationParam.getAcceptingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(14, destinationParam.getTalkingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(15, destinationParam.getLocalByeTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(16, destinationParam.getRemoteByeTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setLong(17, destinationParam.getResponseStatusCode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.setString(18, destinationParam.getResponseStatusDesc());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertDestination() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateDestination(Destination destinationParam) {
        try {
            this.psUpdateDestination.setInt(1, destinationParam.getCampaignId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().1: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setInt(2, destinationParam.getDestinationCount());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().2: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setString(3, destinationParam.getDestination());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().3: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(4, destinationParam.getConnectingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(5, destinationParam.getTryingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().4: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(6, destinationParam.getCallingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(7, destinationParam.getCallingAttempts());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().5: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(8, destinationParam.getRingingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().6: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(9, destinationParam.getLocalCancelingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().7: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(10, destinationParam.getRemoteCancelingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().8: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(11, destinationParam.getLocalBusyTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().9: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(12, destinationParam.getRemoteBusyTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().10: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(13, destinationParam.getAcceptingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().11: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(14, destinationParam.getTalkingTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().12: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(15, destinationParam.getLocalByeTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().13: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(16, destinationParam.getRemoteByeTimestamp());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(17, destinationParam.getResponseStatusCode());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setString(18, destinationParam.getResponseStatusDesc());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().14: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.setLong(19, destinationParam.getId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination().15: " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination() executeupd: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateDestination() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteDestination(long idParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteDestination(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Destination WHERE Id = " + idParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteDestination(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteDestination() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropDestinationTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropDestinationTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Destination");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropDestinationTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropDestinationTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createCampaignStatTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createCampaignStatTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.CampaignStat(CampaignId INT generated by default as identity (START WITH 0, INCREMENT BY 1),OnAC INT,IdleAC INT,ConnectingAC INT,ConnectingTT INT,TryingAC INT,TryingTT INT,CallingAC INT,CallingTT INT,RingingAC INT,RingingTT INT,AcceptingAC INT,AcceptingTT INT,TalkingAC INT,TalkingTT INT,LocalCancelTT INT,RemoteCancelTT INT,LocalBusyTT INT,RemoteBusyTT INT,LocalByeTT INT,RemoteByeTT INT)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCampaignStatTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createCampaignStatTable() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getCampaignStatsCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getCampaignStatsCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.CampaignStat");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCampaignStatsCount(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCampaignStatsCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getCampaignStatsCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized CampaignStat selectCampaignStat(int campaignIdParam) {
        Statement statement = null;
        ResultSet resultset = null;
        CampaignStat campaignStat = new CampaignStat();
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectCampaignStat(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.CampaignStat WHERE CampaignId = " + Integer.toString(campaignIdParam));
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaignStat.setCampaignId(resultset.getInt(1));
                campaignStat.setOnAC(resultset.getInt(2));
                campaignStat.setIdleAC(resultset.getInt(3));
                campaignStat.setConnectingAC(resultset.getInt(4));
                campaignStat.setConnectingTT(resultset.getInt(5));
                campaignStat.setTryingAC(resultset.getInt(6));
                campaignStat.setTryingTT(resultset.getInt(7));
                campaignStat.setCallingAC(resultset.getInt(8));
                campaignStat.setCallingTT(resultset.getInt(9));
                campaignStat.setRingingAC(resultset.getInt(10));
                campaignStat.setRingingTT(resultset.getInt(11));
                campaignStat.setAcceptingAC(resultset.getInt(12));
                campaignStat.setAcceptingTT(resultset.getInt(13));
                campaignStat.setTalkingAC(resultset.getInt(14));
                campaignStat.setTalkingTT(resultset.getInt(15));
                campaignStat.setLocalCancelTT(resultset.getInt(16));
                campaignStat.setRemoteCancelTT(resultset.getInt(17));
                campaignStat.setLocalBusyTT(resultset.getInt(18));
                campaignStat.setRemoteBusyTT(resultset.getInt(19));
                campaignStat.setLocalByeTT(resultset.getInt(20));
                campaignStat.setRemoteByeTT(resultset.getInt(21));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectCampaignStat() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaignStat;
    }

    public synchronized CampaignStat selectLastCampaignStat() {
        Statement statement = null;
        ResultSet resultset = null;
        CampaignStat campaignStat = new CampaignStat();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectLastCampaignStat(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.CampaignStat ORDER BY CampaignId DESC");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                campaignStat.setCampaignId(resultset.getInt(1));
                campaignStat.setOnAC(resultset.getInt(2));
                campaignStat.setIdleAC(resultset.getInt(3));
                campaignStat.setConnectingAC(resultset.getInt(4));
                campaignStat.setConnectingTT(resultset.getInt(5));
                campaignStat.setTryingAC(resultset.getInt(6));
                campaignStat.setTryingTT(resultset.getInt(7));
                campaignStat.setCallingAC(resultset.getInt(8));
                campaignStat.setCallingTT(resultset.getInt(9));
                campaignStat.setRingingAC(resultset.getInt(10));
                campaignStat.setRingingTT(resultset.getInt(11));
                campaignStat.setAcceptingAC(resultset.getInt(12));
                campaignStat.setAcceptingTT(resultset.getInt(13));
                campaignStat.setTalkingAC(resultset.getInt(14));
                campaignStat.setTalkingTT(resultset.getInt(15));
                campaignStat.setLocalCancelTT(resultset.getInt(16));
                campaignStat.setRemoteCancelTT(resultset.getInt(17));
                campaignStat.setLocalBusyTT(resultset.getInt(18));
                campaignStat.setRemoteBusyTT(resultset.getInt(19));
                campaignStat.setLocalByeTT(resultset.getInt(20));
                campaignStat.setRemoteByeTT(resultset.getInt(21));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectLastCampaignStat() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return campaignStat;
    }

    public synchronized void insertCampaignStat(CampaignStat campaignStatParam) {
        try {
            this.psInsertCampaignStat.setInt(1, campaignStatParam.getOnAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(2, campaignStatParam.getIdleAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(3, campaignStatParam.getConnectingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(4, campaignStatParam.getConnectingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(5, campaignStatParam.getTryingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(6, campaignStatParam.getTryingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(7, campaignStatParam.getCallingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(8, campaignStatParam.getCallingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(9, campaignStatParam.getRingingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(10, campaignStatParam.getRingingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(11, campaignStatParam.getAcceptingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(12, campaignStatParam.getAcceptingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(13, campaignStatParam.getTalkingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(14, campaignStatParam.getTalkingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(15, campaignStatParam.getLocalCancelTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(16, campaignStatParam.getRemoteCancelTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(17, campaignStatParam.getLocalBusyTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(18, campaignStatParam.getRemoteBusyTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(19, campaignStatParam.getLocalByeTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.setInt(20, campaignStatParam.getRemoteByeTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat() executeUpdate: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertCampaignStat() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updateCampaignStat(CampaignStat campaignStatParam) {
        try {
            this.psUpdateCampaignStat.setInt(1, campaignStatParam.getOnAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(2, campaignStatParam.getIdleAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(3, campaignStatParam.getConnectingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(4, campaignStatParam.getConnectingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(5, campaignStatParam.getTryingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(6, campaignStatParam.getTryingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(7, campaignStatParam.getCallingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(8, campaignStatParam.getCallingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(9, campaignStatParam.getRingingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(10, campaignStatParam.getRingingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(11, campaignStatParam.getAcceptingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(12, campaignStatParam.getAcceptingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(13, campaignStatParam.getTalkingAC());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(14, campaignStatParam.getTalkingTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(15, campaignStatParam.getLocalCancelTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(16, campaignStatParam.getRemoteCancelTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(17, campaignStatParam.getLocalBusyTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(18, campaignStatParam.getRemoteBusyTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(19, campaignStatParam.getLocalByeTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(20, campaignStatParam.getRemoteByeTT());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.setInt(21, campaignStatParam.getCampaignId());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat() executeUpdate: " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updateCampaignStat() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deleteCampaignStat(int campaignIdParam) {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deleteCampaignStat(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.CampaignStat WHERE CampaignId = " + campaignIdParam);
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCampaignStat(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deleteCampaignStat() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropCampaignStatTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropCampaignStatTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.CampaignStat");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCampaignStatTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropCampaignStatTable() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void createPricelistTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createPricelistTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("CREATE TABLE APP.Pricelist(B2BDaytimePerSecond DECIMAL(4,3),B2BEveningPerSecond DECIMAL(4,3),B2CDaytimePerSecond DECIMAL(4,3),B2CEveningPerSecond DECIMAL(4,3),A2SDaytimePerSecond DECIMAL(4,3),A2SEveningPerSecond DECIMAL(4,3))");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createPricelistTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createPricelistTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.createPricelistTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("INSERT INTO APP.Pricelist VALUES (0.01,0.01,0.001,0.005,0.01,0.01)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createPricelistTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.createPricelistTable() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized int getPricelistCount() {
        Statement statement = null;
        ResultSet resultset = null;
        int numberOfRecords = 0;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.getPricelistCount(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT COUNT (*) FROM APP.Pricelist");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getPricelistCount(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                numberOfRecords = resultset.getInt(1);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getPricelistCount(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.getPricelistCount() : connection.commit(): " + ex.getMessage(), true, true);
        }
        return numberOfRecords;
    }

    public synchronized Pricelist selectPricelist() {
        Statement statement = null;
        ResultSet resultset = null;
        Pricelist pricelist = new Pricelist();
        boolean colcount = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.selectPricelist(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM APP.Pricelist");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            while (resultset.next()) {
                pricelist.setB2BDaytimeRatePerSecond(resultset.getFloat(1));
                pricelist.setB2BEveningRatePerSecond(resultset.getFloat(2));
                pricelist.setB2CDaytimeRatePerSecond(resultset.getFloat(3));
                pricelist.setB2CEveningRatePerSecond(resultset.getFloat(4));
                pricelist.setA2SDaytimeRatePerSecond(resultset.getFloat(5));
                pricelist.setA2SEveningRatePerSecond(resultset.getFloat(6));
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.selectPricelist() connection.commit(): " + ex.getMessage(), true, true);
        }
        return pricelist;
    }

    public synchronized void insertPricelist(Pricelist pricelistParam) {
        try {
            this.psInsertPricelist.setFloat(1, pricelistParam.getB2BDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.setFloat(2, pricelistParam.getB2BEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.setFloat(3, pricelistParam.getB2CDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.setFloat(4, pricelistParam.getB2CEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.setFloat(5, pricelistParam.getA2SDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.setFloat(6, pricelistParam.getA2SEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertPricelist.execute();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.insertPricelist() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void updatePricelist(Pricelist pricelistParam) {
        try {
            this.psUpdatePricelist.setFloat(1, pricelistParam.getB2BDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.setFloat(2, pricelistParam.getB2BEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.setFloat(3, pricelistParam.getB2CDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.setFloat(4, pricelistParam.getB2CEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.setFloat(5, pricelistParam.getA2SDaytimeRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.setFloat(6, pricelistParam.getA2SEveningRatePerSecond());
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist.executeUpdate();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.updatePricelist() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void deletePricelist() {
        Statement statement = null;
        ResultSet resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.deletePricelist(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DELETE FROM APP.Pricelist");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        boolean failure = false;
        try {
            if (!resultset.next()) {
                failure = true;
                this.reportFailure("No rows in ResultSet");
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            int number = resultset.getInt(1);
            if (number != 300) {
                failure = true;
                this.reportFailure("Wrong row returned, expected num=300, got " + number);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            if (!resultset.next()) {
                failure = true;
                this.reportFailure("Too few rows");
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            int number = resultset.getInt(1);
            if (number != 1910) {
                failure = true;
                this.reportFailure("Wrong row returned, expected num=1910, got " + number);
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        try {
            if (resultset.next()) {
                failure = true;
                this.reportFailure("Too many rows");
            }
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist(): " + ex.getMessage(), true, true);
        }
        if (!failure) {
            System.out.println("Verified the rows");
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.deletePricelist() connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    public synchronized void dropPricelistTable() {
        Statement statement = null;
        Object resultset = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.dropPricelistTable(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            statement.executeUpdate("DROP TABLE APP.Pricelist");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropPricelistTable(): " + ex.getMessage(), true, true);
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.dropPricelistTable() : connection.commit(): " + ex.getMessage(), true, true);
        }
    }

    private String[] executeSQL(String sqlStatementParam) {
        Statement statement = null;
        Object resultset = null;
        String[] status = new String[]{"0", "0"};
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            status[0] = "1";
            status[1] = "Error: JavaDBClient.executeSQL(): connection.createStatement(): " + ex.getMessage();
            return status;
        }
        try {
            statement.executeUpdate(sqlStatementParam);
        }
        catch (SQLException ex) {
            status[0] = "1";
            status[1] = "Error: JavaDBClient.executeSQL(): statement.executeUpdate(sqlStatementParam): " + ex.getMessage();
            return status;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.executeSQL() connection.commit(): " + ex.getMessage(), true, true);
        }
        return status;
    }

    private void checkTables() {
        Statement statement = null;
        ResultSet resultset = null;
        this.userInterface.feedback("db_tables_checking", 0);
        boolean tablesMissing = false;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'CUSTOMER'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("CUSTOMER")) {
                tablesMissing = true;
                this.createCustomerTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Customer", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkCustomerTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'RESELLER'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("RESELLER")) {
                tablesMissing = true;
                this.createResellerTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Reseller", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkResellerTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'CUSTOMERORDER'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("CUSTOMERORDER")) {
                tablesMissing = true;
                this.createCustomerOrderTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: CustomerOrder", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkCustomerOrderTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'CAMPAIGN'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("CAMPAIGN")) {
                tablesMissing = true;
                this.createCampaignTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Campaign", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkCampaignTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'DESTINATION'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("DESTINATION")) {
                tablesMissing = true;
                this.createDestinationTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Destination", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkDestinationTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'CAMPAIGNSTAT'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("CAMPAIGNSTAT")) {
                tablesMissing = true;
                this.createCampaignStatTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: CampaignStat", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkCampaignStatTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'INVOICE'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("INVOICE")) {
                tablesMissing = true;
                this.createInvoiceTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Invoice", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkInvoiceTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("Error: JavaDBClient.checkTables(): connection.createStatement(): " + ex.getMessage());
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = this.initDatabaseClientServer();
        }
        try {
            resultset = statement.executeQuery("SELECT * FROM SYS.SYSTABLES WHERE SYS.SYSTABLES.TABLETYPE = 'T' AND SYS.SYSTABLES.TABLENAME = 'PRICELIST'");
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): SQLException: " + ex.getMessage());
        }
        try {
            if (!resultset.next() || !resultset.getString(2).equals("PRICELIST")) {
                tablesMissing = true;
                this.createPricelistTable();
                this.userInterface.showStatus("JavaDB Database Client Created table: Pricelist", true, true);
            }
        }
        catch (SQLException ex) {
            System.out.println("Error: createTables(): checkPricelistTable: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient. : connection.commit(): " + ex.getMessage(), true, true);
        }
        if (tablesMissing) {
            this.userInterface.showStatus("JavaDB Database Client Created " + ECallCenter21.getBrand() + " Database", true, true);
        }
        this.userInterface.feedback("db_tables_checked", 0);
    }

    private synchronized void reportFailure(String message) {
        this.userInterface.showStatus("JavaDB Database Client Data Verification Failed: " + message, true, true);
    }

    public synchronized void printSQLException(SQLException error) {
        while (error != null) {
            this.userInterface.showStatus("SQLException: ", true, true);
            this.userInterface.showStatus(" SQL State: " + error.getSQLState(), true, true);
            this.userInterface.showStatus(" Error Code: " + error.getErrorCode(), true, true);
            this.userInterface.showStatus(" Message: " + error.getMessage(), true, true);
            error = error.getNextException();
        }
    }

    public void shutdownDB() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
                this.userInterface.showStatus("JavaDB Database Client Driver Shutdown Successfull", true, true);
            }
            this.userInterface.showStatus("JavaDB Database Client Driver Shutdown Unsuccessfull", true, true);
            this.printSQLException(se);
        }
    }

    public void unloadDriver() {
        Object statement = null;
        ResultSet resultset = null;
        try {
            if (resultset != null) {
                resultset.close();
                resultset = null;
            }
        }
        catch (SQLException sqle) {
            this.printSQLException(sqle);
        }
        int i = 0;
        while (!this.statements.isEmpty()) {
            Statement st = (Statement)this.statements.remove(i);
            try {
                if (st == null) continue;
                st.close();
                st = null;
            }
            catch (SQLException sqle) {
                this.printSQLException(sqle);
            }
        }
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sqle) {
            this.printSQLException(sqle);
        }
    }

    private void initPrepareStatements() {
        try {
            this.psInsertPricelist = this.connection.prepareStatement("INSERT INTO APP.Pricelist VALUES (?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdatePricelist = this.connection.prepareStatement("UPDATE APP.Pricelist SET B2BDaytimePerSecond = ?, B2BEveningPerSecond = ?, B2CDaytimePerSecond = ?, B2CEveningPerSecond = ?, A2SDaytimePerSecond = ?, A2SEveningPerSecond = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCustomer = this.connection.prepareStatement("INSERT INTO APP.Customer VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCustomer = this.connection.prepareStatement("UPDATE APP.Customer SET CompanyName = ?, Address = ?, AddressNr = ?, Postcode = ?, City = ?, Country = ?, ContactName = ?, PhoneNr = ?, MobileNr = ?, Email = ?, Password = ?, CustomerDiscount = ?, Comment = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertReseller = this.connection.prepareStatement("INSERT INTO APP.Reseller VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateReseller = this.connection.prepareStatement("UPDATE APP.Reseller SET CompanyName = ?, Address = ?, AddressNr = ?, Postcode = ?, City = ?, Country = ?, ContactName = ?, PhoneNr = ?, MobileNr = ?, Email = ?, Password = ?, ResellerDiscount = ?, Comment = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertOrder = this.connection.prepareStatement("INSERT INTO APP.CustomerOrder VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateOrder = this.connection.prepareStatement("UPDATE APP.CustomerOrder SET CustomerId = ?, Recipients = ?, Timewindow0 = ?, Timewindow1 = ?, Timewindow2 = ?, TargetTransactionQuantity = ?, MessageFilename = ?, messageDuration = ?, MessageRatePerSecond = ?, MessageRate = ?, SubTotal = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertInvoice = this.connection.prepareStatement("INSERT INTO APP.Invoice VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateInvoice = this.connection.prepareStatement("UPDATE APP.Invoice SET OrderId = ?, QuantityItem = ?, ItemDesc = ?, ItemUnitPrice = ?, ItemVATPercentage = ?, ItemQuantityPrice = ?, SubTotalB4Discount = ?, CustomerDiscount = ?, SubTotal = ?, VAT = ?, Total = ?, Paid = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaign = this.connection.prepareStatement("INSERT INTO APP.Campaign VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaign = this.connection.prepareStatement("UPDATE APP.Campaign SET Timestamp = ?, OrderId = ?, TimeScheduledStart = ?, TimeScheduledEnd = ?, TimeExpectedStart = ?, TimeExpectedEnd = ?, TimeRegisteredStart = ?, TimeRegisteredEnd = ?, TestCampaign = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertDestination = this.connection.prepareStatement("INSERT INTO APP.Destination VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateDestination = this.connection.prepareStatement("UPDATE APP.Destination SET CampaignId = ?, DestinationCount = ?, Destination = ?, ConnectingTimestamp = ?, TryingTimestamp = ?, CallingTimestamp = ?, CallingAttempts = ?, RingingTimestamp = ?, LocalCancelingTimestamp = ?, RemoteCancelingTimestamp = ?, LocalBusyTimestamp = ?, RemoteBusyTimestamp = ?, AcceptingTimestamp = ?, TalkingTimestamp = ?, LocalByeTimestamp = ?, RemoteByeTimestamp = ?, ResponseStatusCode = ?,  ResponseStatusDesc = ? WHERE Id = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psInsertCampaignStat = this.connection.prepareStatement("INSERT INTO APP.CampaignStat VALUES (DEFAULT, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
        try {
            this.psUpdateCampaignStat = this.connection.prepareStatement("UPDATE APP.CampaignStat SET OnAC = ?, IdleAC = ?, ConnectingAC = ?, ConnectingTT = ?, TryingAC = ?, TryingTT = ?, CallingAC = ?, CallingTT = ?, RingingAC = ?, RingingTT = ?, AcceptingAC = ?, AcceptingTT = ?, TalkingAC = ?, TalkingTT = ?, LocalCancelTT = ?, RemoteCancelTT = ?, LocalBusyTT = ?, RemoteBusyTT = ?, LocalByeTT = ?, RemoteByeTT = ? WHERE CampaignId = ?");
        }
        catch (SQLException ex) {
            this.userInterface.showStatus("Error: JavaDBClient.initPrepareStatements(): " + ex.getMessage(), true, true);
        }
    }

    public boolean getDBServerTest() {
        return this.dbServerTest;
    }
}

