/*
 * Decompiled with CFR 0.152.
 */
import datasets.Configuration;
import java.awt.EventQueue;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;

public class JavaDBServer
extends Thread {
    private Connection connection = null;
    private final String protocol = "jdbc:derby:";
    private String database = "";
    private final String attributes = ";create=true";
    private final String user = "dbadmin";
    private final String toegang = "IsNwtNp4DB";
    private final String url = "jdbc:derby:" + this.database + ";create=true";
    private boolean keepRunning = true;
    private Properties props;
    private NetworkServerControl networkServerControl;
    private UserInterface userInterface;
    private JavaDBServer javaDBServerReference;

    public JavaDBServer(UserInterface userInterfaceParam, String databaseParam, boolean testParam) throws Exception {
        this.userInterface = userInterfaceParam;
        this.javaDBServerReference = this;
        this.networkServerControl = new NetworkServerControl();
        this.database = databaseParam;
        if (testParam) {
            System.setProperty("derby.system.durability", "test");
            System.setProperty("derby.storage.rowLocking", "true");
        }
        this.props = new Properties();
        this.props.setProperty("derby.system.home", Configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.database);
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        this.userInterface.showStatus("JavaDB Database Server Starting...", true, true);
        this.userInterface.feedback("db_server_starting", 0);
        Thread javaDBServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaDBServer.this.networkServerControl.start(null);
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() networkServerControl.start(null): " + ex.getMessage());
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    JavaDBServer.this.javaDBServerReference.waitForStart();
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() javaDBServerReference.waitForStart(): " + ex.getMessage());
                }
                try {
                    JavaDBServer.this.connection = DriverManager.getConnection(JavaDBServer.this.url, JavaDBServer.this.props);
                }
                catch (SQLException ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: SQLException: JavaDBServer() DriverManager.getConnection(url, props): " + ex.getMessage());
                }
                try {
                    JavaDBServer.this.test(JavaDBServer.this.connection);
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() test(connection): " + ex.getMessage());
                }
                JavaDBServer.this.initRuntime();
            }
        });
        javaDBServerThread.setName("javaDBServerThread");
        javaDBServerThread.setDaemon(false);
        javaDBServerThread.setPriority(9);
        javaDBServerThread.start();
    }

    public JavaDBServer() throws Exception {
        this.javaDBServerReference = this;
        this.networkServerControl = new NetworkServerControl();
        this.database = "JavaDB";
        System.setProperty("derby.system.durability", "test");
        System.setProperty("derby.storage.rowLocking", "true");
        this.props = new Properties();
        this.props.setProperty("derby.system.home", Configuration.getDatabasesDir());
        this.props.setProperty("databaseName", this.database);
        this.props.setProperty("user", "dbadmin");
        this.props.setProperty("password", "IsNwtNp4DB");
        this.userInterface.showStatus("JavaDB Database Server Starting...", true, true);
        this.userInterface.feedback("db_server_starting", 0);
        Thread javaDBServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JavaDBServer.this.networkServerControl.start(null);
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() networkServerControl.start(null): " + ex.getMessage());
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    JavaDBServer.this.javaDBServerReference.waitForStart();
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() javaDBServerReference.waitForStart(): " + ex.getMessage());
                }
                try {
                    JavaDBServer.this.connection = DriverManager.getConnection(JavaDBServer.this.url, JavaDBServer.this.props);
                }
                catch (SQLException ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: SQLException: JavaDBServer() DriverManager.getConnection(url, props): " + ex.getMessage());
                }
                try {
                    JavaDBServer.this.test(JavaDBServer.this.connection);
                }
                catch (Exception ex) {
                    JavaDBServer.this.userInterface.logToApplication("Error: Exception: JavaDBServer() test(connection): " + ex.getMessage());
                }
                JavaDBServer.this.initRuntime();
            }
        });
        javaDBServerThread.setName("javaDBServerThread");
        javaDBServerThread.setDaemon(false);
        javaDBServerThread.setPriority(9);
        javaDBServerThread.start();
    }

    private void waitForStart() throws Exception {
        NetworkServerControl server = new NetworkServerControl();
        this.userInterface.showStatus("JavaDB Database Server Waiting for Completion...", true, true);
        boolean dbserverok = false;
        int counter = 0;
        do {
            try {
                Thread.currentThread();
                Thread.sleep(250L);
                this.networkServerControl.ping();
            }
            catch (Exception e) {
                this.userInterface.showStatus("Try #" + counter + " " + e.toString(), true, true);
            }
        } while (!dbserverok && ++counter < 20);
        this.userInterface.showStatus("JavaDB Database Server Running", true, true);
        this.userInterface.feedback("db_server_started", 0);
    }

    public Connection getEmbeddedConnection() throws Exception {
        return DriverManager.getConnection(this.url, this.props);
    }

    public void test(Connection conn) throws Exception {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.createStatement();
            resultSet = statement.executeQuery("select count(*) from sys.systables");
            while (resultSet.next()) {
                this.userInterface.showStatus("JavaDB Database Server Ready for Connections", true, true);
            }
        }
        catch (SQLException sqle) {
            this.userInterface.showStatus("JavaDB Database Server Embedded Connection Failed Test: " + sqle.getMessage(), true, true);
            throw sqle;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void initRuntime() {
        String getProperty = "VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(";
        String setProperty = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(";
        String requireAuth = "'derby.connection.requireAuthentication'";
        String defaultConnMode = "'derby.database.defaultConnectionMode'";
        String fullAccessUsers = "'derby.database.fullAccessUsers'";
        String provider = "'derby.authentication.provider'";
        String propertiesOnly = "'derby.database.propertiesOnly'";
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException ex) {
            System.out.println("1: " + ex.getMessage());
        }
        String providerString = setProperty + provider + ", 'BUILTIN')";
        try {
            statement.executeUpdate(providerString);
        }
        catch (SQLException ex) {
            System.out.println("3: " + ex.getMessage());
        }
        String userString = setProperty + "'derby.user." + "dbadmin" + "', '" + "IsNwtNp4DB" + "')";
        try {
            statement.executeUpdate(userString);
        }
        catch (SQLException ex) {
            System.out.println("4: " + ex.getMessage());
        }
        String fullAccessUsersString = setProperty + fullAccessUsers + ", '" + "dbadmin" + "')";
        try {
            statement.executeUpdate(fullAccessUsersString);
        }
        catch (SQLException ex) {
            System.out.println("6: " + ex.getMessage());
        }
        String defaultConnectionModeString = setProperty + defaultConnMode + ", 'noAccess')";
        try {
            statement.executeUpdate(defaultConnectionModeString);
        }
        catch (SQLException ex) {
            System.out.println("5: " + ex.getMessage());
        }
        String requirteAuthString = setProperty + requireAuth + ", 'true')";
        try {
            statement.executeUpdate(requirteAuthString);
        }
        catch (SQLException ex) {
            System.out.println("2: " + ex.getMessage());
        }
        String propertiesOnlyString = setProperty + propertiesOnly + ", 'true')";
        try {
            statement.executeUpdate(propertiesOnlyString);
        }
        catch (SQLException ex) {
            System.out.println("7: " + ex.getMessage());
        }
        try {
            this.connection.commit();
        }
        catch (SQLException ex) {
            System.out.println("8: " + ex.getMessage());
        }
    }

    private void waitForExit() throws Exception {
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.keepRunning);
    }

    public void shutdown() {
        this.keepRunning = false;
        try {
            this.networkServerControl.shutdown();
        }
        catch (Exception ex) {
            System.err.println("Error: DBServer.shutdown: " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new JavaDBServer();
                }
                catch (Exception ex) {
                    System.err.println("Error: main(): " + ex.getMessage());
                }
            }
        });
    }

    @Override
    public void run() {
    }
}

