/*
 * Decompiled with CFR 0.152.
 */
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestAlgorithm {
    private boolean debugging = false;
    private final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    String calculateResponse(String algorithm, String username_value, String realm_value, String passwd, String nonce_value, String nc_value, String cnonce_value, String method, String digest_uri_value, String entity_body, String qop_value) {
        if (username_value == null || realm_value == null || passwd == null || method == null || digest_uri_value == null || nonce_value == null) {
            throw new NullPointerException("Null parameter to MessageDigestAlgorithm.calculateResponse()");
        }
        String A1 = null;
        if (algorithm == null || algorithm.trim().length() == 0 || algorithm.trim().equalsIgnoreCase("MD5")) {
            if (this.debugging) {
                System.out.print(" 1 ");
            }
            A1 = username_value + ":" + realm_value + ":" + passwd;
        } else {
            if (this.debugging) {
                System.out.print(" 2 ");
            }
            if (cnonce_value == null || cnonce_value.length() == 0) {
                if (this.debugging) {
                    System.out.print("3");
                }
                throw new NullPointerException("cnonce_value may not be absent for MD5-Sess algorithm.");
            }
            if (this.debugging) {
                System.out.print(" 4 ");
            }
            A1 = this.H(username_value + ":" + realm_value + ":" + passwd) + ":" + nonce_value + ":" + cnonce_value;
        }
        String A2 = null;
        if (qop_value == null || qop_value.trim().length() == 0 || qop_value.trim().equalsIgnoreCase("auth")) {
            if (this.debugging) {
                System.out.print(" 5 ");
            }
            A2 = method + ":" + digest_uri_value;
        } else {
            if (this.debugging) {
                System.out.print(" 6 ");
            }
            if (entity_body == null) {
                if (this.debugging) {
                    System.out.print(" 7 ");
                }
                entity_body = "";
            }
            A2 = method + ":" + digest_uri_value + ":" + this.H(entity_body);
        }
        String request_digest = null;
        if (cnonce_value != null && qop_value != null && nc_value != null && (qop_value.equalsIgnoreCase("auth") || qop_value.equalsIgnoreCase("auth-int"))) {
            if (this.debugging) {
                System.out.print(" 8 ");
            }
            request_digest = this.KD(this.H(A1), nonce_value + ":" + nc_value + ":" + cnonce_value + ":" + qop_value + ":" + this.H(A2));
        } else {
            if (this.debugging) {
                System.out.print(" 9 ");
            }
            request_digest = this.KD(this.H(A1), nonce_value + ":" + this.H(A2));
        }
        return request_digest;
    }

    private String H(String data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return this.toHexString(digest.digest(data.getBytes()));
        }
        catch (NoSuchAlgorithmException error) {
            System.out.println("Failed to instantiate an MD5 algorithm" + error);
            return null;
        }
    }

    private String KD(String secret, String data) {
        return this.H(secret + ":" + data);
    }

    private String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = this.toHex[b[i] >> 4 & 0xF];
            c[pos++] = this.toHex[b[i] & 0xF];
        }
        return new String(c);
    }
}

