/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MeterPlotFile
extends ApplicationFrame {
    private static DefaultValueDataset dataset;

    public MeterPlotFile(String title) {
        super(title);
        JPanel chartPanel = MeterPlotFile.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static JFreeChart createChart(DefaultValueDataset dataset) {
        MeterPlot plot = new MeterPlot((ValueDataset)dataset);
        JFreeChart chart = new JFreeChart("Chart", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        return chart;
    }

    public static JPanel createDemoPanel() {
        dataset = new DefaultValueDataset(50.0);
        JFreeChart chart = MeterPlotFile.createChart(dataset);
        JPanel panel = new JPanel(new BorderLayout());
        JSlider slider = new JSlider(0, 100, 50);
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(5);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                dataset.setValue((Number)new Integer(s.getValue()));
            }
        });
        panel.add((Component)new ChartPanel(chart));
        panel.add("South", slider);
        return panel;
    }

    public static void main(String[] args) {
        MeterPlotFile demo = new MeterPlotFile("Meter Plot");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

