/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import net.sf.atomicdate.Client;

public class NTPDate
extends Date {
    private static final long serialVersionUID = 1064411106013132402L;
    private String[] status;
    public static final String SERVER_ADDRESS_PROPERTY = "time.euro.apple.com";
    public static final String DEFAULT_SERVER_ADDRESS = "pool.ntp.org";

    public NTPDate() {
        this.status = new String[2];
        this.status[0] = "0";
        this.status[1] = "";
    }

    public NTPDate(String haddr) throws IOException {
        this(haddr, 123);
    }

    public NTPDate(String haddr, int port) throws IOException {
        this(InetAddress.getByName(haddr), port);
    }

    public NTPDate(InetAddress raddr) throws IOException {
        this(raddr, 123);
    }

    public NTPDate(InetAddress addr, int port) throws IOException {
        this.synchronize(addr, port);
    }

    public String[] synchronize() {
        int port;
        String host;
        String property = System.getProperty(SERVER_ADDRESS_PROPERTY, DEFAULT_SERVER_ADDRESS);
        int hostIndex = property.indexOf(":");
        if (hostIndex != -1) {
            host = property.substring(0, hostIndex);
            try {
                port = Integer.parseInt(property.substring(hostIndex + 1));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Invalid default SNTP server port.");
            }
        } else {
            host = property;
            port = 123;
        }
        try {
            this.status = this.synchronize(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException ex) {
            this.status[0] = "1";
            this.status[1] = "Error: UnknownHostException: synchronize(InetAddress.getByName(host), port): " + ex.getMessage();
            return this.status;
        }
        return this.status;
    }

    public String[] synchronize(InetAddress addr, int port) {
        this.status = new String[2];
        this.status[0] = "0";
        this.status[1] = "";
        Client ntpClient = null;
        try {
            ntpClient = new Client();
        }
        catch (SocketException ex) {
            this.status[0] = "1";
            this.status[1] = "Error: SocketException: ntpClient = new Client(): " + ex.getMessage();
            return this.status;
        }
        try {
            super.setTime(System.currentTimeMillis() + ntpClient.getOffset(addr));
        }
        catch (IOException ex) {
            this.status[0] = "1";
            this.status[1] = "Error: IOException: super.setTime(System.currentTimeMillis() + ntpClient.getOffset(addr)): " + ex.getMessage();
            return this.status;
        }
        if (ntpClient != null) {
            ntpClient.close();
            ntpClient = null;
        }
        return this.status;
    }
}

