/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class NetManagerClient {
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private String message;
    private String server = "localhost";
    private Socket socket;
    private int serverPort = 1969;
    private boolean runThreadsAsDaemons = true;
    private Manager manager;
    private int connectTimeout = 999;
    private InetAddress localhost;
    private SocketAddress serverSocketAddress;
    private boolean clientStopRequested = true;

    public NetManagerClient(Manager managerParam, int portParam) {
        String[] status = new String[2];
        this.manager = managerParam;
        this.serverPort = portParam;
        try {
            this.localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.serverSocketAddress = new InetSocketAddress(this.localhost, this.serverPort);
        this.socket = new Socket();
    }

    public String[] connectAndSend(String messageParam) {
        String[] status = new String[]{"0", ""};
        this.socket = new Socket();
        try {
            this.socket.connect(this.serverSocketAddress, this.connectTimeout);
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: connectAndSend: socket.connect(serverSocketAddress, 500) " + ex.getMessage();
            return status;
        }
        try {
            this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: connectAndSend: outputStream = new ObjectOutputStream(..) " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: NetManClient(): output.flush() " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        try {
            this.inputStream = new ObjectInputStream(this.socket.getInputStream());
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: connectAndSend: inputStream = new ObjectInputStream() " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        try {
            this.outputStream.writeObject(messageParam);
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: connectAndSend: outputStream.writeObject(messageParam) " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: outputStream.flush() " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        try {
            status[1] = (String)this.inputStream.readObject();
        }
        catch (IOException ex) {
            status[0] = "1";
            status[1] = "Error: IOException: connectAndSend: inputStream.readObject() " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        catch (ClassNotFoundException ex) {
            status[0] = "1";
            status[1] = "Error: ClassNotFoundException: inputStream.readObject() " + ex.getMessage();
            this.closeConnection();
            return status;
        }
        this.closeConnection();
        return status;
    }

    public void closeConnection() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
            }
        }
        catch (IOException ex) {
            this.manager.showStatus("Error: NetManagerClient.closeConnection() " + ex.getMessage(), true, true);
        }
    }

    public boolean isConnected() {
        if (this.socket != null) {
            return this.socket.isConnected();
        }
        return false;
    }

    public boolean isBound() {
        return this.socket.isBound();
    }
}

