/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class NetManagerServer {
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private ServerSocket serverSocket;
    private Socket socket;
    private int serverPort;
    private boolean serverStopRequested = false;
    private int connections = 1;
    private boolean runThreadsAsDaemons = true;
    private ECallCenter21 eCallCenter21;

    public NetManagerServer(ECallCenter21 netManagerViewParam, int portParam) {
        this.eCallCenter21 = netManagerViewParam;
        this.serverPort = portParam;
        Thread netManagerServerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                NetManagerServer.this.eCallCenter21.showStatus("Management Server Starting", true, true);
                boolean serverStartUnsuccessful = false;
                boolean retryCounter = false;
                int retryLimit = 100;
                int retryInterval = 100;
                try {
                    NetManagerServer.this.serverSocket = new ServerSocket(NetManagerServer.this.serverPort, NetManagerServer.this.connections);
                }
                catch (IOException ex) {
                    NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: new ServerSocket(serverPort, connections)" + ex.getMessage(), true, true);
                    serverStartUnsuccessful = true;
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                NetManagerServer.this.serverStopRequested = false;
                while (!NetManagerServer.this.serverStopRequested) {
                    try {
                        NetManagerServer.this.socket = NetManagerServer.this.serverSocket.accept();
                    }
                    catch (IOException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: serverSocket.accept() " + ex.getMessage(), true, true);
                    }
                    try {
                        NetManagerServer.this.outputStream = new ObjectOutputStream(NetManagerServer.this.socket.getOutputStream());
                    }
                    catch (IOException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: new ObjectOutputStream(socket.getOutputStream())" + ex.getMessage(), true, true);
                        NetManagerServer.this.closeConnection();
                        NetManagerServer.this.stopServer();
                        return;
                    }
                    try {
                        NetManagerServer.this.outputStream.flush();
                    }
                    catch (IOException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: outputStream.flush()" + ex.getMessage(), true, true);
                    }
                    try {
                        NetManagerServer.this.inputStream = new ObjectInputStream(NetManagerServer.this.socket.getInputStream());
                    }
                    catch (IOException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: new ObjectInputStream(socket.getInputStream()" + ex.getMessage(), true, true);
                        NetManagerServer.this.closeConnection();
                        NetManagerServer.this.stopServer();
                        return;
                    }
                    String message = new String("");
                    try {
                        message = (String)NetManagerServer.this.inputStream.readObject();
                    }
                    catch (IOException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: IOException: NetManagerServer: inputStream.readObject()" + ex.getMessage(), true, true);
                        NetManagerServer.this.closeConnection();
                    }
                    catch (ClassNotFoundException ex) {
                        NetManagerServer.this.eCallCenter21.showStatus("Error: ClassNotFoundException: NetManagerServer: inputStream.readObject()" + ex.getMessage(), true, true);
                        NetManagerServer.this.closeConnection();
                    }
                    if (message.equalsIgnoreCase("getCallCenterStatus")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getCallCenterStatus()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getCallCenterStatusDescription")) {
                        NetManagerServer.this.respond(NetManagerServer.this.eCallCenter21.getCallCenterStatusDescription());
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getBoundMode")) {
                        NetManagerServer.this.respond(NetManagerServer.this.eCallCenter21.getBoundMode());
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getCampaignReRunStage")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getCampaignReRunStage()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getCampaignProgressPercentage")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getCampaignProgressPercentage()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getSoftphonesQuantity")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getSoftphonesQuantity()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getIdleAC")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getIdleAC()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getConnectingAC")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getConnectingAC()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getConnectingTT")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getConnectingTT()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getCallingAC")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getCallingAC()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getCallingTT")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getCallingTT()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getTalkingAC")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getTalkingAC()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getTalkingTT")) {
                        NetManagerServer.this.respond(Integer.toString(NetManagerServer.this.eCallCenter21.getTalkingTT()));
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("runCampaign")) {
                        if (((NetManagerServer)NetManagerServer.this).eCallCenter21.campaign != null) {
                            ((NetManagerServer)NetManagerServer.this).eCallCenter21.runCampaignToggleButton.setSelected(true);
                            NetManagerServer.this.eCallCenter21.runCampaign(((NetManagerServer)NetManagerServer.this).eCallCenter21.campaign.getId());
                            NetManagerServer.this.respond(new String("OK"));
                        }
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("pauseCampaign")) {
                        if (((NetManagerServer)NetManagerServer.this).eCallCenter21.campaign != null) {
                            ((NetManagerServer)NetManagerServer.this).eCallCenter21.runCampaignToggleButton.setSelected(false);
                            NetManagerServer.this.respond(new String("OK"));
                        }
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("continueCampaign")) {
                        if (((NetManagerServer)NetManagerServer.this).eCallCenter21.campaign != null) {
                            ((NetManagerServer)NetManagerServer.this).eCallCenter21.runCampaignToggleButton.setSelected(true);
                            NetManagerServer.this.respond(new String("OK"));
                        }
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("stopCampaign")) {
                        if (((NetManagerServer)NetManagerServer.this).eCallCenter21.campaign != null) {
                            NetManagerServer.this.eCallCenter21.stopCampaign();
                            if (!((NetManagerServer)NetManagerServer.this).eCallCenter21.runCampaignToggleButton.isSelected()) {
                                ((NetManagerServer)NetManagerServer.this).eCallCenter21.runCampaignToggleButton.setSelected(true);
                            }
                            NetManagerServer.this.respond(new String("OK"));
                        }
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("closeCallCenter")) {
                        NetManagerServer.this.eCallCenter21.closeCallCenter();
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("setPowerOn")) {
                        NetManagerServer.this.eCallCenter21.setPowerOn(true);
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("getPID")) {
                        NetManagerServer.this.respond(NetManagerServer.this.eCallCenter21.getPID());
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("setPowerOff")) {
                        NetManagerServer.this.eCallCenter21.setPowerOn(false);
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("register")) {
                        NetManagerServer.this.eCallCenter21.register();
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("unregister")) {
                        NetManagerServer.this.eCallCenter21.unRegister();
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("version")) {
                        NetManagerServer.this.eCallCenter21;
                        NetManagerServer.this.respond(ECallCenter21.getVersion());
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    if (message.equalsIgnoreCase("isStalling")) {
                        NetManagerServer.this.respond(NetManagerServer.this.eCallCenter21.isStalling());
                        NetManagerServer.this.closeConnection();
                        continue;
                    }
                    NetManagerServer.this.respond("Command Invalid");
                    NetManagerServer.this.closeConnection();
                }
                NetManagerServer.this.stopServer();
            }
        });
        netManagerServerThread.setName("netManagerServerThread");
        netManagerServerThread.setDaemon(false);
        netManagerServerThread.setPriority(7);
        netManagerServerThread.start();
    }

    public boolean serverIsListening() {
        return this.serverSocket.isBound();
    }

    public void respond(String messageParam) {
        try {
            this.outputStream.writeObject(messageParam);
        }
        catch (IOException ex) {
            this.eCallCenter21.showStatus("Error: IOException: NetManagerServer.respond(): writeObject(messageParam)" + ex.getMessage(), true, true);
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException ex) {
            this.eCallCenter21.showStatus("Error: IOException: outputStream.flush()" + ex.getMessage(), true, true);
        }
        this.eCallCenter21.selfDestructCounter = this.eCallCenter21.getSelfDestructCounterLimit();
        this.eCallCenter21.blinkNetManagerToggleButton();
    }

    public void closeConnection() {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException ex) {
                this.eCallCenter21.showStatus("Error: IOException: NetManagerServer.closeConnection: socket.shutdownInput()" + ex.getMessage(), true, true);
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException ex) {
                this.eCallCenter21.showStatus("Error: IOException: NetManagerServer.closeConnection: socket.shutdownOutput()" + ex.getMessage(), true, true);
            }
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.eCallCenter21.showStatus("Error: IOException: NetManagerServer.closeConnection: socket.close()" + ex.getMessage(), true, true);
            }
        }
    }

    public void blockServer(boolean enableParam) {
        if (enableParam) {
            try {
                this.serverSocket.setSoTimeout(0);
            }
            catch (SocketException ex) {
                this.eCallCenter21.showStatus("Error: SocketException: NetManagerServer: serverSocket.setSoTimeout(0) " + ex.getMessage(), true, true);
            }
        } else {
            try {
                this.serverSocket.setSoTimeout(1);
            }
            catch (SocketException ex) {
                this.eCallCenter21.showStatus("Error: SocketException: NetManagerServer: serverSocket.setSoTimeout(0) " + ex.getMessage(), true, true);
            }
        }
    }

    public void stopServer() {
        this.serverStopRequested = true;
        this.closeConnection();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                this.eCallCenter21.showStatus("Error: IOException: NetManagerServer.stopServer: serverSocket.close()" + ex.getMessage(), true, true);
            }
        }
        this.eCallCenter21.showStatus("Management Server Closed", false, false);
    }
}

