/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class PerformanceMeter
implements ChangeListener {
    public JFreeChart chart1;
    public ChartPanel chartPanel;
    private DefaultValueDataset vmUsageDataset = new DefaultValueDataset(50.0);
    private DefaultValueDataset callPerHourDataset = new DefaultValueDataset(10.0);
    private StandardDialScale vmUsageScale;
    private StandardDialScale callsPerHourScale;
    private DialPlot dialPlot;
    private StandardDialRange standardDialRangeRed;
    private StandardDialRange standardDialRangeOrange;
    private StandardDialRange standardDialRangeGreen;
    private int callsPerHourScaleRange;
    private int vmUsageScaleRange = 100;
    private int scaleFactorBetweenBothScalers;

    public PerformanceMeter(String title, int vmUsageDecelerationThreasholdParam, int callsPerHourScaleRangeParam) {
        this.callsPerHourScaleRange = callsPerHourScaleRangeParam;
        this.scaleFactorBetweenBothScalers = 1;
        this.dialPlot = new DialPlot();
        this.dialPlot.setDataset(0, (ValueDataset)this.vmUsageDataset);
        this.dialPlot.setDataset(1, (ValueDataset)this.callPerHourDataset);
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setBackgroundPaint((Paint)Color.lightGray);
        dialFrame.setForegroundPaint((Paint)Color.darkGray);
        dialFrame.setStroke((Stroke)new BasicStroke(1.0f));
        this.dialPlot.setDialFrame((DialFrame)dialFrame);
        GradientPaint gp = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 170));
        DialBackground db = new DialBackground((Paint)gp);
        db.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        this.dialPlot.setBackground((DialLayer)db);
        this.vmUsageScale = new StandardDialScale(0.0, (double)this.vmUsageScaleRange, -120.0, -300.0, 10.0, 10);
        this.vmUsageScale.setMajorTickPaint((Paint)Color.red);
        this.vmUsageScale.setTickRadius(0.5);
        this.vmUsageScale.setTickLabelOffset(0.15);
        this.vmUsageScale.setTickLabelFont(new Font("STHeiti", 0, 11));
        this.dialPlot.addScale(0, (DialScale)this.vmUsageScale);
        this.dialPlot.mapDatasetToScale(0, 0);
        this.callsPerHourScale = new StandardDialScale(0.0, (double)this.callsPerHourScaleRange, -120.0, -300.0, 10.0, 10);
        this.callsPerHourScale.setMajorTickIncrement((double)(this.callsPerHourScaleRange / 10));
        this.callsPerHourScale.setTickLabelPaint((Paint)Color.BLACK);
        this.callsPerHourScale.setMajorTickPaint((Paint)Color.BLUE);
        this.callsPerHourScale.setMajorTickLength(0.02);
        this.callsPerHourScale.setMinorTickCount(10);
        this.callsPerHourScale.setTickRadius(0.88);
        this.callsPerHourScale.setTickLabelOffset(0.15);
        this.callsPerHourScale.setTickLabelFont(new Font("STHeiti", 0, 14));
        this.dialPlot.addScale(1, (DialScale)this.callsPerHourScale);
        this.dialPlot.mapDatasetToScale(1, 1);
        DialValueIndicator dialValueIndicator2 = new DialValueIndicator(0);
        dialValueIndicator2.setFont(new Font("STHeiti", 0, 10));
        dialValueIndicator2.setPaint((Paint)Color.BLACK);
        dialValueIndicator2.setOutlinePaint((Paint)Color.red);
        dialValueIndicator2.setRadius(0.6);
        dialValueIndicator2.setAngle(-77.0);
        this.dialPlot.addLayer((DialLayer)dialValueIndicator2);
        DialValueIndicator dialValueIndicator = new DialValueIndicator(1);
        dialValueIndicator.setFont(new Font("STHeiti", 0, 10));
        dialValueIndicator.setPaint((Paint)Color.BLACK);
        dialValueIndicator.setOutlinePaint((Paint)Color.black);
        dialValueIndicator.setRadius(0.6);
        dialValueIndicator.setAngle(-103.0);
        this.dialPlot.addLayer((DialLayer)dialValueIndicator);
        this.addColorScale(Math.round(vmUsageDecelerationThreasholdParam / this.scaleFactorBetweenBothScalers), this.vmUsageScaleRange, 0.0, 0.0, 0.0, 0.0, 0.49, 0.5);
        DialTextAnnotation annotation2 = new DialTextAnnotation("X100");
        annotation2.setFont(new Font("Courier", 0, 18));
        annotation2.setRadius(0.71);
        this.dialPlot.addLayer((DialLayer)annotation2);
        DialPointer.Pin vmUsageNeedle = new DialPointer.Pin(0);
        vmUsageNeedle.setRadius(0.55);
        this.dialPlot.addLayer((DialLayer)vmUsageNeedle);
        DialPointer.Pointer callsPerHourNeedle = new DialPointer.Pointer(1);
        this.dialPlot.addLayer((DialLayer)callsPerHourNeedle);
        DialCap cap = new DialCap();
        cap.setRadius(0.1);
        this.dialPlot.setCap((DialLayer)cap);
        this.chart1 = new JFreeChart((Plot)this.dialPlot);
        this.chartPanel = new ChartPanel(this.chart1);
        this.chartPanel.setPreferredSize(new Dimension(150, 150));
        Color windowGrey = new Color(216, 216, 222);
        this.chart1.setBackgroundPaint((Paint)windowGrey);
    }

    public void setCallPerHourScale(double startValue, double endValue, double majorTickIncrement) {
        this.callsPerHourScale.setLowerBound(startValue);
        this.callsPerHourScale.setUpperBound(endValue);
        this.callsPerHourScale.setMajorTickIncrement(majorTickIncrement);
    }

    public void addColorScale(double redStart, double redEnd, double orangeStart, double orangeEnd, double greenStart, double greenEnd, double innerRadiusParam, double outerRadiusParam) {
        this.standardDialRangeRed = new StandardDialRange(redStart, redEnd, (Paint)Color.red);
        this.standardDialRangeRed.setInnerRadius(innerRadiusParam);
        this.standardDialRangeRed.setOuterRadius(outerRadiusParam);
        this.standardDialRangeOrange = new StandardDialRange(orangeStart, orangeEnd, (Paint)Color.orange);
        this.standardDialRangeOrange.setInnerRadius(innerRadiusParam);
        this.standardDialRangeOrange.setOuterRadius(outerRadiusParam);
        this.standardDialRangeGreen = new StandardDialRange(greenStart, greenEnd, (Paint)Color.green);
        this.standardDialRangeGreen.setInnerRadius(innerRadiusParam);
        this.standardDialRangeGreen.setOuterRadius(outerRadiusParam);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeRed);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeOrange);
        this.dialPlot.addLayer((DialLayer)this.standardDialRangeGreen);
    }

    public void setColorScale(double redStart, double redEnd, double orangeStart, double orangeEnd, double greenStart, double greenEnd) {
        double innerRadius = 0.0;
        double outerRadius = 0.5;
        this.standardDialRangeRed.setBounds(redStart, redEnd);
        this.standardDialRangeOrange.setBounds(orangeStart, orangeEnd);
        this.standardDialRangeGreen.setBounds(greenStart, greenEnd);
        this.standardDialRangeGreen.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
        this.standardDialRangeOrange.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
        this.standardDialRangeRed.setInnerRadius(innerRadius);
        this.standardDialRangeRed.setOuterRadius(outerRadius);
    }

    public void removeColorScale() {
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeRed);
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeOrange);
        this.dialPlot.removeLayer((DialLayer)this.standardDialRangeGreen);
    }

    public Number getCallPerHourNeedle() {
        return this.callPerHourDataset.getValue();
    }

    public Number getVMUsageNeedle() {
        return this.vmUsageDataset.getValue();
    }

    public void setCallPerHourNeedle(Number valueParam) {
        this.callPerHourDataset.setValue(valueParam);
    }

    public void setVMUsageNeedle(Number valueParam) {
        this.vmUsageDataset.setValue(valueParam);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

