/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.Connection;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.sdp.Time;
import javax.sdp.Version;

public class SDPConvert {
    byte[] mySDPBytes;
    SDPInfo mySDPInfo;
    Version myVersion;
    Origin myOrigin;
    SessionName mySessionName;
    Connection myConnection;
    Time myTime;
    Long ss;
    Vector myTimeVector;
    SdpFactory mySDPFactory = SdpFactory.getInstance();
    SessionDescription receiveSessionDescription;
    String[] myCodecArray = new String[9];

    public SDPConvert() {
        this.myCodecArray[0] = "ULAW/8000";
        this.myCodecArray[1] = "";
        this.myCodecArray[2] = "";
        this.myCodecArray[3] = "GSM/8000";
        this.myCodecArray[4] = "G723/8000";
        this.myCodecArray[5] = "";
        this.myCodecArray[6] = "";
        this.myCodecArray[7] = "";
        this.myCodecArray[8] = "ALAW/8000";
    }

    public byte[] info2Bytes(SDPInfo mySDPInfo, int audioFormatParam) {
        this.myVersion = this.mySDPFactory.createVersion(0);
        this.ss = null;
        try {
            this.ss = SdpFactory.getNtpTime((Date)new Date());
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: ss = mySDPFactory.getNtpTime(new Date()" + ex.getMessage());
        }
        this.myOrigin = null;
        try {
            this.myOrigin = this.mySDPFactory.createOrigin("-", 0L, 0L, "IN", "IP4", mySDPInfo.getIPAddress());
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: myOrigin = mySDPFactory.createOrigin(\"-\", 0L, 0L, \"IN\", \"IP4\", " + mySDPInfo.getIPAddress() + ") " + ex.getMessage());
        }
        this.mySessionName = this.mySDPFactory.createSessionName("Voice Session");
        Connection myConnection = null;
        try {
            myConnection = this.mySDPFactory.createConnection("IN", "IP4", mySDPInfo.getIPAddress());
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: myConnection = mySDPFactory.createConnection(\"IN\", \"IP4\", " + mySDPInfo.getIPAddress() + ") " + ex.getMessage());
        }
        this.myTime = null;
        try {
            this.myTime = this.mySDPFactory.createTime();
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: myTime = mySDPFactory.createTime() " + ex.getMessage());
        }
        this.myTimeVector = new Vector();
        this.myTimeVector.add(this.myTime);
        int[] audioFormatArray = new int[]{mySDPInfo.getAudioFormat(), 100};
        MediaDescription myMediaDescription = null;
        Vector<Object> myMediaDescriptionVector = new Vector<Object>();
        try {
            myMediaDescription = this.mySDPFactory.createMediaDescription("audio", mySDPInfo.getAudioPort(), 1, "RTP/AVP", audioFormatArray);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Error: IllegalArgumentException: myAudioDescription = mySDPFactory.createMediaDescription(\"audio\", mySDPInfo.getAudioPort(), 1, \"RTP/AVP\", audioFormat) " + ex.getMessage());
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: myAudioDescription = mySDPFactory.createMediaDescription(\"audio\", mySDPInfo.getAudioPort(), 1, \"RTP/AVP\", audioFormat) " + ex.getMessage());
        }
        Attribute myAudioAttribute = null;
        myAudioAttribute = this.mySDPFactory.createAttribute("rtpmap", "3 " + this.myCodecArray[audioFormatParam]);
        Attribute myTelephoneEvent = null;
        myTelephoneEvent = this.mySDPFactory.createAttribute("rtpmap", "100 telephone-event/8000");
        myMediaDescriptionVector.add(myMediaDescription);
        myMediaDescriptionVector.add(myAudioAttribute);
        myMediaDescriptionVector.add(myTelephoneEvent);
        SessionDescription mySessionDescription = null;
        try {
            mySessionDescription = this.mySDPFactory.createSessionDescription();
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription = mySDPFactory.createSessionDescription() " + ex.getMessage());
        }
        try {
            mySessionDescription.setVersion(this.myVersion);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setVersion(myVersion) " + ex.getMessage());
        }
        try {
            mySessionDescription.setOrigin(this.myOrigin);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setOrigin(myOrigin) " + ex.getMessage());
        }
        try {
            mySessionDescription.setSessionName(this.mySessionName);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setSessionName(mySessionName) " + ex.getMessage());
        }
        try {
            mySessionDescription.setConnection(myConnection);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setConnection(myConnection) " + ex.getMessage());
        }
        try {
            mySessionDescription.setTimeDescriptions(this.myTimeVector);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setTimeDescriptions(myTimeVector) " + ex.getMessage());
        }
        try {
            mySessionDescription.setMediaDescriptions(myMediaDescriptionVector);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpException: mySessionDescription.setMediaDescriptions(myMediaDescriptionVector) " + ex.getMessage());
        }
        byte[] mySDPBytes = mySessionDescription.toString().getBytes();
        return mySDPBytes;
    }

    public SDPInfo bytes2Info(byte[] mySDPBytes, int audioFormatParam) {
        String sdpString = new String((byte[])mySDPBytes.clone());
        SessionDescription receiveSessionDescription = null;
        try {
            receiveSessionDescription = this.mySDPFactory.createSessionDescription(sdpString);
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: receiveSessionDescription = mySDPFactory.createSessionDescription(stringContent) " + ex.getMessage());
        }
        String myPeerIP = null;
        try {
            myPeerIP = receiveSessionDescription.getConnection().getAddress();
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: myPeerIP = receiveSessionDescription.getConnection().getAddress() " + ex.getMessage());
        }
        String myUser = null;
        try {
            myUser = receiveSessionDescription.getOrigin().getUsername();
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: myPeerIP = receiveSessionDescription.getConnection().getAddress() " + ex.getMessage());
        }
        String myPeerName = null;
        try {
            myPeerName = receiveSessionDescription.getOrigin().getUsername();
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: myPeerName = receiveSessionDescription.getOrigin().getUsername() " + ex.getMessage());
        }
        Vector receiveMediaDescriptionVector = null;
        receiveMediaDescriptionVector = new Vector();
        try {
            receiveMediaDescriptionVector = receiveSessionDescription.getMediaDescriptions(false);
        }
        catch (SdpException ex) {
            System.out.println("Error: SdpParseException: receiveMediaDescriptionVector = receiveSessionDescription.getMediaDescriptions(false) " + ex.getMessage());
        }
        MediaDescription myAudioDescription = (MediaDescription)receiveMediaDescriptionVector.elementAt(0);
        Media myAudio = null;
        myAudio = myAudioDescription.getMedia();
        Integer myAudioPort = 0;
        try {
            myAudioPort = myAudio.getMediaPort();
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: myAudioPort = myAudio.getMediaPort() " + ex.getMessage());
        }
        Vector audioFormats = null;
        audioFormats = new Vector();
        try {
            audioFormats = myAudio.getMediaFormats(false);
        }
        catch (SdpParseException ex) {
            System.out.println("Error: SdpParseException: audioFormats = myAudio.getMediaFormats(false) " + ex.getMessage());
        }
        SDPInfo mySDPInfo = new SDPInfo();
        mySDPInfo.setIPAddress(myPeerIP);
        mySDPInfo.setUser(myUser);
        mySDPInfo.setAudioPort(myAudioPort);
        mySDPInfo.setAudioFormat(audioFormatParam);
        return mySDPInfo;
    }
}

