/*
 * Decompiled with CFR 0.152.
 */
import datasets.Configuration;
import datasets.Destination;
import datasets.DisplayData;
import datasets.SpeakerData;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import javax.media.NoDataSourceException;
import javax.media.NoProcessorException;
import javax.media.format.UnsupportedFormatException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AllowHeader;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.UserAgentHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SoftPhone
extends Thread
implements SipListener {
    private static final String THISPRODUCT = "SoftPhone";
    private static final String VERSION = "v1.0";
    private String sipDestination;
    private String aor;
    private String from;
    private String to;
    private String via;
    private String contact;
    public int sipstate;
    public static final int SIPSTATE_OFF = 0;
    public static final int SIPSTATE_ON = 1;
    public static final int SIPSTATE_IDLE = 2;
    public static final int SIPSTATE_WAIT_CONNECT = 3;
    public static final int SIPSTATE_WAIT_PROV = 4;
    public static final int SIPSTATE_WAIT_FINAL = 5;
    public static final int SIPSTATE_WAIT_ACK = 6;
    public static final int SIPSTATE_RINGING = 7;
    public static final int SIPSTATE_ESTABLISHED = 8;
    public static final int SIPSTATE_TRANSITION_LOCALCANCEL = 9;
    public static final int SIPSTATE_TRANSITION_REMOTECANCEL = 10;
    public static final int SIPSTATE_TRANSITION_LOCALBUSY = 11;
    public static final int SIPSTATE_TRANSITION_REMOTEBUSY = 12;
    public static final int SIPSTATE_TRANSITION_LOCALBYE = 13;
    public static final int SIPSTATE_TRANSITION_REMOTEBYE = 14;
    public static final int SIPSTATE_TRANSITION_CONFIG = 15;
    public static final String[] SIPSTATE_DESCRIPTION = new String[]{"SIPSTATE_OFF", "SIPSTATE_ON", "SIPSTATE_IDLE", "SIPSTATE_WAIT_PROV", "SIPSTATE_WAIT_FINAL", "SIPSTATE_WAIT_ACK", "SIPSTATE_RINGING", "SIPSTATE_ESTABLISHED", "SIPSTATE_TRANSITION_LOCALCANCEL", "SIPSTATE_TRANSITION_REMOTECANCEL", "SIPSTATE_TRANSITION_LOCALBUSY", "SIPSTATE_TRANSITION_REMOTEBUSY", "SIPSTATE_TRANSITION_LOCALBYE", "SIPSTATE_TRANSITION_REMOTEBYE", "SIPSTATE_TRANSITION_CONFIG"};
    public static final int SOFTPHONE_ACTIVITY_NORMAL = 0;
    public static final int SOFTPHONE_ACTIVITY_REGISTRATION = 1;
    public static final int SOFTPHONE_ACTIVITY_MAINTENANCE = 2;
    public static final int SOFTPHONE_ACTIVITY_REFRESH = 3;
    public static final int LOGINSTATE_UNREGISTERED = 0;
    public static final int LOGINSTATE_REGISTERED = 1;
    private final int PRIORITY_LOW = 5;
    private final int PRIORITY_HIGH = 9;
    private static final int CALLING = 0;
    private static final int SCANNING = 1;
    public int lastsipstate;
    public int loginstate;
    public int lastloginstate;
    public String availability = "Unavailable";
    public String registered = "Ready";
    public String unregistered = "Callout";
    public String off = "Off";
    private int localSIPPort;
    private int requestedClientAudioPort;
    private int assignedClientAudioPort;
    private int requestedServerAudioPort;
    private int assignedServerAudioPort;
    private String transport;
    private String udpTransport;
    private String inviteAckRequestBranch;
    private String rinstance;
    boolean runThreadsAsDaemons = true;
    boolean isSIPAddress;
    private int ultraShortMessagePeriod;
    private int eyeBlinkMessagePeriod;
    private int shortMessagePeriod;
    public int registerRequestCounter = 1;
    private int audioCodec = 3;
    private int videoPort = -1;
    private int videoCodec = -1;
    private static int registerLoginTimeout;
    private int registerLogoutTimeout;
    MessageDigestAlgorithm messageDigestAlgorithm;
    private SDPConvert sdpConvert;
    private byte[] offerSDPBytes;
    private byte[] answerSDPBytes;
    private SDPInfo offerSDPInfo;
    private SDPInfo answerSDPInfo;
    private Properties sipStackProperties;
    private SipFactory sipFactory;
    private SipStack sipStack;
    private ListeningPoint udpListeningPoint;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private AddressFactory addressFactory;
    private SipProvider sipProvider;
    private InetAddress localIPAddress;
    private int serverSocketBackLog;
    private Address destAddress;
    private Address toAddress;
    private Address fromAddress;
    private Address routeAddress;
    private Address registrarAddress;
    private Address privateContactAddress;
    private Address publicContactAddress;
    private RouteHeader routeHeader;
    private ContentTypeHeader contentTypeHeader;
    private CallIdHeader callIdHeader;
    private FromHeader fromHeader;
    private ToHeader toHeader;
    private ToHeader responseToHeader;
    private ViaHeader viaHeader;
    private ContactHeader privateContactHeader;
    private ContactHeader publicContactHeader;
    private CSeqHeader commandSequenceHeader;
    private ExpiresHeader expiresHeader;
    private AuthorizationHeader authorizationHeader;
    private ProxyAuthorizationHeader proxyAuthorizationHeader;
    private MaxForwardsHeader maxForwardsHeader;
    private UserAgentHeader userAgentHeader;
    private AllowHeader allowHeader;
    private ArrayList viaHeaders = new ArrayList();
    private ArrayList userAgentList = new ArrayList();
    private Request request;
    private Request ackRequest;
    private Request originalRequest;
    private Request registerRequest;
    private String destinationDisplay;
    private String filename;
    private int registerTimeout;
    private int retryInterval;
    Response response;
    private URI requestURI = null;
    private String registerRequestBranch;
    private String inviteRequestBranch;
    private String byeRequestBranch;
    private String cancelRequestBranch;
    private String serverToTag;
    private ClientTransaction clientTransaction;
    private ServerTransaction serverTransaction;
    private Dialog dialog;
    public SoundStreamer soundStreamer;
    private boolean debugging = false;
    private int debugginglevel;
    public boolean autoEndCall = false;
    public int autoRingingResponse;
    private final int NONE = 0;
    private final int ANSWER = 1;
    private final int CANCEL = 2;
    private final int RANDOM = 3;
    private int autoRingingResponseDelay;
    private int busyRatioPercentage = 0;
    private int inboundEndTimerDelay;
    public boolean audioIsMuted = false;
    private UserInterface userInterface1;
    private UserInterface userInterface2;
    private int softPhoneInstanceId;
    public Configuration configuration;
    public String activeLineNumber;
    private String fromHeaderAddress;
    private String toHeaderAddress;
    private DisplayData displayData;
    private SpeakerData speakerData;
    private boolean powerOffRequested = false;
    private boolean keepRunning;
    private Timer inboundEndCallTimer;
    private Timer outboundEndCallTimer;
    private Destination destination;
    private boolean scan = false;
    private SoftPhone softPhoneReference;
    private boolean ePhoneGUIActive = true;
    private final int LINE1BUTTON = 0;
    private final int LINE2BUTTON = 1;
    private final int SAVEBUTTON = 2;
    private final int REGISTERBUTTON = 3;
    private final int ANSWERBUTTON = 4;
    private final int CANCELBUTTON = 5;
    private final int RANDOMRINGRESPONSEBUTTON = 6;
    private final int ENDTIMERBUTTON = 7;
    private final int MUTEAUDIOBUTTON = 8;
    private final int DEBUGBUTTON = 9;
    private final int CALLBUTTON = 10;
    private final int ENDBUTTON = 11;
    private final int RESTARTSOFTPHONEBUTTON = 12;
    private final int MAXFORWARDS = 70;

    public SoftPhone(UserInterface userInterfaceParam, int softPhoneInstanceIdParam, boolean debuggingParam) {
        String[] status = new String[2];
        this.softPhoneReference = this;
        this.userInterface1 = userInterfaceParam;
        this.userInterface2 = null;
        this.softPhoneInstanceId = softPhoneInstanceIdParam;
        this.ultraShortMessagePeriod = 0;
        this.eyeBlinkMessagePeriod = 100;
        this.shortMessagePeriod = 200;
        this.debugging = debuggingParam;
        this.debugginglevel = 0;
        status = new String[2];
        this.configuration = new Configuration();
        status = this.configuration.loadConfiguration("1");
        this.messageDigestAlgorithm = new MessageDigestAlgorithm();
        this.offerSDPInfo = new SDPInfo();
        this.answerSDPInfo = new SDPInfo();
        this.sdpConvert = new SDPConvert();
        try {
            this.localIPAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: InetAddress.getLocalHost(): " + error.getMessage());
        }
        this.serverSocketBackLog = 1000;
        this.requestedClientAudioPort = 0;
        this.assignedClientAudioPort = 0;
        this.requestedServerAudioPort = 0;
        this.assignedServerAudioPort = 0;
        this.transport = "udp";
        this.udpTransport = "udp";
        this.availability = this.off;
        this.lastsipstate = this.sipstate;
        this.sipstate = 1;
        registerLoginTimeout = 3600;
        this.registerLogoutTimeout = 0;
        this.retryInterval = 10;
        this.destination = new Destination();
        this.autoRingingResponse = 0;
        this.displayData = new DisplayData();
        this.displayData.setOnFlag(false);
        this.displayData.setPrimaryStatusCell("Phone Powered " + this.availability);
        this.displayData.setPrimaryStatusDetailsCell("");
        this.displayData.setSecondaryStatusCell("");
        this.displayData.setSecondaryStatusDetailsCell("");
        this.speakerData = new SpeakerData();
        this.userInterface1.phoneDisplay(this.displayData);
        if (this.userInterface2 != null) {
            this.userInterface2.phoneDisplay(this.displayData);
        }
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        this.ePhoneGUIActive = true;
        this.keepRunning = true;
    }

    public SoftPhone(UserInterface userInterfaceParam, int softPhoneInstanceIdParam, boolean debuggingParam, Configuration configurationParam) throws CloneNotSupportedException {
        this(userInterfaceParam, softPhoneInstanceIdParam, debuggingParam);
        this.configuration = new Configuration();
        this.configuration = (Configuration)configurationParam.clone();
        this.ePhoneGUIActive = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] userInput(int buttonParam, String userInputParam1, String userInputParam2, String userInputParam3) {
        String[] status;
        block103: {
            block105: {
                block104: {
                    status = new String[]{"0", ""};
                    if (buttonParam == 0 || buttonParam == 1) {
                        this.activeLineNumber = userInputParam1;
                        if (userInputParam2.equals("1")) {
                            if (!userInputParam3.equals("0")) {
                                status = this.startListener(this.configuration.getClientPort());
                                if (!status[0].equals("1")) return status;
                                this.userInterface1.showStatus("Power Failure: " + status[1] + " (Configuration Cause?)", true, true);
                                if (!this.ePhoneGUIActive) return status;
                                this.displayData.setPrimaryStatusCell("Line" + this.activeLineNumber + " Failure");
                                this.displayData.setPrimaryStatusDetailsCell("");
                                this.displayData.setSecondaryStatusCell("");
                                this.displayData.setSecondaryStatusDetailsCell("");
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 == null) return status;
                                this.userInterface2.phoneDisplay(this.displayData);
                                return status;
                            }
                            status = this.configuration.loadConfiguration(userInputParam1);
                            if (!status[0].equals("1")) {
                                status = this.startListener(this.configuration.getClientPort());
                                if (!status[0].equals("1")) return status;
                                this.userInterface1.showStatus("Power Failure: " + status[1] + " (Configuration Cause?)", true, true);
                                if (!this.ePhoneGUIActive) return status;
                                this.displayData.setPrimaryStatusCell("Line" + this.activeLineNumber + " Failure");
                                this.displayData.setPrimaryStatusDetailsCell("");
                                this.displayData.setSecondaryStatusCell("");
                                this.displayData.setSecondaryStatusDetailsCell("");
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 == null) return status;
                                this.userInterface2.phoneDisplay(this.displayData);
                                return status;
                            }
                            this.userInterface1.showStatus("Error: loadConfiguration: " + status[1], true, true);
                            this.userInterface1.showStatus("Creating new configuration", true, true);
                            status[0] = "0";
                            status[1] = "";
                            status = this.configuration.createConfiguration();
                            if (status[0].equals("1")) {
                                this.userInterface1.showStatus("Error: Creating configuration, please setup configuration manually!", true, true);
                                return status;
                            }
                            this.userInterface1.showStatus("Creating Configuration Successfull", true, true);
                            this.userInterface1.showStatus("Saving Configuration", true, true);
                            status[0] = "0";
                            status[1] = "";
                            status = this.configuration.saveConfiguration(userInputParam1);
                            if (status[0].equals("1")) {
                                this.userInterface1.showStatus("Error: Saving Configuration: " + status[1] + " please contact your administrator!!", true, true);
                                return status;
                            }
                            this.userInterface1.showStatus("Saved new Configuration, please check new Configuration", true, true);
                            status[0] = "1";
                            status[1] = "Please restart Line";
                            return status;
                        }
                        if (this.loginstate != 1) return this.stopListener();
                        status = this.sendRegister(this.registerLogoutTimeout);
                        this.powerOffRequested = true;
                        if (!status[0].equals("1")) return status;
                        return this.stopListener();
                    }
                    if (buttonParam == 2) {
                        this.configuration.saveConfiguration(this.activeLineNumber);
                        return status;
                    }
                    if (buttonParam == 3) {
                        if (userInputParam1.equals("1") ? (status = this.sendRegister(registerLoginTimeout))[0].equals("1") : (status = this.sendRegister(this.registerLogoutTimeout))[0].equals("1")) {
                            return status;
                        }
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
                        return status;
                    }
                    if (buttonParam == 4) {
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (userInputParam1.equals("1")) {
                            this.autoRingingResponse = 1;
                            this.autoRingingResponseDelay = Integer.parseInt(userInputParam2);
                            if (this.ePhoneGUIActive) {
                                this.displayData.setAnswerFlag(true);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setAnswerEnabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setAnswerEnabledToneFlag(false);
                            }
                        } else {
                            this.autoRingingResponse = 0;
                            this.autoRingingResponseDelay = 0;
                            if (this.ePhoneGUIActive) {
                                this.displayData.setAnswerFlag(false);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setAnswerDisabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setAnswerDisabledToneFlag(false);
                            }
                        }
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                            return status;
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                            return status;
                        }
                    }
                    if (buttonParam == 5) {
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (userInputParam1.equals("1")) {
                            this.autoRingingResponse = 2;
                            this.autoRingingResponseDelay = Integer.parseInt(userInputParam2);
                            if (this.ePhoneGUIActive) {
                                this.displayData.setCancelFlag(true);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setCancelEnabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setCancelEnabledToneFlag(false);
                            }
                        } else {
                            this.autoRingingResponse = 0;
                            this.autoRingingResponseDelay = 0;
                            if (this.ePhoneGUIActive) {
                                this.displayData.setCancelFlag(false);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setCancelDisabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setCancelDisabledToneFlag(false);
                            }
                        }
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                            return status;
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                            return status;
                        }
                    }
                    if (buttonParam == 6) {
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (userInputParam1.equals("1")) {
                            this.autoRingingResponse = 3;
                            this.autoRingingResponseDelay = Integer.parseInt(userInputParam2);
                            this.busyRatioPercentage = Integer.parseInt(userInputParam3);
                            if (this.ePhoneGUIActive) {
                                this.displayData.setCancelFlag(true);
                                this.displayData.setAnswerFlag(true);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setAnswerEnabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setAnswerEnabledToneFlag(false);
                            }
                        } else {
                            this.autoRingingResponse = 0;
                            this.autoRingingResponseDelay = 0;
                            if (this.ePhoneGUIActive) {
                                this.displayData.setCancelFlag(false);
                                this.displayData.setAnswerFlag(false);
                                this.userInterface1.phoneDisplay(this.displayData);
                                if (this.userInterface2 != null) {
                                    this.userInterface2.phoneDisplay(this.displayData);
                                }
                                this.speakerData.setAnswerDisabledToneFlag(true);
                                this.userInterface1.speaker(this.speakerData);
                                this.speakerData.setAnswerDisabledToneFlag(false);
                            }
                        }
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
                        try {
                            Thread.sleep(this.ultraShortMessagePeriod);
                            return status;
                        }
                        catch (InterruptedException error) {
                            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                            return status;
                        }
                    }
                    if (buttonParam == 7) {
                        if (userInputParam1.equals("1")) {
                            this.inboundEndTimerDelay = Integer.parseInt(userInputParam2);
                            return status;
                        }
                        this.inboundEndTimerDelay = 0;
                        return status;
                    }
                    if (buttonParam != 8) break block103;
                    this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
                    try {
                        Thread.sleep(this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (!userInputParam1.equals("1")) break block104;
                    if (this.ePhoneGUIActive) {
                        this.displayData.setMuteFlag(true);
                        this.userInterface1.phoneDisplay(this.displayData);
                        if (this.userInterface2 != null) {
                            this.userInterface2.phoneDisplay(this.displayData);
                        }
                        this.speakerData.setMuteEnabledToneFlag(true);
                        this.userInterface1.speaker(this.speakerData);
                        this.speakerData.setMuteEnabledToneFlag(false);
                    }
                    if (this.soundStreamer != null) {
                        this.audioIsMuted = true;
                        status = this.muteAudio();
                        if (status[0].equals("1")) {
                            this.userInterface1.logToApplication(status[1]);
                        }
                    }
                    break block105;
                }
                if (this.soundStreamer != null) {
                    this.audioIsMuted = false;
                    status = this.unMuteAudio();
                    if (status[0].equals("1")) {
                        this.userInterface1.logToApplication(status[1]);
                    }
                }
                if (this.ePhoneGUIActive) {
                    this.displayData.setMuteFlag(false);
                    this.userInterface1.phoneDisplay(this.displayData);
                    if (this.userInterface2 != null) {
                        this.userInterface2.phoneDisplay(this.displayData);
                    }
                    this.speakerData.setMuteDisabledToneFlag(true);
                    this.userInterface1.speaker(this.speakerData);
                    this.speakerData.setMuteDisabledToneFlag(false);
                }
                if (status[0].equals("1")) {
                    this.userInterface1.logToApplication(status[1]);
                }
            }
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
                return status;
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                return status;
            }
        }
        if (buttonParam == 12) {
            status = this.restartListener();
            if (!status[0].equals("1")) return status;
            return status;
        }
        if (buttonParam == 9) {
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
            }
            this.debugging = userInputParam1.equals("1");
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
                return status;
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                return status;
            }
        }
        if (buttonParam == 10) {
            block102: {
                this.scan = userInputParam3.equals(Integer.toString(1));
                this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
                if (this.sipstate == 0) {
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
                if (this.sipstate == 1) {
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
                if (this.sipstate == 2) {
                    if (userInputParam1 != null && userInputParam2 != null && !userInputParam1.equals("") && !userInputParam2.equals("")) {
                        status = this.sendRequest(userInputParam1, userInputParam2);
                        if (status[0].equals("1")) {
                            return status;
                        }
                        break block102;
                    } else {
                        status[0] = "1";
                        status[1] = "Error: UserInput: CallButton UserInputParamater Error";
                        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
                        return status;
                    }
                }
                if (this.sipstate == 4) {
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
                if (this.sipstate == 5) {
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
                if (this.sipstate == 6) {
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
                if (this.sipstate == 7) {
                    status = this.createResponse();
                    if (status[0].equals("1")) {
                        return status;
                    }
                } else {
                    if (this.sipstate == 8) {
                        status[0] = "1";
                        status[1] = Integer.toString(this.sipstate);
                        return status;
                    }
                    status[0] = "1";
                    status[1] = Integer.toString(this.sipstate);
                    return status;
                }
            }
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
            return status;
        }
        if (buttonParam != 11) {
            status[0] = "1";
            status[1] = "Button not recognized";
            return status;
        }
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
        if (this.sipstate == 0) {
            this.stopTones();
        } else if (this.sipstate == 1) {
            this.stopTones();
        } else if (this.sipstate == 2) {
            this.stopTones();
        } else if (this.sipstate == 4) {
            status = this.cancelRequest();
            if (status[0].equals("1")) {
                return status;
            }
        } else if (this.sipstate == 5) {
            status = this.cancelRequest();
            if (status[0].equals("1")) {
                return status;
            }
        } else if (this.sipstate == 6) {
            status = this.cancelRequest();
            if (status[0].equals("1")) {
                return status;
            }
        } else if (this.sipstate == 7) {
            status = this.busyResponse();
            if (status[0].equals("1")) {
                return status;
            }
        } else {
            if (this.sipstate != 8) {
                status[0] = "1";
                status[1] = "State Error: Sipstate Unknown";
                return status;
            }
            status = this.byeRequest();
            if (status[0].equals("1")) {
                return status;
            }
        }
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
        return status;
    }

    private void stopTones() {
        this.speakerData.setRingToneFlag(false);
        this.speakerData.setCallToneFlag(false);
        this.userInterface1.speaker(this.speakerData);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int findFreePort() {
        ServerSocket serverSocket = null;
        do {
            try {
                serverSocket = new ServerSocket(0, this.serverSocketBackLog, this.localIPAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                serverSocket.setReuseAddress(true);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            try {
                serverSocket.bind(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!serverSocket.isBound());
        int autoPort = serverSocket.getLocalPort();
        try {
            serverSocket.close();
        }
        catch (IOException ex) {
            this.userInterface1.showStatus("\u260e " + this.softPhoneInstanceId + " Error: IOException: findFreePort(): serverSocket.close() " + ex.getMessage(), this.keepRunning, this.autoEndCall);
        }
        return autoPort;
    }

    public String[] startListener(String sourcePortParam) {
        this.sipStackProperties = new Properties();
        String[] status = new String[]{"0", ""};
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName("gov.nist");
        this.sipStackProperties.setProperty("javax.sip.STACK_NAME", Integer.toString(this.softPhoneInstanceId));
        this.sipStackProperties.setProperty("javax.sip.MAX_MESSAGE_SIZE", "4096");
        this.sipStackProperties.setProperty("javax.sip.THREAD_AUDIT_INTERVAL_IN_MILLISECS", "1000");
        try {
            this.sipStack = this.sipFactory.createSipStack(this.sipStackProperties);
        }
        catch (PeerUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createSipStack(mySipStackProperties): " + error.getMessage();
            return status;
        }
        boolean createUDPListeningPointUnSuccessFull = false;
        int retryCounter = 0;
        do {
            createUDPListeningPointUnSuccessFull = false;
            ServerSocket serverSocket = null;
            if (sourcePortParam.equals("auto") || sourcePortParam.equals("")) {
                try {
                    serverSocket = new ServerSocket(0, this.serverSocketBackLog, this.localIPAddress);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.localSIPPort = serverSocket.getLocalPort();
            } else {
                this.localSIPPort = Integer.parseInt(sourcePortParam);
            }
            try {
                this.udpListeningPoint = this.sipStack.createListeningPoint(this.configuration.getClientIP(), this.localSIPPort, this.udpTransport);
            }
            catch (TransportNotSupportedException error) {
                createUDPListeningPointUnSuccessFull = true;
                if (retryCounter != 3) continue;
                status[0] = "1";
                status[1] = "\u260e " + this.softPhoneInstanceId + " [" + retryCounter + "] TransportNotSupportedException: mySipStack.createListeningPoint(..udp..) " + error.getMessage();
                return status;
            }
            catch (InvalidArgumentException error) {
                createUDPListeningPointUnSuccessFull = true;
                if (retryCounter != 3) continue;
                status[0] = "1";
                status[1] = "\u260e " + this.softPhoneInstanceId + " [" + retryCounter + "] InvalidArgumentException: mySipStack.createListeningPoint(..udp..) " + error.getMessage();
                return status;
            }
        } while (++retryCounter <= 3 && createUDPListeningPointUnSuccessFull);
        try {
            this.messageFactory = this.sipFactory.createMessageFactory();
        }
        catch (PeerUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createMessageFactory(): " + error.getMessage();
            return status;
        }
        try {
            this.addressFactory = this.sipFactory.createAddressFactory();
        }
        catch (PeerUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createMessageFactory(): " + error.getMessage();
            return status;
        }
        try {
            this.headerFactory = this.sipFactory.createHeaderFactory();
        }
        catch (PeerUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createHeaderFactory(): " + error.getMessage();
            return status;
        }
        try {
            this.addressFactory = this.sipFactory.createAddressFactory();
        }
        catch (PeerUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
            return status;
        }
        try {
            this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() > 0) {
            try {
                this.publicContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getPublicIP() + ":" + this.localSIPPort);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                return status;
            }
        }
        try {
            this.publicContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
            return status;
        }
        this.privateContactHeader = this.headerFactory.createContactHeader(this.privateContactAddress);
        this.publicContactHeader = this.headerFactory.createContactHeader(this.publicContactAddress);
        if (this.configuration.getPublicIP().length() == 0) {
            this.rinstance = VoipStormTools.getRandom(8);
            try {
                this.privateContactHeader.setParameter("rinstance", this.rinstance);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter(\"rinstance\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage();
                return status;
            }
            try {
                this.privateContactHeader.setParameter("transport", this.transport);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter(\"rinstance\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage();
                return status;
            }
        }
        this.rinstance = VoipStormTools.getRandom(8);
        try {
            this.privateContactHeader.setParameter("rinstance", this.rinstance);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter(\"rinstance\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.privateContactHeader.setParameter("transport", this.transport);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter(\"rinstance\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage();
            return status;
        }
        this.userAgentList.add("VoipStorm ECallCenter21");
        try {
            this.userAgentHeader = this.headerFactory.createUserAgentHeader((List)this.userAgentList);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: userAgentHeader = myHeaderFactory.createUserAgentHeader(viaHeaders): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.allowHeader = this.headerFactory.createAllowHeader("INVITE,ACK,CANCEL,OPTIONS,BYE,REFER,NOTIFY,MESSAGE,SUBSCRIBE,INFO");
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: allowHeader = myHeaderFactory.createAllowHeader(...): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.sipProvider = this.sipStack.createSipProvider(this.udpListeningPoint);
        }
        catch (ObjectInUseException error) {
            status[0] = "1";
            status[1] = "Error: sipStack.createSipProvider(udpisteningPoint): " + error.getMessage();
            return status;
        }
        try {
            this.sipProvider.addSipListener((SipListener)this);
        }
        catch (TooManyListenersException error) {
            status[0] = "1";
            status[1] = "Error: sipProvider.addSipListener(this): " + error.getMessage();
            return status;
        }
        if (status[0].equals("0")) {
            status[1] = Integer.toString(this.localSIPPort);
        }
        this.availability = this.unregistered;
        this.lastsipstate = this.sipstate;
        this.sipstate = 2;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        this.displayData.setSoftphoneInfoCell("Phone: sip:" + this.configuration.getClientIP() + ":" + this.localSIPPort);
        this.displayData.setPrimaryStatusCell("Phone \"" + this.configuration.getUsername() + "\" " + this.availability);
        this.displayData.setPrimaryStatusDetailsCell("");
        this.displayData.setSecondaryStatusCell("");
        this.displayData.setSecondaryStatusDetailsCell("");
        this.displayData.resetSip();
        this.displayData.setIdleFlag(true);
        this.userInterface1.phoneDisplay(this.displayData);
        if (this.userInterface2 != null) {
            this.userInterface2.phoneDisplay(this.displayData);
        }
        return status;
    }

    public String[] stopListener() {
        String[] status = new String[]{"0", ""};
        this.sipStack.stop();
        if (this.debugging && this.debugginglevel == 1) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " stopListener\n\n");
        }
        this.availability = "On";
        this.lastsipstate = this.sipstate;
        this.sipstate = 1;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        this.displayData.setSoftphoneInfoCell("");
        this.displayData.setPrimaryStatusCell("Phone Powered " + this.availability);
        this.displayData.setPrimaryStatusDetailsCell("");
        this.displayData.setSecondaryStatusCell("");
        this.displayData.setSecondaryStatusDetailsCell("");
        this.displayData.resetSip();
        this.displayData.setOnFlag(true);
        this.userInterface1.phoneDisplay(this.displayData);
        if (this.userInterface2 != null) {
            this.userInterface2.phoneDisplay(this.displayData);
        }
        return status;
    }

    public String[] restartListener() {
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 2, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String[] status = new String[]{"0", ""};
        this.userInterface1.showStatus("Reloading SoftPhone Instance: " + this.getInstanceId(), true, true);
        status = this.stopListener();
        if (status[0].equals("1")) {
            return status;
        }
        status = this.startListener(Integer.toString(this.localSIPPort));
        if (status[0].equals("1")) {
            return status;
        }
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 3, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return status;
    }

    public String[] sendRegister(int registerTimeoutParam) {
        this.registerRequestCounter = 1;
        String[] status = new String[]{"0", ""};
        if (this.configuration.getPublicIP().length() == 0) {
            this.aor = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
            this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
            this.to = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
            this.via = this.configuration.getClientIP();
            try {
                this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                return status;
            }
        }
        this.aor = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
        this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
        this.to = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
        this.via = this.configuration.getPublicIP();
        try {
            this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getPublicIP() + ":" + this.localSIPPort);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
            return status;
        }
        this.registerTimeout = registerTimeoutParam;
        try {
            this.registrarAddress = this.addressFactory.createAddress("sip:" + this.configuration.getServerIP() + ":" + this.configuration.getServerPort());
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: registrarAddress = myAddressFactory.createAddress(\"sip:\" + server): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.fromAddress = this.addressFactory.createAddress(this.from);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: fromAddress = myAddressFactory.createAddress(from): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.toAddress = this.addressFactory.createAddress(this.to);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress(to): " + error.getMessage();
            return status;
        }
        try {
            this.toHeader = this.headerFactory.createToHeader(this.toAddress, null);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createToHeader(registerToAddress, null): " + error.getMessage();
            return status;
        }
        try {
            this.fromHeader = this.headerFactory.createFromHeader(this.fromAddress, VoipStormTools.getRandom(6));
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createFromHeader(registerFromAddress, \"RNDNUMSTRING\"): " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() == 0) {
            try {
                this.privateContactHeader.setParameter("rinstance", this.rinstance);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter\\(\"rinstance\",: ParseException: " + error.getMessage();
                return status;
            }
            try {
                this.privateContactHeader.setParameter("transport", this.transport);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                return status;
            }
            try {
                this.privateContactHeader.setParameter("expires", Integer.toString(registerTimeoutParam));
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                return status;
            }
        }
        try {
            this.publicContactHeader.setParameter("rinstance", this.rinstance);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter\\(\"rinstance\",: ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.publicContactHeader.setParameter("transport", this.transport);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.publicContactHeader.setParameter("expires", Integer.toString(registerTimeoutParam));
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
            return status;
        }
        this.viaHeaders = new ArrayList();
        if (this.configuration.getPublicIP().length() == 0) {
            try {
                this.viaHeader = this.headerFactory.createViaHeader(this.configuration.getClientIP(), this.localSIPPort, this.transport, null);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( configuration.getClientIP(), myPort, myTransport, null): ParseException: " + error.getMessage();
                return status;
            }
            catch (InvalidArgumentException error) {
                status[0] = "1";
                status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( configuration.getClientIP(), myPort, myTransport, null): InvalidArgumentException: " + error.getMessage();
                return status;
            }
        }
        try {
            this.viaHeader = this.headerFactory.createViaHeader(this.configuration.getPublicIP(), this.localSIPPort, this.transport, null);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( configuration.getPubIP(), myPort, myTransport, null): ParseException: " + error.getMessage();
            return status;
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( configuration.getPubIP(), myPort, myTransport, null): InvalidArgumentException: " + error.getMessage();
            return status;
        }
        this.viaHeaders.add(this.viaHeader);
        try {
            this.maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
        }
        catch (InvalidArgumentException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: myMaxForwardsHeader = myHeaderFactory.createMaxForwardsHeader(x);: InvalidArgumentException: " + error.getMessage());
        }
        this.callIdHeader = this.sipProvider.getNewCallId();
        this.commandSequenceHeader = null;
        try {
            this.commandSequenceHeader = this.headerFactory.createCSeqHeader(1L, "REGISTER");
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createCSeqHeader(1, REGISTER): ParseException: " + error.getMessage();
            return status;
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createCSeqHeader(1, REGISTER): InvalidArgumentException: " + error.getMessage();
            return status;
        }
        try {
            this.expiresHeader = this.headerFactory.createExpiresHeader(registerTimeoutParam);
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myExpiresHeader = myHeaderFactory.createExpiresHeader(registerTimeout);: InvalidArgumentException: " + error.getMessage();
            return status;
        }
        this.requestURI = (SipURI)this.registrarAddress.getURI();
        try {
            this.registerRequest = this.messageFactory.createRequest(this.requestURI, "REGISTER", this.callIdHeader, this.commandSequenceHeader, this.fromHeader, this.toHeader, (List)this.viaHeaders, this.maxForwardsHeader);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myMessageFactory.createRequest(: ParseException: " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() == 0) {
            this.registerRequest.addHeader((Header)this.privateContactHeader);
        } else {
            this.registerRequest.addHeader((Header)this.publicContactHeader);
        }
        this.registerRequest.addHeader((Header)this.expiresHeader);
        this.registerRequest.addHeader((Header)this.userAgentHeader);
        try {
            this.clientTransaction = this.sipProvider.getNewClientTransaction(this.registerRequest);
        }
        catch (TransactionUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipProvider.getNewClientTransaction(myRegisterRequest): TransactionUnavailableException: " + error.getMessage();
            return status;
        }
        try {
            this.clientTransaction.sendRequest();
        }
        catch (SipException error) {
            status[0] = "1";
            status[1] = "Error: myClientTransaction.sendRequest(): SipException" + error.getMessage();
            return status;
        }
        this.registerRequestBranch = this.clientTransaction.getBranchId();
        if (this.debugging) {
            if (this.debugginglevel == 1) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " sendRegister: " + this.registerRequest.getMethod() + "-Request Sent:\n\n" + this.registerRequest.toString());
            } else {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " sendRegister: " + this.registerRequest.getMethod() + "-Request Sent.");
            }
        }
        return status;
    }

    public String[] sendRequest(String destinationParam, String filenameParam) {
        String[] status = new String[]{"0", ""};
        if (destinationParam != null && !destinationParam.equals("") && filenameParam != null && !filenameParam.equals("")) {
            if (destinationParam.startsWith("sip:") || destinationParam.startsWith("<sip:") || destinationParam.startsWith("\"")) {
                this.isSIPAddress = true;
                this.sipDestination = this.destination.getDestination();
                if (this.configuration.getPublicIP().length() == 0) {
                    this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
                    this.to = destinationParam;
                    this.via = this.configuration.getClientIP();
                    try {
                        this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
                    }
                    catch (ParseException error) {
                        status[0] = "1";
                        status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                        return status;
                    }
                }
                this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
                this.to = destinationParam;
                this.via = this.configuration.getClientIP();
                try {
                    this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
                }
                catch (ParseException error) {
                    status[0] = "1";
                    status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                    return status;
                }
                this.filename = filenameParam;
            } else {
                this.isSIPAddress = false;
                this.filename = filenameParam;
                this.sipDestination = "sip:" + VoipStormTools.substitude(destinationParam, "[^0-9]") + "@" + this.configuration.getServerIP() + ":" + this.configuration.getServerPort();
                if (this.configuration.getPublicIP().length() == 0) {
                    this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
                    this.to = "sip:" + VoipStormTools.substitude(destinationParam, "[^0-9]") + "@" + this.configuration.getDomain();
                    this.via = this.configuration.getClientIP();
                    try {
                        this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getClientIP() + ":" + this.localSIPPort);
                    }
                    catch (ParseException error) {
                        status[0] = "1";
                        status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                        return status;
                    }
                } else {
                    this.from = "sip:" + this.configuration.getUsername() + "@" + this.configuration.getDomain();
                    this.to = "sip:" + VoipStormTools.substitude(destinationParam, "[^0-9]") + "@" + this.configuration.getDomain();
                    this.via = this.configuration.getPublicIP();
                    try {
                        this.privateContactAddress = this.addressFactory.createAddress("sip:" + this.configuration.getUsername() + "@" + this.configuration.getPublicIP() + ":" + this.localSIPPort);
                    }
                    catch (ParseException error) {
                        status[0] = "1";
                        status[1] = "Error: mySipFactory.createAddressFactory(): " + error.getMessage();
                        return status;
                    }
                }
            }
        } else {
            status[0] = "1";
            status[1] = "Invalid sendRequest Paramer(s): destinationParam: " + destinationParam + " filenameParam: " + filenameParam;
            return status;
        }
        this.destinationDisplay = destinationParam;
        do {
            this.soundStreamer = new SoundStreamer(this.userInterface1, this.softPhoneInstanceId);
            status = this.soundStreamer.startListener(this.configuration.getClientIP(), this.requestedClientAudioPort, this.configuration.getClientIP(), this.assignedServerAudioPort);
            if (!status[0].equals("1") && (!status[0].equals("0") || !status[1].equals(""))) continue;
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: SoundStreamer.startListener(" + this.configuration.getClientIP() + "," + this.requestedClientAudioPort + "," + this.configuration.getClientIP() + "," + this.assignedServerAudioPort + ")");
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException error2) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
            }
        } while (status[0].equals("1") || status[0].equals("0") && status[1].equals(""));
        if (status[0].equals("1") || status[0].equals("0") && status[1].equals("")) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: (sendRequest) status(" + this.assignedClientAudioPort + ") = soundStreamer.startListener(" + this.configuration.getClientIP() + "," + this.requestedClientAudioPort + "," + this.configuration.getClientIP() + "," + this.assignedServerAudioPort + ")");
        } else {
            this.assignedClientAudioPort = Integer.parseInt(status[1]);
            if (this.debugging) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " (sendRequest) status(" + this.assignedClientAudioPort + ") = soundStreamer.startListener(" + this.configuration.getClientIP() + "," + this.requestedClientAudioPort + "," + this.configuration.getClientIP() + "," + this.assignedServerAudioPort + ")");
            }
            this.muteAudio();
        }
        try {
            this.fromAddress = this.addressFactory.createAddress(this.from);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress(from): " + error.getMessage();
            return status;
        }
        try {
            this.toAddress = this.addressFactory.createAddress(this.to);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress(to): " + error.getMessage();
            return status;
        }
        this.viaHeaders = new ArrayList();
        try {
            this.viaHeader = this.headerFactory.createViaHeader(this.via, this.localSIPPort, this.transport, null);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( via, myPort, myTransport, null ): ParseException: " + error.getMessage();
            return status;
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myViaHeader = myHeaderFactory.createViaHeader( via, myPort, myTransport, null ), null): InvalidArgumentException: " + error.getMessage();
            return status;
        }
        try {
            this.viaHeader.setParameter("branch", VoipStormTools.getRandom(6));
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myViaHeader.setParameter(\"branch\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage();
            return status;
        }
        this.viaHeaders.add(this.viaHeader);
        try {
            this.maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createMaxForwardsHeader(MAXFORWARDS): " + error.getMessage();
            return status;
        }
        try {
            this.fromHeader = this.headerFactory.createFromHeader(this.fromAddress, VoipStormTools.getRandom(6));
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createFromHeader(addressOfRecord, \"RNDNUMSTRING\"): " + error.getMessage();
            return status;
        }
        try {
            this.toHeader = this.headerFactory.createToHeader(this.toAddress, null);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createToHeader(destAddress, null): " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() > 0 && !this.isSIPAddress) {
            try {
                this.publicContactHeader.setParameter("transport", this.transport);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter(\"transport\", transport): ParseException: " + error.getMessage();
                return status;
            }
            try {
                this.privateContactHeader.setParameter("registering_acc", "sip1_budgetphone_nl");
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myContactHeader.setParameter(\"registering_acc\", sip1_budgetphone_nl): ParseException: " + error.getMessage();
                return status;
            }
        }
        try {
            this.publicContactHeader.setParameter("transport", this.transport);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter(\"transport\", transport): ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.privateContactHeader.setParameter("registering_acc", "sip1_budgetphone_nl");
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myContactHeader.setParameter(\"registering_acc\", sip1_budgetphone_nl): ParseException: " + error.getMessage();
            return status;
        }
        this.callIdHeader = this.sipProvider.getNewCallId();
        this.commandSequenceHeader = null;
        try {
            this.commandSequenceHeader = this.headerFactory.createCSeqHeader(1L, "INVITE");
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createCSeqHeader(1, INVITE ): ParseException: " + error.getMessage();
            return status;
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createCSeqHeader(1, INVITE ): InvalidArgumentException: " + error.getMessage();
            return status;
        }
        try {
            this.destAddress = this.addressFactory.createAddress(this.sipDestination);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress(destination): " + error.getMessage();
            return status;
        }
        this.requestURI = this.destAddress.getURI();
        try {
            this.request = this.messageFactory.createRequest(this.requestURI, "INVITE", this.callIdHeader, this.commandSequenceHeader, this.fromHeader, this.toHeader, (List)this.viaHeaders, this.maxForwardsHeader);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myMessageFactory.createRequest(myRequestURI, INVITE , myCallIdHeader, myCSeqHeader, myFromHeader, myToHeader, viaHeaders, myMaxForwardsHeader): " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() > 0 && !this.isSIPAddress) {
            this.request.addHeader((Header)this.publicContactHeader);
        } else {
            this.request.addHeader((Header)this.privateContactHeader);
        }
        this.request.addHeader((Header)this.userAgentHeader);
        this.sdpConvert = new SDPConvert();
        this.offerSDPInfo = new SDPInfo();
        if (this.configuration.getPublicIP().length() > 0 && !this.isSIPAddress) {
            this.offerSDPInfo.setIPAddress(this.configuration.getPublicIP());
        } else {
            this.offerSDPInfo.setIPAddress(this.configuration.getClientIP());
        }
        this.offerSDPInfo.setUser(this.configuration.getUsername());
        this.offerSDPInfo.setAudioPort(this.assignedClientAudioPort);
        this.offerSDPInfo.setAudioFormat(this.audioCodec);
        this.offerSDPInfo.setVideoPort(this.videoPort);
        this.offerSDPInfo.setVideoFormat(this.videoCodec);
        try {
            this.contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myHeaderFactory.createContentTypeHeader(\"application\", \"sdp\"): ParseException: " + error.getMessage();
            return status;
        }
        this.offerSDPBytes = this.sdpConvert.info2Bytes(this.offerSDPInfo, this.audioCodec);
        try {
            this.request.setContent((Object)this.offerSDPBytes, this.contentTypeHeader);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myRequest.setContent(content, contentTypeHeader);: ParseException: " + error.getMessage();
            return status;
        }
        try {
            this.clientTransaction = this.sipProvider.getNewClientTransaction(this.request);
        }
        catch (TransactionUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage();
            return status;
        }
        do {
            status[0] = "0";
            status[1] = "";
            try {
                this.clientTransaction.sendRequest();
            }
            catch (SipException error) {
                status[0] = "1";
                status[1] = "Error: sendRequest: myClientTransaction.sendRequest(): SipException" + error.getMessage();
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " status[1]");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException error2) {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                }
            }
        } while (status[0].equals("1"));
        this.inviteRequestBranch = this.clientTransaction.getBranchId();
        if (this.debugging) {
            if (this.debugginglevel == 1) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " sendRequest:     " + this.request.getMethod() + " Request to: " + this.sipDestination + " Sent:\n\n" + this.request.toString());
            } else {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " sendRequest:     " + this.request.getMethod() + " Request to: " + this.sipDestination + " Sent.");
            }
        }
        String toHeaderString = this.request.getHeader("To").toString();
        String namePart1 = VoipStormTools.substitude(toHeaderString, "^.+<");
        this.toHeaderAddress = VoipStormTools.substitude(namePart1, ">.*");
        this.lastsipstate = this.sipstate;
        this.sipstate = 3;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        if (this.ePhoneGUIActive) {
            this.displayData.setPrimaryStatusCell("Call Outgoing");
            this.displayData.setPrimaryStatusDetailsCell("To: " + this.toHeaderAddress);
            this.displayData.setSecondaryStatusCell("");
            this.displayData.setSecondaryStatusDetailsCell("");
            this.displayData.resetSip();
            this.displayData.setConnectFlag(true);
            this.userInterface1.phoneDisplay(this.displayData);
            if (this.userInterface2 != null) {
                this.userInterface2.phoneDisplay(this.displayData);
            }
        }
        return status;
    }

    public String[] cancelRequest() {
        Request myCancelRequest = null;
        String[] status = new String[]{"0", ""};
        try {
            myCancelRequest = this.clientTransaction.createCancel();
        }
        catch (SipException error) {
            status[0] = "1";
            status[1] = "Error: myCancelRequest = myClientTransaction.createCancel();: SipException: " + error.getMessage();
            return status;
        }
        if (this.configuration.getPublicIP().length() > 0 && !this.isSIPAddress) {
            myCancelRequest.addHeader((Header)this.publicContactHeader);
        } else {
            myCancelRequest.addHeader((Header)this.privateContactHeader);
        }
        try {
            this.clientTransaction = this.sipProvider.getNewClientTransaction(myCancelRequest);
        }
        catch (TransactionUnavailableException error) {
            status[0] = "1";
            status[1] = "Error: myClientTransaction = mySipProvider.getNewClientTransaction(myCancelRequest): TransactionUnavailableException: " + error.getMessage();
            return status;
        }
        do {
            status[0] = "0";
            status[1] = "";
            try {
                this.clientTransaction.sendRequest();
            }
            catch (SipException error) {
                status[0] = "1";
                status[1] = "Error: sendRequest: myClientTransaction.sendRequest(): SipException" + error.getMessage();
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " status[1]");
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException error2) {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                }
            }
        } while (status[0].equals("1"));
        this.dialog = this.clientTransaction.getDialog();
        if (this.debugging) {
            if (this.debugginglevel == 1) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " cancelRequest: " + myCancelRequest.getMethod() + "-Request Sent.  DialogStatus: " + this.dialog.getState() + "\n\n" + myCancelRequest.toString());
            } else {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " cancelRequest: " + myCancelRequest.getMethod() + "-Request Sent.  DialogStatus: " + this.dialog.getState());
            }
        }
        this.cancelRequestBranch = this.clientTransaction.getBranchId();
        this.stopTones();
        this.lastsipstate = this.sipstate;
        this.sipstate = 9;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.eyeBlinkMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        this.lastsipstate = this.sipstate;
        this.sipstate = 2;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        if (this.ePhoneGUIActive) {
            this.displayData.setPrimaryStatusCell("Calling: " + this.destinationDisplay + "...");
            this.displayData.setPrimaryStatusDetailsCell("");
            this.displayData.setSecondaryStatusCell("Call Canceled Locally");
            this.displayData.setSecondaryStatusDetailsCell("");
            this.displayData.resetSip();
            this.displayData.setIdleFlag(true);
            this.userInterface1.phoneDisplay(this.displayData);
            if (this.userInterface2 != null) {
                this.userInterface2.phoneDisplay(this.displayData);
            }
        }
        try {
            Thread.sleep(this.shortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        if (this.ePhoneGUIActive) {
            this.displayData.setPrimaryStatusCell("Phone \"" + this.configuration.getUsername() + "\" " + this.availability);
            this.displayData.setPrimaryStatusDetailsCell("");
            this.displayData.setSecondaryStatusCell("");
            this.displayData.setSecondaryStatusDetailsCell("");
            this.userInterface1.phoneDisplay(this.displayData);
            if (this.userInterface2 != null) {
                this.userInterface2.phoneDisplay(this.displayData);
            }
        }
        return status;
    }

    public synchronized void processResponse(final ResponseEvent responseReceivedEvent) {
        Thread processResponseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] status = new String[2];
                Response response = responseReceivedEvent.getResponse();
                ClientTransaction clientTransaction = null;
                SoftPhone.this.destination.setResponseStatusCode(response.getStatusCode());
                SoftPhone.this.destination.setResponseStatusDesc(response.getReasonPhrase());
                SoftPhone.this.userInterface1.responseUpdate(response.getStatusCode(), response.getReasonPhrase(), SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                String myResponseBranch = new String();
                if (responseReceivedEvent.getClientTransaction() != null) {
                    clientTransaction = responseReceivedEvent.getClientTransaction();
                    myResponseBranch = responseReceivedEvent.getClientTransaction().getBranchId();
                }
                if (response.getStatusCode() >= 100 && response.getStatusCode() < 180) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 4;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Phone: " + response.getStatusCode() + " " + response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() >= 180 && response.getStatusCode() < 200) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized DialogStatus: " + SoftPhone.this.dialog.getState() + ".");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.stopTones();
                    SoftPhone.this.speakerData.setCallToneFlag(true);
                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 5;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Phone: " + response.getStatusCode() + " " + response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setCallingFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                    if (SoftPhone.this.scan && (status = SoftPhone.this.userInput(11, "", "", ""))[0].equals("1")) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " End Button Failure: " + status[1]);
                    }
                } else if (response.getStatusCode() == 200) {
                    if (myResponseBranch.equals(SoftPhone.this.registerRequestBranch)) {
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (REGISTER) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (REGISTER) Response Received & Recognized.");
                            }
                        }
                        if (response != null && response.getExpires() != null) {
                            if (response.getExpires().getExpires() > 0) {
                                SoftPhone.this.loginstate = 1;
                                SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 1, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                                SoftPhone.this.availability = SoftPhone.this.registered;
                                if (SoftPhone.this.ePhoneGUIActive) {
                                    SoftPhone.this.displayData.setProxyInfoCell("Proxy: " + SoftPhone.this.configuration.getServerIP() + ":" + SoftPhone.this.configuration.getServerPort());
                                    SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                                    SoftPhone.this.displayData.setRegisteredFlag(true);
                                    SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                                    if (SoftPhone.this.userInterface2 != null) {
                                        SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                                    }
                                    SoftPhone.this.speakerData.setRegisterEnabledToneFlag(true);
                                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                                    SoftPhone.this.speakerData.setRegisterEnabledToneFlag(false);
                                }
                            } else {
                                SoftPhone.this.loginstate = 0;
                                SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 1, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                                try {
                                    Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                                }
                                catch (InterruptedException error) {
                                    SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                                }
                                SoftPhone.this.availability = SoftPhone.this.unregistered;
                                if (SoftPhone.this.ePhoneGUIActive) {
                                    SoftPhone.this.displayData.setProxyInfoCell("");
                                    SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                                    SoftPhone.this.displayData.setRegisteredFlag(false);
                                    SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                                    if (SoftPhone.this.userInterface2 != null) {
                                        SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                                    }
                                    SoftPhone.this.speakerData.setRegisterDisabledToneFlag(true);
                                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                                    SoftPhone.this.speakerData.setRegisterDisabledToneFlag(false);
                                }
                                if (SoftPhone.this.powerOffRequested) {
                                    SoftPhone.this.stopListener();
                                }
                            }
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.inviteRequestBranch)) {
                        byte[] answerSDPBytes;
                        SoftPhone.this.stopTones();
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                            }
                        }
                        if ((answerSDPBytes = response.getRawContent()) != null) {
                            SoftPhone.this.answerSDPInfo = SoftPhone.this.sdpConvert.bytes2Info(answerSDPBytes, SoftPhone.this.audioCodec);
                            SoftPhone.this.soundStreamer.updateDestination(SoftPhone.this.answerSDPInfo.getIPAddress(), Integer.toString(SoftPhone.this.answerSDPInfo.getAudioPort()));
                            if (SoftPhone.this.debugging) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " soundStreamer.updateDestination(" + SoftPhone.this.answerSDPInfo.getIPAddress() + "," + Integer.toString(SoftPhone.this.answerSDPInfo.getAudioPort()) + ")");
                            }
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: answerSDPBytes == null");
                        }
                        try {
                            SoftPhone.this.ackRequest = clientTransaction.createAck();
                        }
                        catch (SipException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAckRequest = myClientTransaction.createAck(): SipException:" + error.getMessage());
                        }
                        try {
                            SoftPhone.this.dialog.sendAck(SoftPhone.this.ackRequest);
                        }
                        catch (SipException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myDialog.sendAck(myAckRequest): SipException: " + error.getMessage() + " localhost ?");
                        }
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.ackRequest.getMethod() + "-Request Sent. DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + SoftPhone.this.ackRequest.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.ackRequest.getMethod() + "-Request Sent. DialogStatus: " + SoftPhone.this.dialog.getState());
                            }
                        }
                        SoftPhone.this.stopTones();
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 8;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Established");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setTalkingFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                        if (SoftPhone.this.soundStreamer != null && SoftPhone.this.answerSDPInfo != null && SoftPhone.this.filename != null) {
                            try {
                                status = SoftPhone.this.soundStreamer.startStreamer(SoftPhone.this.answerSDPInfo.getIPAddress(), Integer.toString(SoftPhone.this.answerSDPInfo.getAudioPort()), SoftPhone.this.filename, SoftPhone.this.answerSDPInfo.getAudioFormat());
                            }
                            catch (NoDataSourceException ex) {
                                SoftPhone.this.userInterface1.showStatus("Error: SoftPhone: NoDataSourceException: soundStreamer.startStreamer(.......) " + ex.getMessage(), true, true);
                            }
                            catch (NoProcessorException ex) {
                                SoftPhone.this.userInterface1.showStatus("Error: SoftPhone: NoProcessorException: soundStreamer.startStreamer(.......) " + ex.getMessage(), true, true);
                            }
                            catch (UnsupportedFormatException ex) {
                                SoftPhone.this.userInterface1.showStatus("Error: SoftPhone: UnsupportedFormatException: soundStreamer.startStreamer(.......) " + ex.getMessage(), true, true);
                            }
                            if (status[0].equals("1")) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: status(" + SoftPhone.this.assignedClientAudioPort + ") = soundStreamer.startStreamer(" + SoftPhone.this.answerSDPInfo.getIPAddress() + "," + Integer.toString(SoftPhone.this.answerSDPInfo.getAudioPort()) + "," + SoftPhone.this.filename + "," + SoftPhone.this.answerSDPInfo.getAudioFormat() + ")");
                                SoftPhone.this.userInterface1.logToApplication(status[1]);
                            } else {
                                long mediaDuration = 1000L;
                                mediaDuration = SoftPhone.this.soundStreamer.mediaDuration;
                                if (SoftPhone.this.autoEndCall) {
                                    SoftPhone.this.outboundEndCallTimer = new Timer();
                                    SoftPhone.this.outboundEndCallTimer.schedule((TimerTask)new EndCallTimer(SoftPhone.this.softPhoneReference), mediaDuration);
                                }
                            }
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("Error: SoftPhone: Line 1469: Could not start SoundStreamer: soundStreamer == null");
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.inviteAckRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After Ack?) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After Ack?) Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        SoftPhone.this.stopTones();
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 8;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Established");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setTalkingFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.cancelRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " OK (After CANCEL) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After CANCEL) Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " (Cancel OK) Response Recognized.");
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (Cancel OK) Response Recognized. DialogStatus: " + SoftPhone.this.dialog.getState());
                            }
                        }
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 2;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Canceled Locally");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setIdleFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                            try {
                                Thread.sleep(SoftPhone.this.shortMessagePeriod);
                            }
                            catch (InterruptedException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                            }
                            SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                            SoftPhone.this.displayData.setSecondaryStatusCell("");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.byeRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After Bye) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + "  (After Bye) Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 2;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Ended Locally");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setIdleFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                            try {
                                Thread.sleep(SoftPhone.this.shortMessagePeriod);
                            }
                            catch (InterruptedException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                            }
                            SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                            SoftPhone.this.displayData.setSecondaryStatusCell("");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                    } else if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received & Recognized.");
                        }
                    }
                } else if (response.getStatusCode() >= 300 && response.getStatusCode() <= 400) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized DialogStatus: " + SoftPhone.this.dialog.getState() + ".");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.stopTones();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        SoftPhone.this.speakerData.setErrorToneFlag(true);
                        SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                        SoftPhone.this.speakerData.setErrorToneFlag(false);
                    }
                } else if (response.getStatusCode() == 401) {
                    if (myResponseBranch.equals(SoftPhone.this.registerRequestBranch)) {
                        if (SoftPhone.this.registerRequestCounter == 2) {
                            return;
                        }
                        ++SoftPhone.this.registerRequestCounter;
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.viaHeaders = new ArrayList();
                        SoftPhone.this.viaHeader = (ViaHeader)response.getHeader("Via");
                        try {
                            SoftPhone.this.viaHeader.setParameter("branch", VoipStormTools.getRandom(6));
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myViaHeader.setParameter(\"branch\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage());
                        }
                        SoftPhone.this.viaHeaders.add(SoftPhone.this.viaHeader);
                        try {
                            SoftPhone.this.maxForwardsHeader = SoftPhone.this.headerFactory.createMaxForwardsHeader(70);
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createMaxForwardsHeader(MAXFORWARDS): " + error.getMessage());
                        }
                        SoftPhone.this.fromHeader = (FromHeader)response.getHeader("From");
                        SoftPhone.this.toHeader = (ToHeader)response.getHeader("To");
                        SoftPhone.this.callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                        try {
                            SoftPhone.this.commandSequenceHeader = SoftPhone.this.headerFactory.createCSeqHeader(2L, "REGISTER");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "REGISTER" + " ): ParseException: " + error.getMessage());
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "REGISTER" + " ): InvalidArgumentException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: publicContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: publicContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("expires", Integer.toString(SoftPhone.this.registerTimeout));
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                        } else {
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: privateContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: privateContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("expires", Integer.toString(SoftPhone.this.registerTimeout));
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                        }
                        try {
                            SoftPhone.this.registerRequest = SoftPhone.this.messageFactory.createRequest(SoftPhone.this.requestURI, "REGISTER", SoftPhone.this.callIdHeader, SoftPhone.this.commandSequenceHeader, SoftPhone.this.fromHeader, SoftPhone.this.toHeader, (List)SoftPhone.this.viaHeaders, SoftPhone.this.maxForwardsHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myRegisterRequest = myMessageFactory.createRequest(: ParseException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0) {
                            SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.privateContactHeader);
                        } else {
                            SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.privateContactHeader);
                        }
                        try {
                            SoftPhone.this.expiresHeader = SoftPhone.this.headerFactory.createExpiresHeader(SoftPhone.this.registerTimeout);
                        }
                        catch (InvalidArgumentException error) {
                            status[0] = "1";
                            status[1] = "Error: myExpiresHeader = myHeaderFactory.createExpiresHeader(registerTimeout);: InvalidArgumentException: " + error.getMessage();
                        }
                        SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.expiresHeader);
                        WWWAuthenticateHeader myWWWAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate".toString());
                        String algorithm = new String();
                        algorithm = myWWWAuthenticateHeader.getAlgorithm() != null ? myWWWAuthenticateHeader.getAlgorithm() : "MD5";
                        String realm = myWWWAuthenticateHeader.getRealm();
                        String nonce_value = myWWWAuthenticateHeader.getNonce();
                        String nc_value = myWWWAuthenticateHeader.getParameter("nc");
                        String cnonce_value = myWWWAuthenticateHeader.getParameter("cnonce");
                        String method_value = "REGISTER";
                        String digest_uri_value = SoftPhone.this.requestURI.toString();
                        String entity_body = myWWWAuthenticateHeader.getParameter("entity_body");
                        String qop_value = myWWWAuthenticateHeader.getQop();
                        String scheme = myWWWAuthenticateHeader.getScheme();
                        String domain = myWWWAuthenticateHeader.getDomain();
                        String responseString = SoftPhone.this.messageDigestAlgorithm.calculateResponse(algorithm, SoftPhone.this.configuration.getUsername(), myWWWAuthenticateHeader.getRealm(), SoftPhone.this.configuration.getToegang(), myWWWAuthenticateHeader.getNonce(), myWWWAuthenticateHeader.getParameter("nc"), myWWWAuthenticateHeader.getParameter("cnonce"), "REGISTER", digest_uri_value, SoftPhone.this.requestURI.toString(), myWWWAuthenticateHeader.getQop());
                        try {
                            SoftPhone.this.authorizationHeader = SoftPhone.this.headerFactory.createAuthorizationHeader(scheme);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createAuthorizationHeader(\"Digest\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setUsername(SoftPhone.this.configuration.getUsername());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setUsername(\"\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setAlgorithm(algorithm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setAlgorithm(\"MD5\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setRealm(realm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setRealm(realm): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setNonce(nonce_value);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setNonce(nonce): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setResponse(responseString);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setResponse(response): " + error.getMessage());
                        }
                        SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.authorizationHeader);
                        try {
                            clientTransaction = SoftPhone.this.sipProvider.getNewClientTransaction(SoftPhone.this.registerRequest);
                        }
                        catch (TransactionUnavailableException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage());
                        }
                        do {
                            status[0] = "0";
                            status[1] = "";
                            try {
                                clientTransaction.sendRequest();
                            }
                            catch (SipException error) {
                                status[0] = "1";
                                status[1] = "Error: processResponse: Register Unauthorized: myClientTransaction.sendRequest(): SipException" + error.getMessage();
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " status[1]");
                                try {
                                    Thread.sleep(SoftPhone.this.retryInterval);
                                }
                                catch (InterruptedException error2) {
                                    SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                                }
                            }
                        } while (status[0].equals("1"));
                        SoftPhone.this.registerRequestBranch = clientTransaction.getBranchId();
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.registerRequest.getMethod() + "-Request with Authorization Header Sent:\n\n" + SoftPhone.this.registerRequest.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.registerRequest.getMethod() + "-Request with Authorization Header Sent.");
                            }
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.inviteRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        try {
                            SoftPhone.this.ackRequest = clientTransaction.createAck();
                        }
                        catch (SipException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAckRequest = myClientTransaction.createAck(): SipException:" + error.getMessage());
                        }
                        try {
                            SoftPhone.this.dialog.sendAck(SoftPhone.this.ackRequest);
                        }
                        catch (SipException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myDialog.sendAck(myAckRequest): SipException: " + error.getMessage() + " localhost ?");
                        }
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.ackRequest.getMethod() + "-Request Sent:\n\n" + SoftPhone.this.ackRequest.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.ackRequest.getMethod() + "-Request Sent.");
                            }
                        }
                        SoftPhone.this.viaHeaders = new ArrayList();
                        SoftPhone.this.viaHeader = (ViaHeader)response.getHeader("Via");
                        try {
                            SoftPhone.this.viaHeader.setParameter("branch", VoipStormTools.getRandom(6));
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myViaHeader.setParameter(\"branch\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage());
                        }
                        SoftPhone.this.viaHeader.removeParameter("rport");
                        SoftPhone.this.viaHeader.removeParameter("tag");
                        SoftPhone.this.viaHeaders.add(SoftPhone.this.viaHeader);
                        try {
                            SoftPhone.this.maxForwardsHeader = SoftPhone.this.headerFactory.createMaxForwardsHeader(70);
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createMaxForwardsHeader(MAXFORWARDS): " + error.getMessage());
                        }
                        SoftPhone.this.fromHeader = (FromHeader)response.getHeader("From");
                        SoftPhone.this.toHeader = (ToHeader)response.getHeader("To");
                        SoftPhone.this.callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                        try {
                            SoftPhone.this.commandSequenceHeader = SoftPhone.this.headerFactory.createCSeqHeader(2L, "INVITE");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "INVITE" + " ): ParseException: " + error.getMessage());
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "INVITE" + " ): InvalidArgumentException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                        } else {
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                        }
                        try {
                            SoftPhone.this.request = SoftPhone.this.messageFactory.createRequest(SoftPhone.this.requestURI, "INVITE", SoftPhone.this.callIdHeader, SoftPhone.this.commandSequenceHeader, SoftPhone.this.fromHeader, SoftPhone.this.toHeader, (List)SoftPhone.this.viaHeaders, SoftPhone.this.maxForwardsHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createRequest(myRequestURI, " + "INVITE" + " , myCallIdHeader, myCSeqHeader, myFromHeader, myToHeader, viaHeaders, myMaxForwardsHeader): " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            SoftPhone.this.request.addHeader((Header)SoftPhone.this.publicContactHeader);
                        } else {
                            SoftPhone.this.request.addHeader((Header)SoftPhone.this.privateContactHeader);
                        }
                        SoftPhone.this.sdpConvert = new SDPConvert();
                        SoftPhone.this.offerSDPInfo = new SDPInfo();
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            SoftPhone.this.offerSDPInfo.setIPAddress(SoftPhone.this.configuration.getPublicIP());
                        } else {
                            SoftPhone.this.offerSDPInfo.setIPAddress(SoftPhone.this.configuration.getClientIP());
                        }
                        SoftPhone.this.offerSDPInfo.setUser(SoftPhone.this.configuration.getUsername());
                        SoftPhone.this.offerSDPInfo.setAudioPort(SoftPhone.this.assignedClientAudioPort);
                        SoftPhone.this.offerSDPInfo.setAudioFormat(SoftPhone.this.audioCodec);
                        SoftPhone.this.offerSDPInfo.setVideoPort(SoftPhone.this.videoPort);
                        SoftPhone.this.offerSDPInfo.setVideoFormat(SoftPhone.this.videoCodec);
                        try {
                            SoftPhone.this.contentTypeHeader = SoftPhone.this.headerFactory.createContentTypeHeader("application", "sdp");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createContentTypeHeader(\"application\", \"sdp\"): ParseException: " + error.getMessage());
                        }
                        SoftPhone.access$5402(SoftPhone.this, SoftPhone.this.sdpConvert.info2Bytes(SoftPhone.this.offerSDPInfo, SoftPhone.this.audioCodec));
                        try {
                            SoftPhone.this.request.setContent((Object)SoftPhone.this.offerSDPBytes, SoftPhone.this.contentTypeHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myRequest.setContent(content, contentTypeHeader);: ParseException: " + error.getMessage());
                        }
                        WWWAuthenticateHeader myWWWAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate".toString());
                        String algorithm = new String();
                        algorithm = myWWWAuthenticateHeader.getAlgorithm() != null ? myWWWAuthenticateHeader.getAlgorithm() : "MD5";
                        String realm = myWWWAuthenticateHeader.getRealm();
                        String nonce_value = myWWWAuthenticateHeader.getNonce();
                        String nc_value = myWWWAuthenticateHeader.getParameter("nc");
                        String cnonce_value = myWWWAuthenticateHeader.getParameter("cnonce");
                        String method_value = "INVITE";
                        String digest_uri_value = SoftPhone.this.requestURI.toString();
                        String entity_body = myWWWAuthenticateHeader.getParameter("entity_body");
                        String qop_value = myWWWAuthenticateHeader.getQop();
                        String scheme = myWWWAuthenticateHeader.getScheme();
                        String domain = myWWWAuthenticateHeader.getDomain();
                        String responseString = SoftPhone.this.messageDigestAlgorithm.calculateResponse(algorithm, SoftPhone.this.configuration.getUsername(), myWWWAuthenticateHeader.getRealm(), SoftPhone.this.configuration.getToegang(), myWWWAuthenticateHeader.getNonce(), myWWWAuthenticateHeader.getParameter("nc"), myWWWAuthenticateHeader.getParameter("cnonce"), "INVITE", SoftPhone.this.requestURI.toString(), myWWWAuthenticateHeader.getParameter("entity_body"), myWWWAuthenticateHeader.getQop());
                        try {
                            SoftPhone.this.authorizationHeader = SoftPhone.this.headerFactory.createAuthorizationHeader(scheme);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createAuthorizationHeader(\"Digest\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setUsername(SoftPhone.this.configuration.getUsername());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setUsername(\"\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setAlgorithm(algorithm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setAlgorithm(\"MD5\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setRealm(realm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setRealm(realm): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setNonce(nonce_value);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setNonce(nonce): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setResponse(responseString);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setResponse(response): " + error.getMessage());
                        }
                        SoftPhone.this.request.addHeader((Header)SoftPhone.this.authorizationHeader);
                        try {
                            clientTransaction = SoftPhone.this.sipProvider.getNewClientTransaction(SoftPhone.this.request);
                        }
                        catch (TransactionUnavailableException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage());
                        }
                        int retryCounter = 0;
                        int retryLimit = 3;
                        do {
                            status[0] = "0";
                            status[1] = "";
                            try {
                                clientTransaction.sendRequest();
                            }
                            catch (SipException error) {
                                status[0] = "1";
                                status[1] = " Error: processResponse: Invite with AuthorizationHeader: line 1946: clientTransaction.sendRequest(): SipException: " + error.getMessage();
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + status[1]);
                                try {
                                    Thread.sleep(SoftPhone.this.retryInterval);
                                }
                                catch (InterruptedException error2) {
                                    SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                                }
                            }
                        } while (status[0].equals("1") && retryCounter <= retryLimit);
                        SoftPhone.this.inviteRequestBranch = clientTransaction.getBranchId();
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 4;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setCallingFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.request.getMethod() + "-Request with Authorization Header Sent:\n\n" + SoftPhone.this.request.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.request.getMethod() + "-Request with Authorization Header Sent.");
                            }
                        }
                    } else if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received & Recognized.");
                        }
                    }
                } else if (response.getStatusCode() == 404) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.stopTones();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.speakerData.setDeadToneFlag(true);
                        SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                        SoftPhone.this.speakerData.setDeadToneFlag(false);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                    SoftPhone.this.destination.setResponseStatusCode(response.getStatusCode());
                    SoftPhone.this.destination.setResponseStatusDesc(response.getReasonPhrase());
                    SoftPhone.this.userInterface1.responseUpdate(response.getStatusCode(), response.getReasonPhrase(), SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                } else if (response.getStatusCode() == 407) {
                    if (myResponseBranch.equals(SoftPhone.this.registerRequestBranch)) {
                        if (SoftPhone.this.registerRequestCounter == 2) {
                            return;
                        }
                        ++SoftPhone.this.registerRequestCounter;
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.viaHeaders = new ArrayList();
                        SoftPhone.this.viaHeader = (ViaHeader)response.getHeader("Via");
                        try {
                            SoftPhone.this.viaHeader.setParameter("branch", VoipStormTools.getRandom(6));
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myViaHeader.setParameter(\"branch\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage());
                        }
                        SoftPhone.this.viaHeaders.add(SoftPhone.this.viaHeader);
                        try {
                            SoftPhone.this.maxForwardsHeader = SoftPhone.this.headerFactory.createMaxForwardsHeader(70);
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createMaxForwardsHeader(MAXFORWARDS): " + error.getMessage());
                        }
                        SoftPhone.this.fromHeader = (FromHeader)response.getHeader("From");
                        SoftPhone.this.callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                        try {
                            SoftPhone.this.commandSequenceHeader = SoftPhone.this.headerFactory.createCSeqHeader(2L, "REGISTER");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "REGISTER" + " ): ParseException: " + error.getMessage());
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "REGISTER" + " ): InvalidArgumentException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: publicContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("expires", Integer.toString(SoftPhone.this.registerTimeout));
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                        } else {
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: privateContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("expires", Integer.toString(SoftPhone.this.registerTimeout));
                            }
                            catch (ParseException error) {
                                status[0] = "1";
                                status[1] = "Error: myContactHeader.setParameter\\(\"transport\",: ParseException: " + error.getMessage();
                            }
                        }
                        try {
                            SoftPhone.this.registerRequest = SoftPhone.this.messageFactory.createRequest(SoftPhone.this.requestURI, "REGISTER", SoftPhone.this.callIdHeader, SoftPhone.this.commandSequenceHeader, SoftPhone.this.fromHeader, SoftPhone.this.toHeader, (List)SoftPhone.this.viaHeaders, SoftPhone.this.maxForwardsHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myRegisterRequest = myMessageFactory.createRequest(: ParseException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.publicContactHeader);
                        } else {
                            SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.privateContactHeader);
                        }
                        try {
                            SoftPhone.this.expiresHeader = SoftPhone.this.headerFactory.createExpiresHeader(SoftPhone.this.registerTimeout);
                        }
                        catch (InvalidArgumentException error) {
                            status[0] = "1";
                            status[1] = "Error: myExpiresHeader = myHeaderFactory.createExpiresHeader(registerTimeout);: InvalidArgumentException: " + error.getMessage();
                        }
                        SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.expiresHeader);
                        WWWAuthenticateHeader myWWWAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate".toString());
                        String algorithm = new String();
                        algorithm = myWWWAuthenticateHeader.getAlgorithm() != null ? myWWWAuthenticateHeader.getAlgorithm() : "MD5";
                        String realm = myWWWAuthenticateHeader.getRealm();
                        String nonce_value = myWWWAuthenticateHeader.getNonce();
                        String nc_value = myWWWAuthenticateHeader.getParameter("nc");
                        String cnonce_value = myWWWAuthenticateHeader.getParameter("cnonce");
                        String method_value = "REGISTER";
                        String digest_uri_value = SoftPhone.this.requestURI.toString();
                        String entity_body = myWWWAuthenticateHeader.getParameter("entity_body");
                        String qop_value = myWWWAuthenticateHeader.getQop();
                        String scheme = myWWWAuthenticateHeader.getScheme();
                        String domain = myWWWAuthenticateHeader.getDomain();
                        String responseString = SoftPhone.this.messageDigestAlgorithm.calculateResponse(algorithm, SoftPhone.this.configuration.getUsername(), realm, SoftPhone.this.configuration.getToegang(), nonce_value, nc_value, cnonce_value, method_value, digest_uri_value, entity_body, qop_value);
                        try {
                            SoftPhone.this.authorizationHeader = SoftPhone.this.headerFactory.createAuthorizationHeader(scheme);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createAuthorizationHeader(\"Digest\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setUsername(SoftPhone.this.configuration.getUsername());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setUsername(\"\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setAlgorithm(algorithm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setAlgorithm(\"MD5\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setRealm(realm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setRealm(realm): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setNonce(nonce_value);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setNonce(nonce): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.authorizationHeader.setResponse(responseString);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAuthorizationHeader.setResponse(response): " + error.getMessage());
                        }
                        SoftPhone.this.registerRequest.addHeader((Header)SoftPhone.this.authorizationHeader);
                        try {
                            clientTransaction = SoftPhone.this.sipProvider.getNewClientTransaction(SoftPhone.this.registerRequest);
                        }
                        catch (TransactionUnavailableException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage());
                        }
                        do {
                            status[0] = "0";
                            status[1] = "";
                            try {
                                clientTransaction.sendRequest();
                            }
                            catch (SipException error) {
                                status[0] = "1";
                                status[1] = "Error: processResponse: Register Unauthorized: myClientTransaction.sendRequest(): SipException" + error.getMessage();
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " status[1]");
                                try {
                                    Thread.sleep(SoftPhone.this.retryInterval);
                                }
                                catch (InterruptedException error2) {
                                    SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                                }
                            }
                        } while (status[0].equals("1"));
                        SoftPhone.this.registerRequestBranch = clientTransaction.getBranchId();
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.registerRequest.getMethod() + "-Request with Proxy Authorization Header Sent:\n\n" + SoftPhone.this.registerRequest.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.registerRequest.getMethod() + "-Request with Proxy Authorization Header Sent.");
                            }
                        }
                    } else if (myResponseBranch.equals(SoftPhone.this.inviteRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.viaHeaders = new ArrayList();
                        SoftPhone.this.viaHeader = (ViaHeader)response.getHeader("Via");
                        try {
                            SoftPhone.this.viaHeader.setParameter("branch", VoipStormTools.getRandom(6));
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myViaHeader.setParameter(\"branch\", SoftPhoneTools.getRandom(6)): ParseException: " + error.getMessage());
                        }
                        SoftPhone.this.viaHeader.removeParameter("rport");
                        SoftPhone.this.viaHeaders.add(SoftPhone.this.viaHeader);
                        try {
                            SoftPhone.this.maxForwardsHeader = SoftPhone.this.headerFactory.createMaxForwardsHeader(70);
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createMaxForwardsHeader(MAXFORWARDS): " + error.getMessage());
                        }
                        SoftPhone.this.fromHeader = (FromHeader)response.getHeader("From");
                        SoftPhone.this.viaHeader.removeParameter("tag");
                        SoftPhone.this.callIdHeader = (CallIdHeader)response.getHeader("Call-ID");
                        try {
                            SoftPhone.this.commandSequenceHeader = SoftPhone.this.headerFactory.createCSeqHeader(2L, "INVITE");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "INVITE" + " ): ParseException: " + error.getMessage());
                        }
                        catch (InvalidArgumentException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createCSeqHeader(1, " + "INVITE" + " ): InvalidArgumentException: " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            try {
                                SoftPhone.this.publicContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: publicContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                        } else {
                            try {
                                SoftPhone.this.privateContactHeader.setParameter("transport", SoftPhone.this.transport);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: privateContactHeader.setParameter(\"transport\", \"udp\"): ParseException: " + error.getMessage());
                            }
                        }
                        try {
                            SoftPhone.this.request = SoftPhone.this.messageFactory.createRequest(SoftPhone.this.requestURI, "INVITE", SoftPhone.this.callIdHeader, SoftPhone.this.commandSequenceHeader, SoftPhone.this.fromHeader, SoftPhone.this.toHeader, (List)SoftPhone.this.viaHeaders, SoftPhone.this.maxForwardsHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createRequest(myRequestURI, " + "INVITE" + " , myCallIdHeader, myCSeqHeader, myFromHeader, myToHeader, viaHeaders, myMaxForwardsHeader): " + error.getMessage());
                        }
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            SoftPhone.this.request.addHeader((Header)SoftPhone.this.publicContactHeader);
                        } else {
                            SoftPhone.this.request.addHeader((Header)SoftPhone.this.privateContactHeader);
                        }
                        SoftPhone.this.sdpConvert = new SDPConvert();
                        SoftPhone.this.offerSDPInfo = new SDPInfo();
                        if (SoftPhone.this.configuration.getPublicIP().length() > 0 && !SoftPhone.this.isSIPAddress) {
                            SoftPhone.this.offerSDPInfo.setIPAddress(SoftPhone.this.configuration.getPublicIP());
                        } else {
                            SoftPhone.this.offerSDPInfo.setIPAddress(SoftPhone.this.configuration.getClientIP());
                        }
                        SoftPhone.this.offerSDPInfo.setUser(SoftPhone.this.configuration.getUsername());
                        SoftPhone.this.offerSDPInfo.setAudioPort(SoftPhone.this.assignedClientAudioPort);
                        SoftPhone.this.offerSDPInfo.setAudioFormat(SoftPhone.this.audioCodec);
                        SoftPhone.this.offerSDPInfo.setVideoPort(SoftPhone.this.videoPort);
                        SoftPhone.this.offerSDPInfo.setVideoFormat(SoftPhone.this.videoCodec);
                        try {
                            SoftPhone.this.contentTypeHeader = SoftPhone.this.headerFactory.createContentTypeHeader("application", "sdp");
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createContentTypeHeader(\"application\", \"sdp\"): ParseException: " + error.getMessage());
                        }
                        SoftPhone.access$5402(SoftPhone.this, SoftPhone.this.sdpConvert.info2Bytes(SoftPhone.this.offerSDPInfo, SoftPhone.this.audioCodec));
                        try {
                            SoftPhone.this.request.setContent((Object)SoftPhone.this.offerSDPBytes, SoftPhone.this.contentTypeHeader);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myRequest.setContent(content, contentTypeHeader);: ParseException: " + error.getMessage());
                        }
                        ProxyAuthenticateHeader authHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate".toString());
                        String algorithm = "";
                        algorithm = authHeader.getAlgorithm() != null ? authHeader.getAlgorithm() : "MD5";
                        String realm = authHeader.getRealm();
                        String nonce_value = authHeader.getNonce();
                        String nc_value = "00000001";
                        String cnonce_value = "xyz";
                        String method_value = "INVITE";
                        String uriString = SoftPhone.this.configuration.getServerIP();
                        String entity_body = authHeader.getParameter("entity_body");
                        String qop_value = "auth";
                        String scheme = authHeader.getScheme();
                        String domain = authHeader.getDomain();
                        String qopList = authHeader.getQop();
                        String qop = qopList != null ? "auth" : null;
                        String responseString = SoftPhone.this.messageDigestAlgorithm.calculateResponse(algorithm, SoftPhone.this.configuration.getUsername(), authHeader.getRealm(), new String(SoftPhone.this.configuration.getToegang()), authHeader.getNonce(), authHeader.getParameter("nc"), authHeader.getParameter("cnonce"), "INVITE", SoftPhone.this.requestURI.toString(), entity_body, qop);
                        try {
                            SoftPhone.this.proxyAuthorizationHeader = SoftPhone.this.headerFactory.createProxyAuthorizationHeader(scheme);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myHeaderFactory.createAuthorizationHeader(\"Digest\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setUsername(SoftPhone.this.configuration.getUsername());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setUsername(\"\"): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setRealm(authHeader.getRealm());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setRealm(realm): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setNonce(authHeader.getNonce());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setNonce(nonce): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setParameter("uri", SoftPhone.this.request.getRequestURI().toString());
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setNonce(nonce): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setResponse(responseString);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setResponse(response): " + error.getMessage());
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setAlgorithm(algorithm);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setAlgorithm(algorithm): " + error.getMessage());
                        }
                        if (authHeader.getOpaque() != null) {
                            try {
                                SoftPhone.this.proxyAuthorizationHeader.setOpaque(authHeader.getOpaque());
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setOpaque(proxyAuthenticateHeader.getOpaque(): " + error.getMessage());
                            }
                        }
                        if (qop != null) {
                            try {
                                SoftPhone.this.proxyAuthorizationHeader.setQop(qop);
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setQop(qop): " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.proxyAuthorizationHeader.setCNonce(authHeader.getParameter("cnonce"));
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setCNonce(proxyAuthenticateHeader.getParameter(\"cnonce\")): " + error.getMessage());
                            }
                            try {
                                SoftPhone.this.proxyAuthorizationHeader.setNonceCount(Integer.parseInt(nc_value));
                            }
                            catch (ParseException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setNonceCount(Integer.parseInt(nc_value)): " + error.getMessage());
                            }
                        }
                        try {
                            SoftPhone.this.proxyAuthorizationHeader.setResponse(responseString);
                        }
                        catch (ParseException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: proxyAuthorizationHeader.setResponse(response): " + error.getMessage());
                        }
                        SoftPhone.this.request.addHeader((Header)SoftPhone.this.proxyAuthorizationHeader);
                        try {
                            clientTransaction = SoftPhone.this.sipProvider.getNewClientTransaction(SoftPhone.this.request);
                        }
                        catch (TransactionUnavailableException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage());
                        }
                        do {
                            status[0] = "0";
                            status[1] = "";
                            try {
                                clientTransaction.sendRequest();
                            }
                            catch (SipException error) {
                                status[0] = "1";
                                status[1] = "Error: processResponse: Invite Unauthorized: myClientTransaction.sendRequest(): SipException" + error.getMessage();
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " status[1]");
                                try {
                                    Thread.sleep(SoftPhone.this.retryInterval);
                                }
                                catch (InterruptedException error2) {
                                    SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Sleep error: " + error2.getMessage());
                                }
                            }
                        } while (status[0].equals("1"));
                        SoftPhone.this.inviteRequestBranch = clientTransaction.getBranchId();
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 4;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setCallingFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.request.getMethod() + "-Request with Proxy Authorization Header Sent:\n\n" + SoftPhone.this.request.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + SoftPhone.this.request.getMethod() + "-Request with Proxy Authorization Header Sent.");
                            }
                        }
                    } else if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received & Recognized.");
                        }
                    }
                } else if (response.getStatusCode() == 480) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.stopTones();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.speakerData.setBusyToneFlag(true);
                        SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                        SoftPhone.this.speakerData.setBusyToneFlag(false);
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() == 481) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() >= 402 && response.getStatusCode() <= 485) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.speakerData.setErrorToneFlag(true);
                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                    SoftPhone.this.speakerData.setErrorToneFlag(false);
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() == 486) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 12;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.eyeBlinkMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.speakerData.setBusyToneFlag(true);
                        SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                        SoftPhone.this.speakerData.setBusyToneFlag(false);
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() == 487) {
                    if (myResponseBranch.equals(SoftPhone.this.cancelRequestBranch)) {
                        if (SoftPhone.this.debugging) {
                            if (SoftPhone.this.debugginglevel == 1) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After Cancel) Response Received & Recognized.\n\n" + response.toString());
                            } else {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (After Cancel) Response Received & Recognized.");
                            }
                        }
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                        if (SoftPhone.this.soundStreamer != null) {
                            SoftPhone.this.soundStreamer.stopListener();
                            SoftPhone.this.soundStreamer = null;
                        }
                        SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                        SoftPhone.this.sipstate = 2;
                        SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                        try {
                            Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Canceled Locally");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setIdleFlag(true);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                            try {
                                Thread.sleep(SoftPhone.this.shortMessagePeriod);
                            }
                            catch (InterruptedException error) {
                                SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                            }
                            SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                            SoftPhone.this.displayData.setSecondaryStatusCell("");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                    } else if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Uncorrelated Response Received.");
                        }
                    }
                } else if (response.getStatusCode() == 488) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.speakerData.setErrorToneFlag(true);
                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                    SoftPhone.this.speakerData.setErrorToneFlag(false);
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() >= 488 && response.getStatusCode() <= 490) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " (INVITE) Response Received & Recognized.");
                        }
                    }
                    SoftPhone.this.dialog = clientTransaction.getDialog();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.speakerData.setErrorToneFlag(true);
                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                    SoftPhone.this.speakerData.setErrorToneFlag(false);
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (response.getStatusCode() > 491) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Response Received & Recognized DialogStatus: " + SoftPhone.this.dialog.getState() + ".");
                        }
                    }
                    if (clientTransaction != null) {
                        SoftPhone.this.dialog = clientTransaction.getDialog();
                    }
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.speakerData.setErrorToneFlag(true);
                    SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                    SoftPhone.this.speakerData.setErrorToneFlag(false);
                    SoftPhone.this.userInterface1.showStatus(response.getStatusCode() + " " + response.getReasonPhrase(), true, true);
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Outgoing");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("To: " + SoftPhone.this.toHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell(response.getReasonPhrase());
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (SoftPhone.this.debugging) {
                    if (SoftPhone.this.debugginglevel == 1) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Fully Uncorrelated Response Received.\n\n" + response.toString());
                    } else {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processResponse: " + response.getStatusCode() + " " + response.getReasonPhrase() + " Fully Request Terminated Uncorrelated Response Received.");
                    }
                }
            }
        });
        processResponseThread.setName("processResponseThread");
        processResponseThread.setDaemon(this.runThreadsAsDaemons);
        processResponseThread.setPriority(9);
        processResponseThread.start();
    }

    public synchronized void processRequest(final RequestEvent requestReceivedEvent) {
        Thread processRequestThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] status = new String[2];
                Response response = null;
                SoftPhone.this.request = requestReceivedEvent.getRequest();
                String fromHeaderString = SoftPhone.this.request.getHeader("From").toString();
                String namePart1 = VoipStormTools.substitude(fromHeaderString, "^.+<");
                SoftPhone.this.fromHeaderAddress = VoipStormTools.substitude(namePart1, ">.*");
                if (SoftPhone.this.request.getMethod().equals("OPTIONS")) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Request Received & Recognized:\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Request Received & Recognized.");
                        }
                    }
                    try {
                        response = SoftPhone.this.messageFactory.createResponse(200, SoftPhone.this.request);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createResponse(Response.OK, myRequest): ParseException: " + error.getMessage());
                    }
                    try {
                        SoftPhone.this.sipProvider.sendResponse(response);
                    }
                    catch (SipException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: mySipProvider.sendResponse(myResponse): SipException: " + error.getMessage());
                    }
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response (After OPTIONS Request) Sent.\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response (After OPTIONS Request) Sent.");
                        }
                    }
                } else if (SoftPhone.this.request.getMethod().equals("INVITE")) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Request Received & Recognized:\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " INVITE Request Received & Recognized.");
                        }
                    }
                    Response myTMPResponse = null;
                    try {
                        SoftPhone.this.serverTransaction = SoftPhone.this.sipProvider.getNewServerTransaction(SoftPhone.this.request);
                    }
                    catch (TransactionAlreadyExistsException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: TransactionAlreadyExistsException: mySipProvider.getNewServerTransaction(myRequest)");
                    }
                    catch (TransactionUnavailableException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: TransactionUnavailableException: mySipProvider.getNewServerTransaction(myRequest)");
                    }
                    try {
                        myTMPResponse = SoftPhone.this.messageFactory.createResponse(100, SoftPhone.this.request);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("Error: myMessageFactory.createResponse(100, myRequest): " + error.getMessage());
                    }
                    try {
                        response = SoftPhone.this.messageFactory.createResponse(180, SoftPhone.this.request);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createResponse(" + 180 + ", myRequest): " + error.getMessage());
                    }
                    SoftPhone.this.responseToHeader = (ToHeader)response.getHeader("To");
                    SoftPhone.this.serverToTag = VoipStormTools.getRandom(6);
                    try {
                        SoftPhone.this.responseToHeader.setTag(SoftPhone.this.serverToTag);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: responseToHeader.setTag(\"454326\"): ParseException: " + error.getMessage());
                    }
                    myTMPResponse.addHeader((Header)SoftPhone.this.privateContactHeader);
                    response.addHeader((Header)SoftPhone.this.privateContactHeader);
                    myTMPResponse.setHeader((Header)SoftPhone.this.responseToHeader);
                    response.setHeader((Header)SoftPhone.this.responseToHeader);
                    byte[] offerSDPBytes = SoftPhone.this.request.getRawContent();
                    SoftPhone.this.offerSDPInfo = SoftPhone.this.sdpConvert.bytes2Info(offerSDPBytes, SoftPhone.this.audioCodec);
                    try {
                        SoftPhone.this.serverTransaction.sendResponse(myTMPResponse);
                    }
                    catch (SipException error) {
                        SoftPhone.this.userInterface1.logToApplication("Error: myServerTransaction.sendResponse(myTMPResponse): SipException: " + error.getMessage());
                    }
                    catch (InvalidArgumentException error) {
                        SoftPhone.this.userInterface1.logToApplication("Error: myServerTransaction.sendResponse(myTMPResponse): InvalidArgumentException: " + error.getMessage());
                    }
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Trying Sent");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setRingingFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("processRequest " + myTMPResponse.getStatusCode() + " (TRYING) Response Sent.\n\n" + myTMPResponse.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("processRequest " + myTMPResponse.getStatusCode() + " (TRYING) Response Sent.\n\n");
                        }
                    }
                    try {
                        SoftPhone.this.serverTransaction.sendResponse(response);
                    }
                    catch (SipException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myServerTransaction.sendResponse(myResponse): SipException: " + error.getMessage());
                    }
                    catch (InvalidArgumentException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myAddressFactory.createAddress: InvalidArgumentException: " + error.getMessage());
                    }
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (RINGING) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (RINGING) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState());
                        }
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 7;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.stopTones();
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.speakerData.setRingToneFlag(true);
                        SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                        SoftPhone.this.speakerData.setRingToneFlag(false);
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Phone Ringing");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setRingingFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                    boolean isBusy = false;
                    if (Math.round(Math.random() * 100.0) <= (long)SoftPhone.this.busyRatioPercentage) {
                        isBusy = true;
                    }
                    if (SoftPhone.this.autoRingingResponse == 3 && isBusy || SoftPhone.this.autoRingingResponse == 2) {
                        SoftPhone.this.stopTones();
                        if (SoftPhone.this.ePhoneGUIActive) {
                            SoftPhone.this.speakerData.setBusyToneFlag(true);
                            SoftPhone.this.userInterface1.speaker(SoftPhone.this.speakerData);
                            SoftPhone.this.speakerData.setBusyToneFlag(false);
                            SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                            SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                            SoftPhone.this.displayData.setSecondaryStatusCell("Call Canceled Locally");
                            SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                            SoftPhone.this.displayData.resetSip();
                            SoftPhone.this.displayData.setRingingFlag(false);
                            SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                            if (SoftPhone.this.userInterface2 != null) {
                                SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                            }
                        }
                        SoftPhone.this.busyResponse();
                    } else if (SoftPhone.this.autoRingingResponse == 3 && !isBusy || SoftPhone.this.autoRingingResponse == 1) {
                        try {
                            Thread.sleep(SoftPhone.this.autoRingingResponseDelay);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.createResponse();
                    }
                } else if (SoftPhone.this.request.getMethod().equals("ACK")) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Ack Request Received & Recognized:\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Ack Request Received & Recognized.");
                        }
                    }
                    if (SoftPhone.this.inboundEndTimerDelay > 0) {
                        SoftPhone.this.inboundEndCallTimer = new Timer();
                        SoftPhone.this.inboundEndCallTimer.schedule((TimerTask)new EndCallTimer(SoftPhone.this.softPhoneReference), SoftPhone.this.inboundEndTimerDelay);
                    }
                    SoftPhone.this.serverTransaction = requestReceivedEvent.getServerTransaction();
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    SoftPhone.this.stopTones();
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 8;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Call Established");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setTalkingFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (SoftPhone.this.request.getMethod().equals("BYE")) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " BYE Request Received & Recognized:\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " BYE Request Received & Recognized.");
                        }
                    }
                    if (SoftPhone.this.inboundEndCallTimer != null) {
                        SoftPhone.this.inboundEndCallTimer.cancel();
                        SoftPhone.this.inboundEndCallTimer.purge();
                    }
                    if (SoftPhone.this.outboundEndCallTimer != null) {
                        SoftPhone.this.outboundEndCallTimer.cancel();
                        SoftPhone.this.outboundEndCallTimer.purge();
                    }
                    SoftPhone.this.stopTones();
                    SoftPhone.this.soundStreamer.stopMedia();
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    SoftPhone.this.serverTransaction = requestReceivedEvent.getServerTransaction();
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    try {
                        response = SoftPhone.this.messageFactory.createResponse(200, SoftPhone.this.request);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createResponse(Response.OK, myRequest): ParseException: " + error.getMessage());
                    }
                    try {
                        SoftPhone.this.serverTransaction.sendResponse(response);
                    }
                    catch (SipException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myServerTransaction.sendResponse(myResponse): SipException: " + error.getMessage());
                    }
                    catch (InvalidArgumentException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myServerTransaction.sendResponse(myResponse): InvalidArgumentException: " + error.getMessage());
                    }
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState());
                        }
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 14;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.eyeBlinkMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Call Ended Remotely");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else if (SoftPhone.this.request.getMethod().equals("CANCEL")) {
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " CANCEL Request Received & Recognized:\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " CANCEL Request Received & Recognized.");
                        }
                    }
                    SoftPhone.this.serverTransaction = requestReceivedEvent.getServerTransaction();
                    SoftPhone.this.dialog = SoftPhone.this.serverTransaction.getDialog();
                    SoftPhone.this.originalRequest = SoftPhone.this.serverTransaction.getRequest();
                    SoftPhone.this.stopTones();
                    try {
                        response = SoftPhone.this.messageFactory.createResponse(200, SoftPhone.this.originalRequest);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myMessageFactory.createResponse(487, myRequest): ParseException: " + error.getMessage());
                    }
                    SoftPhone.this.responseToHeader = (ToHeader)response.getHeader("To");
                    try {
                        SoftPhone.this.responseToHeader.setTag(SoftPhone.this.serverToTag);
                    }
                    catch (ParseException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: responseToHeader.setTag(\"454326\"): ParseException: " + error.getMessage());
                    }
                    response.setHeader((Header)SoftPhone.this.responseToHeader);
                    response.addHeader((Header)SoftPhone.this.privateContactHeader);
                    try {
                        SoftPhone.this.dialog.sendReliableProvisionalResponse(response);
                    }
                    catch (SipException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: myDialog.sendReliableProvisionalResponse(myResponse): SipException: " + error.getMessage());
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 10;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.eyeBlinkMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    SoftPhone.this.lastsipstate = SoftPhone.this.sipstate;
                    SoftPhone.this.sipstate = 2;
                    SoftPhone.this.dispatchSipState(SoftPhone.this.sipstate, SoftPhone.this.lastsipstate, SoftPhone.this.loginstate, 0, SoftPhone.this.softPhoneInstanceId, SoftPhone.this.destination);
                    try {
                        Thread.sleep(SoftPhone.this.ultraShortMessagePeriod);
                    }
                    catch (InterruptedException error) {
                        SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                    }
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + response.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + SoftPhone.this.dialog.getState());
                        }
                    }
                    if (SoftPhone.this.ePhoneGUIActive) {
                        SoftPhone.this.displayData.setPrimaryStatusCell("Call Incoming");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("From: " + SoftPhone.this.fromHeaderAddress);
                        SoftPhone.this.displayData.setSecondaryStatusCell("Call Canceled Remotely");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.displayData.resetSip();
                        SoftPhone.this.displayData.setIdleFlag(true);
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                        try {
                            Thread.sleep(SoftPhone.this.shortMessagePeriod);
                        }
                        catch (InterruptedException error) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                        }
                        SoftPhone.this.displayData.setPrimaryStatusCell("Phone \"" + SoftPhone.this.configuration.getUsername() + "\" " + SoftPhone.this.availability);
                        SoftPhone.this.displayData.setSecondaryStatusCell("");
                        SoftPhone.this.displayData.setPrimaryStatusDetailsCell("");
                        SoftPhone.this.displayData.setSecondaryStatusDetailsCell("");
                        SoftPhone.this.userInterface1.phoneDisplay(SoftPhone.this.displayData);
                        if (SoftPhone.this.userInterface2 != null) {
                            SoftPhone.this.userInterface2.phoneDisplay(SoftPhone.this.displayData);
                        }
                    }
                } else {
                    if (SoftPhone.this.soundStreamer != null) {
                        SoftPhone.this.soundStreamer.stopListener();
                        SoftPhone.this.soundStreamer = null;
                    }
                    if (SoftPhone.this.debugging) {
                        if (SoftPhone.this.debugginglevel == 1) {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Request NOT Recognized. DialogStatus: " + SoftPhone.this.dialog.getState() + "\n\n" + SoftPhone.this.request.toString());
                        } else {
                            SoftPhone.this.userInterface1.logToApplication("\u260e " + SoftPhone.this.softPhoneInstanceId + " processRequest " + SoftPhone.this.request.getMethod() + " Request NOT Recognized. DialogStatus: " + SoftPhone.this.dialog.getState());
                        }
                    }
                }
            }
        });
        processRequestThread.setName("processRequestThread");
        processRequestThread.setDaemon(this.runThreadsAsDaemons);
        processRequestThread.start();
    }

    public synchronized String[] createResponse() {
        String[] status = new String[]{"0", ""};
        if (this.sipstate == 7) {
            this.dialog = this.serverTransaction.getDialog();
            this.soundStreamer = new SoundStreamer(this.userInterface1, this.softPhoneInstanceId);
            status = this.soundStreamer.startListener(this.configuration.getClientIP(), this.requestedServerAudioPort, this.offerSDPInfo.getIPAddress(), this.offerSDPInfo.getAudioPort());
            if (status[0].equals("1")) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " (createResponse) status(" + status[1] + ") = soundStreamer.startListener(" + this.configuration.getClientIP() + "," + this.requestedServerAudioPort + "," + this.offerSDPInfo.getIPAddress() + "," + this.offerSDPInfo.getAudioPort() + ")");
                this.userInterface1.logToApplication("inbound soundStreamer.startListener(configuration.getClientIP() basically failed with sipStatus: " + status[1]);
                return status;
            }
            this.assignedServerAudioPort = Integer.parseInt(status[1]);
            if (this.debugging) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " (createResponse) status(" + Integer.parseInt(status[1]) + ") = soundStreamer.startListener(" + this.configuration.getClientIP() + "," + this.requestedServerAudioPort + "," + this.offerSDPInfo.getIPAddress() + "," + this.offerSDPInfo.getAudioPort() + ")");
            }
            this.muteAudio();
            this.originalRequest = this.serverTransaction.getRequest();
            try {
                this.response = this.messageFactory.createResponse(200, this.originalRequest);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myMessageFactory.createResponse(200, originalRequest): " + error.getMessage();
                return status;
            }
            this.responseToHeader = (ToHeader)this.response.getHeader("To");
            try {
                this.responseToHeader.setTag(this.serverToTag);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: responseToHeader.setTag(\"454326\"): ParseException: " + error.getMessage();
                return status;
            }
            this.response.addHeader((Header)this.responseToHeader);
            this.response.addHeader((Header)this.privateContactHeader);
            if (this.configuration.getPublicIP().length() > 0 && !this.isSIPAddress) {
                this.answerSDPInfo.setIPAddress(this.configuration.getClientIP());
            } else {
                this.answerSDPInfo.setIPAddress(this.configuration.getClientIP());
            }
            this.answerSDPInfo.setAudioPort(this.assignedServerAudioPort);
            this.answerSDPInfo.setAudioFormat(this.offerSDPInfo.getAudioFormat());
            try {
                this.contentTypeHeader = this.headerFactory.createContentTypeHeader("application", "sdp");
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: contentTypeHeader = myHeaderFactory.createContentTypeHeader(\"application\", \"sdp\"): ParseException: " + error.getMessage();
                return status;
            }
            this.answerSDPBytes = this.sdpConvert.info2Bytes(this.answerSDPInfo, this.offerSDPInfo.getAudioFormat());
            try {
                this.response.setContent((Object)this.answerSDPBytes, this.contentTypeHeader);
            }
            catch (ParseException error) {
                status[0] = "1";
                status[1] = "Error: myResponse.setContent(answerContent, contentTypeHeader): ParseException: " + error.getMessage();
                return status;
            }
            this.dialog = this.serverTransaction.getDialog();
            try {
                this.dialog.sendReliableProvisionalResponse(this.response);
            }
            catch (SipException error) {
                status[0] = "1";
                status[1] = "Error: myDialog.sendReliableProvisionalResponse(myResponse): SipException: " + error.getMessage();
                return status;
            }
            if (this.debugging) {
                if (this.debugginglevel == 1) {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " createResponse " + this.response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + this.dialog.getState() + "\n\n" + this.response.toString());
                } else {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " createResponse " + this.response.getStatusCode() + " (OK) Response Sent. DialogStatus: " + this.dialog.getState());
                }
            }
            this.lastsipstate = this.sipstate;
            this.sipstate = 6;
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
                return status;
            }
            if (this.ePhoneGUIActive) {
                this.displayData.resetSip();
                this.displayData.setAcceptFlag(true);
            }
            this.stopTones();
            if (this.audioIsMuted) {
                this.muteAudio();
            }
        } else if (this.debugging && this.debugginglevel == 1) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " createResponse NOT executed. Reason: in required state!\n");
        }
        return status;
    }

    public synchronized String[] busyResponse() {
        String[] status = new String[]{"0", ""};
        this.lastsipstate = this.sipstate;
        this.sipstate = 11;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.eyeBlinkMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        try {
            this.response = this.messageFactory.createResponse(486, this.request);
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: myMessageFactory.createResponse(180, myRequest): " + error.getMessage();
        }
        this.responseToHeader = (ToHeader)this.response.getHeader("To");
        try {
            this.responseToHeader.setTag(VoipStormTools.getRandom(6));
        }
        catch (ParseException error) {
            status[0] = "1";
            status[1] = "Error: responseToHeader.setTag(\"RNDNUMSTRING\"): ParseException: " + error.getMessage();
        }
        this.response.addHeader((Header)this.privateContactHeader);
        this.response.addHeader((Header)this.responseToHeader);
        try {
            this.serverTransaction.sendResponse(this.response);
        }
        catch (SipException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress: ParseException: " + error.getMessage();
        }
        catch (InvalidArgumentException error) {
            status[0] = "1";
            status[1] = "Error: myAddressFactory.createAddress: ParseException: " + error.getMessage();
        }
        this.dialog = this.serverTransaction.getDialog();
        if (this.debugging) {
            if (this.debugginglevel == 1) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " endRequest " + this.response.getStatusCode() + " (Busy Here) Response Sent. DialogStatus: " + this.dialog.getState() + "\n\n" + this.response.toString());
            } else {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " endRequest " + this.response.getStatusCode() + " (Busy Here) Response Sent. DialogStatus: " + this.dialog.getState());
            }
        }
        this.lastsipstate = this.sipstate;
        this.sipstate = 2;
        this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
        try {
            Thread.sleep(this.ultraShortMessagePeriod);
        }
        catch (InterruptedException error) {
            this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
        }
        this.stopTones();
        if (this.ePhoneGUIActive) {
            this.displayData.setPrimaryStatusCell("Call Incoming");
            this.displayData.setPrimaryStatusDetailsCell("From: " + this.fromHeaderAddress);
            this.displayData.setSecondaryStatusCell("Call Denied");
            this.displayData.setSecondaryStatusDetailsCell("");
            this.displayData.resetSip();
            this.displayData.setIdleFlag(true);
            this.userInterface1.phoneDisplay(this.displayData);
            if (this.userInterface2 != null) {
                this.userInterface2.phoneDisplay(this.displayData);
            }
            try {
                Thread.sleep(this.shortMessagePeriod);
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
            }
            this.displayData.setPrimaryStatusCell("Phone \"" + this.configuration.getUsername() + "\" " + this.availability);
            this.displayData.setSecondaryStatusCell("");
            this.displayData.setPrimaryStatusDetailsCell("");
            this.displayData.setSecondaryStatusDetailsCell("");
            this.userInterface1.phoneDisplay(this.displayData);
            if (this.userInterface2 != null) {
                this.userInterface2.phoneDisplay(this.displayData);
            }
        }
        return status;
    }

    public synchronized String[] byeRequest() {
        String[] status = new String[]{"0", ""};
        if (this.sipstate == 8) {
            try {
                this.request = this.dialog.createRequest("BYE");
            }
            catch (SipException error) {
                status[0] = "1";
                status[1] = "Error: myDialog.createRequest(\"BYE\"): SipException: " + error.getMessage();
            }
            this.request.addHeader((Header)this.privateContactHeader);
            try {
                this.clientTransaction = this.sipProvider.getNewClientTransaction(this.request);
            }
            catch (TransactionUnavailableException error) {
                status[0] = "1";
                status[1] = "Error: mySipProvider.getNewClientTransaction(myRequest): TransactionUnavailableException: " + error.getMessage();
            }
            try {
                this.dialog.sendRequest(this.clientTransaction);
            }
            catch (TransactionDoesNotExistException error) {
                status[0] = "1";
                status[1] = "Error: myDialog.sendRequest(myClientTransaction): TransactionDoesNotExistException: " + error.getMessage();
            }
            catch (SipException error) {
                status[0] = "1";
                status[1] = "Error: myDialog.sendRequest(myClientTransaction): SipException: " + error.getMessage();
            }
            if (this.debugging) {
                if (this.debugginglevel == 1) {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " endRequest " + this.request.getMethod() + " (Bye) Request Sent. DialogStatus: " + this.dialog.getState() + "\n\n" + this.request.toString());
                } else {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " endRequest " + this.request.getMethod() + " (Bye) Request Sent. DialogStatus: " + this.dialog.getState());
                }
            }
            this.byeRequestBranch = this.clientTransaction.getBranchId();
            this.lastsipstate = this.sipstate;
            this.sipstate = 13;
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.eyeBlinkMessagePeriod);
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
            }
            this.lastsipstate = this.sipstate;
            this.sipstate = 2;
            this.dispatchSipState(this.sipstate, this.lastsipstate, this.loginstate, 0, this.softPhoneInstanceId, this.destination);
            try {
                Thread.sleep(this.ultraShortMessagePeriod);
            }
            catch (InterruptedException error) {
                this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(ultraShortMessagePeriod);: InterruptedException: " + error.getMessage());
            }
            this.stopTones();
            this.soundStreamer.stopMedia();
            if (this.soundStreamer != null) {
                this.soundStreamer.stopListener();
                this.soundStreamer = null;
            }
            if (this.ePhoneGUIActive) {
                this.displayData.setPrimaryStatusCell("Call Incoming");
                this.displayData.setPrimaryStatusDetailsCell("From: " + this.fromHeaderAddress);
                this.displayData.setSecondaryStatusCell("Call Ended Locally");
                this.displayData.setSecondaryStatusDetailsCell("");
                this.displayData.resetSip();
                this.displayData.setIdleFlag(true);
                this.userInterface1.phoneDisplay(this.displayData);
                if (this.userInterface2 != null) {
                    this.userInterface2.phoneDisplay(this.displayData);
                }
                try {
                    Thread.sleep(this.shortMessagePeriod);
                }
                catch (InterruptedException error) {
                    this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: Thread.sleep(shortMessagePeriod);: InterruptedException: " + error.getMessage());
                }
                this.displayData.setPrimaryStatusCell("Phone \"" + this.configuration.getUsername() + "\" " + this.availability);
                this.displayData.setSecondaryStatusCell("");
                this.displayData.setPrimaryStatusDetailsCell("");
                this.displayData.setSecondaryStatusDetailsCell("");
                this.userInterface1.phoneDisplay(this.displayData);
                if (this.userInterface2 != null) {
                    this.userInterface2.phoneDisplay(this.displayData);
                }
            }
            if (this.inboundEndCallTimer != null) {
                this.inboundEndCallTimer.cancel();
                this.inboundEndCallTimer.purge();
            }
            if (this.outboundEndCallTimer != null) {
                this.outboundEndCallTimer.cancel();
                this.outboundEndCallTimer.purge();
            }
        }
        return status;
    }

    private synchronized void dispatchSipState(int sipstateParam, int lastsipstateParam, int loginstateParam, int softphoneActivityParam, int softPhoneInstanceIdParam, Destination destinationParam) {
        if (sipstateParam != lastsipstateParam) {
            if (this.sipstate == 2) {
                this.softPhoneReference.setPriority(5);
            } else {
                this.softPhoneReference.setPriority(9);
            }
        }
        this.userInterface1.sipstateUpdate(sipstateParam, lastsipstateParam, loginstateParam, softphoneActivityParam, softPhoneInstanceIdParam, destinationParam);
    }

    public synchronized String[] muteAudio() {
        String[] status = new String[]{"0", ""};
        status = this.soundStreamer.muteAudio();
        this.displayData.setMuteFlag(true);
        this.userInterface1.phoneDisplay(this.displayData);
        if (this.userInterface2 != null) {
            this.userInterface2.phoneDisplay(this.displayData);
        }
        this.speakerData.setMuteEnabledToneFlag(true);
        this.userInterface1.speaker(this.speakerData);
        this.speakerData.setMuteEnabledToneFlag(false);
        return status;
    }

    public synchronized String[] unMuteAudio() {
        String[] status = new String[]{"0", ""};
        this.displayData.setMuteFlag(false);
        this.userInterface1.phoneDisplay(this.displayData);
        if (this.userInterface2 != null) {
            this.userInterface2.phoneDisplay(this.displayData);
        }
        this.speakerData.setMuteDisabledToneFlag(true);
        this.userInterface1.speaker(this.speakerData);
        this.speakerData.setMuteDisabledToneFlag(false);
        status = this.soundStreamer.unMuteAudio();
        return status;
    }

    public synchronized void processTimeout(TimeoutEvent arg0) {
        this.userInterface1.responseUpdate(0, "processTimeout: " + arg0.toString(), this.softPhoneInstanceId, this.destination);
        this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " processTimeout!!!");
        this.userInterface1.logToFile("\u260e " + this.softPhoneInstanceId + " processTimeout!!!");
        this.restartListener();
    }

    public synchronized void processIOException(IOExceptionEvent arg0) {
        this.userInterface1.logToApplication("\u260e " + this.softPhoneInstanceId + " Error: processIOException: ");
        this.userInterface1.logToFile("\u260e " + this.softPhoneInstanceId + " Error: processIOException: ");
        this.restartListener();
    }

    public synchronized void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
    }

    public synchronized void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    public void terminate() {
        this.keepRunning = false;
    }

    public void pleaseStop() {
        this.keepRunning = false;
    }

    public boolean keepRunning() {
        return this.keepRunning;
    }

    public static String getBrand() {
        return "VoipStorm";
    }

    public static String getBusiness() {
        return "Telemarketing";
    }

    public static String getBrandDescription() {
        return "VoipStorm offers 21st Century TeleMarketing Software. Select a soundfile, copy and paste your phonenumbers and start a lightning fast Telephone Advertisement Campaign. TeleMarketing has never been so Fast and Easy at only a tiny Fraction of the costs of Traditional TeleMarketing channels like: CallCenters, Radio and TV !";
    }

    public static String getProduct() {
        return "ECallCenter21";
    }

    public static String getProductDescription() {
        return Vergunning.PRODUCT_DESCRIPTION;
    }

    public static String getCopyright() {
        return Vergunning.COPYRIGHT;
    }

    public static String getAuthor() {
        return "Ron de Jong";
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getWindowTitle() {
        return "VoipStorm ECallCenter21 SoftPhone v1.0";
    }

    public int getInstanceId() {
        return this.softPhoneInstanceId;
    }

    public static int getRegisterLoginTimeout() {
        return registerLoginTimeout;
    }

    public int getSipState() {
        return this.sipstate;
    }

    public int getSipPort() {
        return this.localSIPPort;
    }

    public int getLoginState() {
        return this.loginstate;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public synchronized void setConfiguration(Configuration configurationParam) throws CloneNotSupportedException {
        this.configuration = (Configuration)configurationParam.clone();
        this.userInterface1.showStatus("SoftPhone Configuration Set", false, false);
    }

    public void setDebugging(boolean enableParam, int debugginglevelParam) {
        this.debugging = enableParam;
        this.debugginglevel = debugginglevelParam;
    }

    public void setSipState(int sipstateParam) {
        this.sipstate = sipstateParam;
    }

    public void setInboundEndTimer(int inboundEndTimerDelayParam) {
        this.inboundEndTimerDelay = inboundEndTimerDelayParam;
    }

    public void setUserInterface2(UserInterface myUserInterface2Param) {
        this.userInterface2 = myUserInterface2Param;
    }

    public void setDestination(Destination destinationParam) {
        this.destination = destinationParam;
    }

    public void setEPhoneGUIActive(boolean enableParam) {
        this.ePhoneGUIActive = enableParam;
    }

    public void updateDisplay() {
        this.userInterface2.phoneDisplay(this.displayData);
    }

    public void setRingingResponse(int autoRingingResponseParam, int autoRingingResponseDelayParam) {
        this.autoRingingResponse = autoRingingResponseParam;
        this.autoRingingResponseDelay = autoRingingResponseDelayParam;
    }

    @Override
    public void run() {
    }

    static /* synthetic */ byte[] access$5402(SoftPhone x0, byte[] x1) {
        x0.offerSDPBytes = x1;
        return x1;
    }
}

