/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.rtp.RTPSessionMgr;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;

public class SoundStreamer
implements ReceiveStreamListener {
    private boolean muteAudio;
    private RTPSessionMgr rtpSessionManager;
    private InetAddress sourceIP;
    private InetAddress destinationIP;
    private Integer sourcePort;
    private Integer destinationPort;
    private SessionAddress localAddress;
    private SessionAddress remoteAddress;
    private SessionAddress destAddress;
    private Processor processor;
    private SendStream sendStream;
    private ReceiveStream receiveStream;
    private Player player;
    private AudioFormat audioFormat;
    private DataSource iDS;
    private DataSource oDS;
    private DataSource rDS;
    private DataSource tDS;
    private boolean isListening;
    private static int AUTO_SOURCE_PORT_RANGE_START = 10000;
    private static int AUTO_SOURCE_PORT_RANGE_END = 49998;
    public long mediaDuration = 1000L;
    private final double RTCP_BW_FRACTION = 0.05;
    private final double RTCP_SENDER_BW_FRACTION = 0.25;
    SessionAddress localSessionAddress;
    UserInterface userInterface;

    SoundStreamer(UserInterface userInterfaceParam, int superIdParam) {
        this.userInterface = userInterfaceParam;
    }

    public synchronized String[] startListener(String sourceIPParam, int sourcePortParam, String destinationIPParam, int destinationPortParam) {
        String[] status = new String[]{"0", "0"};
        try {
            this.sourceIP = InetAddress.getByName(sourceIPParam);
        }
        catch (UnknownHostException error) {
            status[0] = "1";
            status[1] = "Error: UnknownHostException: sourceIP = InetAddress.getByName( " + sourceIPParam + "): UnknownHostException: " + error.getMessage();
            return status;
        }
        this.rtpSessionManager = new RTPSessionMgr();
        this.rtpSessionManager.addReceiveStreamListener((ReceiveStreamListener)this);
        this.localSessionAddress = new SessionAddress();
        try {
            this.rtpSessionManager.initSession(this.localSessionAddress, null, 0.05, 0.25);
        }
        catch (InvalidSessionAddressException error) {
            status[0] = "1";
            status[1] = "Error: InvalidSessionAddressException: voiceSessionManager.initSession(localSessionAddress, null, RTCP_BW_FRACTION, RTCP_SENDER_BW_FRACTION): InvalidSessionAddressException: " + error.getMessage();
            return status;
        }
        try {
            this.destinationIP = InetAddress.getByName(destinationIPParam);
        }
        catch (UnknownHostException error) {
            status[0] = "1";
            status[1] = "Error: UnknownHostException: destinationIP = InetAddress.getByName(" + destinationIPParam + "): UnknownHostException: " + error.getMessage();
            return status;
        }
        boolean startSessionUnsuccessfull = false;
        int retryCounter = 0;
        int retryLimit = 5;
        int retryInterval = 100;
        do {
            startSessionUnsuccessfull = false;
            if (sourcePortParam == 0) {
                this.sourcePort = this.findSoundPorts();
                status[0] = "0";
                status[1] = this.sourcePort.toString();
            } else {
                this.sourcePort = sourcePortParam;
                status[0] = "0";
                status[1] = this.sourcePort.toString();
            }
            this.destinationPort = destinationPortParam;
            this.localAddress = new SessionAddress(this.sourceIP, this.sourcePort.intValue(), this.sourceIP, this.sourcePort + 1);
            this.remoteAddress = new SessionAddress(this.destinationIP, this.destinationPort.intValue(), this.destinationIP, this.destinationPort + 1);
            try {
                this.rtpSessionManager.startSession(this.localAddress, this.localAddress, this.remoteAddress, null);
            }
            catch (IOException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: startListener IOException: voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (InvalidSessionAddressException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: startListener InvalidSessionAddressException: voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (startSessionUnsuccessfull);
        this.isListening = true;
        return status;
    }

    public String[] stopListener() {
        String[] status = new String[]{"0", ""};
        if (this.isListening) {
            // empty if block
        }
        if (this.rtpSessionManager != null) {
            this.rtpSessionManager.closeSession();
            this.rtpSessionManager.removeReceiveStreamListener((ReceiveStreamListener)this);
            this.rtpSessionManager.dispose();
            this.rtpSessionManager = null;
            this.localSessionAddress = null;
            this.destinationIP = null;
            this.sourceIP = null;
            this.sourcePort = null;
            this.destinationIP = null;
            this.destinationPort = null;
            this.localAddress = null;
            this.remoteAddress = null;
            this.userInterface = null;
            this.iDS = null;
            this.oDS = null;
            this.rDS = null;
            this.tDS = null;
            this.userInterface = null;
            this.processor = null;
            this.player = null;
            this.sendStream = null;
            this.receiveStream = null;
            this.audioFormat = null;
        }
        this.isListening = false;
        return status;
    }

    public synchronized String[] muteAudio() {
        String[] status = new String[]{"0", ""};
        if (this.rtpSessionManager != null) {
            this.rtpSessionManager.closeSession();
            this.rtpSessionManager.dispose();
        }
        return status;
    }

    public synchronized String[] unMuteAudio() {
        String[] status = new String[]{"0", ""};
        if (this.rtpSessionManager != null) {
            this.rtpSessionManager = new RTPSessionMgr();
            this.rtpSessionManager.addReceiveStreamListener((ReceiveStreamListener)this);
            try {
                this.rtpSessionManager.initSession(this.localSessionAddress, null, 0.05, 0.25);
            }
            catch (InvalidSessionAddressException error) {
                status[0] = "1";
                status[1] = "Error: voiceSessionManager.initSession(localSessionAddress, null, RTCP_BW_FRACTION, RTCP_SENDER_BW_FRACTION): InvalidSessionAddressException: " + error.getMessage();
                return status;
            }
            boolean startSessionUnsuccessfull = false;
            int retryCounter = 0;
            int retryLimit = 5;
            int retryInterval = 100;
            do {
                startSessionUnsuccessfull = false;
                try {
                    this.rtpSessionManager.startSession(this.localAddress, this.localAddress, this.remoteAddress, null);
                }
                catch (IOException error) {
                    startSessionUnsuccessfull = true;
                    if (retryCounter == retryLimit) {
                        status[0] = "1";
                        status[1] = "Error: IOException voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                        return status;
                    }
                    ++retryCounter;
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (InvalidSessionAddressException error) {
                    startSessionUnsuccessfull = true;
                    if (retryCounter == retryLimit) {
                        status[0] = "1";
                        status[1] = "Error: InvalidSessionAddressException voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                        return status;
                    }
                    ++retryCounter;
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (startSessionUnsuccessfull);
        }
        return status;
    }

    public synchronized String[] updateDestination(String destinationIPParam, String destinationPortParam) {
        String[] status = new String[]{"0", ""};
        try {
            this.destinationIP = InetAddress.getByName(destinationIPParam);
        }
        catch (UnknownHostException error) {
            status[0] = "1";
            status[1] = "Error: InetAddress.getByName(destIPField): UnknownHostException: " + error.getMessage();
            return status;
        }
        this.destinationPort = Integer.parseInt(destinationPortParam);
        this.remoteAddress = new SessionAddress(this.destinationIP, this.destinationPort.intValue(), this.destinationIP, this.destinationPort + 1);
        this.rtpSessionManager.closeSession();
        this.rtpSessionManager.removeReceiveStreamListener((ReceiveStreamListener)this);
        this.rtpSessionManager.dispose();
        this.rtpSessionManager = new RTPSessionMgr();
        this.rtpSessionManager.addReceiveStreamListener((ReceiveStreamListener)this);
        try {
            this.rtpSessionManager.initSession(this.localSessionAddress, null, 0.05, 0.25);
        }
        catch (InvalidSessionAddressException error) {
            status[0] = "1";
            status[1] = "Error: voiceSessionManager.initSession(localSessionAddress, null, RTCP_BW_FRACTION, RTCP_SENDER_BW_FRACTION): InvalidSessionAddressException: " + error.getMessage();
            return status;
        }
        boolean startSessionUnsuccessfull = false;
        int retryCounter = 0;
        int retryLimit = 5;
        int retryInterval = 100;
        do {
            startSessionUnsuccessfull = false;
            try {
                this.rtpSessionManager.startSession(this.localAddress, this.localAddress, this.remoteAddress, null);
            }
            catch (IOException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: [" + retryCounter + "] updateDestination IOException: voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (InvalidSessionAddressException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: [" + retryCounter + "] updateDestination InvalidSessionAddressException: voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++retryCounter;
        } while (startSessionUnsuccessfull);
        return status;
    }

    public synchronized String[] startStreamer(String destIPField, String destPortField, String fileName, int audioFormatParam) throws NoDataSourceException, NoProcessorException, UnsupportedFormatException {
        String[] status = new String[]{"0", ""};
        InetAddress destIP = null;
        try {
            destIP = InetAddress.getByName(destIPField);
        }
        catch (UnknownHostException error) {
            status[0] = "1";
            status[1] = "Error: destIP = InetAddress.getByName(destIPField): UnknownHostException: " + error.getMessage();
            return status;
        }
        Integer destPort = Integer.parseInt(destPortField);
        MediaLocator mediaLocator = new MediaLocator(fileName);
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            status[0] = "1";
            status[1] = "Error: url = new URL(fileName): MalformedURLException: " + ex.getMessage();
            return status;
        }
        try {
            this.iDS = Manager.createDataSource((MediaLocator)mediaLocator);
        }
        catch (IOException error) {
            status[0] = "1";
            status[1] = "Error: iDS = Manager.createDataSource(mediaLocator): IOException: " + error.getMessage();
            return status;
        }
        catch (NoDataSourceException error) {
            status[0] = "1";
            status[1] = "Error: iDS = Manager.createDataSource(mediaLocator): NoDataSourceException: " + error.getMessage();
            return status;
        }
        try {
            this.processor = Manager.createProcessor((DataSource)this.iDS);
        }
        catch (IOException error) {
            status[0] = "1";
            status[1] = "Error: processor = Manager.createProcessor(iDS): IOException: " + error.getMessage();
            return status;
        }
        catch (NoProcessorException error) {
            status[0] = "1";
            status[1] = "Error: processor = Manager.createProcessor(iDS): NoProcessorException: " + error.getMessage();
            return status;
        }
        this.processor.configure();
        int retryCounter = 0;
        int retryLimit = 3;
        int retryInterval = 10;
        try {
            Thread.sleep(retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.processor != null && this.processor.getState() != 180 && retryCounter != retryLimit) {
            if (++retryCounter == retryLimit) {
                status[0] = "1";
                status[1] = "Error: SoundStreamer: processor.configure() Giving Up!";
                return status;
            }
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.processor.setContentDescriptor(new ContentDescriptor("raw.rtp"));
        TrackControl[] track = this.processor.getTrackControls();
        switch (audioFormatParam) {
            case 0: {
                this.audioFormat = new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
                break;
            }
            case 3: {
                this.audioFormat = new AudioFormat("gsm/rtp", 8000.0, 8, 1);
                break;
            }
            case 4: {
                this.audioFormat = new AudioFormat("g723/rtp", 8000.0, 8, 1);
                break;
            }
            case 8: {
                this.audioFormat = new AudioFormat("alaw", 8000.0, 8, 1);
            }
        }
        track[0].setFormat((Format)this.audioFormat);
        this.processor.realize();
        retryCounter = 0;
        retryLimit = 20;
        retryInterval = 100;
        try {
            Thread.sleep(retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this.processor == null || this.processor.getState() != 300 && retryCounter <= retryLimit) {
            if (this.processor == null) {
                this.processor.realize();
            }
            if (++retryCounter == retryLimit) {
                status[0] = "1";
                status[1] = "Error: SoundStreamer: processor.realize() Giving Up!";
                return status;
            }
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.mediaDuration = (long)(this.processor.getDuration().getSeconds() * 1000.0);
        this.tDS = this.processor.getDataOutput();
        this.destAddress = new SessionAddress(destIP, destPort.intValue(), destIP, destPort + 1);
        boolean startSessionUnsuccessfull = false;
        retryCounter = 0;
        retryLimit = 5;
        retryInterval = 10;
        do {
            startSessionUnsuccessfull = false;
            try {
                this.rtpSessionManager.startSession(this.localAddress, this.localAddress, this.remoteAddress, null);
            }
            catch (IOException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: startStreamer IOException voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (InvalidSessionAddressException error) {
                startSessionUnsuccessfull = true;
                if (retryCounter == retryLimit) {
                    status[0] = "1";
                    status[1] = "Error: startStreamer InvalidSessionAddressException voiceSessionManager.startSession(..) " + error.getMessage() + " Giving Up!!!";
                    return status;
                }
                ++retryCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (startSessionUnsuccessfull);
        try {
            this.sendStream = this.rtpSessionManager.createSendStream(this.tDS, 0);
        }
        catch (IOException error) {
            status[0] = "1";
            status[1] = "Error: sendStream = voiceSessionManager.createSendStream(tDS, 0): " + error.getMessage();
            return status;
        }
        catch (UnsupportedFormatException error) {
            status[0] = "1";
            status[1] = "Error: sendStream = voiceSessionManager.createSendStream(tDS, 0): UnsupportedFormatException: " + error.getMessage();
            return status;
        }
        try {
            this.sendStream.start();
            this.processor.start();
        }
        catch (IOException error) {
            status[0] = "1";
            status[1] = "Error: sendStream.start(); processor.start();: IOException: " + error.getMessage();
            return status;
        }
        return status;
    }

    public String[] stopMedia() {
        String[] status = new String[]{"0", ""};
        if (this.processor != null) {
            switch (this.processor.getState()) {
                case 100: {
                    status[1] = "Processor Unrealized...";
                    this.processor.close();
                    break;
                }
                case 200: {
                    status[1] = "Processor Realizing...";
                    this.processor.close();
                    break;
                }
                case 300: {
                    status[1] = "Processor Realized...";
                    this.processor.close();
                    break;
                }
                case 140: {
                    status[1] = "Processor Configuring...";
                    this.processor.close();
                    break;
                }
                case 180: {
                    status[1] = "Processor Configured...";
                    this.processor.close();
                    break;
                }
                case 400: {
                    status[1] = "Processor Prefetching...";
                    this.processor.close();
                    break;
                }
                case 500: {
                    status[1] = "Processor Prefetched...";
                    this.processor.close();
                    break;
                }
                case 600: {
                    status[1] = "Processor Started...";
                    this.processor.stop();
                    this.processor.close();
                    try {
                        this.sendStream.stop();
                        this.sendStream.close();
                        break;
                    }
                    catch (IOException error) {
                        status[0] = "1";
                        status[1] = "Error: sendStream.stop(); sendStream.close();: IOException: " + error.getMessage();
                        return status;
                    }
                }
                default: {
                    status[1] = "Processor Unknown state: " + this.processor.getState();
                }
            }
        }
        if (this.player != null) {
            switch (this.player.getState()) {
                case 100: {
                    status[1] = "Player Unrealized...";
                    this.player.close();
                    break;
                }
                case 200: {
                    status[1] = "Player Realizing...";
                    this.player.close();
                    break;
                }
                case 300: {
                    status[1] = "Player Realized...";
                    this.player.close();
                    break;
                }
                case 400: {
                    status[1] = "Player Prefetching...";
                    this.player.close();
                    break;
                }
                case 500: {
                    status[1] = "Player Prefetched...";
                    this.player.close();
                    break;
                }
                case 600: {
                    this.player.stop();
                    this.player.close();
                    break;
                }
                default: {
                    status[1] = "Player Unknown state: " + this.player.getState();
                }
            }
        }
        return status;
    }

    public synchronized void update(ReceiveStreamEvent event) {
        if (event instanceof NewReceiveStreamEvent) {
            this.receiveStream = event.getReceiveStream();
            this.rDS = this.receiveStream.getDataSource();
            try {
                this.player = Manager.createPlayer((DataSource)this.rDS);
            }
            catch (IOException ex) {
                this.userInterface.showStatus("Error: IOException: SoundStreamer.update(event): player = javax.media.Manager.createPlayer(rDS) " + ex.getMessage(), true, true);
            }
            catch (NoPlayerException ex) {
                this.userInterface.showStatus("Error: NoPlayerException: SoundStreamer.update(event): player = javax.media.Manager.createPlayer(rDS) " + ex.getMessage(), true, true);
            }
            this.player.start();
        } else if (this.player != null) {
            this.player.start();
        }
    }

    public boolean isListening() {
        return this.isListening;
    }

    public synchronized int findSoundPorts() {
        Integer randomEvenPort = 0;
        Integer oddPort = 0;
        DatagramSocket evenUDPSocket = null;
        DatagramSocket oddUDPSocket = null;
        boolean evenUDPSocketNotInstantiated = false;
        boolean oddUDPSocketNotInstantiated = false;
        int retryInterval = 100;
        int oddLoopCounter = 0;
        int outerRetryLimit = 10;
        do {
            evenUDPSocketNotInstantiated = false;
            oddUDPSocketNotInstantiated = false;
            int evenLoopCounter = 0;
            int evenRetryLimit = 10;
            do {
                randomEvenPort = (int)(Math.random() * (double)(AUTO_SOURCE_PORT_RANGE_END - AUTO_SOURCE_PORT_RANGE_START) + (double)AUTO_SOURCE_PORT_RANGE_START);
                evenUDPSocketNotInstantiated = false;
                if (Integer.lowestOneBit(randomEvenPort) == 1) {
                    Integer n = randomEvenPort;
                    Integer n2 = randomEvenPort = Integer.valueOf(randomEvenPort + 1);
                }
                try {
                    evenUDPSocket = new DatagramSocket(randomEvenPort);
                }
                catch (IOException error) {
                    evenUDPSocketNotInstantiated = true;
                    if (evenLoopCounter == evenRetryLimit) {
                        this.userInterface.logToApplication("Error: [" + evenLoopCounter + "] SoundStreamer.findSoundPorts(): evenUDPSocket = new DatagramSocket(" + randomEvenPort + "): " + error.getMessage());
                    }
                    if (evenUDPSocket != null && evenUDPSocket.isBound()) {
                        evenUDPSocket.close();
                    }
                    try {
                        Thread.sleep(retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++evenLoopCounter;
                }
            } while (evenLoopCounter <= evenRetryLimit && (evenUDPSocketNotInstantiated || evenUDPSocket == null));
            int oddRetryLimit = 10;
            try {
                oddUDPSocket = new DatagramSocket(randomEvenPort + 1);
            }
            catch (IOException error) {
                oddUDPSocketNotInstantiated = true;
                if (oddLoopCounter == oddRetryLimit) {
                    this.userInterface.logToApplication("Error: [" + oddLoopCounter + "] SoundStreamer.findSoundPorts(): oddUDPSocket = new DatagramSocket(" + randomEvenPort + 1 + "): " + error.getMessage());
                }
                if (oddUDPSocket != null && oddUDPSocket.isBound()) {
                    oddUDPSocket.close();
                }
                ++oddLoopCounter;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (oddLoopCounter <= outerRetryLimit && evenUDPSocketNotInstantiated && oddUDPSocketNotInstantiated || oddUDPSocket == null);
        evenUDPSocket.close();
        evenUDPSocket = null;
        oddUDPSocket.close();
        oddUDPSocket = null;
        return randomEvenPort;
    }
}

