/*
 * Decompiled with CFR 0.152.
 */
import datasets.Destination;
import datasets.DisplayData;
import datasets.SpeakerData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.NoDataSourceException;
import javax.media.NoProcessorException;
import javax.media.format.UnsupportedFormatException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class SoundStreamerGUI
extends JFrame
implements UserInterface {
    private InetAddress myIP = null;
    public static String bufferDisplay = null;
    private SoundStreamer soundStreamer = null;
    private boolean powerOn = false;
    private String[] status = null;
    private JComboBox audioFormatBox;
    private JLabel audioFormatLabel;
    private JLabel audioFormatLabel1;
    private JTextField destinationIPField;
    private JLabel destinationIPLabel;
    private JPanel destinationPanel;
    private JTextField destinationPortField;
    private JLabel destinationPortLabel;
    private JTextField filenameField;
    private static JEditorPane logDisplay;
    private JPanel mediaPanel;
    private JButton powerButton;
    private JTextField sourceIPField;
    private JLabel sourceIPLabel;
    private JPanel sourcePanel;
    private JTextField sourcePortField;
    private JLabel sourcePortLabel;
    private JButton startStreamButton;
    private static JEditorPane statusDisplay;
    private JScrollPane statusDisplayPane;
    private JScrollPane statusDisplayPane1;
    private JButton stopStreamButton;
    private JPanel streamButtonsPanel;
    private JButton updateDestinationButton;

    public SoundStreamerGUI(String sourceIPParam, String sourcePortParam, String destIPParam, String destPortParam) {
        this.initComponents();
        try {
            this.myIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException error) {
            this.showStatus("Error: InetAddress.getLocalHost(): " + error.getMessage(), true, true);
        }
        this.sourceIPField.setText(sourceIPParam);
        this.sourcePortField.setText(sourcePortParam);
        this.destinationIPField.setText(destIPParam);
        this.destinationPortField.setText(destPortParam);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (args.length != 4) {
                    String myIPString = null;
                    try {
                        myIPString = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    new SoundStreamerGUI(myIPString, "0", myIPString, "0").setVisible(true);
                } else {
                    new SoundStreamerGUI(args[0], args[1], args[2], args[3]).setVisible(true);
                }
            }
        });
    }

    private void initComponents() {
        this.powerButton = new JButton();
        this.statusDisplayPane = new JScrollPane();
        logDisplay = new JEditorPane();
        this.statusDisplayPane1 = new JScrollPane();
        statusDisplay = new JEditorPane();
        this.sourcePanel = new JPanel();
        this.sourceIPLabel = new JLabel();
        this.sourceIPField = new JTextField();
        this.sourcePortLabel = new JLabel();
        this.sourcePortField = new JTextField();
        this.destinationPanel = new JPanel();
        this.destinationIPLabel = new JLabel();
        this.destinationIPField = new JTextField();
        this.destinationPortLabel = new JLabel();
        this.destinationPortField = new JTextField();
        this.updateDestinationButton = new JButton();
        this.mediaPanel = new JPanel();
        this.audioFormatLabel = new JLabel();
        this.audioFormatBox = new JComboBox();
        this.filenameField = new JTextField();
        this.audioFormatLabel1 = new JLabel();
        this.streamButtonsPanel = new JPanel();
        this.startStreamButton = new JButton();
        this.stopStreamButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.powerButton.setFont(new Font("STHeiti", 0, 13));
        this.powerButton.setText("Power");
        this.powerButton.setName("powerButton");
        this.powerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundStreamerGUI.this.powerButtonActionPerformed(evt);
            }
        });
        this.statusDisplayPane.setHorizontalScrollBar(null);
        this.statusDisplayPane.setName("statusDisplayPane");
        logDisplay.setBackground(new Color(230, 230, 230));
        logDisplay.setEditable(false);
        logDisplay.setFont(new Font("Courier New", 0, 8));
        logDisplay.setDragEnabled(false);
        logDisplay.setMinimumSize(new Dimension(600, 200));
        logDisplay.setName("logDisplay");
        logDisplay.setPreferredSize(new Dimension(600, 200));
        logDisplay.setRequestFocusEnabled(false);
        logDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SoundStreamerGUI.this.logDisplayMouseClicked(evt);
            }
        });
        this.statusDisplayPane.setViewportView(logDisplay);
        this.statusDisplayPane1.setHorizontalScrollBar(null);
        this.statusDisplayPane1.setName("statusDisplayPane1");
        statusDisplay.setBackground(new Color(230, 230, 230));
        statusDisplay.setEditable(false);
        statusDisplay.setFont(new Font("STHeiti", 0, 8));
        statusDisplay.setDragEnabled(false);
        statusDisplay.setMinimumSize(new Dimension(600, 200));
        statusDisplay.setName("statusDisplay");
        statusDisplay.setPreferredSize(new Dimension(600, 200));
        statusDisplay.setRequestFocusEnabled(false);
        this.statusDisplayPane1.setViewportView(statusDisplay);
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder(null, "Source", 0, 0, new Font("STHeiti", 0, 13)));
        this.sourcePanel.setFont(new Font("STHeiti", 0, 13));
        this.sourcePanel.setName("sourcePanel");
        this.sourceIPLabel.setFont(new Font("STHeiti", 0, 13));
        this.sourceIPLabel.setText("Source IP");
        this.sourceIPLabel.setName("sourceIPLabel");
        this.sourceIPField.setFont(new Font("STHeiti", 0, 13));
        this.sourceIPField.setName("sourceIPField");
        this.sourcePortLabel.setFont(new Font("STHeiti", 0, 13));
        this.sourcePortLabel.setText("Source Port");
        this.sourcePortLabel.setName("sourcePortLabel");
        this.sourcePortField.setFont(new Font("STHeiti", 0, 13));
        this.sourcePortField.setName("sourcePortField");
        GroupLayout sourcePanelLayout = new GroupLayout((Container)this.sourcePanel);
        this.sourcePanel.setLayout((LayoutManager)sourcePanelLayout);
        sourcePanelLayout.setHorizontalGroup((GroupLayout.Group)sourcePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sourcePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)sourcePanelLayout.createParallelGroup(1).add((Component)this.sourcePortLabel).add((Component)this.sourceIPLabel)).addPreferredGap(0, 113, Short.MAX_VALUE).add((GroupLayout.Group)sourcePanelLayout.createParallelGroup(1, false).add((Component)this.sourcePortField).add((Component)this.sourceIPField, -1, 207, Short.MAX_VALUE)).addContainerGap()));
        sourcePanelLayout.setVerticalGroup((GroupLayout.Group)sourcePanelLayout.createParallelGroup(1).add((GroupLayout.Group)sourcePanelLayout.createSequentialGroup().add((GroupLayout.Group)sourcePanelLayout.createParallelGroup(3).add((Component)this.sourceIPLabel).add((Component)this.sourceIPField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)sourcePanelLayout.createParallelGroup(3).add((Component)this.sourcePortLabel).add((Component)this.sourcePortField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(null, "Media", 0, 0, new Font("STHeiti", 0, 13)));
        this.destinationPanel.setFont(new Font("STHeiti", 0, 13));
        this.destinationPanel.setName("destinationPanel");
        this.destinationIPLabel.setFont(new Font("STHeiti", 0, 13));
        this.destinationIPLabel.setText("Dest IP");
        this.destinationIPLabel.setName("destinationIPLabel");
        this.destinationIPField.setFont(new Font("STHeiti", 0, 13));
        this.destinationIPField.setName("destinationIPField");
        this.destinationPortLabel.setFont(new Font("STHeiti", 0, 13));
        this.destinationPortLabel.setText("Dest Port");
        this.destinationPortLabel.setName("destinationPortLabel");
        this.destinationPortField.setFont(new Font("STHeiti", 0, 13));
        this.destinationPortField.setName("destinationPortField");
        this.updateDestinationButton.setFont(new Font("STHeiti", 0, 13));
        this.updateDestinationButton.setText("Update");
        this.updateDestinationButton.setName("updateDestinationButton");
        this.updateDestinationButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SoundStreamerGUI.this.updateDestinationButtonMouseClicked(evt);
            }
        });
        GroupLayout destinationPanelLayout = new GroupLayout((Container)this.destinationPanel);
        this.destinationPanel.setLayout((LayoutManager)destinationPanelLayout);
        destinationPanelLayout.setHorizontalGroup((GroupLayout.Group)destinationPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)destinationPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)destinationPanelLayout.createParallelGroup(1).add((Component)this.destinationIPLabel).add((Component)this.destinationPortLabel)).addPreferredGap(0, 130, Short.MAX_VALUE).add((GroupLayout.Group)destinationPanelLayout.createParallelGroup(1, false).add(2, (Component)this.updateDestinationButton, -1, -1, Short.MAX_VALUE).add((Component)this.destinationPortField).add((Component)this.destinationIPField, -2, 206, -2)).addContainerGap()));
        destinationPanelLayout.setVerticalGroup((GroupLayout.Group)destinationPanelLayout.createParallelGroup(1).add((GroupLayout.Group)destinationPanelLayout.createSequentialGroup().add((GroupLayout.Group)destinationPanelLayout.createParallelGroup(3).add((Component)this.destinationIPLabel).add((Component)this.destinationIPField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)destinationPanelLayout.createParallelGroup(3).add((Component)this.destinationPortLabel).add((Component)this.destinationPortField, -2, -1, -2)).addPreferredGap(0).add((Component)this.updateDestinationButton, -2, 35, -2).addContainerGap(19, Short.MAX_VALUE)));
        this.mediaPanel.setBorder(BorderFactory.createTitledBorder(null, "Media", 0, 0, new Font("STHeiti", 0, 13)));
        this.mediaPanel.setFont(new Font("STHeiti", 0, 13));
        this.mediaPanel.setName("mediaPanel");
        this.audioFormatLabel.setFont(new Font("STHeiti", 0, 13));
        this.audioFormatLabel.setText("Audio Format");
        this.audioFormatLabel.setName("audioFormatLabel");
        this.audioFormatBox.setFont(new Font("STHeiti", 0, 13));
        this.audioFormatBox.setModel(new DefaultComboBoxModel<String>(new String[]{"GSM_RTP", "LINEAR"}));
        this.audioFormatBox.setName("audioFormatBox");
        this.filenameField.setFont(new Font("STHeiti", 0, 13));
        this.filenameField.setText("file://var/tmp/softphone.wav");
        this.filenameField.setName("filenameField");
        this.audioFormatLabel1.setFont(new Font("STHeiti", 0, 13));
        this.audioFormatLabel1.setText("Media File");
        this.audioFormatLabel1.setName("audioFormatLabel1");
        GroupLayout mediaPanelLayout = new GroupLayout((Container)this.mediaPanel);
        this.mediaPanel.setLayout((LayoutManager)mediaPanelLayout);
        mediaPanelLayout.setHorizontalGroup((GroupLayout.Group)mediaPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mediaPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mediaPanelLayout.createParallelGroup(1).add((Component)this.audioFormatLabel).add((Component)this.audioFormatLabel1)).addPreferredGap(0, 98, Short.MAX_VALUE).add((GroupLayout.Group)mediaPanelLayout.createParallelGroup(1, false).add((Component)this.filenameField).add((Component)this.audioFormatBox, -2, 207, -2)).addContainerGap()));
        mediaPanelLayout.setVerticalGroup((GroupLayout.Group)mediaPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mediaPanelLayout.createSequentialGroup().add((GroupLayout.Group)mediaPanelLayout.createParallelGroup(3).add((Component)this.audioFormatLabel).add((Component)this.audioFormatBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mediaPanelLayout.createParallelGroup(3).add((Component)this.audioFormatLabel1).add((Component)this.filenameField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.streamButtonsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.streamButtonsPanel.setName("streamButtonsPanel");
        this.startStreamButton.setFont(new Font("STHeiti", 0, 13));
        this.startStreamButton.setText("Start Stream");
        this.startStreamButton.setName("startStreamButton");
        this.startStreamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundStreamerGUI.this.startStreamButtonActionPerformed(evt);
            }
        });
        this.stopStreamButton.setFont(new Font("STHeiti", 0, 13));
        this.stopStreamButton.setText("Stop Stream");
        this.stopStreamButton.setName("stopStreamButton");
        this.stopStreamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundStreamerGUI.this.stopStreamButtonActionPerformed(evt);
            }
        });
        GroupLayout streamButtonsPanelLayout = new GroupLayout((Container)this.streamButtonsPanel);
        this.streamButtonsPanel.setLayout((LayoutManager)streamButtonsPanelLayout);
        streamButtonsPanelLayout.setHorizontalGroup((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)streamButtonsPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.startStreamButton, -2, 150, -2).addPreferredGap(0, 101, Short.MAX_VALUE).add((Component)this.stopStreamButton, -2, 150, -2).addContainerGap()));
        streamButtonsPanelLayout.setVerticalGroup((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)streamButtonsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(3).add((Component)this.startStreamButton, -2, 71, -2).add((Component)this.stopStreamButton, -2, 71, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.sourcePanel, -1, -1, Short.MAX_VALUE).add((Component)this.statusDisplayPane, -1, 415, Short.MAX_VALUE).add(2, (Component)this.statusDisplayPane1, -1, 415, Short.MAX_VALUE).add((Component)this.destinationPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.mediaPanel, -1, -1, Short.MAX_VALUE).add((Component)this.streamButtonsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.powerButton, -2, 150, -2).add(123, 123, 123)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.powerButton).addPreferredGap(0).add((Component)this.statusDisplayPane, -2, 105, -2).addPreferredGap(0).add((Component)this.statusDisplayPane1, -2, 18, -2).addPreferredGap(0).add((Component)this.sourcePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.destinationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.mediaPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.streamButtonsPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void logDisplayMouseClicked(MouseEvent evt) {
        SoundStreamerGUI.resetStatusDisplay();
    }

    private void startStreamButtonActionPerformed(ActionEvent evt) {
        try {
            this.soundStreamer.startStreamer(this.destinationIPField.getText(), this.destinationPortField.getText(), this.filenameField.getText().toString(), this.audioFormatBox.getSelectedIndex());
        }
        catch (NoDataSourceException noDataSourceException) {
        }
        catch (NoProcessorException noProcessorException) {
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            // empty catch block
        }
    }

    private void stopStreamButtonActionPerformed(ActionEvent evt) {
        this.soundStreamer.stopMedia();
    }

    private void powerButtonActionPerformed(ActionEvent evt) {
        if (!this.powerOn) {
            this.soundStreamer = new SoundStreamer(this, 0);
            this.status = this.soundStreamer.startListener(this.sourceIPField.getText(), Integer.parseInt(this.sourcePortField.getText()), this.destinationIPField.getText(), Integer.parseInt(this.destinationPortField.getText()));
            if (this.status[0].equals("1")) {
                this.logToApplication(this.status[1]);
            } else {
                this.sourcePortField.setText(this.status[1]);
            }
            this.powerOn = true;
            this.sourceIPField.setEnabled(false);
            this.sourcePortField.setEditable(false);
            this.showStatus("Media listener started.", true, true);
        } else if (this.powerOn) {
            this.powerOn = false;
            this.soundStreamer.stopMedia();
            this.soundStreamer.stopListener();
            this.sourceIPField.setEnabled(true);
            this.sourcePortField.setEditable(true);
            this.sourcePortField.setText("0");
            this.showStatus("Power Off", true, true);
        }
    }

    private void updateDestinationButtonMouseClicked(MouseEvent evt) {
        this.status = this.soundStreamer.updateDestination(this.destinationIPField.getText(), this.destinationPortField.getText());
        if (this.status[0].equals("1")) {
            this.logToApplication("Error: " + this.status[1]);
        } else {
            this.logToApplication("Succes: " + this.status[1]);
        }
    }

    @Override
    public void phoneDisplay(DisplayData displayParam) {
    }

    @Override
    public void logToApplication(String logmessage) {
        bufferDisplay = bufferDisplay + logmessage + "\n";
        logDisplay.setText(bufferDisplay);
    }

    @Override
    public void logToFile(String logmessage) {
        bufferDisplay = bufferDisplay + logmessage + "\n";
        logDisplay.setText(bufferDisplay);
    }

    public static void resetDisplay() {
        bufferDisplay = "";
        logDisplay.setText(bufferDisplay);
    }

    @Override
    public void showStatus(String messageParam, boolean logToApplicationParam, boolean logToFileParam) {
        statusDisplay.setText(messageParam);
    }

    public static void resetStatusDisplay() {
        logDisplay.setText("");
    }

    public void applicationConfigurationStatus(String statusParam) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void applicationFinished() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resetLog() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sipstateUpdate(int sipstateParam, int lastsipstateParam, int loginstateParam, int softphoneActivityParam, int softPhoneInstanceIdParam, Destination destinationParam) {
    }

    @Override
    public void speaker(SpeakerData speakerParam) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void responseUpdate(int responseCodeParam, String responseReasonPhraseParam, int softPhoneInstanceIdParam, Destination destinationParam) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void feedback(String messageParam, int valueParam) {
    }
}

