/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.media.protocol.DataSource;

public class SoundTool
implements ControllerListener {
    private URL url;
    private MediaLocator mediaLocator;
    private DataSource dsource;
    private Player player;
    private boolean end = false;
    private float mediaRate = 1.0f;
    private static final String dataDir = "data/";
    private static final String soundsDir = "data/sounds/";
    public static final String RINGTONE = "data/sounds//ringtone.wav";
    public static final String DIALTONE = "data/sounds//dialtone.wav";
    public static final String CALLTONE = "data/sounds//calltone.wav";
    public static final String BUSYTONE = "data/sounds//busytone.wav";
    public static final String DEADTONE = "data/sounds//deadtone.wav";
    public static final String ERRORTONE = "data/sounds//errortone.wav";
    public static final String CLICKONTONE = "data/sounds//clickontone.wav";
    public static final String CLICKOFFTONE = "data/sounds//clickofftone.wav";
    public static final String TICKTONE = "data/sounds//ticktone.wav";
    public static final String SUCCESSTONE = "data/sounds//successtone.wav";
    public static final String POWERSUCCESSTONE = "data/sounds//powersuccesstone.wav";
    public static final String FAILURETONE = "data/sounds//failuretone.wav";
    public static final String REGISTERENABLEDTONE = "data/sounds//enabledtone.wav";
    public static final String REGISTERDISABLEDTONE = "data/sounds//disabledtone.wav";
    public static final String ANSWERENABLEDTONE = "data/sounds//enabledtone.wav";
    public static final String ANSWERDISABLEDTONE = "data/sounds//disabledtone.wav";
    public static final String CANCELENABLEDTONE = "data/sounds//enabledtone.wav";
    public static final String CANCELDISABLEDTONE = "data/sounds//disabledtone.wav";
    public static final String MUTEENABLEDTONE = "data/sounds//enabledtone.wav";
    public static final String MUTEDISABLEDTONE = "data/sounds//disabledtone.wav";

    public SoundTool(String urlParam) {
        try {
            this.mediaLocator = new MediaLocator(urlParam);
            this.dsource = Manager.createDataSource((MediaLocator)this.mediaLocator);
            this.player = Manager.createRealizedPlayer((DataSource)this.dsource);
            this.player.addControllerListener((ControllerListener)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getMessage());
        }
    }

    public void rewind() {
        this.player.setMediaTime(Time.TIME_UNKNOWN);
    }

    public void fastBackward() {
        this.mediaRate = (float)((double)this.mediaRate - 0.5);
        this.player.setRate(this.mediaRate);
    }

    public void play() {
        this.end = true;
        this.mediaRate = 1.0f;
        this.player.setRate(this.mediaRate);
        this.player.start();
    }

    public void playLoop() {
        this.end = false;
        this.mediaRate = 1.0f;
        this.player.setRate(this.mediaRate);
        this.player.start();
    }

    public void stop() {
        this.end = true;
        this.player.stop();
        this.player.setMediaTime(Time.TIME_UNKNOWN);
    }

    public void fastForward() {
        this.mediaRate = (float)((double)this.mediaRate + 0.5);
        this.player.setRate(this.mediaRate);
    }

    public void wind() {
        this.player.setMediaTime(this.player.getDuration());
    }

    public int getMediaDuration() {
        int duration = 0;
        if (this.player.getDuration() != null) {
            duration = (int)this.player.getDuration().getSeconds();
        }
        return duration;
    }

    public String getSoundsDir() {
        return soundsDir;
    }

    public void controllerUpdate(ControllerEvent cEvent) {
        if (cEvent instanceof EndOfMediaEvent) {
            if (!this.end) {
                this.rewind();
                this.player.start();
            } else {
                this.player.stop();
                this.rewind();
            }
        }
    }

    public void dispose() {
        this.player.removeControllerListener((ControllerListener)this);
        this.player.close();
    }
}

