/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Calendar;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Vergunning
implements Cloneable {
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int HOUR = 3600000;
    private static final int DAY = 86400000;
    private static final int WEEK = 604800000;
    private static final int YEAR = 1471228928;
    public final int PHONELINES_DEMO = 500;
    public final int CALLSPERHOUR_DEMO = 20000;
    public final int MAXCALLS_DEMO = 1000000000;
    public final int DESTINATIONDIGITS_DEMO = 100;
    public final int PHONELINES_STANDARD = 500;
    public final int CALLSPERHOUR_STANDARD = 20000;
    public final int MAXCALLS_STANDARD = 1000000000;
    public final int DESTINATIONDIGITS_STANDARD = 100;
    public final int PHONELINES_PROFESSIONAL = 500;
    public final int CALLSPERHOUR_PROFESSIONAL = 20000;
    public final int MAXCALLS_PROFESSIONAL = 1000000000;
    public final int DESTINATIONDIGITS_PROFESSIONAL = 100;
    public final int PHONELINES_ENTERPRISE = 500;
    public static final int CALLSPERHOUR_ENTERPRISE = 20000;
    public final int MAXCALLS_ENTERPRISE = 1000000000;
    public final int DESTINATIONDIGITS_ENTERPRISE = 100;
    public static final String BRAND = "VoipStorm";
    public static final String BUSINESS = "Telemarketing";
    public static final String BRAND_DESCRIPTION = "VoipStorm offers 21st Century TeleMarketing Software. Select a soundfile, copy and paste your phonenumbers and start a lightning fast Telephone Advertisement Campaign. TeleMarketing has never been so Fast and Easy at only a tiny Fraction of the costs of Traditional TeleMarketing channels like: CallCenters, Radio and TV !";
    public static final String PRODUCT = "ECallCenter21";
    public static final String VERSION = "v3.2";
    public static final String PRODUCT_DESCRIPTION = "ECallCenter21 is the driving force behind VoipStorm. ECallCenter21 can make 20000 Phonecalls per Hour, " + Math.round(320.0f) + " thousand people hear your message in 16 Hours. " + Math.round(175.0f) + " million calls a year (non stop!)";
    public static final String WEBLINK = "https://sites.google.com/site/voipstorm2/";
    public static final String REQUEST_VERGUNNINGLINK = "https://sites.google.com/site/voipstorm2/";
    private static final String VERGUNNINGTOEKENNERTOEGANG = "IsNwtNp4L";
    public static final String WARNING = "Please use VoipStorm software carefully, responsibly and according your country's legislation.";
    public static final String COPYRIGHT = "\u00a9 " + Calendar.getInstance().get(1);
    public static final String AUTHOR = "Ron de Jong";
    private boolean debugging = false;
    private static final String dataDir = "data/";
    private final String xmlVergunningDir = "data/license/";
    private String xmlFileName;
    private String xmlFileBase;
    private String xmlFileExtention;
    private boolean vergunningLoaded;
    private boolean vergunningOrderInProgress;
    private String activationCodeFromFile;
    private String vergunningCodeFromFile;
    private String vergunningType;
    private Calendar vergunningStartCalendar;
    private Calendar vergunningEndCalendar;
    private Calendar systemTimeCalendar;
    private String vergunningPeriod;
    private String activationCodeFromSystem;
    private String vergunningCodeFromSystem;
    private boolean vergunningValid;
    private int phoneLines;
    private int callsPerHour;
    private int maxCalls;
    private int destinationDigits;
    private String[] status;
    private InetAddress myIP;
    private byte[] myBytes;
    private String vergunningInvalidReason = "";
    private String vergunningInvalidAdvise = "";
    private String output = "";
    private String totOutput = "";
    private NetworkInterface networkInterface;
    private Enumeration networkInterfaceList;
    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = null;
    Document xmlDocument = null;

    public Vergunning() {
        this.xmlFileName = "";
        this.xmlFileBase = "license";
        this.xmlFileExtention = ".xml";
        this.activationCodeFromFile = "";
        this.vergunningCodeFromFile = "";
        this.status = new String[2];
        this.vergunningLoaded = true;
        this.vergunningValid = true;
        this.vergunningOrderInProgress = false;
        this.vergunningType = "Enterprise";
        this.vergunningPeriod = "";
        this.phoneLines = 500;
        this.callsPerHour = 20000;
        this.maxCalls = 1000000000;
        this.destinationDigits = 100;
        this.vergunningStartCalendar = Calendar.getInstance();
        this.vergunningEndCalendar = Calendar.getInstance();
        this.systemTimeCalendar = Calendar.getInstance();
    }

    public Vergunning(String activationCodeParam, String vergunningCodeParam) {
        this.activationCodeFromFile = activationCodeParam;
        this.vergunningCodeFromFile = vergunningCodeParam;
    }

    public String[] createVergunning() {
        this.status[0] = "0";
        this.status[1] = "";
        this.setActivationCode("");
        this.setVergunningCode("");
        return this.status;
    }

    public String[] loadVergunning() {
        this.vergunningLoaded = false;
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = "data/license/" + this.xmlFileBase + this.xmlFileExtention;
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        this.xmlDocument = null;
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: builder = builderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        try {
            this.xmlDocument = this.builder.parse(this.xmlFileName);
        }
        catch (SAXException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: xmlDocument = builder.parse(xmlFile): SAXException: " + error.getMessage();
            return this.status;
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: xmlDocument = builder.parse(xmlFile): IOException: " + error.getMessage();
            return this.status;
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "loadLicense Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        Node node = this.xmlDocument.getFirstChild();
        NodeList nodelist = node.getChildNodes();
        int nodelistcount = nodelist.getLength();
        for (int i = 1; i < nodelistcount; i += 2) {
            String nodeName = nodelist.item(i).getNodeName();
            String nodeValue = nodelist.item(i).getTextContent();
            if (nodeName.equals("activationCode")) {
                this.setActivationCode(nodeValue);
                continue;
            }
            if (!nodeName.equals("licenseCode")) continue;
            this.setVergunningCode(nodeValue);
        }
        this.vergunningLoaded = true;
        return this.status;
    }

    public String[] saveVergunning() {
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = "data/license/" + this.xmlFileBase + this.xmlFileExtention;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: docBuilder = documentBuilderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        this.xmlDocument = docBuilder.newDocument();
        Element root = this.xmlDocument.createElement("license");
        this.xmlDocument.appendChild(root);
        Comment comment = this.xmlDocument.createComment("VoipStorm License");
        root.appendChild(comment);
        Element child = this.xmlDocument.createElement("activationCode");
        Text text = this.xmlDocument.createTextNode(this.getActivationCode());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("licenseCode");
        text = this.xmlDocument.createTextNode(this.getVergunningCode());
        child.appendChild(text);
        root.appendChild(child);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        FileWriter fileWriter = null;
        File fileToWrite = new File(this.xmlFileName);
        try {
            fileWriter = new FileWriter(fileToWrite);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter = new FileWriter(fileToWrite): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.write(xmlString);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter.write(xmlString): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.flush();
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveLicense Error: fileWriter.flush(): IOException: " + error.getMessage();
            return this.status;
        }
        return this.status;
    }

    public boolean controleerVergunning() {
        this.status = this.loadVergunning();
        if (this.status[0].equals("0")) {
            this.vergunningLoaded = true;
            String[] activationCodeField = new String[10];
            activationCodeField = this.activationCodeFromFile.split("-");
            this.systemTimeCalendar = Calendar.getInstance();
            if (this.debugging) {
                System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
            }
            this.vergunningStartCalendar = Calendar.getInstance();
            this.vergunningStartCalendar.set(Integer.parseInt(activationCodeField[1]), Integer.parseInt(activationCodeField[2]) - 1, Integer.parseInt(activationCodeField[3]));
            this.vergunningStartCalendar.set(11, 0);
            this.vergunningStartCalendar.set(12, 0);
            this.vergunningStartCalendar.set(13, 0);
            this.vergunningType = activationCodeField[0];
            if (this.vergunningType.equals("Demo")) {
                this.phoneLines = 500;
                this.callsPerHour = 20000;
                this.maxCalls = 1000000000;
                this.destinationDigits = 100;
            } else if (this.vergunningType.equals("Standard")) {
                this.phoneLines = 500;
                this.callsPerHour = 20000;
                this.maxCalls = 1000000000;
                this.destinationDigits = 100;
            } else if (this.vergunningType.equals("Professional")) {
                this.phoneLines = 500;
                this.callsPerHour = 20000;
                this.maxCalls = 1000000000;
                this.destinationDigits = 100;
            } else if (this.vergunningType.equals("Enterprise")) {
                this.phoneLines = 500;
                this.callsPerHour = 20000;
                this.maxCalls = 1000000000;
                this.destinationDigits = 100;
            } else {
                this.phoneLines = 500;
                this.callsPerHour = 20000;
                this.maxCalls = 1000000000;
                this.destinationDigits = 100;
            }
            this.vergunningEndCalendar = Calendar.getInstance();
            this.vergunningEndCalendar.setTimeInMillis(this.vergunningStartCalendar.getTimeInMillis());
            this.vergunningEndCalendar.set(11, 0);
            this.vergunningEndCalendar.set(12, 0);
            this.vergunningEndCalendar.set(13, 0);
            this.vergunningPeriod = activationCodeField[4];
            if (this.vergunningPeriod.equals("Day")) {
                this.vergunningEndCalendar.add(6, 1);
            } else if (this.vergunningPeriod.equals("Week")) {
                this.vergunningEndCalendar.add(3, 1);
            } else if (this.vergunningPeriod.equals("Month")) {
                this.vergunningEndCalendar.add(2, 1);
            } else if (this.vergunningPeriod.equals("Year")) {
                this.vergunningEndCalendar.add(1, 1);
            } else {
                this.vergunningEndCalendar.add(1, 100);
            }
            this.status = this.getAK();
            if (this.status[0].equals("0")) {
                String activationCodeKeyString = null;
                activationCodeKeyString = this.status[1];
                this.activationCodeFromSystem = this.vergunningType + "-" + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2) + 1) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + "-" + this.vergunningPeriod + "-" + activationCodeKeyString;
                this.vergunningCodeFromSystem = MD5Converter.getMD5SumFromString(this.activationCodeFromSystem + VERGUNNINGTOEKENNERTOEGANG);
                if (this.debugging) {
                    System.out.println();
                    System.out.println("ACFF: " + this.activationCodeFromFile);
                    System.out.println("ACFS: " + this.activationCodeFromSystem);
                    System.out.println();
                    System.out.println("LCFF: " + this.vergunningCodeFromFile);
                    System.out.println("LCFS: " + this.vergunningCodeFromSystem);
                }
                this.vergunningValid = true;
                if (this.vergunningCodeFromSystem == null) {
                    this.vergunningValid = false;
                    this.vergunningInvalidReason = "LicenseCode Missing";
                    this.vergunningInvalidAdvise = "Please contact VoipStorm";
                } else if (this.vergunningCodeFromSystem.length() == 0) {
                    this.vergunningValid = false;
                    this.vergunningInvalidReason = "LicenseCode Missing";
                    this.vergunningInvalidAdvise = "Please contact VoipStorm";
                } else if (!this.vergunningCodeFromSystem.equals(this.vergunningCodeFromFile)) {
                    this.vergunningValid = false;
                    this.vergunningInvalidReason = "LicenseCode Invalid";
                    this.vergunningInvalidAdvise = "Please fill in correct LicenseCode";
                } else if (this.systemTimeCalendar.before(this.vergunningStartCalendar)) {
                    this.vergunningValid = false;
                    this.vergunningInvalidReason = "License in Future";
                    this.vergunningInvalidAdvise = "Please wait until LicenseStart Date";
                } else if (this.systemTimeCalendar.after(this.vergunningEndCalendar)) {
                    this.vergunningValid = false;
                    this.vergunningInvalidReason = "License Expired";
                    this.vergunningInvalidAdvise = "Please renew your LicenseCode";
                }
                if (this.vergunningValid) {
                    if (this.debugging) {
                        System.out.println();
                        System.out.println("licenseStartCalendar: " + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + " " + String.format("%02d", this.vergunningStartCalendar.get(11)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(12)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(13)));
                        System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
                        System.out.println("licenseEndCalendar:   " + String.format("%04d", this.vergunningEndCalendar.get(1)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(2)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(5)) + " " + String.format("%02d", this.vergunningEndCalendar.get(11)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(12)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(13)));
                    }
                } else if (this.debugging) {
                    System.out.println();
                    System.out.println(this.vergunningInvalidReason);
                    System.out.println();
                    System.out.println("licenseStartCalendar: " + String.format("%04d", this.vergunningStartCalendar.get(1)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(2)) + "-" + String.format("%02d", this.vergunningStartCalendar.get(5)) + " " + String.format("%02d", this.vergunningStartCalendar.get(11)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(12)) + ":" + String.format("%02d", this.vergunningStartCalendar.get(13)));
                    System.out.println("systemTimeCalendar:   " + String.format("%04d", this.systemTimeCalendar.get(1)) + "-" + String.format("%02d", this.systemTimeCalendar.get(2)) + "-" + String.format("%02d", this.systemTimeCalendar.get(5)) + " " + String.format("%02d", this.systemTimeCalendar.get(11)) + ":" + String.format("%02d", this.systemTimeCalendar.get(12)) + ":" + String.format("%02d", this.systemTimeCalendar.get(13)));
                    System.out.println("licenseEndCalendar:   " + String.format("%04d", this.vergunningEndCalendar.get(1)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(2)) + "-" + String.format("%02d", this.vergunningEndCalendar.get(5)) + " " + String.format("%02d", this.vergunningEndCalendar.get(11)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(12)) + ":" + String.format("%02d", this.vergunningEndCalendar.get(13)));
                }
            }
        } else {
            this.vergunningLoaded = true;
        }
        return this.vergunningValid;
    }

    public String[] getAK() {
        try {
            this.status[0] = "0";
            this.status[1] = "";
            this.output = "";
            this.totOutput = "";
            this.networkInterfaceList = NetworkInterface.getNetworkInterfaces();
            this.networkInterfaceList = NetworkInterface.getNetworkInterfaces();
            while (this.networkInterfaceList.hasMoreElements()) {
                this.networkInterface = (NetworkInterface)this.networkInterfaceList.nextElement();
                if (this.networkInterface.isUp() && !this.networkInterface.isLoopback() && !this.networkInterface.isVirtual()) {
                    try {
                        this.myBytes = this.networkInterface.getHardwareAddress();
                    }
                    catch (SocketException ex) {
                        System.out.println("myBytes = netif.getHardwareAddress(): " + ex.getMessage());
                    }
                }
                if (!this.networkInterface.isUp() || this.networkInterface.isLoopback() || this.networkInterface.isVirtual() || this.myBytes == null || this.myBytes.length <= 0) continue;
                byte[] ex = this.myBytes;
                int n = ex.length;
                for (int i = 0; i < n; ++i) {
                    Byte myByte = ex[i];
                    int highNibble = 0;
                    int high2lowNibble = 0;
                    int lowNibble = 0;
                    if (myByte != null && myByte >= 0) {
                        highNibble = myByte & 0xF0;
                        high2lowNibble = highNibble >>> 4;
                        lowNibble = myByte & 0xF;
                    }
                    this.output = this.output + Integer.toHexString(high2lowNibble) + Integer.toHexString(lowNibble);
                }
                this.totOutput = this.totOutput + this.output;
            }
            this.status[1] = this.status[1] + MD5Converter.getMD5SumFromString(this.totOutput);
        }
        catch (SocketException ex) {
            System.out.println("Error: UnknownHostException: Vergunning.getAK()): NetworkInterface.getByInetAddress(inetAddress): " + ex.getMessage());
        }
        return this.status;
    }

    public boolean isValid() {
        return true;
    }

    public String getVergunningInvalidReason() {
        return this.vergunningInvalidReason;
    }

    public String getVergunningInvalidAdvise() {
        return this.vergunningInvalidAdvise;
    }

    public boolean vergunningOrderInProgress() {
        return this.vergunningOrderInProgress;
    }

    public String getActivationCode() {
        return this.activationCodeFromFile;
    }

    public String getVergunningCode() {
        return this.vergunningCodeFromFile;
    }

    public String getVergunningType() {
        return this.vergunningType;
    }

    public Calendar getVergunningStartDate() {
        return this.vergunningStartCalendar;
    }

    public Calendar getVergunningEndDate() {
        return this.vergunningEndCalendar;
    }

    public String getVergunningPeriod() {
        return this.vergunningPeriod;
    }

    public int getPhoneLines() {
        return this.phoneLines;
    }

    public int getCallsPerHour() {
        return this.callsPerHour;
    }

    public int getMaxCalls() {
        return this.maxCalls;
    }

    public int getDestinationDigits() {
        return this.destinationDigits;
    }

    public int getOutboundBurstRate() {
        double outboundBurstRate = 0.0;
        if (this.callsPerHour > 0) {
            outboundBurstRate = Math.round(1.0 / ((double)this.callsPerHour / 3600.0) * 1000.0);
        }
        return (int)Math.round(outboundBurstRate);
    }

    public void setActivationCode(String activationCodeParam) {
        this.activationCodeFromFile = activationCodeParam;
    }

    public void setVergunningCode(String vergunningCodeParam) {
        this.vergunningCodeFromFile = vergunningCodeParam;
    }

    public void setVergunningValid(boolean vergunningValidParam) {
        this.vergunningValid = vergunningValidParam;
    }

    public void setVergunningOrderInProgress(boolean vergunningOrderInProgressParam) {
        this.vergunningOrderInProgress = vergunningOrderInProgressParam;
    }

    public void setVergunningType(String vergunningTypeParam) {
        this.vergunningType = vergunningTypeParam;
    }

    public void setVergunningStartDate(Calendar vergunningStartCalendarParam) {
        this.vergunningStartCalendar = vergunningStartCalendarParam;
    }

    public void setVergunningEndDate(Calendar vergunningEndCalendarParam) {
        this.vergunningEndCalendar = vergunningEndCalendarParam;
    }

    public void setVergunningPeriod(String vergunningPeriodParam) {
        this.vergunningPeriod = vergunningPeriodParam;
    }

    public void setPhoneLines(int phoneLinesParam) {
        this.phoneLines = phoneLinesParam;
    }

    public void setCallsPerHour(int callsPerHourParam) {
        this.callsPerHour = callsPerHourParam;
    }

    public void setMaxCalls(int maxCallsParam) {
        this.maxCalls = maxCallsParam;
    }

    public void setDestinationDigits(int destinationDigitsParam) {
        this.destinationDigits = destinationDigitsParam;
    }

    public String toString() {
        String output = null;
        output = "activationCode: " + this.getActivationCode() + "\n";
        output = output + "licenseCode: " + this.getVergunningCode() + "\n";
        return output;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

