/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;

public class VersionChecker {
    private String UPDATEURL = "http://www.voipstorm.nl/VoipStorm.jar";
    private String newJarFileString;
    private String curJarFileString;
    private String oldJarFileString;
    private boolean versionCheckerFailed = false;
    private boolean detectedANewVersion = false;
    private VersionUpdateDialog updateDialog;
    private boolean newVersionInstalled = false;
    private Manager eCallCenterManager;
    private boolean runThreadsAsDaemons = true;
    private Shell shell;
    private String responseCodeDescription;
    private int httpConTimeout = 1000;
    private String dataDir;
    private String binDir;
    private String fileSeparator;
    private String platform = System.getProperty("os.name").toLowerCase();

    public VersionChecker(Manager eCallCenterManagerParam) throws MalformedURLException, IOException {
        this.fileSeparator = this.platform.indexOf("windows") != -1 ? "\\" : "/";
        this.dataDir = "data" + this.fileSeparator;
        this.binDir = this.dataDir + "bin" + this.fileSeparator;
        this.newJarFileString = new String(this.binDir + "VoipStorm-New.jar");
        this.curJarFileString = new String("VoipStorm.jar");
        this.oldJarFileString = new String(this.binDir + "VoipStorm-Old.jar");
        this.eCallCenterManager = eCallCenterManagerParam;
        int rescode = this.downloadRemoteJarFile();
        if (rescode == 200) {
            this.compareFiles();
        } else {
            this.eCallCenterManager.showStatus("Software Update Check Failed!" + this.responseCodeDescription, true, true);
            this.eCallCenterManager.managerVersionLabel.setForeground(Color.yellow);
            this.eCallCenterManager.callcenterVersionLabel.setForeground(Color.yellow);
            this.eCallCenterManager.ephoneVersionLabel.setForeground(Color.yellow);
        }
    }

    public final int downloadRemoteJarFile() throws MalformedURLException, IOException {
        int byteNumber;
        this.eCallCenterManager.showStatus("Download and Check Update...", true, true);
        URL remoteURL = new URL(this.UPDATEURL);
        HttpURLConnection urlConnection = (HttpURLConnection)remoteURL.openConnection();
        urlConnection.setConnectTimeout(this.httpConTimeout);
        int responseCode = urlConnection.getResponseCode();
        this.responseCodeDescription = urlConnection.getResponseMessage();
        InputStream inputStream = urlConnection.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream fileOutputStream = new FileOutputStream(this.newJarFileString);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        while ((byteNumber = bufferedInputStream.read()) != -1) {
            bufferedOutputStream.write(byteNumber);
        }
        bufferedOutputStream.flush();
        return responseCode;
    }

    public void compareFiles() throws FileNotFoundException, MalformedURLException, IOException {
        String localMD5String;
        String remoteMD5String;
        int offset;
        File newFile = new File(this.newJarFileString);
        File curFile = new File(this.curJarFileString);
        long newFileLength = newFile.length();
        long curFileLength = curFile.length();
        FileInputStream newInputStream = new FileInputStream(this.newJarFileString);
        FileInputStream curInputStream = new FileInputStream(this.curJarFileString);
        byte[] newByteArray = new byte[(int)newFileLength];
        byte[] curByteArray = new byte[(int)curFileLength];
        int numRead = 0;
        try {
            for (offset = 0; offset < newByteArray.length && (numRead = ((InputStream)newInputStream).read(newByteArray, offset, newByteArray.length - offset)) >= 0; offset += numRead) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        numRead = 0;
        try {
            for (offset = 0; offset < curByteArray.length && (numRead = ((InputStream)curInputStream).read(curByteArray, offset, curByteArray.length - offset)) >= 0; offset += numRead) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ((remoteMD5String = MD5Converter.getMD5SumFromByteArray(newByteArray)).equals(localMD5String = MD5Converter.getMD5SumFromByteArray(curByteArray))) {
            this.detectedANewVersion = false;
            this.eCallCenterManager.showStatus("Software is up to Date!", true, true);
            this.eCallCenterManager.managerVersionLabel.setForeground(Color.green);
            this.eCallCenterManager.callcenterVersionLabel.setForeground(Color.green);
            this.eCallCenterManager.ephoneVersionLabel.setForeground(Color.green);
        } else {
            this.detectedANewVersion = true;
            this.eCallCenterManager.showStatus("New Software Update Found", true, true);
            this.eCallCenterManager.managerVersionLabel.setForeground(Color.red);
            this.eCallCenterManager.callcenterVersionLabel.setForeground(Color.red);
            this.eCallCenterManager.ephoneVersionLabel.setForeground(Color.red);
            this.updateDialog = new VersionUpdateDialog((Frame)new JFrame(), true);
            this.updateDialog.setVisible(true);
            int retcode = this.updateDialog.getReturnStatus();
            if (retcode == 1) {
                this.installNewVersion();
                this.eCallCenterManager.requestStop();
            } else if (retcode == 0) {
                this.eCallCenterManager.showStatus("Software Update User Canceled!", true, true);
            }
        }
    }

    public void installNewVersion() {
        this.shell = new Shell();
        Thread restartThread = new Thread(new Runnable(){

            @Override
            public void run() {
                VersionChecker.this.shell.startVoipStormUpdater();
            }
        });
        restartThread.setName("restartThread");
        restartThread.setDaemon(this.runThreadsAsDaemons);
        restartThread.start();
    }

    public boolean hasDetectedANewVersion() {
        return this.detectedANewVersion;
    }

    public boolean hasInstalledNewVersion() {
        return this.newVersionInstalled;
    }
}

