/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration
implements Cloneable {
    private static final String dataDir = "data/";
    private static final String databasesDir = "data/databases/";
    private final String xmlConfigDir = "data/config/";
    private String xmlFileName;
    private String xmlFileBase;
    private String xmlFileExtention;
    private String domain;
    private String clientIP;
    private String publicIP;
    private String clientPort;
    private String serverIP;
    private String serverPort;
    private String prefPhoneLines;
    private String username;
    private String toegang;
    private String register;
    private String icons;
    private InetAddress myIP;
    private String[] status;
    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    DocumentBuilder builder = null;
    Document xmlDocument = null;

    public Configuration() {
        try {
            this.myIP = Configuration.getLocalHostLANAddress();
        }
        catch (UnknownHostException error) {
            System.out.println("Error: InetAddress.getLocalHost(): " + error.getMessage());
        }
        this.xmlFileName = "";
        this.xmlFileBase = "network";
        this.xmlFileExtention = ".xml";
        this.domain = "voipstorm.nl";
        this.clientIP = this.myIP.getHostAddress();
        this.publicIP = "";
        this.clientPort = "auto";
        this.serverIP = "";
        this.serverPort = "5060";
        this.prefPhoneLines = "500";
        this.username = "";
        this.toegang = "";
        this.register = "0";
        this.icons = "1";
        this.status = new String[2];
    }

    public Configuration(String domainParam, String clientIPParam, String pubIPParam, String clientPortParam, String serverIPParam, String serverPortParam, String prefPhoneLinesParam, String usernameParam, String passwordParam, String registerParam, String iconsParam) {
        try {
            this.myIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException error) {
            System.out.println("Error: InetAddress.getLocalHost(): " + error.getMessage());
        }
        this.domain = domainParam;
        this.clientIP = clientIPParam;
        this.publicIP = pubIPParam;
        this.clientPort = domainParam;
        this.serverIP = serverIPParam;
        this.serverPort = serverPortParam;
        this.prefPhoneLines = prefPhoneLinesParam;
        this.username = usernameParam;
        this.toegang = passwordParam;
        this.register = registerParam;
        this.register = iconsParam;
    }

    public String[] createConfiguration() {
        this.status[0] = "0";
        this.status[1] = "";
        try {
            this.myIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException error) {
            this.status[0] = "1";
            this.status[1] = "createConfiguration Error: myIP = InetAddress.getLocalHost(): UnknownHostException: " + error.getMessage();
            return this.status;
        }
        this.setDomain("");
        this.setClientIP(this.myIP.getHostAddress());
        this.setPublicIP("");
        this.setClientPort("auto");
        this.setServerIP(this.myIP.getHostAddress());
        this.setServerPort("5060");
        this.setPrefPhoneLines("500");
        this.setUsername("");
        this.setToegang("");
        this.setRegister("0");
        this.setIcons("1");
        return this.status;
    }

    private static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public String[] loadConfiguration(String configNumberParam) {
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = configNumberParam != null && !configNumberParam.equals("") ? "data/config/" + this.xmlFileBase + configNumberParam + this.xmlFileExtention : "data/config/" + this.xmlFileBase + "1" + this.xmlFileExtention;
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = null;
        this.xmlDocument = null;
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadConfiguration Error: builder = builderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        try {
            this.xmlDocument = this.builder.parse(this.xmlFileName);
        }
        catch (SAXException error) {
            this.status[0] = "1";
            this.status[1] = "loadConfiguration Error: xmlDocument = builder.parse(xmlFile): SAXException: " + error.getMessage();
            return this.status;
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "loadConfiguration Error: xmlDocument = builder.parse(xmlFile): IOException: " + error.getMessage();
            return this.status;
        }
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "loadConfiguration Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "loadConfiguration Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        Node node = this.xmlDocument.getFirstChild();
        NodeList nodelist = node.getChildNodes();
        int nodelistcount = nodelist.getLength();
        for (int i = 1; i < nodelistcount; i += 2) {
            String nodeName = nodelist.item(i).getNodeName();
            String nodeValue = nodelist.item(i).getTextContent();
            if (nodeName.equals("domain")) {
                this.setDomain(nodeValue);
                continue;
            }
            if (nodeName.equals("clientIP")) {
                this.setClientIP(this.myIP.getHostAddress());
                continue;
            }
            if (nodeName.equals("pubIP")) {
                this.setPublicIP(nodeValue);
                continue;
            }
            if (nodeName.equals("clientPort")) {
                this.setClientPort(nodeValue);
                continue;
            }
            if (nodeName.equals("serverIP")) {
                this.setServerIP(nodeValue);
                continue;
            }
            if (nodeName.equals("serverPort")) {
                this.setServerPort(nodeValue);
                continue;
            }
            if (nodeName.equals("prefPhoneLines")) {
                this.setPrefPhoneLines(nodeValue);
                continue;
            }
            if (nodeName.equals("username")) {
                this.setUsername(nodeValue);
                continue;
            }
            if (nodeName.equals("password")) {
                this.setToegang(nodeValue);
                continue;
            }
            if (nodeName.equals("register")) {
                this.setRegister(nodeValue);
                continue;
            }
            if (!nodeName.equals("icons")) continue;
            this.setIcons(nodeValue);
        }
        return this.status;
    }

    public String[] saveConfiguration(String configNumberParam) {
        this.status[0] = "0";
        this.status[1] = "";
        this.xmlFileName = configNumberParam != null && !configNumberParam.equals("") ? "data/config/" + this.xmlFileBase + configNumberParam + this.xmlFileExtention : "data/config/" + this.xmlFileBase + "1" + this.xmlFileExtention;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: docBuilder = documentBuilderFactory.newDocumentBuilder(): ParserConfigurationException: " + error.getMessage();
            return this.status;
        }
        this.xmlDocument = docBuilder.newDocument();
        Element root = this.xmlDocument.createElement("softphoneconfiguration");
        this.xmlDocument.appendChild(root);
        Comment comment = this.xmlDocument.createComment("SoftPhone Configuration");
        root.appendChild(comment);
        Element child = this.xmlDocument.createElement("domain");
        Text text = this.xmlDocument.createTextNode(this.getDomain());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("clientIP");
        text = this.xmlDocument.createTextNode(this.getClientIP());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("pubIP");
        text = this.xmlDocument.createTextNode(this.getPublicIP());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("clientPort");
        text = this.xmlDocument.createTextNode(this.getClientPort());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("serverIP");
        text = this.xmlDocument.createTextNode(this.getServerIP());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("serverPort");
        text = this.xmlDocument.createTextNode(this.getServerPort());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("prefPhoneLines");
        text = this.xmlDocument.createTextNode(this.getPrefPhoneLines());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("username");
        text = this.xmlDocument.createTextNode(this.getUsername());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("password");
        text = this.xmlDocument.createTextNode(this.getToegang());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("register");
        text = this.xmlDocument.createTextNode(this.getRegister());
        child.appendChild(text);
        root.appendChild(child);
        child = this.xmlDocument.createElement("icons");
        text = this.xmlDocument.createTextNode(this.getIcons());
        child.appendChild(text);
        root.appendChild(child);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: trans = transfac.newTransformer(): TransformerConfigurationException: " + error.getMessage();
            return this.status;
        }
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        DOMSource source = new DOMSource(this.xmlDocument);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: trans.transform(source, result): TransformerException: " + error.getMessage();
            return this.status;
        }
        String xmlString = stringWriter.toString();
        FileWriter fileWriter = null;
        File fileToWrite = new File(this.xmlFileName);
        try {
            fileWriter = new FileWriter(fileToWrite);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: fileWriter = new FileWriter(fileToWrite): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.write(xmlString);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: fileWriter.write(xmlString): IOException: " + error.getMessage();
            return this.status;
        }
        try {
            fileWriter.flush();
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "saveConfiguration Error: fileWriter.flush(): IOException: " + error.getMessage();
            return this.status;
        }
        return this.status;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public String getClientPort() {
        return this.clientPort;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getPrefPhoneLines() {
        return this.prefPhoneLines;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToegang() {
        return this.toegang;
    }

    public String getRegister() {
        return this.register;
    }

    public String getIcons() {
        return this.icons;
    }

    public static String getDataDir() {
        return dataDir;
    }

    public static String getDatabasesDir() {
        return databasesDir;
    }

    public void setDomain(String domainParam) {
        this.domain = domainParam;
    }

    public void setClientIP(String clientIPParam) {
        this.clientIP = clientIPParam;
    }

    public void setPublicIP(String pubIPParam) {
        this.publicIP = pubIPParam;
    }

    public void setClientPort(String clientPortParam) {
        this.clientPort = clientPortParam;
    }

    public void setServerIP(String serverIPParam) {
        this.serverIP = serverIPParam;
    }

    public void setServerPort(String serverPortParam) {
        this.serverPort = serverPortParam;
    }

    public void setPrefPhoneLines(String prefPhoneLinesParam) {
        this.prefPhoneLines = prefPhoneLinesParam;
    }

    public void setUsername(String usernameParam) {
        this.username = usernameParam;
    }

    public void setToegang(String passwordParam) {
        this.toegang = passwordParam;
    }

    public void setRegister(String registerParam) {
        this.register = registerParam;
    }

    public void setIcons(String iconsParam) {
        this.icons = iconsParam;
    }

    public String toString() {
        String output = null;
        output = "domain: " + this.getDomain() + "\n";
        output = output + "clientIP: " + this.getClientIP() + "\n";
        output = output + "pubIP: " + this.getPublicIP() + "\n";
        output = output + "clientPort: " + this.getClientPort() + "\n";
        output = output + "serverIP: " + this.getServerIP() + "\n";
        output = output + "serverPort: " + this.getServerPort() + "\n";
        output = output + "prefPhoneLines: " + this.getPrefPhoneLines() + "\n";
        output = output + "username: " + this.getUsername() + "\n";
        output = output + "password: " + this.getToegang() + "\n";
        output = output + "register: " + this.getRegister() + "\n";
        output = output + "icons: " + this.getIcons() + "\n";
        return output;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

