/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import datasets.Order;
import datasets.TimeWindow;
import java.util.Calendar;

public class TimeTool {
    private TimeWindow[] timewindowArray = new TimeWindow[3];

    public TimeTool() {
        this.timewindowArray[0] = new TimeWindow("Morning", 0, 0, 8, 59);
        this.timewindowArray[1] = new TimeWindow("Daytime", 9, 0, 17, 59);
        this.timewindowArray[2] = new TimeWindow("Evening", 18, 0, 23, 59);
    }

    public Calendar getEstimatedEndCalendar(Calendar headStartCalParam, Order orderParam, int throughputFactorParam, int targetOffset, int[] timewindowIndices) {
        long headDuration = 0L;
        long bodyDuration = 0L;
        long campaignDuration = 0L;
        long headAndBodyGrosDuration = 0L;
        long bodyGrosDuration = 0L;
        Calendar bodyEndGrosCal = Calendar.getInstance();
        Calendar headStartCal = (Calendar)headStartCalParam.clone();
        campaignDuration = Math.round(orderParam.getMessageDuration() * (orderParam.getTargetTransactionQuantity() - targetOffset) / throughputFactorParam);
        Calendar bodyEndCal = Calendar.getInstance();
        bodyEndCal.setTimeInMillis(headStartCal.getTimeInMillis() + campaignDuration * 1000L);
        Calendar headEndCal = (Calendar)headStartCal.clone();
        headEndCal.set(11, 0);
        headEndCal.set(12, 0);
        headEndCal.set(13, 0);
        headEndCal.setTimeInMillis(headEndCal.getTimeInMillis() + (long)(this.timewindowArray[timewindowIndices.length - 1].getEndSeconds() * 1000));
        if (bodyEndCal.after(headEndCal)) {
            headDuration = headEndCal.getTimeInMillis() / 1000L - headStartCalParam.getTimeInMillis() / 1000L;
            bodyDuration = bodyEndCal.getTimeInMillis() / 1000L - headEndCal.getTimeInMillis() / 1000L;
            int selectedTimewindowsSeconds = 0;
            for (int timewindowIndice : timewindowIndices) {
                selectedTimewindowsSeconds += this.timewindowArray[timewindowIndice].getSeconds();
            }
            bodyGrosDuration = bodyDuration + (long)(86400 - selectedTimewindowsSeconds) + bodyDuration / (long)selectedTimewindowsSeconds * (long)(86400 - selectedTimewindowsSeconds);
            bodyEndGrosCal.setTimeInMillis(headEndCal.getTimeInMillis() + bodyGrosDuration * 1000L);
        } else {
            bodyEndGrosCal = (Calendar)bodyEndCal.clone();
        }
        return bodyEndGrosCal;
    }

    public String displayCalendar(Calendar calendarParam) {
        String calendarString = String.format("%04d", calendarParam.get(1)) + "-" + String.format("%02d", calendarParam.get(3)) + "-" + String.format("%02d", calendarParam.get(5)) + " " + String.format("%02d", calendarParam.get(11)) + ":" + String.format("%02d", calendarParam.get(12)) + ":" + String.format("%02d", calendarParam.get(13));
        return calendarString;
    }

    public int getCurrentTimeWindowIndex() {
        int timeWindow = 0;
        Calendar currentTimeCalendar = Calendar.getInstance();
        int currentTimeHour = currentTimeCalendar.get(11);
        for (int counter = 0; counter <= this.timewindowArray.length - 1; ++counter) {
            if (currentTimeHour < this.timewindowArray[counter].getStartHour() || currentTimeHour > this.timewindowArray[counter].getEndHour()) continue;
            timeWindow = counter;
        }
        return timeWindow;
    }

    public TimeWindow getCurrentTimeWindow() {
        return this.timewindowArray[this.getCurrentTimeWindowIndex()];
    }

    public TimeWindow getTimeWindow(int timewindowIndexParam) {
        return this.timewindowArray[timewindowIndexParam];
    }
}

