/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.saas;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.saas.RestResponse;

public class RestConnection {
    private HttpURLConnection conn;
    private String date;

    public RestConnection(String baseUrl) {
        this(baseUrl, null, null);
    }

    public RestConnection(String baseUrl, String[][] params) {
        this(baseUrl, null, params);
    }

    public RestConnection(String baseUrl, String[][] pathParams, String[][] params) {
        try {
            String urlStr = baseUrl;
            if (pathParams != null && pathParams.length > 0) {
                urlStr = this.replaceTemplateParameters(baseUrl, pathParams);
            }
            URL url = new URL(this.encodeUrl(urlStr, params));
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setDoInput(true);
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
            this.conn.setDefaultUseCaches(false);
            this.conn.setAllowUserInteraction(true);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            this.date = format.format(new Date());
            this.conn.setRequestProperty("Date", this.date);
        }
        catch (Exception ex) {
            Logger.getLogger(RestConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setAuthenticator(Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
    }

    public String getDate() {
        return this.date;
    }

    public RestResponse get() throws IOException {
        return this.get(null);
    }

    public RestResponse get(String[][] headers) throws IOException {
        this.conn.setRequestMethod("GET");
        return this.connect(headers, null);
    }

    public RestResponse head() throws IOException {
        return this.get(null);
    }

    public RestResponse head(String[][] headers) throws IOException {
        this.conn.setRequestMethod("HEAD");
        return this.connect(headers, null);
    }

    public RestResponse put(String[][] headers) throws IOException {
        return this.put(headers, (InputStream)null);
    }

    public RestResponse put(String[][] headers, String data) throws IOException {
        ByteArrayInputStream is = null;
        if (data != null) {
            is = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        return this.put(headers, is);
    }

    public RestResponse put(String[][] headers, InputStream is) throws IOException {
        this.conn.setRequestMethod("PUT");
        return this.connect(headers, is);
    }

    public RestResponse post(String[][] headers) throws IOException {
        return this.post(headers, (InputStream)null);
    }

    public RestResponse post(String[][] headers, String data) throws IOException {
        ByteArrayInputStream is = null;
        if (data != null) {
            is = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        return this.post(headers, is);
    }

    public RestResponse post(String[][] headers, InputStream is) throws IOException {
        this.conn.setRequestMethod("POST");
        return this.connect(headers, is);
    }

    public RestResponse post(String[][] headers, String[][] params) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("ContentType", "application/x-www-form-urlencoded");
        String data = this.encodeParams(params);
        return this.connect(headers, new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    public RestResponse delete(String[][] headers) throws IOException {
        this.conn.setRequestMethod("DELETE");
        return this.connect(headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResponse connect(String[][] headers, InputStream data) throws IOException {
        try {
            this.setHeaders(headers);
            String method = this.conn.getRequestMethod();
            byte[] buffer = new byte[1024];
            int count = 0;
            if ((method.equals("PUT") || method.equals("POST")) && data != null) {
                this.conn.setDoOutput(true);
                OutputStream os = this.conn.getOutputStream();
                while ((count = data.read(buffer)) != -1) {
                    os.write(buffer, 0, count);
                }
                os.flush();
            }
            RestResponse response = new RestResponse();
            InputStream is = this.conn.getInputStream();
            while ((count = is.read(buffer)) != -1) {
                response.write(buffer, 0, count);
            }
            response.setResponseCode(this.conn.getResponseCode());
            response.setResponseMessage(this.conn.getResponseMessage());
            response.setContentType(this.conn.getContentType());
            response.setContentEncoding(this.conn.getContentEncoding());
            response.setLastModified(this.conn.getLastModified());
            return response;
        }
        catch (Exception e) {
            String errMsg = "Cannot connect to :" + this.conn.getURL();
            try {
                String line;
                BufferedReader rd = new BufferedReader(new InputStreamReader(this.conn.getErrorStream()));
                StringBuffer buf = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    buf.append(line);
                    buf.append('\n');
                }
                errMsg = buf.toString();
                return errMsg;
            }
            finally {
                throw new IOException(errMsg);
            }
        }
    }

    private String replaceTemplateParameters(String baseUrl, String[][] pathParams) {
        String url = baseUrl;
        if (pathParams != null) {
            for (int i = 0; i < pathParams.length; ++i) {
                String key = pathParams[i][0];
                String value = pathParams[i][1];
                if (value == null) {
                    value = "";
                }
                url = url.replace(key, value);
            }
        }
        return url;
    }

    private String encodeUrl(String baseUrl, String[][] params) {
        String encodedParams = this.encodeParams(params);
        if (encodedParams.length() > 0) {
            encodedParams = "?" + encodedParams;
        }
        return baseUrl + encodedParams;
    }

    private String encodeParams(String[][] params) {
        String p = "";
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String key = params[i][0];
                String value = params[i][1];
                if (value == null) continue;
                try {
                    p = p + key + "=" + URLEncoder.encode(value, "UTF-8") + "&";
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(RestConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (p.length() > 0) {
                p = p.substring(0, p.length() - 1);
            }
        }
        return p;
    }

    private void setHeaders(String[][] headers) {
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                this.conn.setRequestProperty(headers[i][0], headers[i][1]);
            }
        }
    }

    static {
        System.setProperty("http.agent", System.getProperty("user.name") + " (from NetBeans IDE)");
    }
}

