/*
 * Decompiled with CFR 0.152.
 */
package video;

import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.CannotRealizeException;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.Player;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import video.VideoFrame;

public class VideoStreamer
implements ReceiveStreamListener {
    private RTPSessionMgr myVideoSessionManager = null;
    private Processor myProcessor = null;
    private SendStream sendStream = null;
    private ReceiveStream receiveStream = null;
    private Player player = null;
    private VideoFormat videoFormat = null;
    private DataSource iDS = null;
    private DataSource oDS = null;
    private DataSource rDS = null;
    private DataSource tDS = null;
    private VideoFrame videoFrame = null;
    private InetAddress sourceIP = null;
    private InetAddress destIP = null;
    private Integer sourcePort = null;
    private Integer destPort = null;
    private SessionAddress localAddress = null;
    private SessionAddress remoteAddress = null;
    private SessionAddress destAddress = null;
    private String fileName = null;
    String[] status = new String[2];

    public String[] startListener(String sourceIPField, String sourcePortField, String destIPField, String destPortField) {
        this.status[0] = "0";
        this.status[1] = "";
        try {
            this.sourceIP = InetAddress.getByName(sourceIPField);
        }
        catch (UnknownHostException error) {
            this.status[0] = "1";
            this.status[1] = "Error: sourceIP = InetAddress.getByName(sourceIPField): UnknownHostException: " + error.getMessage();
            return this.status;
        }
        this.myVideoSessionManager = new RTPSessionMgr();
        this.myVideoSessionManager.addReceiveStreamListener((ReceiveStreamListener)this);
        SessionAddress senderAddr = new SessionAddress();
        try {
            this.myVideoSessionManager.initSession(senderAddr, null, 0.05, 0.25);
        }
        catch (InvalidSessionAddressException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myVideoSessionManager.initSession(senderAddr, null, 0.05, 0.25): InvalidSessionAddressException: " + error.getMessage();
            return this.status;
        }
        try {
            this.destIP = InetAddress.getByName(destIPField);
        }
        catch (UnknownHostException error) {
            this.status[0] = "1";
            this.status[1] = "Error: destIP = InetAddress.getByName(destIPField): UnknownHostException: " + error.getMessage();
            return this.status;
        }
        this.sourcePort = Integer.parseInt(sourcePortField);
        this.destPort = Integer.parseInt(destPortField);
        this.localAddress = new SessionAddress(this.sourceIP, this.sourcePort.intValue(), this.sourceIP, this.sourcePort + 1);
        this.remoteAddress = new SessionAddress(this.destIP, this.destPort.intValue(), this.destIP, this.destPort + 1);
        try {
            this.myVideoSessionManager.startSession(this.localAddress, this.localAddress, this.remoteAddress, null);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myVideoSessionManager.startSession(localAddress, localAddress, remoteAddress, null): IOException: " + error.getMessage();
            return this.status;
        }
        catch (InvalidSessionAddressException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myVideoSessionManager.startSession(localAddress, localAddress, remoteAddress, null): InvalidSessionAddressException: " + error.getMessage();
            return this.status;
        }
        return this.status;
    }

    public String[] stopListener() {
        this.status[0] = "0";
        this.status[1] = "";
        this.myVideoSessionManager.closeSession();
        this.myVideoSessionManager.removeReceiveStreamListener((ReceiveStreamListener)this);
        this.myVideoSessionManager.dispose();
        return this.status;
    }

    public String[] startStreamer(String destIPField, String destPortField, String fileName, int fmt) {
        this.status[0] = "0";
        this.status[1] = "";
        InetAddress myDestIP = null;
        try {
            myDestIP = InetAddress.getByName(destIPField);
        }
        catch (UnknownHostException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myDestIP = InetAddress.getByName(destIPField): UnknownHostException: " + error.getMessage();
            return this.status;
        }
        Integer myDestPort = Integer.parseInt(destPortField);
        MediaLocator mediaLocator = new MediaLocator(fileName);
        try {
            this.iDS = Manager.createDataSource((MediaLocator)mediaLocator);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: iDS = Manager.createDataSource(mediaLocator): IOException: " + error.getMessage();
            return this.status;
        }
        catch (NoDataSourceException error) {
            this.status[0] = "1";
            this.status[1] = "Error: iDS = Manager.createDataSource(mediaLocator): NoDataSourceException: " + error.getMessage();
            return this.status;
        }
        try {
            this.myProcessor = Manager.createProcessor((DataSource)this.iDS);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myProcessor = Manager.createProcessor(iDS): IOException: " + error.getMessage();
            return this.status;
        }
        catch (NoProcessorException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myProcessor = Manager.createProcessor(iDS): NoProcessorException: " + error.getMessage();
            return this.status;
        }
        this.myProcessor.configure();
        while (this.myProcessor.getState() != 180) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException error) {
                this.status[0] = "1";
                this.status[1] = "Error: Thread.sleep(20): InterruptedException: " + error.getMessage();
                return this.status;
            }
        }
        this.myProcessor.setContentDescriptor(new ContentDescriptor("UnknownContent"));
        TrackControl[] track = this.myProcessor.getTrackControls();
        switch (fmt) {
            case 0: {
                this.videoFormat = new VideoFormat("jpeg/rtp");
                break;
            }
            case 1: {
                this.videoFormat = new VideoFormat("h263");
                break;
            }
            case 2: {
                this.videoFormat = new VideoFormat("h263/rtp");
                break;
            }
            case 3: {
                this.videoFormat = new VideoFormat("h263-1998/rtp");
                break;
            }
            case 4: {
                this.videoFormat = new VideoFormat("mpeg/rtp");
            }
        }
        boolean formatMatch = false;
        Format[] mySupportedFormats = track[0].getSupportedFormats();
        for (int counter = 0; counter < mySupportedFormats.length; ++counter) {
            this.status[0] = "1";
            this.status[1] = "Fmt: " + mySupportedFormats[counter].toString();
            if (!this.videoFormat.matches(mySupportedFormats[counter])) continue;
            formatMatch = true;
        }
        if (!formatMatch) {
            this.status[0] = "1";
            this.status[1] = "Error: videoFormat not supported: " + Integer.toString(fmt);
            return this.status;
        }
        track[0].setFormat((Format)this.videoFormat);
        this.myProcessor.realize();
        while (this.myProcessor.getState() != 300) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException error) {
                this.status[0] = "1";
                this.status[1] = "Error: Thread.sleep(20): InterruptedException: " + error.getMessage();
                return this.status;
            }
        }
        this.tDS = this.myProcessor.getDataOutput();
        this.destAddress = new SessionAddress(myDestIP, myDestPort.intValue(), myDestIP, myDestPort + 1);
        try {
            this.myVideoSessionManager.startSession(this.localAddress, this.localAddress, this.destAddress, null);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myVideoSessionManager.startSession(localAddress, localAddress, destAddress, null): IOException: " + error.getMessage();
            return this.status;
        }
        catch (InvalidSessionAddressException error) {
            this.status[0] = "1";
            this.status[1] = "Error: myVideoSessionManager.startSession(localAddress, localAddress, destAddress, null): InvalidSessionAddressException: " + error.getMessage();
            return this.status;
        }
        try {
            this.sendStream = this.myVideoSessionManager.createSendStream(this.tDS, 0);
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: sendStream = myVideoSessionManager.createSendStream(tDS, 0): IOException: " + error.getMessage();
            return this.status;
        }
        catch (UnsupportedFormatException error) {
            this.status[0] = "1";
            this.status[1] = "Error: sendStream = myVideoSessionManager.createSendStream(tDS, 0): UnsupportedFormatException: " + error.getMessage();
            return this.status;
        }
        try {
            this.sendStream.start();
            this.myProcessor.start();
        }
        catch (IOException error) {
            this.status[0] = "1";
            this.status[1] = "Error: sendStream.start(); myProcessor.start();: IOException: " + error.getMessage();
            return this.status;
        }
        return this.status;
    }

    public String[] getMultiMediaStatus() {
        this.status[1] = "MultiMediaStatus:\n\n";
        if (this.myProcessor != null) {
            switch (this.myProcessor.getState()) {
                case 100: {
                    this.status[1] = this.status[1] + "Processor Unrealized: 100\n";
                    break;
                }
                case 200: {
                    this.status[1] = this.status[1] + "Processor Realizing: 200\n";
                    break;
                }
                case 300: {
                    this.status[1] = this.status[1] + "Processor Realized: 300\n";
                    break;
                }
                case 140: {
                    this.status[1] = this.status[1] + "Processor Configuring: 140\n";
                    break;
                }
                case 180: {
                    this.status[1] = this.status[1] + "Processor Configured: 180\n";
                    break;
                }
                case 400: {
                    this.status[1] = this.status[1] + "Processor Prefetching: 400\n";
                    break;
                }
                case 500: {
                    this.status[1] = this.status[1] + "Processor Prefetched: 500\n";
                    break;
                }
                case 600: {
                    this.status[1] = this.status[1] + "Processor Started: 600\n";
                    break;
                }
                default: {
                    this.status[1] = this.status[1] + "Processor Unknown state: " + this.myProcessor.getState() + "\n";
                    break;
                }
            }
        } else {
            this.status[1] = this.status[1] + "myProcessor not instantiated\n";
        }
        if (this.player != null) {
            switch (this.player.getState()) {
                case 100: {
                    this.status[1] = this.status[1] + "Player Unrealized: 100\n";
                    break;
                }
                case 200: {
                    this.status[1] = this.status[1] + "Player Realizing: 200\n";
                    break;
                }
                case 300: {
                    this.status[1] = this.status[1] + "Player Realized: 300\n";
                    break;
                }
                case 400: {
                    this.status[1] = this.status[1] + "Player Prefetching: 400\n";
                    break;
                }
                case 500: {
                    this.status[1] = this.status[1] + "Player Prefetched: 500\n";
                    break;
                }
                case 600: {
                    this.status[1] = this.status[1] + "Player Started: 600\n";
                    break;
                }
                default: {
                    this.status[1] = this.status[1] + "Player Unknown state: " + this.player.getState() + "\n";
                    break;
                }
            }
        } else {
            this.status[1] = this.status[1] + "player not instantiated\n";
        }
        return this.status;
    }

    public String[] stopMedia() {
        this.status[0] = "0";
        this.status[1] = "";
        if (this.myProcessor != null) {
            switch (this.myProcessor.getState()) {
                case 100: {
                    this.status[1] = "Processor Unrealized...";
                    break;
                }
                case 200: {
                    this.status[1] = "Processor Realizing...";
                    break;
                }
                case 300: {
                    this.status[1] = "Processor Realized...";
                    break;
                }
                case 140: {
                    this.status[1] = "Processor Configuring...";
                    break;
                }
                case 180: {
                    this.status[1] = "Processor Configured...";
                    break;
                }
                case 400: {
                    this.status[1] = "Processor Prefetching...";
                    break;
                }
                case 500: {
                    this.status[1] = "Processor Prefetched...";
                    this.myProcessor.close();
                    break;
                }
                case 600: {
                    this.status[1] = "Processor Started...";
                    this.myProcessor.stop();
                    this.myProcessor.close();
                    try {
                        this.sendStream.stop();
                        this.sendStream.close();
                        break;
                    }
                    catch (IOException error) {
                        this.status[0] = "1";
                        this.status[1] = "Error: : : " + error.getMessage();
                        return this.status;
                    }
                }
                default: {
                    this.status[1] = "Processor Unknown state: " + this.myProcessor.getState();
                }
            }
        }
        if (this.player != null) {
            switch (this.player.getState()) {
                case 100: {
                    this.status[1] = "Player Unrealized...";
                    break;
                }
                case 200: {
                    this.status[1] = "Player Realizing...";
                    break;
                }
                case 300: {
                    this.status[1] = "Player Realized...";
                    break;
                }
                case 400: {
                    this.status[1] = "Player Prefetching...";
                    break;
                }
                case 500: {
                    this.status[1] = "Player Prefetched...";
                    this.player.close();
                    break;
                }
                case 600: {
                    this.status[1] = "Player Started...";
                    this.player.stop();
                    this.player.close();
                    break;
                }
                default: {
                    this.status[1] = "Player Unknown state: " + this.player.getState();
                }
            }
        }
        if (this.videoFrame != null) {
            this.videoFrame.dispose();
        }
        this.stopListener();
        return this.status;
    }

    public void update(ReceiveStreamEvent event) {
        this.status[0] = "0";
        this.status[1] = "";
        if (event instanceof NewReceiveStreamEvent) {
            this.receiveStream = event.getReceiveStream();
            this.rDS = this.receiveStream.getDataSource();
            try {
                this.player = Manager.createRealizedPlayer((DataSource)this.rDS);
            }
            catch (IOException iOException) {
            }
            catch (NoPlayerException noPlayerException) {
            }
            catch (CannotRealizeException cannotRealizeException) {
                // empty catch block
            }
            Component component = this.player.getVisualComponent();
            Dimension dimension = component.getSize();
            this.videoFrame = new VideoFrame();
            this.videoFrame.jPanel1.add(component);
            this.videoFrame.setSize(dimension);
            this.videoFrame.pack();
            this.videoFrame.setVisible(true);
            this.player.start();
        } else {
            this.player.start();
        }
    }
}

