/*
 * Decompiled with CFR 0.152.
 */
package video;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import video.VideoStreamer;

public class VideoStreamerGUI
extends JFrame {
    private InetAddress myIP = null;
    public static String bufferDisplay = "";
    private VideoStreamer myVideoTool = null;
    private Boolean powerOn = false;
    private JComboBox audioFormatBox;
    private JLabel audioFormatLabel;
    private JTextField destIPField;
    private JTextField destPortField;
    private JLabel destPortLabel;
    private JPanel fieldsPanel;
    private JTextField filenameField;
    private JLabel peerIPLabel;
    private JLabel peerIPLabel1;
    private JButton powerButton;
    private JLabel receivePortLabel;
    private JTextField sourceIPField;
    private JTextField sourcePortField;
    private JButton startStreamButton;
    private static JEditorPane statusDisplay;
    private JScrollPane statusDisplayPane;
    private JScrollPane statusDisplayPane1;
    private JButton stopStreamButton;
    private JPanel streamButtonsPanel;
    private static JEditorPane textDisplay;

    public VideoStreamerGUI(String sourceIPParam, String sourcePortParam, String destIPParam, String destPortParam) {
        this.initComponents();
        try {
            this.myIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException error) {
            VideoStreamerGUI.showStatus("Error: InetAddress.getLocalHost(): " + error.getMessage());
        }
        this.sourceIPField.setText(sourceIPParam);
        this.sourcePortField.setText(sourcePortParam);
        this.destIPField.setText(destIPParam);
        this.destPortField.setText(destPortParam);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (args.length != 4) {
                    System.out.println("Usage: VideoToolGUI \"sourceIP\" \"sourcePort\" \"destIP\" \"destPort\"\n");
                    return;
                }
                new VideoStreamerGUI(args[0], args[1], args[2], args[3]).setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.streamButtonsPanel = new JPanel();
        this.startStreamButton = new JButton();
        this.stopStreamButton = new JButton();
        this.fieldsPanel = new JPanel();
        this.peerIPLabel = new JLabel();
        this.peerIPLabel1 = new JLabel();
        this.receivePortLabel = new JLabel();
        this.destPortLabel = new JLabel();
        this.audioFormatLabel = new JLabel();
        this.sourceIPField = new JTextField();
        this.sourcePortField = new JTextField();
        this.destIPField = new JTextField();
        this.destPortField = new JTextField();
        this.audioFormatBox = new JComboBox();
        this.statusDisplayPane = new JScrollPane();
        textDisplay = new JEditorPane();
        this.powerButton = new JButton();
        this.statusDisplayPane1 = new JScrollPane();
        statusDisplay = new JEditorPane();
        this.filenameField = new JTextField();
        this.setDefaultCloseOperation(3);
        this.streamButtonsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.streamButtonsPanel.setName("streamButtonsPanel");
        this.streamButtonsPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VideoStreamerGUI.this.streamButtonsPanelMouseClicked(evt);
            }
        });
        this.startStreamButton.setFont(new Font("STHeiti", 0, 13));
        this.startStreamButton.setText("Start Stream");
        this.startStreamButton.setMaximumSize(new Dimension(120, 30));
        this.startStreamButton.setMinimumSize(new Dimension(120, 30));
        this.startStreamButton.setName("startStreamButton");
        this.startStreamButton.setPreferredSize(new Dimension(120, 30));
        this.startStreamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VideoStreamerGUI.this.startStreamButtonActionPerformed(evt);
            }
        });
        this.stopStreamButton.setFont(new Font("STHeiti", 0, 13));
        this.stopStreamButton.setText("Stop Stream");
        this.stopStreamButton.setMaximumSize(new Dimension(120, 30));
        this.stopStreamButton.setMinimumSize(new Dimension(120, 30));
        this.stopStreamButton.setName("stopStreamButton");
        this.stopStreamButton.setPreferredSize(new Dimension(120, 30));
        this.stopStreamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VideoStreamerGUI.this.stopStreamButtonActionPerformed(evt);
            }
        });
        GroupLayout streamButtonsPanelLayout = new GroupLayout((Container)this.streamButtonsPanel);
        this.streamButtonsPanel.setLayout((LayoutManager)streamButtonsPanelLayout);
        streamButtonsPanelLayout.setHorizontalGroup((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)streamButtonsPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.startStreamButton, -2, 150, -2).addPreferredGap(0, 293, Short.MAX_VALUE).add((Component)this.stopStreamButton, -2, 150, -2).addContainerGap()));
        streamButtonsPanelLayout.setVerticalGroup((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)streamButtonsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)streamButtonsPanelLayout.createParallelGroup(3).add((Component)this.startStreamButton, -2, 70, -2).add((Component)this.stopStreamButton, -2, 70, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.fieldsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.fieldsPanel.setName("fieldsPanel");
        this.peerIPLabel.setFont(new Font("STHeiti", 0, 13));
        this.peerIPLabel.setText("Source IP");
        this.peerIPLabel.setName("peerIPLabel");
        this.peerIPLabel1.setFont(new Font("STHeiti", 0, 13));
        this.peerIPLabel1.setText("Source Port");
        this.peerIPLabel1.setName("peerIPLabel1");
        this.receivePortLabel.setFont(new Font("STHeiti", 0, 13));
        this.receivePortLabel.setText("Dest IP");
        this.receivePortLabel.setName("receivePortLabel");
        this.destPortLabel.setFont(new Font("STHeiti", 0, 13));
        this.destPortLabel.setText("Dest Port");
        this.destPortLabel.setName("destPortLabel");
        this.audioFormatLabel.setFont(new Font("STHeiti", 0, 13));
        this.audioFormatLabel.setText("Audio Format");
        this.audioFormatLabel.setName("audioFormatLabel");
        this.sourceIPField.setFont(new Font("STHeiti", 0, 13));
        this.sourceIPField.setName("sourceIPField");
        this.sourcePortField.setFont(new Font("STHeiti", 0, 13));
        this.sourcePortField.setName("sourcePortField");
        this.destIPField.setFont(new Font("STHeiti", 0, 13));
        this.destIPField.setName("destIPField");
        this.destPortField.setFont(new Font("STHeiti", 0, 13));
        this.destPortField.setName("destPortField");
        this.audioFormatBox.setFont(new Font("STHeiti", 0, 13));
        this.audioFormatBox.setModel(new DefaultComboBoxModel<String>(new String[]{"JPEG_RTP", "H263", "H263_RTP", "H263_2_RTP", "MPEG_RTP", " "}));
        this.audioFormatBox.setName("audioFormatBox");
        GroupLayout fieldsPanelLayout = new GroupLayout((Container)this.fieldsPanel);
        this.fieldsPanel.setLayout((LayoutManager)fieldsPanelLayout);
        fieldsPanelLayout.setHorizontalGroup((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)fieldsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add((Component)this.audioFormatLabel).add((Component)this.peerIPLabel1).add((Component)this.receivePortLabel).add((Component)this.destPortLabel).add((Component)this.peerIPLabel)).addPreferredGap(0, 361, Short.MAX_VALUE).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(2, false).add((Component)this.audioFormatBox, 0, -1, Short.MAX_VALUE).add((Component)this.destPortField).add((Component)this.destIPField).add((Component)this.sourcePortField).add((Component)this.sourceIPField, -1, 146, Short.MAX_VALUE)).addContainerGap()));
        fieldsPanelLayout.setVerticalGroup((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)fieldsPanelLayout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.sourceIPField, -2, -1, -2).add((Component)this.peerIPLabel)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.peerIPLabel1).add((Component)this.sourcePortField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.receivePortLabel).add((Component)this.destIPField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.destPortField, -2, -1, -2).add((Component)this.destPortLabel)).addPreferredGap(0).add((GroupLayout.Group)fieldsPanelLayout.createParallelGroup(3).add((Component)this.audioFormatLabel).add((Component)this.audioFormatBox, -2, -1, -2)).add(30, 30, 30)));
        this.statusDisplayPane.setHorizontalScrollBar(null);
        this.statusDisplayPane.setName("statusDisplayPane");
        textDisplay.setBackground(new Color(230, 230, 230));
        textDisplay.setEditable(false);
        textDisplay.setFont(new Font("Courier New", 0, 8));
        textDisplay.setDragEnabled(false);
        textDisplay.setMinimumSize(new Dimension(600, 200));
        textDisplay.setName("textDisplay");
        textDisplay.setPreferredSize(new Dimension(600, 200));
        textDisplay.setRequestFocusEnabled(false);
        textDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VideoStreamerGUI.this.textDisplayMouseClicked(evt);
            }
        });
        this.statusDisplayPane.setViewportView(textDisplay);
        this.powerButton.setFont(new Font("STHeiti", 0, 13));
        this.powerButton.setText("Power");
        this.powerButton.setName("powerButton");
        this.powerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VideoStreamerGUI.this.powerButtonActionPerformed(evt);
            }
        });
        this.statusDisplayPane1.setHorizontalScrollBar(null);
        this.statusDisplayPane1.setName("statusDisplayPane1");
        statusDisplay.setBackground(new Color(230, 230, 230));
        statusDisplay.setEditable(false);
        statusDisplay.setFont(new Font("STHeiti", 0, 8));
        statusDisplay.setDragEnabled(false);
        statusDisplay.setMinimumSize(new Dimension(600, 200));
        statusDisplay.setName("statusDisplay");
        statusDisplay.setPreferredSize(new Dimension(600, 200));
        statusDisplay.setRequestFocusEnabled(false);
        this.statusDisplayPane1.setViewportView(statusDisplay);
        this.filenameField.setFont(new Font("STHeiti", 0, 13));
        this.filenameField.setText("file://var/tmp/softphone.mov");
        this.filenameField.setName("filenameField");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.streamButtonsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.statusDisplayPane, -1, 607, Short.MAX_VALUE).add(2, (Component)this.statusDisplayPane1, -1, 607, Short.MAX_VALUE).add(2, (Component)this.fieldsPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.filenameField, -1, 607, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(233, 233, 233).add((Component)this.powerButton, -2, 150, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(19, 19, 19).add((Component)this.powerButton).addPreferredGap(0).add((Component)this.statusDisplayPane, -2, 298, -2).addPreferredGap(0).add((Component)this.statusDisplayPane1, -2, 18, -2).addPreferredGap(0).add((Component)this.fieldsPanel, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.filenameField, -2, -1, -2).addPreferredGap(0).add((Component)this.streamButtonsPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void textDisplayMouseClicked(MouseEvent evt) {
        VideoStreamerGUI.resetStatusDisplay();
    }

    private void startStreamButtonActionPerformed(ActionEvent evt) {
        this.myVideoTool.startStreamer(this.destIPField.getText(), this.destPortField.getText(), this.filenameField.getText().toString(), this.audioFormatBox.getSelectedIndex());
    }

    private void stopStreamButtonActionPerformed(ActionEvent evt) {
        this.myVideoTool.stopMedia();
        this.myVideoTool.startListener(this.sourceIPField.getText(), this.sourcePortField.getText(), this.destIPField.getText(), this.destPortField.getText());
    }

    private void powerButtonActionPerformed(ActionEvent evt) {
        if (!this.powerOn.booleanValue()) {
            this.myVideoTool = new VideoStreamer();
            this.myVideoTool.startListener(this.sourceIPField.getText(), this.sourcePortField.getText(), this.destIPField.getText(), this.destPortField.getText());
            this.powerOn = true;
            this.sourceIPField.setEnabled(false);
            this.sourcePortField.setEnabled(false);
            VideoStreamerGUI.showStatus("Media listener started.");
        } else if (this.powerOn.booleanValue()) {
            this.powerOn = false;
            this.myVideoTool.stopMedia();
            this.myVideoTool.stopListener();
            this.sourceIPField.setEnabled(true);
            this.sourcePortField.setEnabled(true);
            VideoStreamerGUI.showStatus("Power Off");
        }
    }

    private void streamButtonsPanelMouseClicked(MouseEvent evt) {
        this.myVideoTool.getMultiMediaStatus();
    }

    public static void display(String displaymessage) {
        bufferDisplay = bufferDisplay + displaymessage + "\n";
        textDisplay.setText(bufferDisplay);
    }

    public static void resetDisplay() {
        bufferDisplay = "";
        textDisplay.setText(bufferDisplay);
    }

    public static void showStatus(String displaystatus) {
        statusDisplay.setText(displaystatus);
    }

    public static void resetStatusDisplay() {
        textDisplay.setText("");
    }
}

