/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import net.sf.atomicdate.sntp.Listener;
import net.sf.atomicdate.sntp.Message;
import net.sf.atomicdate.sntp.Sender;
import net.sf.atomicdate.sntp.Timestamp;

public class Client
extends Listener {
    public static final int DEFAULT_SNTP_PORT = 123;
    public static final int DEFAULT_TIMEOUT = 10000;
    private static final long SECS_1900_1970 = 2208988800L;
    private final MessageHolder holder;

    public Client() throws SocketException {
        this(10000);
    }

    public Client(int timeout) throws SocketException {
        super(new DatagramSocket());
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout<0");
        }
        if (timeout > 0) {
            super.getSocket().setSoTimeout(timeout);
        }
        this.holder = new MessageHolder();
        super.startListening();
    }

    public void close() {
        if (super.isListening()) {
            super.stopListening();
        }
        super.getSocket().close();
    }

    public long getOffset(String host) throws IOException {
        return this.getOffset(host, 123);
    }

    public long getOffset(String host, int port) throws IOException {
        return this.getOffset(InetAddress.getByName(host), port);
    }

    public long getOffset(InetAddress addr) throws IOException {
        return this.getOffset(addr, 123);
    }

    public long getOffset(InetAddress addr, int port) throws IOException {
        return this.queryServer(addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessage(Message message, long time) {
        MessageHolder messageHolder = this.holder;
        synchronized (messageHolder) {
            this.holder.hold(message, time);
            this.holder.notify();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String toString() {
        DatagramSocket socket = super.getSocket();
        return socket.getInetAddress() + ":" + socket.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long queryServer(InetAddress addr, int port) throws IOException {
        Message rmessage;
        long t4;
        if (addr == null) {
            throw new NullPointerException("addr=null");
        }
        if (!super.isListening()) {
            throw new IllegalStateException("Client closed.");
        }
        Sender sender = new Sender(super.getSocket());
        Message smessage = new Message();
        smessage.setTransmitTimestamp(Client.toTimestamp(System.currentTimeMillis()));
        sender.send(smessage, addr, port);
        MessageHolder messageHolder = this.holder;
        synchronized (messageHolder) {
            try {
                this.holder.wait(10000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(System.err);
                throw new IOException("Error waiting for the server answer.");
            }
            t4 = this.holder.getTimestamp();
            if (!this.holder.isHolding()) {
                throw new IOException("Timed-out while querying the server.");
            }
            rmessage = this.holder.getMessage();
        }
        long t1 = Client.fromTimestamp(rmessage.getOriginateTimestamp());
        long t2 = Client.fromTimestamp(rmessage.getReceiveTimestamp());
        long t3 = Client.fromTimestamp(rmessage.getTransmitTimestamp());
        return (t2 - t1 + (t3 - t4)) / 2L;
    }

    protected static Timestamp toTimestamp(long time) {
        double temp = (double)time / 1000.0;
        long integer = (long)Math.floor(temp);
        long fraction = (long)((temp - (double)integer) * 4.294967296E9);
        return new Timestamp(integer + 2208988800L, fraction);
    }

    protected static long fromTimestamp(Timestamp timestamp) {
        long time = (timestamp.getInteger() - 2208988800L) * 1000L;
        return time += timestamp.getFraction() * 1000L / 0x100000000L;
    }

    private class MessageHolder {
        private Message message;
        private long time;

        public MessageHolder() {
            this.release();
        }

        public boolean isHolding() {
            return this.message != null;
        }

        public void hold(Message message, long time) {
            this.message = message;
            this.time = time;
        }

        public Message getMessage() {
            return this.message;
        }

        public long getTimestamp() {
            return this.time;
        }

        public void release() {
            this.message = null;
        }
    }
}

