/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate;

import java.io.IOException;
import java.net.InetAddress;
import net.sf.atomicdate.Client;

public class Date
extends java.util.Date {
    private static final long serialVersionUID = 1064411106013132402L;
    public static final String SERVER_ADDRESS_PROPERTY = "atomicdate.server.address";
    public static final String DEFAULT_SERVER_ADDRESS = "time.nist.gov";

    public Date() {
        try {
            this.synchronize();
        }
        catch (Throwable t) {
            System.err.println("AtomicDate: error synchronizing. Details: " + t.getClass().getName() + ": " + t.getMessage());
            super.setTime(new java.util.Date().getTime());
        }
    }

    public Date(String haddr) throws IOException {
        this(haddr, 123);
    }

    public Date(String haddr, int port) throws IOException {
        this(InetAddress.getByName(haddr), port);
    }

    public Date(InetAddress raddr) throws IOException {
        this(raddr, 123);
    }

    public Date(InetAddress addr, int port) throws IOException {
        this.synchronize(addr, port);
    }

    private void synchronize() throws IOException {
        int port;
        String host;
        String p = System.getProperty(SERVER_ADDRESS_PROPERTY, DEFAULT_SERVER_ADDRESS);
        int idx = p.indexOf(":");
        if (idx != -1) {
            host = p.substring(0, idx);
            try {
                port = Integer.parseInt(p.substring(idx + 1));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Invalid default SNTP server port.");
            }
        } else {
            host = p;
            port = 123;
        }
        this.synchronize(InetAddress.getByName(host), port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize(InetAddress addr, int port) throws IOException {
        Client client = null;
        try {
            client = new Client();
            System.out.println(client.getOffset(addr, port));
            super.setTime(System.currentTimeMillis() + client.getOffset(addr));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

