/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.atomicdate.Client;

public class Service
extends TimerTask {
    private InetAddress host = null;
    private int port;
    private Timer timer;
    private Client client;
    private long offset;

    public Service() throws SocketException {
        this.setServerPort(123);
        this.client = new Client();
        this.offset = -1L;
        this.setSyncPeriod(0L);
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setServerHost(String host) throws UnknownHostException {
        if (host == null) {
            throw new NullPointerException("host=null");
        }
        this.host = InetAddress.getByName(host);
    }

    public void setServerPort(int port) {
        if (port <= 0) {
            throw new NullPointerException("port<=0");
        }
        this.port = port;
    }

    public synchronized void setSyncPeriod(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("period<0");
        }
        this.cancel();
        if (period != 0L) {
            if (this.timer != null) {
                this.timer = new Timer();
            }
            this.timer.schedule((TimerTask)this, period, period);
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public long getTime() throws IOException {
        if (this.offset == -1L) {
            throw new IllegalStateException("Not synchronized.");
        }
        return System.currentTimeMillis() + this.offset;
    }

    public void run() {
        try {
            this.offset = this.client.getOffset(this.host, this.port);
        }
        catch (IOException ioe) {
            System.err.println("AtomicDate: error synchronizing the SNTP service.");
            ioe.printStackTrace(System.err);
        }
    }
}

