/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate.sntp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.atomicdate.sntp.Message;
import net.sf.atomicdate.sntp.Timestamp;

public final class Codec {
    public static void encodeMessage(Message message, OutputStream output) throws IOException {
        byte flags = (byte)(message.getLeapIndicator() << 6);
        flags = (byte)(flags + (byte)(message.getVersionNumber() << 3));
        flags = (byte)(flags + message.getMode());
        output.write(flags);
        output.write(message.getStratum());
        output.write(message.getPollInterval());
        output.write(message.getPrecision());
        Codec.encodeFixedPoint(message.getRootDelay(), output);
        Codec.encodeFixedPoint(message.getRootDispersion(), output);
        Codec.encodeBitstring(message.getReferenceIdentifier(), output);
        Codec.encodeTimestamp(message.getReferenceTimestamp(), output);
        Codec.encodeTimestamp(message.getOriginateTimestamp(), output);
        Codec.encodeTimestamp(message.getReceiveTimestamp(), output);
        Codec.encodeTimestamp(message.getTransmitTimestamp(), output);
    }

    public static Message decodeMessage(InputStream input) throws IOException {
        Message message = new Message();
        byte flags = (byte)input.read();
        message.setLeapIndicator((byte)(flags >> 6));
        message.setVersionNumber((byte)(flags >> 3 & 7));
        message.setMode((byte)(flags & 7));
        message.setStratum((byte)input.read());
        message.setPollInterval((byte)input.read());
        message.setPrecision((byte)input.read());
        message.setRootDelay(Codec.decodeFixedPoint(input));
        message.setRootDispersion(Codec.decodeFixedPoint(input));
        message.setReferenceIdentifier(Codec.decodeBitstring(input));
        message.setReferenceTimestamp(Codec.decodeTimestamp(input));
        message.setOriginateTimestamp(Codec.decodeTimestamp(input));
        message.setReceiveTimestamp(Codec.decodeTimestamp(input));
        message.setTransmitTimestamp(Codec.decodeTimestamp(input));
        return message;
    }

    protected static void encode32(long number, OutputStream output) throws IOException {
        for (int i = 3; i >= 0; --i) {
            output.write((int)(number >> 8 * i & 0xFFL));
        }
    }

    protected static long decode32(InputStream input) throws IOException {
        long number = 0L;
        for (int i = 0; i < 4; ++i) {
            number = (number << 8) + (long)input.read();
        }
        return number;
    }

    protected static void encodeBitstring(byte[] bitstring, OutputStream output) throws IOException {
        byte[] temp = new byte[]{0, 0, 0, 0};
        System.arraycopy(bitstring, 0, temp, 0, bitstring.length);
        output.write(temp);
    }

    protected static byte[] decodeBitstring(InputStream input) throws IOException {
        byte[] bitstring = new byte[4];
        input.read(bitstring, 0, 4);
        return bitstring;
    }

    protected static void encodeFixedPoint(double number, OutputStream output) throws IOException {
        Codec.encode32((long)(number * 65536.0), output);
    }

    protected static double decodeFixedPoint(InputStream input) throws IOException {
        return (double)Codec.decode32(input) / 65536.0;
    }

    protected static void encodeTimestamp(Timestamp timestamp, OutputStream output) throws IOException {
        Codec.encode32(timestamp.getInteger(), output);
        Codec.encode32(timestamp.getFraction(), output);
    }

    protected static Timestamp decodeTimestamp(InputStream input) throws IOException {
        long integer = Codec.decode32(input);
        long fraction = Codec.decode32(input);
        return new Timestamp(integer, fraction);
    }
}

