/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate.sntp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.sf.atomicdate.sntp.Codec;
import net.sf.atomicdate.sntp.Message;

public abstract class Listener
extends Thread {
    private static final String THREAD_NAME = "AtomicDate";
    private final DatagramSocket socket;
    private boolean listening;

    public Listener(DatagramSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket=null");
        }
        this.socket = socket;
        super.setName("AtomicDate-" + socket.getPort());
        this.listening = false;
    }

    protected DatagramSocket getSocket() {
        return this.socket;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void startListening() {
        this.listening = true;
        super.start();
    }

    public void stopListening() {
        this.listening = false;
    }

    public void run() {
        while (this.listening) {
            try {
                DatagramPacket packet = new DatagramPacket(new byte[384], 384);
                this.socket.receive(packet);
                long time = System.currentTimeMillis();
                this.onMessage(Codec.decodeMessage(new ByteArrayInputStream(packet.getData())), time);
            }
            catch (IOException ioe) {
                if (!this.isListening()) continue;
                System.err.println("AtomicDate: error receiving a message.");
                ioe.printStackTrace(System.err);
            }
        }
    }

    protected abstract void onMessage(Message var1, long var2);
}

