/*
 * Decompiled with CFR 0.152.
 */
package net.sf.atomicdate.sntp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.sf.atomicdate.sntp.Codec;
import net.sf.atomicdate.sntp.Message;

public final class Sender {
    private final DatagramSocket socket;

    public Sender(DatagramSocket socket) {
        if (socket == null) {
            throw new NullPointerException("socket=null");
        }
        this.socket = socket;
    }

    public void send(Message message, InetAddress addr, int port) throws IOException {
        if (message == null) {
            throw new NullPointerException("message=null");
        }
        if (addr == null) {
            throw new NullPointerException("addr=null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("port<0");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Codec.encodeMessage(message, output);
        byte[] data = output.toByteArray();
        output.close();
        DatagramPacket packet = new DatagramPacket(data, data.length, addr, port);
        this.socket.send(packet);
    }
}

