/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.locale;

import datechooser.beans.DateChooserPanel;
import datechooser.beans.editor.locale.LocaleSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class LocaleEditorPane
extends JPanel {
    private PropertyEditorSupport editor;
    private static LocaleSet data = null;
    private JComboBox selLocale;
    private boolean innerEdit;
    private DateChooserPanel dc;

    public LocaleEditorPane(PropertyEditorSupport editor) {
        if (data == null) {
            data = new LocaleSet();
        }
        this.setEditor(editor);
        this.setInnerEdit(false);
        this.selLocale = new JComboBox<String>(data.getNames());
        this.dc = new DateChooserPanel();
        this.dc.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this.selLocale.setFont(new Font("Serif", 0, 12));
        this.updateValue();
        this.selLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LocaleEditorPane.this.isInnerEdit()) {
                    return;
                }
                LocaleEditorPane.this.getEditor().setValue(data.getLocales()[LocaleEditorPane.this.selLocale.getSelectedIndex()]);
            }
        });
        this.getEditor().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LocaleEditorPane.this.updateValue();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.selLocale, "North");
        this.add((Component)this.dc, "Center");
    }

    private void updateValue() {
        if (this.isInnerEdit()) {
            return;
        }
        this.setInnerEdit(true);
        this.selLocale.setSelectedIndex(data.getIndex(this.getEditorValue()));
        this.dc.setLocale(this.getEditorValue());
        this.setInnerEdit(false);
    }

    private Locale getEditorValue() {
        return (Locale)this.getEditor().getValue();
    }

    public PropertyEditorSupport getEditor() {
        return this.editor;
    }

    public void setEditor(PropertyEditorSupport editor) {
        this.editor = editor;
    }

    public boolean isInnerEdit() {
        return this.innerEdit;
    }

    public void setInnerEdit(boolean innerEdit) {
        this.innerEdit = innerEdit;
    }
}

