/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import datechooser.view.AbstractNavigatePane;
import datechooser.view.pic.ViewPictures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ButtonNavigatePane
extends AbstractNavigatePane {
    private static final int BORDER = 3;
    private JLabel showYearMonth = new JLabel("", 0);
    private int currentMonth;
    private int currentYear;
    private JButton bPrevYear;
    private JButton bPrevMonth;
    private JButton bNothing;
    private JButton bNextMonth;
    private JButton bNextYear;

    public ButtonNavigatePane() {
        this.initMonthList();
        this.showYearMonth.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel pRight = new JPanel(new GridLayout(1, 5));
        OnClick onClick = new OnClick();
        this.bPrevYear = new JButton(new ImageIcon(ViewPictures.class.getResource("prev_year.gif")));
        this.bPrevYear.addActionListener(onClick);
        this.bPrevMonth = new JButton(new ImageIcon(ViewPictures.class.getResource("prev_month.gif")));
        this.bPrevMonth.addActionListener(onClick);
        this.bNothing = new JButton(new ImageIcon(ViewPictures.class.getResource("nothing.gif")));
        this.bNothing.addActionListener(onClick);
        this.bNextMonth = new JButton(new ImageIcon(ViewPictures.class.getResource("next_month.gif")));
        this.bNextMonth.addActionListener(onClick);
        this.bNextYear = new JButton(new ImageIcon(ViewPictures.class.getResource("next_year.gif")));
        this.bNextYear.addActionListener(onClick);
        pRight.add(this.bPrevYear);
        pRight.add(this.bPrevMonth);
        pRight.add(this.bNothing);
        pRight.add(this.bNextMonth);
        pRight.add(this.bNextYear);
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)this.showYearMonth, "West");
        this.add((Component)pRight, "Center");
    }

    private String getDateText() {
        return this.monthsList[this.currentMonth] + " " + this.currentYear;
    }

    public void updateMonthControl() {
        this.showYearMonth.setText(this.getDateText());
    }

    public int getMonth() {
        return this.currentMonth;
    }

    public int getYear() {
        return this.currentYear;
    }

    public void setMonth(int aMonth) {
        this.currentMonth = aMonth;
        this.updateMonthControl();
    }

    public void setYear(int aYear) {
        this.currentYear = aYear;
        this.updateMonthControl();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.showYearMonth != null) {
            this.showYearMonth.setFont(font);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bPrevYear.setEnabled(enabled);
        this.bPrevMonth.setEnabled(enabled);
        this.bNextMonth.setEnabled(enabled);
        this.bNextYear.setEnabled(enabled);
        this.bNothing.setEnabled(this.isNothingSelectEnabled() ? enabled : false);
    }

    public void applyNothingSelectEnabled(boolean enabled) {
        this.bNothing.setEnabled(enabled);
    }

    private class OnClick
    implements ActionListener {
        private OnClick() {
        }

        public void actionPerformed(ActionEvent e) {
            JButton src = (JButton)e.getSource();
            if (src == ButtonNavigatePane.this.bNothing) {
                ButtonNavigatePane.this.getModel().selectNothing();
                return;
            }
            if (src == ButtonNavigatePane.this.bPrevYear) {
                ButtonNavigatePane.this.currentYear--;
            }
            if (src == ButtonNavigatePane.this.bNextYear) {
                ButtonNavigatePane.this.currentYear++;
            }
            if (src == ButtonNavigatePane.this.bPrevMonth) {
                if (ButtonNavigatePane.this.currentMonth > 0) {
                    ButtonNavigatePane.this.currentMonth--;
                } else {
                    ButtonNavigatePane.this.currentMonth = 11;
                }
            }
            if (src == ButtonNavigatePane.this.bNextMonth) {
                if (ButtonNavigatePane.this.currentMonth < 11) {
                    ButtonNavigatePane.this.currentMonth++;
                } else {
                    ButtonNavigatePane.this.currentMonth = 0;
                }
            }
            ButtonNavigatePane.this.someChanged();
        }
    }
}

