/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance.swing;

import datechooser.view.appearance.CellRenderer;
import datechooser.view.appearance.swing.Painter;
import datechooser.view.appearance.swing.SwingCellAppearance;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.Border;

public class SwingCellRenderer
extends CellRenderer {
    private static final int ALLOW_DECREASE = 7;
    private Painter painter;
    private SwingCellAppearance appearance;
    private Font defaultFont;

    public SwingCellRenderer(SwingCellAppearance appearance, Painter painter) {
        this.painter = painter;
        this.defaultFont = painter.getFont();
        this.setAppearance(appearance);
    }

    private void testDecreasing(Insets insets, Rectangle bounds) {
        int horizontalMax = bounds.width / 7;
        int verticalMax = bounds.height / 7;
        if (insets.left > horizontalMax) {
            insets.left = horizontalMax;
        }
        if (insets.right > horizontalMax) {
            insets.right = horizontalMax;
        }
        if (insets.top > verticalMax) {
            insets.top = verticalMax;
        }
        if (insets.bottom > verticalMax) {
            insets.bottom = verticalMax;
        }
    }

    public void render(Graphics2D g, Component c, String text, int width, int height, boolean isCursor) {
        Color aColor;
        this.getPainter().updateUI();
        this.getPainter().setText(text);
        this.getPainter().setSize(width, height);
        Font aFont = this.getAppearance().getFont();
        if (aFont != null) {
            this.getPainter().setFont(aFont);
        }
        if ((aColor = this.getAppearance().getTextColor()) != null) {
            this.getPainter().setTextColor(aColor);
        }
        this.getPainter().setPressed(this.getAppearance().isPressed());
        this.getPainter().setEnabled(this.getAppearance().isEnabled());
        this.getPainter().paint(g);
        Rectangle cellRect = new Rectangle(0, 0, width, height);
        Border border = this.getPainter().getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(this.getPainter().getComponent(c));
            this.testDecreasing(borderInsets, cellRect);
            cellRect.setRect(borderInsets.left, borderInsets.top, cellRect.width - (borderInsets.left + borderInsets.right), cellRect.height - (borderInsets.top + borderInsets.bottom));
        }
        if (isCursor) {
            this.paintCursor(g, cellRect, this.getAppearance().getCursorColor());
        }
    }

    public SwingCellAppearance getAppearance() {
        return this.appearance;
    }

    public void setAppearance(SwingCellAppearance appearance) {
        this.appearance = appearance;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Painter getPainter() {
        return this.painter;
    }
}

