/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.sip.address.Hop;

public class TCPMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    protected InputStream myClientInputStream;
    protected OutputStream myClientOutputStream;
    protected String key;
    protected boolean isCached;
    protected boolean isRunning = true;
    private Thread mythread;
    protected SIPTransactionStack sipStack;
    protected String myAddress;
    protected int myPort;
    protected InetAddress peerAddress;
    protected int peerPort;
    protected String peerProtocol;
    private TCPMessageProcessor tcpMessageProcessor;

    protected TCPMessageChannel(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    protected TCPMessageChannel(Socket sock, SIPTransactionStack sipStack, TCPMessageProcessor msgProcessor, String threadName) throws IOException {
        if (sipStack.isLoggingEnabled(32)) {
            sipStack.getStackLogger().logDebug("creating new TCPMessageChannel ");
            sipStack.getStackLogger().logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.myClientOutputStream = this.mySock.getOutputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName(threadName);
        this.sipStack = sipStack;
        this.peerPort = this.mySock.getPort();
        this.tcpMessageProcessor = msgProcessor;
        this.myPort = this.tcpMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TCPMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TCPMessageProcessor messageProcessor) throws IOException {
        if (sipStack.isLoggingEnabled(32)) {
            sipStack.getStackLogger().logDebug("creating new TCPMessageChannel ");
            sipStack.getStackLogger().logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TCP";
        this.sipStack = sipStack;
        this.tcpMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        this.messageProcessor = messageProcessor;
    }

    public void setViaHost(String viaAddress) {
        this.myAddress = viaAddress;
    }

    public void setViaPort(int viaPort) {
        this.myPort = viaPort;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                    this.mySock = null;
                }
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Closing message Channel " + this);
                }
            }
            catch (IOException ex) {
                if (!this.sipStack.isLoggingEnabled(32)) break block4;
                this.sipStack.getStackLogger().logDebug("Error closing socket " + ex);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "TCP";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean isClient) throws IOException {
        Socket sock;
        if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("sendMessage isClient  = " + isClient);
        }
        if ((sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, isClient, this)) != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Closing socket");
                    }
                    this.mySock.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TCPMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(final SIPMessage sipMessage) throws IOException {
        if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("sendMessage:: " + sipMessage.getFirstLine() + " cseq method = " + sipMessage.getCSeq().getMethod());
        }
        for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
            if (!messageProcessor.getIpAddress().getHostAddress().equals(this.getPeerAddress()) || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
            Runnable processMessageTask = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            TCPMessageChannel.this.processMessage(sipMessage);
                        }
                        catch (Exception ex) {
                            if (!TCPMessageChannel.this.getSIPStack().getStackLogger().isLoggingEnabled(4)) break block2;
                            TCPMessageChannel.this.getSIPStack().getStackLogger().logError("Error self routing message cause by: ", ex);
                        }
                    }
                }
            };
            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
            if (this.getSIPStack().getStackLogger().isLoggingEnabled(32)) {
                this.getSIPStack().getStackLogger().logDebug("Self routing message");
            }
            return;
        }
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        Socket sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TCP", message, retry, this);
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                this.sipStack.getTimer().schedule(new SIPStackTimerTask(){

                    public void cleanUpBeforeCancel() {
                        try {
                            TCPMessageChannel.this.sipStack.getStackLogger().logDebug("closing socket");
                            TCPMessageChannel.this.mySock.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    public void runTask() {
                        try {
                            if (TCPMessageChannel.this.sipStack.isLoggingEnabled(32)) {
                                TCPMessageChannel.this.sipStack.getStackLogger().logDebug("Closing socket");
                            }
                            TCPMessageChannel.this.mySock.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, 8000L);
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            this.myClientOutputStream = this.mySock.getOutputStream();
            Thread mythread = new Thread(this);
            mythread.setDaemon(true);
            mythread.setName("TCPMessageChannelThread");
            mythread.start();
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            String msgString;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Encountered Bad Message \n" + sipMessage.toString());
            }
            if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getStackLogger().logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.getPeerInetAddress(), this.getPeerPort(), false);
                    }
                    catch (IOException e) {
                        this.sipStack.getStackLogger().logException(e);
                    }
                } else if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void processMessage(SIPMessage sipMessage, InetAddress address) {
        block2: {
            this.peerAddress = address;
            try {
                this.processMessage(sipMessage);
            }
            catch (Exception e) {
                if (!this.sipStack.getStackLogger().isLoggingEnabled(4)) break block2;
                this.sipStack.getStackLogger().logError("ERROR processing self routing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        try {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (!this.sipStack.isLoggingEnabled(32)) return;
                this.sipStack.getStackLogger().logDebug(">>> Dropped Bad Msg");
                this.sipStack.getStackLogger().logDebug(badmsg);
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerProtocol = v.getTransport();
                try {
                    if (this.mySock != null) {
                        this.peerAddress = this.mySock.getInetAddress();
                    }
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex, this.sipStack.getStackLogger());
                }
                if (!this.isCached && this.mySock != null) {
                    this.isCached = true;
                    int remotePort = ((InetSocketAddress)this.mySock.getRemoteSocketAddress()).getPort();
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), remotePort);
                    this.sipStack.ioHandler.putSocket(key, this.mySock);
                    ((TCPMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                String cseqMethod;
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("----Processing Message---");
                }
                if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
                    this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getMessageProcessor().getIpAddress().getHostAddress() + ":" + this.getMessageProcessor().getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                String sipVersion = ((SIPRequest)sipMessage).getRequestLine().getSipVersion();
                if (!sipVersion.equals("SIP/2.0")) {
                    SIPResponse versionNotSupported = ((SIPRequest)sipMessage).createResponse(505, "Bad version " + sipVersion);
                    this.sendMessage(versionNotSupported.encodeAsBytes(this.getTransport()), false);
                    throw new Exception("Bad sip version");
                }
                String method = ((SIPRequest)sipMessage).getMethod();
                if (!method.equalsIgnoreCase(cseqMethod = ((SIPRequest)sipMessage).getCSeqHeader().getMethod())) {
                    SIPResponse sipResponse = sipRequest.createResponse(400);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Bad CSeq method");
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var12_26 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) return;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) return;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var12_27 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) throw throwable;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        throw throwable;
                    }
                } else {
                    if (!this.sipStack.isLoggingEnabled()) return;
                    this.sipStack.getStackLogger().logWarning("Dropping request -- could not acquire semaphore in 10 sec");
                }
                return;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logError("Dropping Badly formatted response message >>> " + sipResponse);
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (!this.sipStack.isLoggingEnabled(32)) return;
                this.sipStack.getStackLogger().logDebug("Message size exceeded");
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                block27: {
                    try {
                        if (!(sipServerResponse instanceof SIPClientTransaction) || ((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) break block27;
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        Object var15_31 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_33 = null;
                        if (!(sipServerResponse instanceof SIPTransaction)) throw throwable;
                        if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                        throw throwable;
                    }
                    if (!(sipServerResponse instanceof SIPTransaction)) return;
                    if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    return;
                }
                sipServerResponse.processResponse(sipResponse, this);
                Object var15_32 = null;
                if (!(sipServerResponse instanceof SIPTransaction)) return;
                if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                return;
            }
            this.sipStack.getStackLogger().logWarning("Application is blocked -- could not acquire semaphore -- dropping response");
            return;
        }
        catch (Throwable throwable) {
            Object var17_9 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this.sipStack, this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        int bufferSize = 4096;
        ++this.tcpMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int nbytes;
                byte[] msg;
                try {
                    msg = new byte[bufferSize];
                    nbytes = this.myClientInputStream.read(msg, 0, bufferSize);
                    if (nbytes == -1) {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TCPMessageProcessor tCPMessageProcessor = this.tcpMessageProcessor;
                                synchronized (tCPMessageProcessor) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            hispipe.close();
                            if (this.mySock != null) {
                                if (this.sipStack.isLoggingEnabled(32)) {
                                    this.sipStack.getStackLogger().logDebug("Closing socket");
                                }
                                this.mySock.close();
                            }
                        }
                        catch (IOException ioex) {
                        }
                        Object var9_13 = null;
                        this.isRunning = false;
                        this.tcpMessageProcessor.remove(this);
                        --this.tcpMessageProcessor.useCount;
                        this.myParser.close();
                        return;
                    }
                }
                catch (IOException ex) {
                    try {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("IOException  closing sock " + ex);
                        }
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TCPMessageProcessor e = this.tcpMessageProcessor;
                                synchronized (e) {
                                    --this.tcpMessageProcessor.nConnections;
                                    this.tcpMessageProcessor.notify();
                                }
                            }
                            if (this.mySock != null) {
                                if (this.sipStack.isLoggingEnabled(32)) {
                                    this.sipStack.getStackLogger().logDebug("Closing socket");
                                }
                                this.mySock.close();
                            }
                            hispipe.close();
                        }
                        catch (IOException ioex) {}
                    }
                    catch (Exception ex1) {
                    }
                    Object var9_14 = null;
                    this.isRunning = false;
                    this.tcpMessageProcessor.remove(this);
                    --this.tcpMessageProcessor.useCount;
                    this.myParser.close();
                    return;
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex, this.sipStack.getStackLogger());
                    continue;
                }
                {
                    hispipe.write(msg, 0, nbytes);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.isRunning = false;
            this.tcpMessageProcessor.remove(this);
            --this.tcpMessageProcessor.useCount;
            this.myParser.close();
            throw throwable;
        }
    }

    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            this.tcpMessageProcessor.remove(this);
        }
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TCPMessageChannel that = (TCPMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TCP");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return false;
    }
}

