/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.DialogTimeoutEvent;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipListener;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;

class EventScanner
implements Runnable {
    private boolean isStopped;
    private int refCount;
    private LinkedList pendingEvents;
    private int[] eventMutex = new int[]{0};
    private SipStackImpl sipStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefcount() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            ++this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public EventScanner(SipStackImpl sipStackImpl) {
        this.pendingEvents = new LinkedList();
        Thread myThread = new Thread(this);
        myThread.setDaemon(false);
        this.sipStack = sipStackImpl;
        myThread.setName("EventScannerThread");
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("addEvent " + eventWrapper);
        }
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.pendingEvents.add(eventWrapper);
            this.eventMutex.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            if (this.refCount > 0) {
                --this.refCount;
            }
            if (this.refCount == 0) {
                this.isStopped = true;
                this.eventMutex.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        int[] nArray = this.eventMutex;
        synchronized (this.eventMutex) {
            this.isStopped = true;
            this.refCount = 0;
            this.eventMutex.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deliverEvent(EventWrapper eventWrapper) {
        SipListener sipListener;
        EventObject sipEvent;
        block63: {
            block62: {
                block61: {
                    block60: {
                        sipEvent = eventWrapper.sipEvent;
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("sipEvent = " + sipEvent + "source = " + sipEvent.getSource());
                        }
                        sipListener = null;
                        sipListener = !(sipEvent instanceof IOExceptionEvent) ? ((SipProviderImpl)sipEvent.getSource()).getSipListener() : this.sipStack.getSipListener();
                        if (!(sipEvent instanceof RequestEvent)) break block63;
                        try {
                            SIPRequest sipRequest;
                            block65: {
                                block64: {
                                    SIPServerTransaction tx;
                                    sipRequest = (SIPRequest)((RequestEvent)sipEvent).getRequest();
                                    if (this.sipStack.isLoggingEnabled(32)) {
                                        this.sipStack.getStackLogger().logDebug("deliverEvent : " + sipRequest.getFirstLine() + " transaction " + eventWrapper.transaction + " sipEvent.serverTx = " + ((RequestEvent)sipEvent).getServerTransaction());
                                    }
                                    if ((tx = (SIPServerTransaction)this.sipStack.findTransaction(sipRequest, true)) == null || tx.passToListener()) break block64;
                                    if (sipRequest.getMethod().equals("ACK") && tx.isInviteTransaction() && (tx.getLastResponseStatusCode() / 100 == 2 || this.sipStack.isNon2XXAckPassedToListener())) {
                                        if (this.sipStack.isLoggingEnabled(32)) {
                                            this.sipStack.getStackLogger().logDebug("Detected broken client sending ACK with same branch! Passing...");
                                        }
                                        break block65;
                                    } else {
                                        if (this.sipStack.isLoggingEnabled(32)) {
                                            this.sipStack.getStackLogger().logDebug("transaction already exists! " + tx);
                                        }
                                        Object var8_15 = null;
                                        break block60;
                                    }
                                }
                                if (this.sipStack.findPendingTransaction(sipRequest.getTransactionId()) != null) {
                                    if (this.sipStack.isLoggingEnabled(32)) {
                                        this.sipStack.getStackLogger().logDebug("transaction already exists!!");
                                    }
                                    break block61;
                                }
                                SIPServerTransaction st = (SIPServerTransaction)eventWrapper.transaction;
                                this.sipStack.putPendingTransaction(st);
                            }
                            sipRequest.setTransaction(eventWrapper.transaction);
                            try {
                                SIPDialog dialog;
                                if (this.sipStack.isLoggingEnabled(32)) {
                                    this.sipStack.getStackLogger().logDebug("Calling listener " + sipRequest.getFirstLine());
                                    this.sipStack.getStackLogger().logDebug("Calling listener " + eventWrapper.transaction);
                                }
                                if (sipListener != null) {
                                    sipListener.processRequest((RequestEvent)sipEvent);
                                }
                                if (this.sipStack.isLoggingEnabled(32)) {
                                    this.sipStack.getStackLogger().logDebug("Done processing Message " + sipRequest.getFirstLine());
                                }
                                if (eventWrapper.transaction != null && (dialog = (SIPDialog)eventWrapper.transaction.getDialog()) != null) {
                                    dialog.requestConsumed();
                                }
                                break block62;
                            }
                            catch (Exception ex) {
                                this.sipStack.getStackLogger().logException(ex);
                            }
                            break block62;
                        }
                        catch (Throwable throwable) {
                            Object var8_18 = null;
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                            }
                            if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                                ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                            }
                            if (eventWrapper.transaction != null) {
                                this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                            }
                            if (!eventWrapper.transaction.getMethod().equals("ACK")) throw throwable;
                            eventWrapper.transaction.setState(5);
                            throw throwable;
                        }
                    }
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                    }
                    if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                        ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                    }
                    if (eventWrapper.transaction != null) {
                        this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                    }
                    if (!eventWrapper.transaction.getMethod().equals("ACK")) return;
                    eventWrapper.transaction.setState(5);
                    return;
                }
                Object var8_16 = null;
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
                }
                if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                    ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
                }
                if (eventWrapper.transaction != null) {
                    this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
                }
                if (!eventWrapper.transaction.getMethod().equals("ACK")) return;
                eventWrapper.transaction.setState(5);
                return;
            }
            Object var8_17 = null;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Done processing Message " + ((SIPRequest)((RequestEvent)sipEvent).getRequest()).getFirstLine());
            }
            if (eventWrapper.transaction != null && ((SIPServerTransaction)eventWrapper.transaction).passToListener()) {
                ((SIPServerTransaction)eventWrapper.transaction).releaseSem();
            }
            if (eventWrapper.transaction != null) {
                this.sipStack.removePendingTransaction((SIPServerTransaction)eventWrapper.transaction);
            }
            if (!eventWrapper.transaction.getMethod().equals("ACK")) return;
            eventWrapper.transaction.setState(5);
            return;
        }
        if (sipEvent instanceof ResponseEvent) {
            try {
                ResponseEvent responseEvent = (ResponseEvent)sipEvent;
                SIPResponse sipResponse = (SIPResponse)responseEvent.getResponse();
                SIPDialog sipDialog = (SIPDialog)responseEvent.getDialog();
                try {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Calling listener for " + sipResponse.getFirstLine());
                    }
                    if (sipListener != null) {
                        SIPTransaction tx = eventWrapper.transaction;
                        if (tx != null) {
                            tx.setPassToListener();
                        }
                        sipListener.processResponse((ResponseEvent)sipEvent);
                    }
                    if (!(sipDialog == null || sipDialog.getState() != null && sipDialog.getState().equals((Object)DialogState.TERMINATED) || sipResponse.getStatusCode() != 481 && sipResponse.getStatusCode() != 408)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logDebug("Removing dialog on 408 or 481 response");
                        }
                        sipDialog.doDeferredDelete();
                    }
                    if (sipResponse.getCSeq().getMethod().equals("INVITE") && sipDialog != null && sipResponse.getStatusCode() == 200) {
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("Warning! unacknowledged dialog. " + sipDialog.getState());
                        }
                        sipDialog.doDeferredDeleteIfNoAckSent(sipResponse.getCSeq().getSeqNumber());
                    }
                }
                catch (Exception ex) {
                    this.sipStack.getStackLogger().logException(ex);
                }
                SIPClientTransaction ct = (SIPClientTransaction)eventWrapper.transaction;
                if (ct != null && 3 == ct.getInternalState() && !ct.getMethod().equals("INVITE")) {
                    ct.clearState();
                }
                Object var10_25 = null;
                if (eventWrapper.transaction == null) return;
                if (!eventWrapper.transaction.passToListener()) return;
                eventWrapper.transaction.releaseSem();
                return;
            }
            catch (Throwable throwable) {
                Object var10_26 = null;
                if (eventWrapper.transaction == null) throw throwable;
                if (!eventWrapper.transaction.passToListener()) throw throwable;
                eventWrapper.transaction.releaseSem();
                throw throwable;
            }
        }
        if (sipEvent instanceof TimeoutEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processTimeout((TimeoutEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logException(ex);
                return;
            }
        }
        if (sipEvent instanceof DialogTimeoutEvent) {
            try {
                if (sipListener != null && sipListener instanceof SipListenerExt) {
                    ((SipListenerExt)sipListener).processDialogTimeout((DialogTimeoutEvent)sipEvent);
                    return;
                }
                if (!this.sipStack.getStackLogger().isLoggingEnabled(32)) return;
                this.sipStack.getStackLogger().logDebug("DialogTimeoutEvent not delivered");
                return;
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logException(ex);
                return;
            }
        }
        if (sipEvent instanceof IOExceptionEvent) {
            try {
                if (sipListener == null) return;
                sipListener.processIOException((IOExceptionEvent)sipEvent);
                return;
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logException(ex);
                return;
            }
        }
        if (sipEvent instanceof TransactionTerminatedEvent) {
            try {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("About to deliver transactionTerminatedEvent");
                    this.sipStack.getStackLogger().logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getClientTransaction());
                    this.sipStack.getStackLogger().logDebug("tx = " + ((TransactionTerminatedEvent)sipEvent).getServerTransaction());
                }
                if (sipListener == null) return;
                sipListener.processTransactionTerminated((TransactionTerminatedEvent)sipEvent);
                return;
            }
            catch (AbstractMethodError ame) {
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logWarning("Unable to call sipListener.processTransactionTerminated");
                return;
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logException(ex);
                return;
            }
        }
        if (!(sipEvent instanceof DialogTerminatedEvent)) {
            this.sipStack.getStackLogger().logFatalError("bad event" + sipEvent);
            return;
        }
        try {
            if (sipListener == null) return;
            sipListener.processDialogTerminated((DialogTerminatedEvent)sipEvent);
            return;
        }
        catch (AbstractMethodError ame) {
            if (!this.sipStack.isLoggingEnabled()) return;
            this.sipStack.getStackLogger().logWarning("Unable to call sipListener.processDialogTerminated");
            return;
        }
        catch (Exception ex) {
            this.sipStack.getStackLogger().logException(ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            ThreadAuditor.ThreadHandle threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
            block10: while (true) {
                EventWrapper eventWrapper = null;
                int[] nArray = this.eventMutex;
                // MONITORENTER : this.eventMutex
                while (this.pendingEvents.isEmpty()) {
                    if (this.isStopped) {
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("Stopped event scanner!!");
                        }
                        // MONITOREXIT : nArray
                        Object var8_7 = null;
                        if (!this.sipStack.isLoggingEnabled(32)) return;
                        if (this.isStopped) return;
                        this.sipStack.getStackLogger().logFatalError("Event scanner exited abnormally");
                        return;
                    }
                    try {
                        threadHandle.ping();
                        this.eventMutex.wait(threadHandle.getPingIntervalInMillisecs());
                    }
                    catch (InterruptedException ex) {
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("Interrupted!");
                        }
                        // MONITOREXIT : nArray
                        Object var8_8 = null;
                        if (!this.sipStack.isLoggingEnabled(32)) return;
                        if (this.isStopped) return;
                        this.sipStack.getStackLogger().logFatalError("Event scanner exited abnormally");
                        return;
                    }
                }
                LinkedList eventsToDeliver = this.pendingEvents;
                this.pendingEvents = new LinkedList();
                // MONITOREXIT : nArray
                ListIterator iterator = eventsToDeliver.listIterator();
                while (true) {
                    if (!iterator.hasNext()) continue block10;
                    eventWrapper = (EventWrapper)iterator.next();
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Processing " + eventWrapper + "nevents " + eventsToDeliver.size());
                    }
                    try {
                        this.deliverEvent(eventWrapper);
                    }
                    catch (Exception e) {
                        if (!this.sipStack.isLoggingEnabled()) continue;
                        this.sipStack.getStackLogger().logError("Unexpected exception caught while delivering event -- carrying on bravely", e);
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!this.sipStack.isLoggingEnabled(32)) throw throwable;
            if (this.isStopped) throw throwable;
            this.sipStack.getStackLogger().logFatalError("Event scanner exited abnormally");
            throw throwable;
        }
    }
}

