/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    private static int uid = 0;
    private static ExecutorService postParseExecutor = null;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            }
            if (ch == '\n') break;
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        final StackLogger stackLogger = this.sipStack.getStackLogger();
        while (true) {
            try {
                SIPMessage sipMessage;
                while (true) {
                    block51: {
                        ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap;
                        String line1;
                        this.sizeCounter = this.maxMessageSize;
                        StringBuilder inputBuffer = new StringBuilder();
                        if (Debug.parserDebug) {
                            Debug.println("Starting parse!");
                        }
                        String line2 = null;
                        try {
                            while ((line1 = this.readLine(inputStream)).equals("\n")) {
                                if (!Debug.parserDebug) continue;
                                Debug.println("Discarding blank line. ");
                            }
                        }
                        catch (IOException ex) {
                            if (postParseExecutor != null) {
                                concurrentHashMap = this.messagesOrderingMap;
                                synchronized (concurrentHashMap) {
                                    try {
                                        this.messagesOrderingMap.wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            Debug.printStackTrace(ex);
                            this.rawInputStream.stopTimer();
                            Object var15_27 = null;
                            try {
                                this.cleanMessageOrderingMap();
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        inputBuffer.append(line1);
                        this.rawInputStream.startTimer();
                        Debug.println("Reading Input Stream");
                        try {
                            do {
                                line2 = this.readLine(inputStream);
                                inputBuffer.append(line2);
                            } while (!line2.trim().equals(""));
                        }
                        catch (IOException ex) {
                            if (postParseExecutor != null) {
                                concurrentHashMap = this.messagesOrderingMap;
                                synchronized (concurrentHashMap) {
                                    try {
                                        this.messagesOrderingMap.wait();
                                    }
                                    catch (InterruptedException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.rawInputStream.stopTimer();
                            Debug.printStackTrace(ex);
                            Object var15_28 = null;
                            try {
                                this.cleanMessageOrderingMap();
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        this.rawInputStream.stopTimer();
                        inputBuffer.append(line2);
                        sipMessage = null;
                        try {
                            if (stackLogger.isLoggingEnabled(32)) {
                                stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                            }
                            if ((sipMessage = this.smp.parseSIPMessage(inputBuffer.toString().getBytes(), false, false, this.sipMessageListener)) == null) {
                                this.rawInputStream.stopTimer();
                            }
                            break block51;
                        }
                        catch (ParseException ex) {
                            stackLogger.logError("Detected a parse error", ex);
                        }
                        continue;
                    }
                    if (Debug.debug) {
                        Debug.println("Completed parsing message");
                    }
                    ContentLength cl = (ContentLength)sipMessage.getContentLength();
                    int contentLength = 0;
                    contentLength = cl != null ? cl.getContentLength() : 0;
                    if (Debug.debug) {
                        Debug.println("contentLength " + contentLength);
                    }
                    if (contentLength == 0) {
                        sipMessage.removeContent();
                    } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                        int readlength;
                        byte[] message_body = new byte[contentLength];
                        for (int nread = 0; nread < contentLength; nread += readlength) {
                            Object var13_26;
                            this.rawInputStream.startTimer();
                            try {
                                try {
                                    readlength = inputStream.read(message_body, nread, contentLength - nread);
                                    if (readlength > 0) {
                                    } else {
                                        var13_26 = null;
                                        this.rawInputStream.stopTimer();
                                        break;
                                    }
                                    var13_26 = null;
                                    this.rawInputStream.stopTimer();
                                    continue;
                                }
                                catch (IOException ex) {
                                    stackLogger.logError("Exception Reading Content", ex);
                                    var13_26 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                var13_26 = null;
                                this.rawInputStream.stopTimer();
                                throw throwable;
                            }
                        }
                        sipMessage.setMessageContent(message_body);
                    }
                    if (this.sipMessageListener != null) break;
                }
                try {
                    CallIDOrderingStructure newCallIDOrderingStructure;
                    if (postParseExecutor == null) {
                        this.sipMessageListener.processMessage(sipMessage);
                        continue;
                    }
                    final String callId = sipMessage.getCallId().getCallId();
                    CallIDOrderingStructure orderingStructure = this.messagesOrderingMap.get(callId);
                    if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure())) == null) {
                        orderingStructure = newCallIDOrderingStructure;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("new CallIDOrderingStructure added for message " + sipMessage);
                        }
                    }
                    final CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                    callIDOrderingStructure.getMessagesForCallID().offer(sipMessage);
                    Thread messageDispatchTask = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            Semaphore semaphore = callIDOrderingStructure.getSemaphore();
                            Queue<SIPMessage> messagesForCallID = callIDOrderingStructure.getMessagesForCallID();
                            try {
                                semaphore.acquire();
                            }
                            catch (InterruptedException e) {
                                stackLogger.logError("Semaphore acquisition for callId " + callId + " interrupted", e);
                            }
                            SIPMessage message = messagesForCallID.poll();
                            if (stackLogger.isLoggingEnabled(32)) {
                                stackLogger.logDebug("semaphore acquired for message " + message);
                            }
                            try {
                                try {
                                    PipelinedMsgParser.this.sipMessageListener.processMessage(message);
                                }
                                catch (Exception e) {
                                    stackLogger.logError("Error occured processing message", e);
                                    Object var6_6 = null;
                                    if (callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                                        PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                                        if (stackLogger.isLoggingEnabled(32)) {
                                            stackLogger.logDebug("CallIDOrderingStructure removed for message " + callId);
                                        }
                                    }
                                    if (stackLogger.isLoggingEnabled(32)) {
                                        stackLogger.logDebug("releasing semaphore for message " + message);
                                    }
                                    semaphore.release();
                                    if (!PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) return;
                                    ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                                    synchronized (concurrentHashMap) {
                                        PipelinedMsgParser.this.messagesOrderingMap.notify();
                                        return;
                                    }
                                }
                                Object var6_5 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_7 = null;
                                if (callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                                    PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                                    if (stackLogger.isLoggingEnabled(32)) {
                                        stackLogger.logDebug("CallIDOrderingStructure removed for message " + callId);
                                    }
                                }
                                if (stackLogger.isLoggingEnabled(32)) {
                                    stackLogger.logDebug("releasing semaphore for message " + message);
                                }
                                semaphore.release();
                                if (!PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) throw throwable;
                                ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                                synchronized (concurrentHashMap) {
                                    PipelinedMsgParser.this.messagesOrderingMap.notify();
                                    throw throwable;
                                }
                            }
                            if (callIDOrderingStructure.getMessagesForCallID().size() <= 0) {
                                PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                                if (stackLogger.isLoggingEnabled(32)) {
                                    stackLogger.logDebug("CallIDOrderingStructure removed for message " + callId);
                                }
                            }
                            if (stackLogger.isLoggingEnabled(32)) {
                                stackLogger.logDebug("releasing semaphore for message " + message);
                            }
                            semaphore.release();
                            if (!PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) return;
                            ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                            synchronized (concurrentHashMap) {
                                PipelinedMsgParser.this.messagesOrderingMap.notify();
                                return;
                            }
                        }
                    };
                    postParseExecutor.execute(messageDispatchTask);
                }
                catch (Exception ex) {
                    Object var15_29 = null;
                    try {
                        this.cleanMessageOrderingMap();
                        inputStream.close();
                    }
                    catch (IOException e) {
                        InternalErrorHandler.handleException(e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var15_30 = null;
                try {
                    this.cleanMessageOrderingMap();
                    inputStream.close();
                }
                catch (IOException e) {
                    InternalErrorHandler.handleException(e);
                }
                throw throwable;
            }
        }
    }

    public static void setPostParseExcutorSize(int threads) {
        if (postParseExecutor == null) {
            postParseExecutor = threads <= 0 ? null : Executors.newFixedThreadPool(threads);
        }
    }

    public void close() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (postParseExecutor != null) {
            postParseExecutor.shutdown();
            postParseExecutor = null;
        }
        this.cleanMessageOrderingMap();
    }

    private void cleanMessageOrderingMap() {
        for (CallIDOrderingStructure callIDOrderingStructure : this.messagesOrderingMap.values()) {
            callIDOrderingStructure.getSemaphore().release();
            callIDOrderingStructure.getMessagesForCallID().clear();
        }
        this.messagesOrderingMap.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CallIDOrderingStructure {
        private Semaphore semaphore = new Semaphore(1, true);
        private Queue<SIPMessage> messagesForCallID = new ConcurrentLinkedQueue<SIPMessage>();

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public Queue<SIPMessage> getMessagesForCallID() {
            return this.messagesForCallID;
        }
    }
}

