/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.mime.MinimalField;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.descriptor.ContentDescriptor;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.parser.Field;

@NotThreadSafe
public class FormBodyPart
extends BodyPart {
    private final String name;

    public FormBodyPart(String name, ContentBody body) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = name;
        Header header = new Header();
        this.setHeader(header);
        this.setBody(body);
        this.generateContentDisp(body);
        this.generateContentType(body);
        this.generateTransferEncoding(body);
    }

    public String getName() {
        return this.name;
    }

    protected void generateContentDisp(ContentBody body) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body.getFilename());
            buffer.append("\"");
        }
        this.addField("Content-Disposition", buffer.toString());
    }

    protected void generateContentType(ContentDescriptor desc) {
        if (desc.getMimeType() != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(desc.getMimeType());
            if (desc.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(desc.getCharset());
            }
            this.addField("Content-Type", buffer.toString());
        }
    }

    protected void generateTransferEncoding(ContentDescriptor desc) {
        if (desc.getTransferEncoding() != null) {
            this.addField("Content-Transfer-Encoding", desc.getTransferEncoding());
        }
    }

    private void addField(String name, String value) {
        this.getHeader().addField((Field)new MinimalField(name, value));
    }
}

