/*
 * Decompiled with CFR 0.152.
 */
package test.tck;

import gov.nist.javax.sip.address.AddressFactoryImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.sip.SipFactory;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import test.tck.TckInternalError;

public class TestHarness
extends TestCase {
    private static final String PATH_GOV_NIST = "gov.nist";
    protected static final String IMPLEMENTATION_PATH = "javax.sip.tck.PATH";
    protected static final String ABORT_ON_FAIL = "javax.sip.tck.ABORT_ON_FAIL";
    protected static final String LOG_FILE_NAME = "javax.sip.tck.LOG_FILE";
    protected static final String LOCAL_ADDRESS = "127.0.0.1";
    protected static final int TI_PORT = 5060;
    protected static final int RI_PORT = 6050;
    protected static String logFileName = "tcklog.txt";
    protected static String path = null;
    protected static PrintWriter printWriter;
    protected static boolean abortOnFail;
    private static boolean testPassed;
    protected static MessageFactory tiMessageFactory;
    protected static HeaderFactory tiHeaderFactory;
    protected static AddressFactory tiAddressFactory;
    protected static MessageFactory riMessageFactory;
    protected static HeaderFactory riHeaderFactory;
    protected static AddressFactory riAddressFactory;
    protected static int testCounter;
    protected static SipFactory riFactory;
    protected static SipFactory tiFactory;
    protected TestResult testResult;
    private static Logger logger;
    private static String currentMethodName;
    private static String currentClassName;
    protected static Appender console;

    private static void println(String messageToPrint) {
        logger.info((Object)messageToPrint);
    }

    protected TestHarness() {
    }

    protected String getImplementationPath() {
        return System.getProperties().getProperty(IMPLEMENTATION_PATH, PATH_GOV_NIST);
    }

    public TestHarness(String name) {
        this(name, false);
    }

    protected TestHarness(String name, boolean autoDialog) {
        super(name);
        this.testResult = new TestResult();
        TestHarness.getRIFactories(autoDialog);
        TestHarness.getTIFactories();
    }

    private static void logSuccess(String message) {
        ++testCounter;
        Throwable throwable = new Throwable();
        StackTraceElement[] frameset = throwable.getStackTrace();
        StackTraceElement frame = frameset[2];
        String className = frame.getClassName();
        logger.info((Object)(className + ":" + frame.getMethodName() + "(" + frame.getFileName() + ":" + frame.getLineNumber() + ")" + " : Status =  passed ! "));
        String methodName = frame.getMethodName();
        if (currentMethodName == null || !methodName.equals(currentMethodName) || !currentClassName.equals(className)) {
            currentClassName = className;
            currentMethodName = methodName;
            System.out.println("\n");
            System.out.print(currentClassName + ":" + currentMethodName);
        }
    }

    private static void logSuccess() {
        Throwable throwable = new Throwable();
        StackTraceElement[] frameset = throwable.getStackTrace();
        StackTraceElement frame = frameset[2];
        String className = frame.getClassName();
        logger.info((Object)(className + ":" + frame.getMethodName() + ": Status =  passed ! "));
        String methodName = frame.getMethodName();
        if (currentMethodName == null || !methodName.equals(currentMethodName) || !currentClassName.equals(className)) {
            currentClassName = className;
            currentMethodName = methodName;
            System.out.println("\n");
            System.out.print(currentClassName + ":" + currentMethodName);
        }
    }

    private static void logFailureDetails(String reason) {
        Throwable throwable = new Throwable();
        StackTraceElement[] frameset = throwable.getStackTrace();
        StackTraceElement frame = frameset[2];
        String className = frame.getClassName();
        TestHarness.logFailure(className, frame.getMethodName(), reason);
    }

    private static void logFailure(String className, String methodName, String reason) {
        TestHarness.println(" Test in function " + className + ":" + methodName + " failed because of " + reason);
        StringWriter stringWriter = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(stringWriter));
        TestHarness.println(stringWriter.getBuffer().toString());
        testPassed = false;
        if (abortOnFail) {
            new Exception().printStackTrace();
            System.exit(0);
        }
    }

    private static void logFailure(String reason) {
        TestHarness.logFailureDetails(reason);
    }

    public static void assertTrue(boolean cond) {
        if (cond) {
            TestHarness.logSuccess();
        } else {
            TestHarness.logFailure("assertTrue failed");
        }
        if (!cond) {
            new Exception().printStackTrace();
            TestHarness.fail("assertion failure");
        }
        TestCase.assertTrue((boolean)cond);
    }

    public static void assertTrue(String diagnostic, boolean cond) {
        if (cond) {
            TestHarness.logSuccess("assertTrue " + diagnostic);
        } else {
            TestHarness.logFailure(diagnostic);
        }
        if (!cond) {
            new Exception(diagnostic).printStackTrace();
            TestHarness.fail(diagnostic + " : Assertion Failure ");
        }
        TestCase.assertTrue((String)diagnostic, (boolean)cond);
    }

    public static void assertEquals(Object me, Object him) {
        if (me == him) {
            TestHarness.logSuccess();
        } else if (me == null && him != null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (me != null && him == null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (!me.equals(him)) {
            TestHarness.logFailure("assertEquals failed");
        }
        TestCase.assertEquals((Object)me, (Object)him);
    }

    public static void assertEquals(String me, String him) {
        if (me == him) {
            TestHarness.logSuccess();
        } else if (me == null && him != null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (me != null && him == null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (!me.equals(him)) {
            TestHarness.logFailure("assertEquals failed");
        }
        TestCase.assertEquals((String)me, (String)him);
    }

    public static void assertEquals(String reason, Object me, Object him) {
        if (me == him) {
            TestHarness.logSuccess("assertEquals : " + reason);
        } else if (me == null && him != null) {
            TestHarness.logFailure("assertEquals failed:" + reason);
        } else if (me != null && him == null) {
            TestHarness.logFailure("assertEquals failed:" + reason);
        } else if (!me.equals(him)) {
            TestHarness.logFailure(reason);
        }
        TestCase.assertEquals((String)reason, (Object)me, (Object)him);
    }

    public static void assertEquals(String reason, String me, String him) {
        if (me == him) {
            TestHarness.logSuccess("assertEquals " + reason);
        } else if (me == null && him != null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (me != null && him == null) {
            TestHarness.logFailure("assertEquals failed");
        } else if (!me.equals(him)) {
            TestHarness.logFailure("assertEquals failed");
        }
        TestCase.assertEquals((String)reason, (String)me, (String)him);
    }

    public static void assertNotNull(String reason, Object thing) {
        if (thing != null) {
            TestHarness.logSuccess("assertNotNull " + reason);
        } else {
            TestHarness.logFailure(reason);
        }
        TestCase.assertNotNull((String)reason, (Object)thing);
    }

    public static void assertNull(String reason, Object thing) {
        if (thing == null) {
            TestHarness.logSuccess("assertNull " + reason);
        } else {
            TestHarness.logFailure(reason);
        }
        TestCase.assertNull((String)reason, (Object)thing);
    }

    public static void assertSame(String diagnostic, Object thing, Object thingie) {
        if (thing == thingie) {
            TestHarness.logSuccess("assertSame " + diagnostic);
        } else {
            TestHarness.logFailure(diagnostic);
        }
        TestCase.assertSame((String)diagnostic, (Object)thing, (Object)thingie);
    }

    public static void fail(String message) {
        TestHarness.logFailure(message);
        TestCase.fail((String)message);
    }

    public static void fail(String message, Exception ex) {
        TestHarness.logFailure(message);
        logger.error((Object)message, (Throwable)ex);
        TestCase.fail((String)message);
    }

    public static void fail() {
        TestHarness.logFailure("Unknown reason for failure. Check logs for more info.");
        new Exception().printStackTrace();
        TestCase.fail();
    }

    public static void checkImplementsInterface(Class implementationClass, Class jainInterface) {
        TestHarness.assertTrue(jainInterface.toString() + " is_assignable_from " + implementationClass.toString(), jainInterface.isAssignableFrom(implementationClass));
    }

    public static boolean implementsInterface(Class implementationClass, Class jainInterface) {
        return jainInterface.isAssignableFrom(implementationClass);
    }

    static void getTIFactories() {
        try {
            tiFactory = SipFactory.getInstance();
            tiFactory.resetFactory();
            String tiPathName = System.getProperty(IMPLEMENTATION_PATH, PATH_GOV_NIST);
            tiFactory.setPathName(tiPathName);
            tiAddressFactory = tiFactory.createAddressFactory();
            tiHeaderFactory = tiFactory.createHeaderFactory();
            tiMessageFactory = tiFactory.createMessageFactory();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Cannot get TI factories -- cannot proceed! Bailing");
            System.exit(0);
        }
        if (tiAddressFactory == null || tiMessageFactory == null || tiHeaderFactory == null) {
            System.out.println("Cannot get TI factories --  cannot proceed! Bailing!!");
            System.exit(0);
        }
    }

    static void getRIFactories(boolean autoDialog) {
        try {
            riFactory = SipFactory.getInstance();
            if (riFactory == null) {
                throw new TckInternalError("could not get SipFactory");
            }
            riFactory.resetFactory();
            riFactory.setPathName(PATH_GOV_NIST);
            riAddressFactory = riFactory.createAddressFactory();
            TestHarness.assertTrue("RI must be gov.nist implementation", riAddressFactory instanceof AddressFactoryImpl);
            riHeaderFactory = riFactory.createHeaderFactory();
            riMessageFactory = riFactory.createMessageFactory();
        }
        catch (Exception ex) {
            throw new TckInternalError("Could not get factories");
        }
    }

    public void logTestCompleted() {
        TestCase.assertTrue((boolean)testPassed);
        logger.info((Object)(this.getName() + " Completed"));
    }

    public void logTestCompleted(String info) {
        TestCase.assertTrue((boolean)testPassed);
        logger.info((Object)(this.getName() + ":" + info + " Completed"));
    }

    public static Properties getRiProperties(boolean autoDialog) {
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "RiStack");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "logs/riDebugLog.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "logs/riMessageLog.txt");
        properties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", autoDialog ? "ON" : "OFF");
        properties.setProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "true");
        properties.setProperty("javax.sip.OUTBOUND_PROXY", "127.0.0.1:5060/udp");
        return properties;
    }

    public static Properties getTiProperties() {
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "TiStack");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "logs/tiDebugLog.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "logs/tiMessageLog.txt");
        properties.setProperty("javax.sip.OUTBOUND_PROXY", "127.0.0.1:6050/udp");
        return properties;
    }

    public void setUp() throws Exception {
        testPassed = true;
    }

    public void tearDown() throws Exception {
        TestHarness.assertTrue("Test failed. See log for details.", testPassed);
    }

    static {
        abortOnFail = true;
        testPassed = true;
        logger = Logger.getLogger((String)"test.tck");
        console = new ConsoleAppender((Layout)new SimpleLayout());
        try {
            Properties tckProperties = new Properties();
            tckProperties.load(TestHarness.class.getClassLoader().getResourceAsStream("tck.properties"));
            Enumeration<?> props = tckProperties.propertyNames();
            while (props.hasMoreElements()) {
                String propname = (String)props.nextElement();
                System.setProperty(propname, tckProperties.getProperty(propname));
            }
            path = System.getProperties().getProperty(IMPLEMENTATION_PATH);
            String flag = System.getProperties().getProperty(ABORT_ON_FAIL);
            String lf = System.getProperties().getProperty(LOG_FILE_NAME);
            if (lf != null) {
                logFileName = lf;
            }
            abortOnFail = flag != null && flag.equalsIgnoreCase("true");
            BasicConfigurator.configure();
            if (lf != null) {
                logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), logFileName));
            } else {
                logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), "tckoutput.txt"));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

