/*
 * Decompiled with CFR 0.152.
 */
package test.tck.factory;

import java.text.ParseException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.address.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.factory.FactoryTestHarness;

public class AddressFactoryTest
extends FactoryTestHarness {
    public AddressFactoryTest() {
        super("AddressFactoryTest");
    }

    protected URI createTiURI(String uriString) {
        URI uri = null;
        try {
            uri = tiAddressFactory.createURI(uriString);
            AddressFactoryTest.assertTrue(uri != null);
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        return uri;
    }

    protected URI createRiURI(String uriString) {
        URI uri = null;
        try {
            uri = riAddressFactory.createURI(uriString);
        }
        catch (Exception ex) {
            throw new TckInternalError(ex.getMessage());
        }
        return uri;
    }

    protected SipURI createTiSipURI(String name, String address) {
        SipURI sipUri = null;
        try {
            sipUri = tiAddressFactory.createSipURI(name, address);
            AddressFactoryTest.assertNotNull((Object)sipUri);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TiUnexpectedError(ex.getMessage());
        }
        return sipUri;
    }

    protected SipURI createRiSipURI(String name, String address) {
        SipURI sipUri = null;
        try {
            sipUri = riAddressFactory.createSipURI(name, address);
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        return sipUri;
    }

    protected TelURL createTiTelURL(String phoneNumber) {
        TelURL telUrl = null;
        try {
            telUrl = tiAddressFactory.createTelURL(phoneNumber);
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        return telUrl;
    }

    protected TelURL createRiTelURLFromTiTelURL(TelURL tiTelURL) {
        TelURL telUrl = null;
        try {
            String phoneNumber = tiTelURL.getPhoneNumber();
            telUrl = riAddressFactory.createTelURL(phoneNumber);
            telUrl.setGlobal(tiTelURL.isGlobal());
            telUrl.setPhoneContext(tiTelURL.getPhoneContext());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TiUnexpectedError(ex.getMessage());
        }
        return telUrl;
    }

    protected TelURL createRiTelURL(String phoneNumber) {
        TelURL telUrl = null;
        try {
            telUrl = riAddressFactory.createTelURL(phoneNumber);
        }
        catch (Exception ex) {
            throw new TckInternalError(ex.getMessage());
        }
        return telUrl;
    }

    protected Address createAddress(String address) {
        Address addr = null;
        try {
            addr = tiAddressFactory.createAddress(address);
            AddressFactoryTest.assertTrue(addr != null);
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        return addr;
    }

    protected Address createAddress(URI uri) {
        Address addr = null;
        try {
            System.out.println("Uri = " + uri);
            addr = tiAddressFactory.createAddress(uri);
            System.out.println("addr = " + addr);
            System.out.println("createAddress returns " + tiAddressFactory.createAddress(uri.toString()));
            AddressFactoryTest.assertTrue(addr.equals(tiAddressFactory.createAddress(uri.toString())));
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        return addr;
    }

    protected Address createRiAddress(URI uri) {
        Address addr = null;
        try {
            addr = riAddressFactory.createAddress(uri);
        }
        catch (Exception ex) {
            throw new TckInternalError(ex.getMessage());
        }
        return addr;
    }

    protected Address createRiAddress(String address) {
        Address addr = null;
        try {
            addr = riAddressFactory.createAddress(address);
            AddressFactoryTest.assertTrue(addr != null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TckInternalError(ex.getMessage());
        }
        return addr;
    }

    protected Address createRiAddressFromTiAddress(Address tiAddress) throws TiUnexpectedError {
        try {
            return riAddressFactory.createAddress(tiAddress.toString());
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
    }

    public void testStar() {
        try {
            Address star = tiAddressFactory.createAddress("*");
            AddressFactoryTest.assertTrue(star.isWildcard());
            AddressFactoryTest.assertTrue(star.getURI().isSipURI());
            AddressFactoryTest.assertEquals("*", ((SipURI)star.getURI()).getUser());
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            AddressFactoryTest.fail(pe.getMessage());
        }
    }

    public void testAddressFactory() {
        try {
            Address riAddress;
            int i;
            for (i = 0; i < urls.length; ++i) {
                URI uri = this.createTiURI(urls[i]);
                AddressFactoryTest.assertNotNull((Object)uri);
                Address tiAddress = this.createAddress(uri);
                AddressFactoryTest.assertNotNull((Object)tiAddress);
                URI riUri = this.createRiURI(urls[i]);
                riAddress = this.createRiAddress(riUri);
                tiAddress = this.createRiAddress(tiAddress.toString());
                AddressFactoryTest.assertEquals(riAddress, this.createRiAddressFromTiAddress(tiAddress));
            }
            for (i = 0; i < hosts.length; ++i) {
                SipURI tiSipURI = this.createTiSipURI(null, hosts[i]);
                AddressFactoryTest.assertTrue(tiSipURI != null);
                AddressFactoryTest.assertTrue(tiSipURI.isSipURI());
                AddressFactoryTest.assertTrue(!tiSipURI.isSecure());
                AddressFactoryTest.assertTrue(((SipURI)tiAddressFactory.createURI("sip:" + hosts[i])).equals(tiSipURI));
                SipURI riSipURI = this.createRiSipURI(null, hosts[i]);
                Address tiAddress = this.createAddress((URI)tiSipURI);
                AddressFactoryTest.assertTrue(tiAddress != null);
                riAddress = this.createRiAddress((URI)riSipURI);
                AddressFactoryTest.assertTrue(riAddress.equals(this.createRiAddressFromTiAddress(tiAddress)));
                tiSipURI = this.createTiSipURI("jaintck", hosts[i]);
                AddressFactoryTest.assertTrue(tiSipURI != null);
                AddressFactoryTest.assertTrue(tiSipURI.isSipURI());
                AddressFactoryTest.assertTrue(!tiSipURI.isSecure());
                AddressFactoryTest.assertTrue(((SipURI)tiAddressFactory.createURI("sip:jaintck@" + hosts[i])).equals(tiSipURI));
                tiAddress = this.createAddress((URI)tiSipURI);
                AddressFactoryTest.assertTrue(tiAddress != null);
                riSipURI = this.createRiSipURI("jaintck", hosts[i]);
                riAddress = this.createRiAddress((URI)riSipURI);
                AddressFactoryTest.assertTrue(riAddress.equals(this.createRiAddressFromTiAddress(tiAddress)));
            }
            for (i = 0; i < phoneNumbers.length; ++i) {
                TelURL tiTelUrl = this.createTiTelURL(phoneNumbers[i]);
                AddressFactoryTest.assertTrue(tiTelUrl != null);
                TelURL riTelUrl = this.createRiTelURL(phoneNumbers[i]);
                System.out.println("TI:" + tiTelUrl);
                System.out.println("RI:" + riTelUrl);
                AddressFactoryTest.assertEquals(riTelUrl, this.createRiTelURLFromTiTelURL(tiTelUrl));
            }
            for (i = 0; i < telUrls.length; ++i) {
                TelURL telUrl = (TelURL)this.createTiURI(telUrls[i]);
                AddressFactoryTest.assertTrue(telUrl != null);
                int start = telUrl.toString().indexOf(58);
                String phone = telUrl.toString().substring(start + 1).trim();
                TelURL tiTelUrl = this.createTiTelURL(phone);
                tiTelUrl.setGlobal(telUrl.isGlobal());
                AddressFactoryTest.assertTrue(telUrl.equals(tiTelUrl));
            }
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testAddressFactory()");
        }
    }

    public void testTelURL() throws Exception {
        URI telURL = tiAddressFactory.createURI("tel:0123456789ABCDEF#*-.();isub=/:-_.!~*'();phone-context=+123-.();-=[]/:");
        AddressFactoryTest.assertTrue(telURL instanceof TelURL);
        TelURL t = (TelURL)telURL;
        AddressFactoryTest.assertEquals("0123456789ABCDEF#*-.()", t.getPhoneNumber());
        AddressFactoryTest.assertEquals("+123-.()", t.getPhoneContext());
        AddressFactoryTest.assertEquals("/:-_.!~*'()", t.getIsdnSubAddress());
        AddressFactoryTest.assertEquals("[]/:", t.getParameter("-"));
    }

    public void setUp() {
    }

    public static Test suite() {
        return new TestSuite(AddressFactoryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AddressFactoryTest.class);
    }
}

