/*
 * Decompiled with CFR 0.152.
 */
package test.tck.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import javax.sip.address.SipURI;
import javax.sip.address.TelURL;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.DateHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.factory.FactoryTestHarness;

public class HeaderFactoryTest
extends FactoryTestHarness {
    private static Logger logger = Logger.getLogger(HeaderFactoryTest.class);

    private void testGetMethods(Header refHeader, Header headerToTest) throws IllegalAccessException, InvocationTargetException {
        try {
            String name = refHeader.getName();
            Class<?> implementationClass = refHeader.getClass();
            Class<?>[] implementedInterfaces = implementationClass.getInterfaces();
            int j = 0;
            for (j = 0; j < implementedInterfaces.length && !Header.class.isAssignableFrom(implementedInterfaces[j]); ++j) {
            }
            if (j == implementedInterfaces.length) {
                logger.fatal((Object)("Hmm... could not find it" + refHeader.getClass()));
                throw new TckInternalError("Header not implemented");
            }
            String jainClassName = implementedInterfaces[j].getName();
            HeaderFactoryTest.checkImplementsInterface(headerToTest.getClass(), implementedInterfaces[j]);
            Method[] methods = implementedInterfaces[j].getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Object testValue;
                String methodName = methods[i].getName();
                if (!methodName.startsWith("get") || methodName.equals("getParameter")) continue;
                Class<?> returnType = methods[i].getReturnType();
                Object refType = null;
                try {
                    refType = methods[i].invoke((Object)refHeader, (Object[])null);
                }
                catch (InvocationTargetException ex1) {
                    ex1.getCause().printStackTrace();
                    throw new TckInternalError("Invocation failure " + methodName);
                }
                String ftype = returnType.toString();
                if (returnType.isPrimitive()) {
                    testValue = methods[i].invoke((Object)headerToTest, (Object[])null);
                    HeaderFactoryTest.assertTrue(testValue.equals(refType));
                    continue;
                }
                testValue = methods[i].invoke((Object)headerToTest, (Object[])null);
                if (refType != null) {
                    if (refType instanceof Calendar || refType instanceof Iterator) continue;
                    HeaderFactoryTest.assertEquals("Method:" + methods[i], refType, testValue);
                    continue;
                }
                HeaderFactoryTest.assertNull((Object)testValue);
            }
            if (refHeader instanceof Parameters) {
                Parameters p1 = (Parameters)refHeader;
                Parameters p2 = (Parameters)headerToTest;
                Iterator it = ((Parameters)refHeader).getParameterNames();
                while (it.hasNext()) {
                    String pname = (String)it.next();
                    HeaderFactoryTest.assertEquals(p1.getParameter(pname), p2.getParameter(pname));
                }
            }
        }
        catch (InvocationTargetException ex) {
            ex.getCause().printStackTrace();
            throw new TiUnexpectedError(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TiUnexpectedError(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testGetMethods(refHeader,headerToTest)");
        }
    }

    public void testHeaderFactory() {
        try {
            Header headerToTest;
            StringBuffer value;
            int i;
            for (i = 0; i < headers.length; ++i) {
                value = new StringBuffer(headers[i]);
                StringBuffer name = new StringBuffer();
                StringBuffer body = new StringBuffer();
                int j = 0;
                for (j = 0; j < value.length() && value.charAt(j) != ':'; ++j) {
                    name.append(value.charAt(j));
                }
                ++j;
                while (j < value.length()) {
                    body.append(value.charAt(j));
                    ++j;
                }
                Header riHeader = null;
                Object tiHeader = null;
                try {
                    riHeader = riHeaderFactory.createHeader(name.toString().trim(), body.toString().trim());
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    throw new TckInternalError(ex.getMessage());
                }
                headerToTest = tiHeaderFactory.createHeader(name.toString().trim(), body.toString().trim());
                HeaderFactoryTest.assertTrue(headerToTest != null);
                logger.info((Object)("Testing header: " + name + " = " + body));
                this.testGetMethods(riHeader, headerToTest);
            }
            for (i = 0; i < multiHeaders.length; ++i) {
                value = new StringBuffer(multiHeaders[i]);
                List riHeaders = null;
                List tiHeaders = null;
                try {
                    riHeaders = riHeaderFactory.createHeaders(multiHeaders[i]);
                }
                catch (ParseException ex) {
                    throw new TckInternalError(ex.getMessage());
                }
                tiHeaders = tiHeaderFactory.createHeaders(multiHeaders[i]);
                HeaderFactoryTest.assertTrue(tiHeaders != null);
                HeaderFactoryTest.assertTrue(tiHeaders.size() == riHeaders.size());
                ListIterator li = riHeaders.listIterator();
                ListIterator li1 = tiHeaders.listIterator();
                while (li.hasNext()) {
                    Header riHeader = (Header)li.next();
                    headerToTest = (Header)li1.next();
                    this.testGetMethods(riHeader, headerToTest);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TiUnexpectedError(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testHeaderFactory()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDate() {
        try {
            Calendar date = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            date.setTimeInMillis(0L);
            DateHeader dh = tiHeaderFactory.createDateHeader(date);
            HeaderFactoryTest.assertEquals("Date: Thu, 01 Jan 1970 00:00:00 GMT", dh.toString().trim());
        }
        finally {
            this.logTestCompleted("testDate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeaderParams() {
        try {
            Header h = tiHeaderFactory.createHeader("m", "sip:User1@127.0.0.1:1234;param1");
            System.err.println(h);
            HeaderFactoryTest.assertTrue(h instanceof ContactHeader);
            ContactHeader c = (ContactHeader)h;
            URI u = c.getAddress().getURI();
            HeaderFactoryTest.assertTrue(u.isSipURI());
            HeaderFactoryTest.assertNull("URI must have no params", ((SipURI)u).getParameter("param1"));
            HeaderFactoryTest.assertNotNull("Parameter 'param1' must be assigned to the header", c.getParameter("param1"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            HeaderFactoryTest.fail(e.getMessage());
        }
        finally {
            this.logTestCompleted("testHeaderParams()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeaderParams2() {
        try {
            Header h = tiHeaderFactory.createHeader("From", "sip:07077004201@x.com;tag=gc2zbu");
            System.err.println(h);
            HeaderFactoryTest.assertTrue(h instanceof FromHeader);
            FromHeader c = (FromHeader)h;
            URI u = c.getAddress().getURI();
            HeaderFactoryTest.assertTrue(u.isSipURI());
            HeaderFactoryTest.assertFalse((String)"URI must have no params", (boolean)((SipURI)u).getParameterNames().hasNext());
            HeaderFactoryTest.assertNotNull("Parameter 'tag' must be assigned to the header", c.getTag());
        }
        catch (ParseException e) {
            e.printStackTrace();
            HeaderFactoryTest.fail(e.getMessage());
        }
        finally {
            this.logTestCompleted("testHeaderParams2()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeaderParams3() {
        try {
            Header h = tiHeaderFactory.createHeader("From", "tel:07077004201;tag=gc2zbu");
            System.err.println(h);
            HeaderFactoryTest.assertTrue(h instanceof FromHeader);
            FromHeader c = (FromHeader)h;
            URI u = c.getAddress().getURI();
            HeaderFactoryTest.assertTrue(u instanceof TelURL);
            HeaderFactoryTest.assertFalse((String)"URI must have no params", (boolean)((TelURL)u).getParameterNames().hasNext());
            HeaderFactoryTest.assertNotNull("Parameter 'tag' must be assigned to the header", c.getTag());
        }
        catch (ParseException e) {
            e.printStackTrace();
            HeaderFactoryTest.fail(e.getMessage());
        }
        finally {
            this.logTestCompleted("testHeaderParams3()");
        }
    }

    public HeaderFactoryTest() {
        super("HeaderFactoryTest");
    }

    public static void main(String[] args) {
        TestRunner.run(HeaderFactoryTest.class);
    }
}

