/*
 * Decompiled with CFR 0.152.
 */
package test.tck.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExtensionHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.factory.FactoryTestHarness;

public class MessageFactoryTest
extends FactoryTestHarness {
    protected String method;
    protected URI tiRequestURI;
    protected CallIdHeader ticallId;
    protected FromHeader tifrom;
    protected ToHeader tito;
    protected MaxForwardsHeader timaxForwards;
    protected ContentTypeHeader ticontentType;
    protected List tivia;
    protected CSeqHeader ticSeq;
    protected ExtensionHeader tiextensionHeader;
    protected URI riRequestURI;
    protected CallIdHeader ricallId;
    protected FromHeader rifrom;
    protected ToHeader rito;
    protected MaxForwardsHeader rimaxForwards;
    protected ContentTypeHeader ricontentType;
    protected List rivia;
    protected CSeqHeader ricSeq;
    protected ExtensionHeader riextensionHeader;
    protected byte[] contentBytes;
    protected Object contentObject;
    protected int statusCode;

    public MessageFactoryTest() {
        super("MessageFactoryTest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneTest(Request request) {
        try {
            Request newRequest = (Request)request.clone();
            MessageFactoryTest.assertEquals(newRequest, request);
            newRequest.setMethod("FOOBAR");
            MessageFactoryTest.assertFalse((boolean)newRequest.equals(request));
            newRequest = (Request)request.clone();
            Header extensionHeader = tiHeaderFactory.createHeader("My-Header", "my header value");
            request.addHeader(extensionHeader);
            MessageFactoryTest.assertFalse((boolean)newRequest.equals(request));
            request.removeHeader("My-Header");
            MessageFactoryTest.assertEquals(newRequest, request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("cloneTest(request)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneTest(Response response) {
        try {
            Response newResponse = (Response)response.clone();
            MessageFactoryTest.assertEquals(newResponse, response);
            MessageFactoryTest.assertNotSame((Object)newResponse, (Object)response);
            newResponse = (Response)response.clone();
            Header extensionHeader = tiHeaderFactory.createHeader("My-Header", "my header value");
            newResponse.addHeader(extensionHeader);
            MessageFactoryTest.assertFalse((boolean)newResponse.equals(response));
            newResponse.removeHeader("My-Header");
            MessageFactoryTest.assertEquals(newResponse, response);
        }
        catch (ParseException ex) {
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("cloneTest(response)");
        }
    }

    private void testAgainstRIMsg(Message tiMsg, Message riMsg) {
        MessageFactoryTest.assertEquals(riMsg.getHeader("From"), tiMsg.getHeader("From"));
        MessageFactoryTest.assertEquals(riMsg.getHeader("To"), tiMsg.getHeader("To"));
        MessageFactoryTest.assertEquals(riMsg.getHeader("Via"), tiMsg.getHeader("Via"));
        MessageFactoryTest.assertEquals(riMsg.getHeader("Call-ID"), tiMsg.getHeader("Call-ID"));
        MessageFactoryTest.assertEquals(riMsg.getHeader("CSeq"), tiMsg.getHeader("CSeq"));
    }

    private void testAgainstRIMsgContent(Message tiMsg, Message riMsg) {
        MessageFactoryTest.assertEquals(riMsg.getHeader("Content-Length"), tiMsg.getHeader("Content-Length"));
        MessageFactoryTest.assertEquals(riMsg.getHeader("Content-Type"), tiMsg.getHeader("Content-Type"));
        MessageFactoryTest.assertEquals(riMsg.getContent(), tiMsg.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAgainstRI(Response tiResponse, Response riResponse) {
        try {
            MessageFactoryTest.assertEquals((int)riResponse.getStatusCode(), (int)tiResponse.getStatusCode());
            this.testAgainstRIMsg((Message)tiResponse, (Message)riResponse);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testAgainstRI(testResponse)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAgainstRI(Request tiRequest, Request riRequest) {
        try {
            MessageFactoryTest.assertEquals(riRequest.getMethod(), tiRequest.getMethod());
            MessageFactoryTest.assertEquals(riRequest.getRequestURI(), tiRequest.getRequestURI());
            MessageFactoryTest.assertEquals(riRequest.getHeader("Max-Forwards"), tiRequest.getHeader("Max-Forwards"));
            this.testAgainstRIMsg((Message)tiRequest, (Message)riRequest);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testAgainstRI(testRequest)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRequest() {
        try {
            Request tiRequest = tiMessageFactory.createRequest(this.tiRequestURI, this.method, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            this.cloneTest(tiRequest);
            Request riRequest = riMessageFactory.createRequest(this.riRequestURI, this.method, this.ricallId, this.ricSeq, this.rifrom, this.rito, this.rivia, this.rimaxForwards, this.ricontentType, this.contentObject);
            this.testAgainstRI(tiRequest, riRequest);
            this.testAgainstRIMsgContent((Message)tiRequest, (Message)riRequest);
            tiRequest = tiMessageFactory.createRequest(this.tiRequestURI, this.method, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentBytes);
            this.cloneTest(tiRequest);
            riRequest = riMessageFactory.createRequest(this.riRequestURI, this.method, this.ricallId, this.ricSeq, this.rifrom, this.rito, this.rivia, this.rimaxForwards, this.ricontentType, this.contentBytes);
            this.cloneTest(tiRequest);
            this.testAgainstRI(tiRequest, riRequest);
            this.testAgainstRIMsgContent((Message)tiRequest, (Message)riRequest);
            Response tiResponse = tiMessageFactory.createResponse(this.statusCode, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            this.cloneTest(tiResponse);
            Response riResponse = riMessageFactory.createResponse(this.statusCode, this.ricallId, this.ricSeq, this.rifrom, this.rito, this.rivia, this.rimaxForwards, this.ricontentType, this.contentObject);
            this.testAgainstRI(tiResponse, riResponse);
            this.testAgainstRIMsgContent((Message)tiResponse, (Message)riResponse);
            tiResponse = tiMessageFactory.createResponse(this.statusCode, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            this.cloneTest(tiResponse);
            riResponse = riMessageFactory.createResponse(this.statusCode, this.ricallId, this.ricSeq, this.rifrom, this.rito, this.rivia, this.rimaxForwards, this.ricontentType, this.contentObject);
            this.testAgainstRI(tiResponse, riResponse);
            this.testAgainstRIMsgContent((Message)tiResponse, (Message)riResponse);
            tiResponse = tiMessageFactory.createResponse(this.statusCode, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards);
            this.cloneTest(tiResponse);
            riResponse = riMessageFactory.createResponse(this.statusCode, this.ricallId, this.ricSeq, this.rifrom, this.rito, this.rivia, this.rimaxForwards);
            this.testAgainstRI(tiResponse, riResponse);
            tiResponse = tiMessageFactory.createResponse(this.statusCode, tiRequest, this.ticontentType, this.contentBytes);
            this.cloneTest(tiResponse);
            riResponse = riMessageFactory.createResponse(this.statusCode, riRequest, this.ricontentType, this.contentBytes);
            this.testAgainstRI(tiResponse, riResponse);
            this.testAgainstRIMsgContent((Message)tiResponse, (Message)riResponse);
            tiResponse = tiMessageFactory.createResponse(this.statusCode, tiRequest, this.ticontentType, this.contentObject);
            this.cloneTest(tiResponse);
            riResponse = riMessageFactory.createResponse(this.statusCode, riRequest, this.ricontentType, this.contentObject);
            this.testAgainstRI(tiResponse, riResponse);
            this.testAgainstRIMsgContent((Message)tiResponse, (Message)riResponse);
            tiResponse = tiMessageFactory.createResponse(this.statusCode, tiRequest);
            this.cloneTest(tiResponse);
            riResponse = riMessageFactory.createResponse(this.statusCode, riRequest);
            this.testAgainstRI(tiResponse, riResponse);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testCreateRequest()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateRequest1() {
        try {
            Request request = tiMessageFactory.createRequest(this.tiRequestURI, this.method, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards);
            String msgString = request.toString();
            MessageFactoryTest.assertEquals(request, tiMessageFactory.createRequest(msgString));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testCreateRequest1()");
        }
    }

    private void testGetMethods(Request refRequest, Request requestToTest) throws IllegalAccessException, InvocationTargetException {
        try {
            Class<?> implementationClass = refRequest.getClass();
            Class<?>[] implementedInterfaces = implementationClass.getInterfaces();
            int j = 0;
            for (j = 0; j < implementedInterfaces.length && !Request.class.isAssignableFrom(implementedInterfaces[j]); ++j) {
            }
            if (j == implementedInterfaces.length) {
                System.out.println("Hmm... could not find it" + refRequest.getClass());
                throw new TckInternalError("Request not implemented");
            }
            String jainClassName = implementedInterfaces[j].getName();
            MessageFactoryTest.checkImplementsInterface(requestToTest.getClass(), Request.class);
            Method[] methods = implementedInterfaces[j].getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Object testValue;
                String methodName = methods[i].getName();
                if (!methodName.startsWith("get") || methods[i].getParameterTypes().length != 0) continue;
                Class<?> returnType = methods[i].getReturnType();
                Object refType = null;
                try {
                    refType = methods[i].invoke((Object)refRequest, (Object[])null);
                }
                catch (Exception ex) {
                    throw new TckInternalError("Invocation failure " + methodName);
                }
                String ftype = returnType.toString();
                if (returnType.isPrimitive()) {
                    testValue = methods[i].invoke((Object)requestToTest, (Object[])null);
                    MessageFactoryTest.assertEquals(refType, testValue);
                    continue;
                }
                testValue = methods[i].invoke((Object)requestToTest, (Object[])null);
                if (refType != null) {
                    MessageFactoryTest.assertTrue(testValue != null);
                    Class<?> fclass = refType.getClass();
                    Class<?>[] fInterfaces = fclass.getInterfaces();
                    int k = 0;
                    for (k = 0; k < fInterfaces.length && !Header.class.isAssignableFrom(fInterfaces[k]); ++k) {
                    }
                    if (k >= fInterfaces.length) continue;
                    MessageFactoryTest.assertTrue(fInterfaces[k].isAssignableFrom(testValue.getClass()));
                    String refhdrString = refType.toString();
                    String testhdrString = testValue.toString();
                    Header riHeader = this.createRiHeaderFromString(refhdrString);
                    if (riHeader == null) {
                        throw new TckInternalError("could not parse " + refhdrString);
                    }
                    Header tiHeader = this.createRiHeaderFromString(testhdrString);
                    MessageFactoryTest.assertNotNull((Object)tiHeader);
                    MessageFactoryTest.assertEquals("Retrieved header did not match RI", riHeader, tiHeader);
                    continue;
                }
                if (refType != null) continue;
                MessageFactoryTest.assertTrue(testValue == null);
            }
        }
        catch (Exception ex) {
            throw new TiUnexpectedError(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMessageGetMethods() {
        try {
            Request tiRequest = tiMessageFactory.createRequest(msgString);
            Request riRequest = riMessageFactory.createRequest(msgString);
            this.testGetMethods(riRequest, tiRequest);
        }
        catch (Exception ex) {
            MessageFactoryTest.assertTrue(false);
        }
        finally {
            this.logTestCompleted("testMessageGetMethods()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetHeaderNames() {
        try {
            Request request = tiMessageFactory.createRequest(this.tiRequestURI, this.method, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            ListIterator li = request.getHeaderNames();
            TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            while (li.hasNext()) {
                String hdrName = (String)li.next();
                set.add(hdrName);
            }
            MessageFactoryTest.assertTrue(set.contains("CSeq"));
            MessageFactoryTest.assertTrue(set.contains("From"));
            MessageFactoryTest.assertTrue(set.contains("To"));
            MessageFactoryTest.assertTrue(set.contains("Via"));
            MessageFactoryTest.assertTrue(set.contains("Max-Forwards"));
            MessageFactoryTest.assertTrue(set.contains("Content-Type"));
            MessageFactoryTest.assertTrue(set.contains("Call-ID"));
            Response response = tiMessageFactory.createResponse(this.statusCode, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            li = request.getHeaderNames();
            set.clear();
            while (li.hasNext()) {
                String hdrName = (String)li.next();
                set.add(hdrName);
            }
            MessageFactoryTest.assertTrue(set.contains("CSeq"));
            MessageFactoryTest.assertTrue(set.contains("From") || set.contains("f"));
            MessageFactoryTest.assertTrue(set.contains("To") || set.contains("t"));
            MessageFactoryTest.assertTrue(set.contains("Via") || set.contains("v"));
            MessageFactoryTest.assertTrue(set.contains("Max-Forwards"));
            MessageFactoryTest.assertTrue(set.contains("Content-Type") || set.contains("c"));
            MessageFactoryTest.assertTrue(set.contains("Call-ID") || set.contains("i"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testGetHeaderNames()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveHeader() {
        try {
            Request request = tiMessageFactory.createRequest(this.tiRequestURI, this.method, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            request.addHeader((Header)this.tiextensionHeader);
            ListIterator viaHeaders = request.getHeaders("Via");
            ViaHeader viaHeader = (ViaHeader)viaHeaders.next();
            MessageFactoryTest.assertTrue(viaHeader.equals(this.tivia.iterator().next()));
            Header header = request.getHeader("My-Header");
            MessageFactoryTest.assertTrue(header != null && header.equals(this.tiextensionHeader));
            request.removeHeader("My-Header");
            MessageFactoryTest.assertNull((Object)request.getHeader("My-Header"));
            Response response = tiMessageFactory.createResponse(this.statusCode, this.ticallId, this.ticSeq, this.tifrom, this.tito, this.tivia, this.timaxForwards, this.ticontentType, this.contentObject);
            response.addHeader((Header)this.tiextensionHeader);
            viaHeaders = request.getHeaders("Via");
            viaHeader = (ViaHeader)viaHeaders.next();
            MessageFactoryTest.assertEquals(viaHeader, this.tivia.iterator().next());
            header = response.getHeader("My-Header");
            MessageFactoryTest.assertEquals(header, this.tiextensionHeader);
            response.removeHeader("My-Header");
            MessageFactoryTest.assertNull((Object)response.getHeader("My-Header"));
            ContentLengthHeader cl = response.getContentLength();
            MessageFactoryTest.assertNotNull((Object)cl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
        finally {
            this.logTestCompleted("testAddRemoveHeader()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharset() {
        try {
            Request request = tiMessageFactory.createRequest("MESSAGE sip:127.0.0.1 SIP/2.0\r\nVia: SIP/2.0/TCP 127.0.0.1:5060;rport=5060;branch=z9hG4bKd2c87858eb0a7a09becc7a115c608d27\r\nCSeq: 2 BYE\r\nCall-ID: 84a5c57fd263bcce6fec05edf20c5aba@127.0.0.1\r\nFrom: \"The Master Blaster\" <sip:BigGuy@here.com>;tag=12345\r\nTo: \"The Little Blister\" <sip:LittleGuy@there.com>;tag=2955\r\nMax-Forwards: 70\r\nContent-Type: text/plain;charset=ISO-8859-1\r\nContent-Length: 0\r\n\r\n");
            byte[] content = "\ufffd\ufffd".getBytes("ISO-8859-1");
            request.setContent((Object)new String(content, "ISO-8859-1"), (ContentTypeHeader)request.getHeader("Content-Type"));
            MessageFactoryTest.assertEquals((int)2, (int)request.getRawContent().length);
        }
        catch (Exception t) {
            t.printStackTrace();
            MessageFactoryTest.fail("ParseException", t);
        }
        finally {
            this.logTestCompleted("testCharset()");
        }
    }

    public void setUp() {
        try {
            String fromName = "BigGuy";
            String fromSipAddress = "here.com";
            String fromDisplayName = "The Master Blaster";
            String toSipAddress = "there.com";
            String toUser = "LittleGuy";
            String toDisplayName = "The Little Blister";
            SipURI tifromAddress = tiAddressFactory.createSipURI(fromName, fromSipAddress);
            SipURI rifromAddress = riAddressFactory.createSipURI(fromName, fromSipAddress);
            Address tifromNameAddress = tiAddressFactory.createAddress((URI)tifromAddress);
            Address rifromNameAddress = riAddressFactory.createAddress((URI)rifromAddress);
            tifromNameAddress.setDisplayName(fromDisplayName);
            rifromNameAddress.setDisplayName(fromDisplayName);
            this.tifrom = tiHeaderFactory.createFromHeader(tifromNameAddress, "12345");
            this.rifrom = riHeaderFactory.createFromHeader(rifromNameAddress, "12345");
            SipURI titoAddress = tiAddressFactory.createSipURI(toUser, toSipAddress);
            SipURI ritoAddress = riAddressFactory.createSipURI(toUser, toSipAddress);
            Address titoNameAddress = tiAddressFactory.createAddress((URI)titoAddress);
            Address ritoNameAddress = riAddressFactory.createAddress((URI)ritoAddress);
            titoNameAddress.setDisplayName(toDisplayName);
            ritoNameAddress.setDisplayName(toDisplayName);
            this.tito = tiHeaderFactory.createToHeader(titoNameAddress, null);
            this.rito = riHeaderFactory.createToHeader(ritoNameAddress, null);
            this.tiRequestURI = tiAddressFactory.createSipURI(toUser, toSipAddress);
            this.riRequestURI = riAddressFactory.createSipURI(toUser, toSipAddress);
            this.timaxForwards = tiHeaderFactory.createMaxForwardsHeader(70);
            this.rimaxForwards = riHeaderFactory.createMaxForwardsHeader(70);
            this.ticontentType = tiHeaderFactory.createContentTypeHeader("application", "sdp");
            this.ricontentType = riHeaderFactory.createContentTypeHeader("application", "sdp");
            this.tivia = new LinkedList();
            this.rivia = new LinkedList();
            ViaHeader tiviaHeader = tiHeaderFactory.createViaHeader("127.0.0.1", 5060, "udp", null);
            this.tivia.add(tiviaHeader);
            ViaHeader riviaHeader = riHeaderFactory.createViaHeader("127.0.0.1", 5060, "udp", null);
            this.rivia.add(riviaHeader);
            this.ticallId = tiHeaderFactory.createCallIdHeader("12345@127.0.0.1");
            this.ricallId = riHeaderFactory.createCallIdHeader("12345@127.0.0.1");
            this.contentObject = "v=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n";
            this.contentBytes = ((String)this.contentObject).getBytes();
            this.method = "INVITE";
            this.ticSeq = tiHeaderFactory.createCSeqHeader(1L, this.method);
            this.ricSeq = riHeaderFactory.createCSeqHeader(1L, this.method);
            this.statusCode = 200;
            this.tiextensionHeader = (ExtensionHeader)tiHeaderFactory.createHeader("My-Header", "My Header Value");
            this.riextensionHeader = (ExtensionHeader)riHeaderFactory.createHeader("My-Header", "My Header Value");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            MessageFactoryTest.fail(ex.getMessage());
        }
    }

    public void tearDown() {
        riFactory.resetFactory();
        tiFactory.resetFactory();
    }

    public static Test suite() {
        return new TestSuite(MessageFactoryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MessageFactoryTest.class);
    }
}

