/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.ListIterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.TransactionUnavailableException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;

public class ClientTransactionTest
extends MessageFlowHarness {
    public ClientTransactionTest(String name) {
        super(name);
    }

    public void testCreateCancel() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewClientTransaction(invite);
            }
            catch (TransactionUnavailableException exc) {
                throw new TiUnexpectedError("A TransactionUnavailableException was thrown while trying to create a new client transaction", exc);
            }
            tran.getDialog();
            Request cancel = null;
            try {
                cancel = tran.createCancel();
            }
            catch (SipException ex) {
                ex.printStackTrace();
                ClientTransactionTest.fail("Failed to create cancel request!");
            }
            ClientTransactionTest.assertEquals("The created request did not have a CANCEL method.", cancel.getMethod(), "CANCEL");
            ClientTransactionTest.assertEquals("Request-URIs of the original and the cancel request do not match", cancel.getRequestURI(), invite.getRequestURI());
            ClientTransactionTest.assertEquals("Call-IDs of the original and the cancel request do not match", cancel.getHeader("Call-ID"), invite.getHeader("Call-ID"));
            ClientTransactionTest.assertEquals("ToHeaders of the original and the cancel request do not match", cancel.getHeader("To"), invite.getHeader("To"));
            ClientTransactionTest.assertTrue("The CSeqHeader's sequence number of the original and the cancel request do not match", ((CSeqHeader)cancel.getHeader("CSeq")).getSeqNumber() == ((CSeqHeader)invite.getHeader("CSeq")).getSeqNumber());
            ClientTransactionTest.assertEquals("The CSeqHeader's method of the cancel request was not CANCEL", ((CSeqHeader)cancel.getHeader("CSeq")).getMethod(), "CANCEL");
            ClientTransactionTest.assertTrue("There was no ViaHeader in the cancel request", cancel.getHeaders("Via").hasNext());
            ListIterator cancelVias = cancel.getHeaders("Via");
            ViaHeader cancelVia = (ViaHeader)cancelVias.next();
            ViaHeader inviteVia = (ViaHeader)invite.getHeaders("Via").next();
            ClientTransactionTest.assertEquals("ViaHeaders of the original and the cancel request do not match!", cancelVia, inviteVia);
            ClientTransactionTest.assertFalse((String)"Cancel request had more than one ViaHeader.", (boolean)cancelVias.hasNext());
            ClientTransactionTest.assertEquals("To tags must match", ((ToHeader)invite.getHeader("to")).getTag(), ((ToHeader)cancel.getHeader("to")).getTag());
            ClientTransactionTest.assertEquals("From tags must match", ((FromHeader)invite.getHeader("from")).getTag(), ((FromHeader)cancel.getHeader("from")).getTag());
            ClientTransactionTest.assertEquals("Max-Forwards must match", invite.getHeader("Max-Forwards"), cancel.getHeader("Max-Forwards"));
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            ClientTransactionTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        ClientTransactionTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testSendRequest() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            RequestEvent receivedRequestEvent = null;
            ClientTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran.sendRequest();
                ClientTransactionTest.waitForMessage();
                receivedRequestEvent = this.eventCollector.extractCollectedRequestEvent();
                ClientTransactionTest.assertNotNull("The sent request was not received by the RI!", receivedRequestEvent);
                ClientTransactionTest.assertNotNull("The sent request was not received by the RI!", receivedRequestEvent.getRequest());
            }
            catch (TransactionUnavailableException exc) {
                throw new TiUnexpectedError("A TransactionUnavailableException was thrown while trying to create a new client transaction", exc);
            }
            catch (SipException exc) {
                exc.printStackTrace();
                ClientTransactionTest.fail("The SipException was thrown while trying to send the request.");
            }
            catch (TooManyListenersException exc) {
                throw new TckInternalError("A  TooManyListenersException was thrown while trying to add a SipListener to an RI SipProvider", exc);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            ClientTransactionTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        ClientTransactionTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(ClientTransactionTest.class);
    }
}

