/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class DialogStateMachineTest
extends MessageFlowHarness {
    public DialogStateMachineTest(String name) {
        super(name, true);
    }

    public void testClientDialogStates() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a listener with the RI", e);
            }
            catch (SipException e) {
                throw new TiUnexpectedError("Failed to send initial invite request", e);
            }
            DialogStateMachineTest.waitForMessage();
            RequestEvent inviteReqEvt = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReqEvt == null || inviteReqEvt.getRequest() == null) {
                throw new TiUnexpectedError("The TI did not send the initial invite request");
            }
            Dialog dialog = tran.getDialog();
            DialogStateMachineTest.assertNull("A dialog passed into the " + dialog.getState() + " state before receiving any response!", dialog.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TiUnexpectedError("Failed to register a SipListener with the TI.", e);
            }
            Response ringing = null;
            try {
                ringing = riMessageFactory.createResponse(180, inviteReqEvt.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                ringing.setHeader((Header)this.createRiContact());
                this.riSipProvider.sendResponse(ringing);
            }
            catch (Exception e) {
                throw new TckInternalError("Failed to create and send a RINGING response", e);
            }
            DialogStateMachineTest.waitForMessage();
            ResponseEvent ringingRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (ringingRespEvt == null || ringingRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not pass RINGING response to the TU.");
            }
            DialogStateMachineTest.assertEquals("The Dialog did not pass into the early state upon reception of a RINGING response", DialogState.EARLY, dialog.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TiUnexpectedError("Failed to register a SipListener with the TI.", e);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, inviteReqEvt.getRequest());
                ((ToHeader)ok.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                ok.setHeader((Header)this.createRiContact());
                this.riSipProvider.sendResponse(ok);
            }
            catch (Exception e) {
                throw new TckInternalError("Failed to create and send a OK response", e);
            }
            DialogStateMachineTest.waitForMessage();
            ResponseEvent okRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (okRespEvt == null || okRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not pass OK response to the TU.");
            }
            DialogStateMachineTest.assertEquals("The Dialog did not pass into the CONFIRMED state upon reception of an OK response", DialogState.CONFIRMED, dialog.getState());
            Request bye = null;
            try {
                bye = dialog.createRequest("BYE");
                ClientTransaction byeTran = this.tiSipProvider.getNewClientTransaction(bye);
                dialog.sendRequest(byeTran);
            }
            catch (SipException e) {
                throw new TiUnexpectedError("Failed to create and send a BYE request using a dialog.", e);
            }
            DialogStateMachineTest.waitForMessage();
            this.tiSipProvider.sendResponse(tiMessageFactory.createResponse(200, bye));
            DialogStateMachineTest.waitForMessage();
            DialogStateMachineTest.assertTrue("The dialog did not pass into a final ( TERMINATED) state after getting OK for a BYE.", DialogState.TERMINATED.equals((Object)dialog.getState()));
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testServerDialogStates() {
        try {
            ClientTransaction inviteTransaction = null;
            Request invite = this.createRiInviteRequest(null, null, null);
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                inviteTransaction = this.riSipProvider.getNewClientTransaction(invite);
                inviteTransaction.sendRequest();
            }
            catch (TooManyListenersException exc) {
                throw new TiUnexpectedError("Failed to register a listener with the TI", exc);
            }
            catch (SipException exc) {
                throw new TckInternalError("Failed to send initial invite request", exc);
            }
            DialogStateMachineTest.waitForMessage();
            RequestEvent inviteReqEvt = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReqEvt == null || inviteReqEvt.getRequest() == null) {
                throw new TiUnexpectedError("The TI did not dispatch the initial invite request");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReqEvt.getRequest());
            }
            catch (Exception ex) {
                throw new TiUnexpectedError("The TI failed to create a Server transaction for an incoming request");
            }
            Dialog dialog = tran.getDialog();
            DialogStateMachineTest.assertNull("A dialog passed into the " + dialog.getState() + " state before sending any response!", dialog.getState());
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a SipListener with the RI.", e);
            }
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, inviteReqEvt.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                ringing.setHeader((Header)this.createTiContact());
                tran.sendResponse(ringing);
            }
            catch (Exception e) {
                throw new TiUnexpectedError("Failed to create and send a RINGING response", e);
            }
            DialogStateMachineTest.waitForMessage();
            ResponseEvent ringingRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (ringingRespEvt == null || ringingRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not send the RINGING response.");
            }
            DialogStateMachineTest.assertEquals("The Dialog did not pass into the early state after sending a RINGING response", DialogState.EARLY, dialog.getState());
            SipEventCollector tteCollector = new SipEventCollector();
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
                tteCollector.collectTransactionTermiatedEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a SipListener with the RI.", e);
            }
            Response ok = null;
            try {
                ok = tiMessageFactory.createResponse(200, inviteReqEvt.getRequest());
                ((ToHeader)ok.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                ContactHeader contact = this.createTiContact();
                ok.addHeader((Header)contact);
                tran.sendResponse(ok);
            }
            catch (Exception e) {
                throw new TiUnexpectedError("Failed to create and send an OK response", e);
            }
            DialogStateMachineTest.waitForMessage();
            ResponseEvent okRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (okRespEvt == null || okRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not send an OK response.");
            }
            ClientTransaction ct = okRespEvt.getClientTransaction();
            Dialog clientDialog = ct.getDialog();
            DialogStateMachineTest.assertNotNull((Object)clientDialog);
            Request ackReq = clientDialog.createAck(((CSeqHeader)okRespEvt.getResponse().getHeader("CSeq")).getSeqNumber());
            clientDialog.sendAck(ackReq);
            DialogStateMachineTest.waitForMessage();
            DialogStateMachineTest.assertEquals("The Dialog did not pass into the CONFIRMED state upon reception of an OK response", DialogState.CONFIRMED, dialog.getState());
            DialogStateMachineTest.waitForTimeout();
            TransactionTerminatedEvent tte = tteCollector.extractCollectedTransactionTerminatedEvent();
            DialogStateMachineTest.assertNotNull((Object)tte);
            DialogStateMachineTest.assertTrue(tte.isServerTransaction());
            DialogStateMachineTest.assertEquals(tran, tte.getServerTransaction());
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with the TI", ex);
            }
            try {
                Dialog d = inviteTransaction.getDialog();
                Request bye = d.createRequest("BYE");
                ct = this.riSipProvider.getNewClientTransaction(bye);
                d.sendRequest(ct);
            }
            catch (Exception e) {
                throw new TckInternalError("Failed to create and send a BYE request using a dialog.", e);
            }
            DialogStateMachineTest.waitForMessage();
            RequestEvent byeEvt = this.eventCollector.extractCollectedRequestEvent();
            if (byeEvt == null || byeEvt.getRequest() == null) {
                throw new TiUnexpectedError("The TI did not dispatch a BYE request");
            }
            ServerTransaction byeTran = null;
            byeTran = byeEvt.getServerTransaction();
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a SipListener with the RI.", e);
            }
            try {
                ok = tiMessageFactory.createResponse(200, byeEvt.getRequest());
                ok.addHeader((Header)this.createTiContact());
                byeTran.sendResponse(ok);
            }
            catch (Exception e) {
                throw new TiUnexpectedError("Failed to create and send an OK response", e);
            }
            DialogStateMachineTest.waitForMessage();
            ResponseEvent byeOkRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (byeOkRespEvt == null || byeOkRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not send an OK response to a bye request.");
            }
            DialogStateMachineTest.assertTrue("The dialog did not pass into a final (COMPLETED or TERMINATED) state after recieving a BYE.", DialogState.COMPLETED.equals((Object)dialog.getState()) || DialogState.TERMINATED.equals((Object)dialog.getState()));
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(DialogStateMachineTest.class);
    }
}

