/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;

public class DialogTest
extends MessageFlowHarness {
    private Dialog dialog = null;
    private Request tiInvite = null;
    private Request riInvite = null;
    private ClientTransaction cliTran = null;
    private Response ringing = null;
    private String riToTag;

    public DialogTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        try {
            super.setUp();
            this.tiInvite = this.createTiInviteRequest(null, null, null);
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                this.cliTran = this.tiSipProvider.getNewClientTransaction(this.tiInvite);
                this.cliTran.sendRequest();
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a listener with the RI", e);
            }
            catch (SipException e) {
                throw new TiUnexpectedError("Failed to send initial invite request", e);
            }
            DialogTest.waitForMessage();
            RequestEvent inviteReqEvt = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReqEvt == null || inviteReqEvt.getRequest() == null) {
                throw new TiUnexpectedError("The TI did not send the initial invite request");
            }
            this.riInvite = inviteReqEvt.getRequest();
            this.dialog = this.cliTran.getDialog();
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TiUnexpectedError("Failed to register a SipListener with the TI.", e);
            }
            try {
                this.ringing = riMessageFactory.createResponse(180, inviteReqEvt.getRequest());
                this.riToTag = Integer.toString(((Object)((Object)this)).hashCode());
                ((ToHeader)this.ringing.getHeader("To")).setTag(this.riToTag);
                this.ringing.setHeader((Header)this.createRiContact());
                this.riSipProvider.sendResponse(this.ringing);
            }
            catch (Exception e) {
                throw new TckInternalError("Failed to create and send a RINGING response", e);
            }
            DialogTest.waitForMessage();
            ResponseEvent ringingRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (ringingRespEvt == null || ringingRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not dispatch a RINGING response.");
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testDialogProperties() {
        try {
            DialogTest.assertEquals("The Dialog did not have the right Call ID.", ((CallIdHeader)this.riInvite.getHeader("Call-ID")).getCallId(), this.dialog.getCallId().getCallId());
            DialogTest.assertEquals("Dialog.getLocalParty() returned a bad address.", ((FromHeader)this.tiInvite.getHeader("From")).getAddress(), this.dialog.getLocalParty());
            DialogTest.assertTrue("Dialog.getLocalSequenceNumber() returned a bad value.", 1L == this.dialog.getLocalSeqNumber());
            DialogTest.assertEquals("Dialog.getLocalTag() returned a bad tag", ((FromHeader)this.riInvite.getHeader("From")).getTag(), this.dialog.getLocalTag());
            DialogTest.assertEquals("Dialog.getRemoteParty() returned a bad address.", ((ToHeader)this.tiInvite.getHeader("To")).getAddress(), this.dialog.getRemoteParty());
            DialogTest.assertEquals("Dialog.getRemoteTag() returned a bad tag", ((ToHeader)this.ringing.getHeader("To")).getTag(), this.dialog.getRemoteTag());
            DialogTest.assertFalse((String)"Dialog.isServer returned true for a client side dialog", (boolean)this.dialog.isServer());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCreateRequest() {
        try {
            this.cliTran.terminate();
            Request bye = null;
            try {
                bye = this.dialog.createRequest("BYE");
            }
            catch (SipException ex) {
                ex.printStackTrace();
                DialogTest.fail("A dialog failed to create a BYE request.");
            }
            DialogTest.assertEquals("Dialog.createRequest() returned a request with a bad method.", "BYE", bye.getMethod());
            DialogTest.assertEquals((String)"Dialog.createRequest() returned a request with a bad sequence number.", (long)(this.dialog.getLocalSeqNumber() + 1L), (long)((CSeqHeader)bye.getHeader("CSeq")).getSeqNumber());
            FromHeader byeFrom = (FromHeader)bye.getHeader("From");
            DialogTest.assertEquals("Dialog.createRequest() returned a request with a bad From header.", this.dialog.getLocalParty(), byeFrom.getAddress());
            DialogTest.assertEquals("Dialog.createRequest() returned a request with a bad From tag.", this.dialog.getLocalTag(), byeFrom.getTag());
            ToHeader byeTo = (ToHeader)bye.getHeader("To");
            DialogTest.assertEquals("Dialog.createRequest() returned a request with a bad To header.", this.dialog.getRemoteParty(), byeTo.getAddress());
            DialogTest.assertEquals("Dialog.createRequest() returned a request with a bad To tag.", this.dialog.getRemoteTag(), byeTo.getTag());
            ClientTransaction ct = this.tiSipProvider.getNewClientTransaction(bye);
            try {
                this.eventCollector.collectDialogTermiatedEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("failed to regiser a listener iwth the TI", ex);
            }
            this.dialog.sendRequest(ct);
            DialogTest.assertEquals("Dialog mismatch ", ct.getDialog(), this.dialog);
            DialogTest.waitForMessage();
            DialogTest.waitForTimeout();
            DialogTerminatedEvent dte = this.eventCollector.extractCollectedDialogTerminatedEvent();
            DialogTest.assertNotNull("No DTE received for early Dialog terminated via BYE", dte);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testSendAck() {
        this.doTestSendAck(false);
    }

    private void doTestSendAck(boolean sameBranch) {
        System.out.println("doTestSendAck " + sameBranch);
        try {
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException e) {
                throw new TckInternalError("Failed to register a SipListener with the RI.", e);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, this.riInvite);
                ok.addHeader(this.createRiInviteRequest(null, null, null).getHeader("Contact"));
                ToHeader okToHeader = (ToHeader)ok.getHeader("To");
                okToHeader.setTag(this.riToTag);
                ServerTransaction riST = this.riSipProvider.getNewServerTransaction(this.riInvite);
                riST.getDialog();
                riST.sendResponse(ok);
            }
            catch (Exception e) {
                throw new TckInternalError("Failed to create and send an OK response", e);
            }
            DialogTest.waitForMessage();
            ResponseEvent okRespEvt = this.eventCollector.extractCollectedResponseEvent();
            if (okRespEvt == null || okRespEvt.getResponse() == null) {
                throw new TiUnexpectedError("The TI did not dispatch an OK response.");
            }
            String okBranch = ((ViaHeader)okRespEvt.getResponse().getHeader("Via")).getBranch();
            DialogTest.assertEquals(DialogState.CONFIRMED, this.dialog.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with the RI", ex);
            }
            Request ack = null;
            try {
                CSeqHeader cseq = (CSeqHeader)okRespEvt.getResponse().getHeader("CSeq");
                ack = this.dialog.createAck(cseq.getSeqNumber());
                if (sameBranch) {
                    ViaHeader via = (ViaHeader)ack.getHeader("Via");
                    via.setBranch(((ViaHeader)this.riInvite.getHeader("Via")).getBranch());
                }
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("Failed to create an ACK request.", ex);
            }
            try {
                this.dialog.sendAck(ack);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                DialogTest.fail("SipException; Failed to send an ACK request using Dialog.sendAck()");
            }
            DialogTest.waitForMessage();
            RequestEvent ackEvt = this.eventCollector.extractCollectedRequestEvent();
            DialogTest.assertNotNull("No requestEvent sent by Dialog.sendAck() was received by the RI", ackEvt);
            DialogTest.assertNotNull("The request sent by Dialog.sendAck() was not received by the RI", ackEvt.getRequest());
            if (!sameBranch) {
                String ackBranchId = ((ViaHeader)ackEvt.getRequest().getHeader("Via")).getBranch();
                MessageFlowHarness.assertNotSame((String)"ACK branch ID must differ from INVITE OK branch ID", (Object)ackBranchId, (Object)okBranch);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testSendRequest() {
        try {
            Request reInvite = null;
            ClientTransaction reInviteTran = null;
            try {
                reInvite = this.dialog.createRequest("INVITE");
                reInviteTran = this.tiSipProvider.getNewClientTransaction(reInvite);
            }
            catch (Exception ex) {
                throw new TiUnexpectedError("Failed to create a CANCEL request with Dialog.createRequest()", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with the RI", ex);
            }
            try {
                this.dialog.sendRequest(reInviteTran);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                DialogTest.fail("Failed to send a cancel request using Dialog.sendRequest()");
            }
            DialogTest.waitForMessage();
            RequestEvent cancelEvt = this.eventCollector.extractCollectedRequestEvent();
            DialogTest.assertNotNull("The RI did not receive the sent request", cancelEvt);
            DialogTest.assertNotNull("The RI did not receive the sent request", cancelEvt.getRequest());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            DialogTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        DialogTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(DialogTest.class);
    }
}

