/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class InviteClientTransactionsStateMachineTest
extends MessageFlowHarness {
    private static Logger logger = Logger.getLogger(InviteClientTransactionsStateMachineTest.class);

    public InviteClientTransactionsStateMachineTest(String name) {
        super(name, false);
    }

    public void testCallingProceedingCompletedTerminatedScenario() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the RI!");
            }
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                InviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("INVITE", inviteReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                Response resp = riMessageFactory.createResponse(100, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), resp);
                this.riSipProvider.sendResponse(resp);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a trying response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertTrue("A response different from TYING was passed to the TU!", responseEvent.getResponse().getStatusCode() == 100);
            InviteClientTransactionsStateMachineTest.assertSame("The TRYING response was not associated with the right transaction.", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the PROCEEDING state after receiving 1xx provisional response", tran.getState(), TransactionState.PROCEEDING);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response busyHere = null;
            try {
                busyHere = riMessageFactory.createResponse(486, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), busyHere);
                ((ToHeader)busyHere.getHeader("to")).setTag("busy-here");
                this.riSipProvider.sendResponse(busyHere);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a BUSY HERE response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertSame("The BUSY_HERE response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals((String)"A response different from BUSY_HERE was passed to the TU", (int)486, (int)responseEvent.getResponse().getStatusCode());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the COMPLETED state after receiving 300-699 final response", tran.getState(), TransactionState.COMPLETED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request", ackReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request", ackReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("ACK", ackReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.waitForMessage();
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)busyHere.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a BUSY HERE response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNull("The Tested Implementation passed a retransmitted 300-699 response to the TU instead of just silently acknowledging it!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not stay long enough in the COMPLETED state.", tran.getState(), TransactionState.COMPLETED);
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request to the second response", ackReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request to the second response", ackReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("ACK", ackReceivedEvent.getRequest().getMethod());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testInviteCancel() {
        this.doCancelTest(true);
    }

    private void doCancelTest(boolean rfc3261Compliant) {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the RI!");
            }
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                Response resp = riMessageFactory.createResponse(100, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), resp);
                this.riSipProvider.sendResponse(resp);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a trying response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertTrue("A response different from TYING was passed to the TU!", responseEvent.getResponse().getStatusCode() == 100);
            InviteClientTransactionsStateMachineTest.assertSame("The TRYING response was not associated with the right transaction.", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the PROCEEDING state after receiving 1xx provisional response", tran.getState(), TransactionState.PROCEEDING);
            Request tiCancel = tran.createCancel();
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                ClientTransaction tiCancelTrans = this.tiSipProvider.getNewClientTransaction(tiCancel);
                tiCancelTrans.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send CANCEL!", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent cancelReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (cancelReceivedEvent == null || cancelReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The CANCEL request was not received by the RI!");
            }
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            Response riCancelOk = null;
            try {
                riCancelOk = riMessageFactory.createResponse(200, cancelReceivedEvent.getRequest());
                this.addStatus(cancelReceivedEvent.getRequest(), riCancelOk);
                this.riSipProvider.sendResponse(riCancelOk);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a CANCEL OK response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            if (responseEvent == null || responseEvent.getResponse() == null) {
                throw new TiUnexpectedError("The CANCEL OK response was not received by the TI!");
            }
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response riInviteTerminated = null;
            try {
                riInviteTerminated = riMessageFactory.createResponse(487, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), riInviteTerminated);
                this.riSipProvider.sendResponse(riInviteTerminated);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a INVITE 487 response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertSame("The 487 response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals((String)"A response different from 487 was passed to the TU", (int)487, (int)responseEvent.getResponse().getStatusCode());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the COMPLETED state after receiving 300-699 final response", tran.getState(), TransactionState.COMPLETED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request event", ackReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request", ackReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("ACK", ackReceivedEvent.getRequest().getMethod());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCallingCompletedTerminatedScenario() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the RI!");
            }
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                InviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("INVITE", inviteReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response busyHere = null;
            try {
                busyHere = riMessageFactory.createResponse(486, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), busyHere);
                ((ToHeader)busyHere.getHeader("to")).setTag("ack-to-test");
                this.riSipProvider.sendResponse((Response)busyHere.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a BUSY HERE response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 300-699 response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertSame("The BUSY_HERE response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertSame("A response different from BUSY_HERE was passed to the TU", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the COMPLETED state after receiving 300-699 final response", tran.getState(), TransactionState.COMPLETED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request", ackReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request", ackReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("ACK", ackReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.waitForMessage();
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)busyHere.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a BUSY HERE response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNull("The Tested Implementation passed a retransmitted 300-699 response to the TU instead of just silently acknowledging it!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not stay long enough in the COMPLETED state.", tran.getState(), TransactionState.COMPLETED);
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request to the second response", ackReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The TI did not send an ACK request to the second response", ackReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("ACK", ackReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.assertEquals("The To header field in the ACK MUST equal the To header field  in the response being acknowledged", "ack-to-test", ((ToHeader)ackReceivedEvent.getRequest().getHeader("to")).getTag());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCallingProceedingTerminatedScenario() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the RI!");
            }
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                InviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("INVITE", inviteReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                Response resp = riMessageFactory.createResponse(100, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), resp);
                this.riSipProvider.sendResponse(resp);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a trying response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertTrue("A response different from TYING was passed to the TU!", responseEvent.getResponse().getStatusCode() == 100);
            InviteClientTransactionsStateMachineTest.assertSame("The TRYING response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the PROCEEDING state after receiving 1xx provisional response", tran.getState(), TransactionState.PROCEEDING);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, inviteReceivedEvent.getRequest());
                ContactHeader contact = riHeaderFactory.createContactHeader(((ToHeader)ok.getHeader("To")).getAddress());
                ok.addHeader((Header)contact);
                this.addStatus(inviteReceivedEvent.getRequest(), ok);
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send an OK response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200 OK response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200 OK response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertSame("The OK response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertSame("A response different from OK was passed to the TU", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the TERMINATED state after receiving 200 final response", tran.getState(), TransactionState.TERMINATED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            if (ackReceivedEvent != null) {
                logger.error((Object)("Shouldn't have received that=" + ackReceivedEvent.getRequest()));
            }
            InviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK to an OK (this is TU's job)!", ackReceivedEvent);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send an OK response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction mysteriously left the TERMINATED state!", tran.getState(), TransactionState.TERMINATED);
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK request to the second OK response (OK acks are TU's responsibility)!", ackReceivedEvent);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCallingTerminatedScenario() {
        try {
            Request invite = this.createTiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the RI!");
            }
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                InviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The invite request was not retransmitted!", inviteReceivedEvent.getRequest());
            InviteClientTransactionsStateMachineTest.assertEquals("INVITE", inviteReceivedEvent.getRequest().getMethod());
            InviteClientTransactionsStateMachineTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), ok);
                ContactHeader contact = riHeaderFactory.createContactHeader(((ToHeader)ok.getHeader("To")).getAddress());
                ok.addHeader((Header)contact);
                this.riSipProvider.sendResponse(ok);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send an OK response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200 OK response to the TU!", responseEvent);
            InviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200 OK response to the TU!", responseEvent.getResponse());
            InviteClientTransactionsStateMachineTest.assertSame("The OK response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertSame("A response different from OK was passed to the TU", tran, responseEvent.getClientTransaction());
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the TERMINATED state after receiving 200 final response", tran.getState(), TransactionState.TERMINATED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK to an OK (this is TU's job)!", ackReceivedEvent);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send an OK response back to the TI", ex);
            }
            InviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            InviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction mysteriously left the TERMINATED state!", tran.getState(), TransactionState.TERMINATED);
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            InviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK request to the second OK response (OK acks are TU's responsibility)!", ackReceivedEvent);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(InviteClientTransactionsStateMachineTest.class);
    }
}

