/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class InviteServerTransactionsStateMachineTest
extends MessageFlowHarness {
    public InviteServerTransactionsStateMachineTest(String name) {
        super(name);
    }

    public void testProceedingCompletedConfirmedScenario() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            InviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            InviteServerTransactionsStateMachineTest.assertEquals(TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("Retransmitted INVITEs should not be passed to the TU", inviteReceivedEvent);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ringing);
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("Retransmitted INVITEs should not be passed to the TU", inviteReceivedEvent);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No RINGING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI upon reception of a retransmitted invite INVITE", 180 == responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the PROCEEDING state.", TransactionState.PROCEEDING, tran.getState());
            Response busy = null;
            try {
                busy = tiMessageFactory.createResponse(486, tran.getRequest());
                this.addStatus(tran.getRequest(), busy);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a busy_here response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(busy);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a BUSY_HERE response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a BUSY_HERE response", TransactionState.COMPLETED, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The BUSY_HERE response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from BUSY_HERE was sent by the TI", 486 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("Retransmitted INVITEs should not be passed to the TU", inviteReceivedEvent);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No BUSY_HERE response has been sent by the TI upon reception of a retransmitted INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from BUSY_HERE was sent by the TI upon reception of a retransmitted invite INVITE", 486 == responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the COMPLETED state.", TransactionState.COMPLETED, tran.getState());
            Request ack = (Request)invite.clone();
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                ack.setMethod("ACK");
                String toTag = ((ToHeader)responseEvent.getResponse().getHeader("to")).getTag();
                if (toTag != null) {
                    ((ToHeader)ack.getHeader("to")).setTag(toTag);
                }
                this.riSipProvider.sendRequest(ack);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with the TI provider", ex);
            }
            catch (Exception ex) {
                throw new TckInternalError("Failed to create an ack request", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent ackEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("ACKs in ServerInviteTransactions shouldn't be passed to the TU.", ackEvent);
            InviteServerTransactionsStateMachineTest.assertEquals("The ServerTransaction did not pas into the confirmed stateafter receiving an ACK.", TransactionState.CONFIRMED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCanceledInvite() {
        try {
            Response cancelOK;
            ClientTransaction riInviteCt;
            Request invite = this.createRiInviteRequest(null, null, null);
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                riInviteCt = this.riSipProvider.getNewClientTransaction(invite);
                riInviteCt.sendRequest();
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            InviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            InviteServerTransactionsStateMachineTest.assertEquals(TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ringing);
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            Request riCancel = riInviteCt.createCancel();
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(riCancel);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send CANCEL request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent cancelReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (cancelReceivedEvent == null || cancelReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The CANCEL request was not received by the TI!");
            }
            InviteServerTransactionsStateMachineTest.assertEquals(tran.getBranchId(), cancelReceivedEvent.getServerTransaction().getBranchId());
            try {
                cancelOK = tiMessageFactory.createResponse(200, cancelReceivedEvent.getRequest());
                this.addStatus(cancelReceivedEvent.getRequest(), cancelOK);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a OK response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                cancelReceivedEvent.getServerTransaction().sendResponse(cancelOK);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a CANCEL OK response");
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The CANCEL OK response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            Response reqTerminated = null;
            try {
                reqTerminated = tiMessageFactory.createResponse(487, tran.getRequest());
                this.addStatus(tran.getRequest(), reqTerminated);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a req_terminated response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(reqTerminated);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a REQUEST_TERMINATED response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a REQUEST_TERMINATED response", TransactionState.COMPLETED, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The REQUEST_TERMINATED response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertEquals((String)"A response different from REQUEST_TERMINATED was sent by the TI", (int)487, (int)responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The ServerTransaction did not pas into the confirmed stateafter receiving an ACK.", TransactionState.CONFIRMED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testNonRFC3261CanceledInvite() {
        try {
            Response cancelOK;
            ClientTransaction riInviteCt;
            Request invite = this.createRiInviteRequest(null, null, null);
            ViaHeader topVia = (ViaHeader)invite.getHeader("Via");
            topVia.setBranch("non-rfc3261");
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                riInviteCt = this.riSipProvider.getNewClientTransaction(invite);
                riInviteCt.sendRequest();
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            InviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            InviteServerTransactionsStateMachineTest.assertEquals(TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ringing);
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            Request riCancel = riInviteCt.createCancel();
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(riCancel);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send CANCEL request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent cancelReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (cancelReceivedEvent == null || cancelReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The CANCEL request was not received by the TI!");
            }
            InviteServerTransactionsStateMachineTest.assertEquals(tran.getBranchId(), cancelReceivedEvent.getServerTransaction().getBranchId());
            try {
                cancelOK = tiMessageFactory.createResponse(200, cancelReceivedEvent.getRequest());
                this.addStatus(cancelReceivedEvent.getRequest(), cancelOK);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a OK response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                cancelReceivedEvent.getServerTransaction().sendResponse(cancelOK);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a CANCEL OK response");
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The CANCEL OK response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            Response reqTerminated = null;
            try {
                reqTerminated = tiMessageFactory.createResponse(487, tran.getRequest());
                this.addStatus(tran.getRequest(), reqTerminated);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a req_terminated response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(reqTerminated);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a REQUEST_TERMINATED response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a REQUEST_TERMINATED response", TransactionState.COMPLETED, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The REQUEST_TERMINATED response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from REQUEST_TERMINATED was sent by the TI", 487 == responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The ServerTransaction did not pas into the confirmed stateafter receiving an ACK.", TransactionState.CONFIRMED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCaseInsensitiveCanceledInvite() {
        try {
            Response cancelOK;
            ClientTransaction riInviteCt;
            Request invite = this.createRiInviteRequest(null, null, null);
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                riInviteCt = this.riSipProvider.getNewClientTransaction(invite);
                riInviteCt.sendRequest();
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            InviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            InviteServerTransactionsStateMachineTest.assertEquals(TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ringing);
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            Request riCancel = riInviteCt.createCancel();
            ViaHeader topVia = (ViaHeader)riCancel.getHeader("Via");
            topVia.setBranch(topVia.getBranch().toLowerCase());
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(riCancel);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send CANCEL request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent cancelReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (cancelReceivedEvent == null || cancelReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The CANCEL request was not received by the TI!");
            }
            try {
                cancelOK = tiMessageFactory.createResponse(200, cancelReceivedEvent.getRequest());
                this.addStatus(cancelReceivedEvent.getRequest(), cancelOK);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a OK response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                cancelReceivedEvent.getServerTransaction().sendResponse(cancelOK);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a CANCEL OK response");
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The CANCEL OK response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            Response reqTerminated = null;
            try {
                reqTerminated = tiMessageFactory.createResponse(487, tran.getRequest());
                this.addStatus(tran.getRequest(), reqTerminated);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a req_terminated response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(reqTerminated);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a REQUEST_TERMINATED response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a REQUEST_TERMINATED response", TransactionState.COMPLETED, tran.getState());
            InviteServerTransactionsStateMachineTest.waitShortForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The REQUEST_TERMINATED response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from REQUEST_TERMINATED was sent by the TI", 487 == responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The ServerTransaction did not pas into the confirmed stateafter receiving an ACK.", TransactionState.CONFIRMED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testProceedingTerminatedScenario() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            InviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            InviteServerTransactionsStateMachineTest.assertEquals(TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("Retransmitted INVITEs should not be passed to the TU", inviteReceivedEvent);
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of INVITE", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ringing);
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            InviteServerTransactionsStateMachineTest.waitForMessage();
            inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            InviteServerTransactionsStateMachineTest.assertNull("Retransmitted INVITEs should not be passed to the TU", inviteReceivedEvent);
            InviteServerTransactionsStateMachineTest.waitLongForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("No RINGING response has been sent by the TI upon reception of an INVITE request", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI upon reception of a retransmitted invite INVITE", 180 == responseEvent.getResponse().getStatusCode());
            InviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the PROCEEDING state.", TransactionState.PROCEEDING, tran.getState());
            Response ok = null;
            try {
                ok = tiMessageFactory.createResponse(200, tran.getRequest());
                ContactHeader contact = this.createTiContact();
                ok.addHeader((Header)contact);
                ((ToHeader)ok.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
                this.addStatus(tran.getRequest(), ok);
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create an ok response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ok);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                InviteServerTransactionsStateMachineTest.fail("The TI failed to send a OK response");
            }
            InviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not move to the TERMINATED state after transmitting an OK response", TransactionState.TERMINATED, tran.getState());
            InviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            InviteServerTransactionsStateMachineTest.assertNotNull("The OK response was not received by the RI", responseEvent);
            InviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            try {
                Dialog dialog = responseEvent.getDialog();
                Request ack = dialog.createAck(((CSeqHeader)ok.getHeader("CSeq")).getSeqNumber());
                dialog.sendAck(ack);
            }
            catch (SipException ex) {
                InviteServerTransactionsStateMachineTest.fail("error sending ack ", (Exception)((Object)ex));
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            InviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        InviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(InviteServerTransactionsStateMachineTest.class);
    }
}

