/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.text.ParseException;
import java.util.LinkedList;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import test.tck.TckInternalError;
import test.tck.TestHarness;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.SipEventCollector;

public class MessageFlowHarness
extends TestHarness {
    protected static final String EXTENSION_HDR = "Status-Extension";
    protected static int counter;
    protected static long MESSAGES_ARRIVE_FOR;
    protected static int RETRY_OBJECT_DELETES;
    protected static long RETRY_OBJECT_DELETES_AFTER;
    protected static long STACKS_START_FOR;
    protected static long STACKS_SHUT_DOWN_FOR;
    protected static long TRANSACTION_TIMES_OUT_FOR;
    protected ListeningPoint riListeningPoint = null;
    protected ListeningPoint tiListeningPoint = null;
    protected SipProvider riSipProvider = null;
    protected SipProvider tiSipProvider = null;
    protected SipEventCollector eventCollector = new SipEventCollector();
    protected SipStack riSipStack;
    protected SipStack tiSipStack;

    public MessageFlowHarness(String name) {
        this(name, true);
    }

    protected MessageFlowHarness(String name, boolean autoDialog) {
        super(name, autoDialog);
        System.out.println("Initializing test " + name);
        try {
            if (riFactory != null) {
                riFactory.resetFactory();
            }
            this.riSipStack = riFactory.createSipStack(MessageFlowHarness.getRiProperties(autoDialog));
            MessageFlowHarness.assertTrue("RI must be gov.nist", this.riSipStack instanceof SIPTransactionStack);
            tiFactory.resetFactory();
            tiFactory.setPathName(this.getImplementationPath());
            this.tiSipStack = tiFactory.createSipStack(MessageFlowHarness.getTiProperties());
            if (this.riSipStack == this.tiSipStack) {
                throw new TckInternalError("riSipStack should not the same as tiSipStack");
            }
        }
        catch (TckInternalError ex) {
            throw ex;
        }
        catch (Exception ex) {
            MessageFlowHarness.fail("initialization failed");
        }
    }

    protected void addStatus(HeaderFactory headerFactory, Request request) {
        try {
            Header extension = headerFactory.createHeader(EXTENSION_HDR, new Integer(counter++).toString());
            request.addHeader(extension);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void addStatus(Request request, Response response) {
        Header extension = request.getHeader(EXTENSION_HDR);
        if (extension != null) {
            response.addHeader(extension);
        }
    }

    public void setUp() throws Exception {
        this.riListeningPoint = this.riSipStack.createListeningPoint("127.0.0.1", 6050, "udp");
        this.riSipProvider = this.riSipStack.createSipProvider(this.riListeningPoint);
        this.tiListeningPoint = this.tiSipStack.createListeningPoint("127.0.0.1", 5060, "udp");
        this.tiSipProvider = this.tiSipStack.createSipProvider(this.tiListeningPoint);
        this.riSipStack.start();
        this.tiSipStack.start();
        MessageFlowHarness.sleep(STACKS_START_FOR);
    }

    public void tearDown() throws Exception {
        int tries = 0;
        for (tries = 0; tries < RETRY_OBJECT_DELETES; ++tries) {
            try {
                this.riSipStack.deleteSipProvider(this.riSipProvider);
                break;
            }
            catch (ObjectInUseException ex) {
                MessageFlowHarness.sleep(RETRY_OBJECT_DELETES_AFTER);
                continue;
            }
        }
        if (tries >= RETRY_OBJECT_DELETES) {
            throw new TckInternalError("Failed to delete riSipProvider!");
        }
        for (tries = 0; tries < RETRY_OBJECT_DELETES; ++tries) {
            try {
                this.riSipStack.deleteListeningPoint(this.riListeningPoint);
                break;
            }
            catch (ObjectInUseException ex) {
                MessageFlowHarness.sleep(RETRY_OBJECT_DELETES_AFTER);
                continue;
            }
        }
        if (tries >= RETRY_OBJECT_DELETES) {
            throw new TckInternalError("Failed to delete riListeningPoint!");
        }
        this.riSipProvider = null;
        this.riListeningPoint = null;
        for (tries = 0; tries < RETRY_OBJECT_DELETES; ++tries) {
            try {
                this.tiSipStack.deleteSipProvider(this.tiSipProvider);
                break;
            }
            catch (ObjectInUseException ex) {
                MessageFlowHarness.sleep(RETRY_OBJECT_DELETES_AFTER);
                continue;
            }
        }
        if (tries >= RETRY_OBJECT_DELETES) {
            throw new TiUnexpectedError("Failed to delete tiSipProvider!");
        }
        for (tries = 0; tries < RETRY_OBJECT_DELETES; ++tries) {
            try {
                this.tiSipStack.deleteListeningPoint(this.tiListeningPoint);
                break;
            }
            catch (ObjectInUseException ex) {
                MessageFlowHarness.sleep(RETRY_OBJECT_DELETES_AFTER);
                continue;
            }
        }
        if (tries >= RETRY_OBJECT_DELETES) {
            throw new TiUnexpectedError("Failed to delete tiListeningPoint!");
        }
        this.riSipStack.stop();
        this.tiSipStack.stop();
        this.tiSipProvider = null;
        this.tiListeningPoint = null;
        MessageFlowHarness.sleep(STACKS_SHUT_DOWN_FOR);
    }

    protected Request createRequest(String method, AddressFactory addressFactory, HeaderFactory headerFactory, MessageFactory messageFactory, SipProvider srcProvider, SipProvider dstProvider, String contentType, String contentSubType, Object content) throws Exception {
        ListeningPoint srclp = srcProvider.getListeningPoints()[0];
        SipURI srcSipURI = addressFactory.createSipURI(null, srclp.getIPAddress());
        srcSipURI.setPort(srclp.getPort());
        srcSipURI.setTransportParam(srclp.getTransport());
        ListeningPoint dstlp = dstProvider.getListeningPoints()[0];
        SipURI dstSipURI = addressFactory.createSipURI(null, dstlp.getIPAddress());
        dstSipURI.setPort(dstlp.getPort());
        dstSipURI.setTransportParam(dstlp.getTransport());
        CallIdHeader callId = srcProvider.getNewCallId();
        callId = headerFactory.createCallIdHeader(callId.getCallId());
        CSeqHeader cSeq = headerFactory.createCSeqHeader(1L, method);
        Address fromAddress = addressFactory.createAddress((URI)srcSipURI);
        FromHeader from = headerFactory.createFromHeader(fromAddress, Integer.toString(srcProvider.hashCode()));
        Address toAddress = addressFactory.createAddress((URI)dstSipURI);
        ToHeader to = headerFactory.createToHeader(toAddress, null);
        ContactHeader contact = headerFactory.createContactHeader(fromAddress);
        LinkedList<ViaHeader> via = new LinkedList<ViaHeader>();
        ViaHeader viaHeader = headerFactory.createViaHeader(srclp.getIPAddress(), srclp.getPort(), srclp.getTransport(), "z9hG4bK" + Long.toString(System.currentTimeMillis()));
        via.add(viaHeader);
        MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(3);
        Request request = messageFactory.createRequest((URI)dstSipURI, method, callId, cSeq, from, to, via, maxForwards);
        request.addHeader((Header)contact);
        if (contentType != null && contentSubType != null && content != null) {
            ContentTypeHeader contentTypeHdr = headerFactory.createContentTypeHeader(contentType, contentSubType);
            request.setContent(content, contentTypeHdr);
        }
        this.addStatus(headerFactory, request);
        return request;
    }

    protected Request createRiInviteRequest(String contentType, String contentSubType, Object content) throws TckInternalError {
        try {
            return this.createRequest("INVITE", riAddressFactory, riHeaderFactory, riMessageFactory, this.riSipProvider, this.tiSipProvider, contentType, contentSubType, content);
        }
        catch (Throwable exc) {
            throw new TckInternalError("Failed to create an RI->TI invite request", exc);
        }
    }

    protected Request createTiInviteRequest(String contentType, String contentSubType, Object content) throws TiUnexpectedError {
        try {
            return this.createRequest("INVITE", tiAddressFactory, tiHeaderFactory, tiMessageFactory, this.tiSipProvider, this.riSipProvider, contentType, contentSubType, content);
        }
        catch (Throwable exc) {
            throw new TiUnexpectedError("Failed to create a TI->RI invite request", exc);
        }
    }

    protected Request createRiRegisterRequest() throws TckInternalError {
        try {
            return this.createRequest("REGISTER", riAddressFactory, riHeaderFactory, riMessageFactory, this.riSipProvider, this.tiSipProvider, null, null, null);
        }
        catch (Throwable exc) {
            throw new TckInternalError("Failed to create an RI->TI register request", exc);
        }
    }

    protected Request createTiRegisterRequest() throws TiUnexpectedError {
        try {
            return this.createRequest("REGISTER", tiAddressFactory, tiHeaderFactory, tiMessageFactory, this.tiSipProvider, this.riSipProvider, null, null, null);
        }
        catch (Throwable exc) {
            throw new TiUnexpectedError("Failed to create a TI->RI register request", exc);
        }
    }

    public static void waitLongForMessage() {
        MessageFlowHarness.sleep(2L * MESSAGES_ARRIVE_FOR);
    }

    public static void waitForMessage() {
        MessageFlowHarness.sleep(MESSAGES_ARRIVE_FOR);
    }

    protected static void waitForTimeout() {
        MessageFlowHarness.sleep(TRANSACTION_TIMES_OUT_FOR);
    }

    protected static void waitShortForMessage() {
        MessageFlowHarness.sleep(MESSAGES_ARRIVE_FOR / 2L);
    }

    protected static void sleep(long sleepFor) {
        long startTime = System.currentTimeMillis();
        long haveBeenSleeping = 0L;
        while (haveBeenSleeping < sleepFor) {
            try {
                if (sleepFor - haveBeenSleeping < 750L) {
                    Thread.sleep(sleepFor - haveBeenSleeping);
                } else {
                    Thread.sleep(750L);
                    System.out.print(".");
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            haveBeenSleeping = System.currentTimeMillis() - startTime;
        }
    }

    public ContactHeader createTiContact() throws Exception {
        try {
            ContactHeader contact = tiHeaderFactory.createContactHeader();
            String ip = this.tiSipProvider.getSipStack().getIPAddress();
            if (ip == null) {
                ListeningPoint lp = (ListeningPoint)this.tiSipProvider.getSipStack().getListeningPoints().next();
                ip = lp.getIPAddress();
            }
            SipURI srcSipURI = tiAddressFactory.createSipURI(null, ip);
            srcSipURI.setPort(this.tiSipProvider.getListeningPoint("udp").getPort());
            srcSipURI.setTransportParam("udp");
            Address address = tiAddressFactory.createAddress((URI)srcSipURI);
            address.setDisplayName("TI Contact");
            contact.setAddress(address);
            return contact;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageFlowHarness.assertTrue(false);
            throw ex;
        }
    }

    public ContactHeader createRiContact() throws TckInternalError {
        try {
            ContactHeader contact = riHeaderFactory.createContactHeader();
            ListeningPoint lp = this.riSipProvider.getListeningPoints()[0];
            SipURI srcSipURI = riAddressFactory.createSipURI(null, lp.getIPAddress());
            srcSipURI.setPort(lp.getPort());
            srcSipURI.setTransportParam(lp.getTransport());
            Address address = riAddressFactory.createAddress((URI)srcSipURI);
            address.setDisplayName("RI Contact");
            contact.setAddress(address);
            return contact;
        }
        catch (Exception ex) {
            throw new TckInternalError(ex.getMessage());
        }
    }

    static {
        MESSAGES_ARRIVE_FOR = 2500L;
        RETRY_OBJECT_DELETES = 10;
        RETRY_OBJECT_DELETES_AFTER = 500L;
        STACKS_START_FOR = 1000L;
        STACKS_SHUT_DOWN_FOR = 500L;
        TRANSACTION_TIMES_OUT_FOR = 38000L;
    }
}

