/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class NonInviteClientTransactionsStateMachineTest
extends MessageFlowHarness {
    public NonInviteClientTransactionsStateMachineTest(String name) {
        super(name);
    }

    public void testTryingProceedingCompletedTerminatedScenario() {
        try {
            Request register = this.createTiRegisterRequest();
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(register);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (registerReceivedEvent == null || registerReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The REGISTER request was not received by the RI!");
            }
            NonInviteClientTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                NonInviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The REGISTER request was not retransmitted!", registerReceivedEvent);
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The REGISTER request was not retransmitted!", registerReceivedEvent.getRequest());
            NonInviteClientTransactionsStateMachineTest.assertEquals("REGISTER", registerReceivedEvent.getRequest().getMethod());
            NonInviteClientTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                Response res = riMessageFactory.createResponse(100, registerReceivedEvent.getRequest());
                this.addStatus(registerReceivedEvent.getRequest(), res);
                this.riSipProvider.sendResponse(res);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a trying response back to the TI", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent);
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 1xx response to the TU!", responseEvent.getResponse());
            NonInviteClientTransactionsStateMachineTest.assertTrue("A response different from TRYING was passed to the TU!", responseEvent.getResponse().getStatusCode() == 100);
            NonInviteClientTransactionsStateMachineTest.assertSame("The TRYING response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            NonInviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the PROCEEDING state after receiving 1xx provisional response", tran.getState(), TransactionState.PROCEEDING);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, registerReceivedEvent.getRequest());
                this.addStatus(registerReceivedEvent.getRequest(), ok);
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a OK response back to the TI", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200-699 response to the TU!", responseEvent);
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200-699 response to the TU!", responseEvent.getResponse());
            NonInviteClientTransactionsStateMachineTest.assertSame("The OK response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            NonInviteClientTransactionsStateMachineTest.assertSame("A response different from OK was passed to the TU", tran, responseEvent.getClientTransaction());
            NonInviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the COMPLETED state after receiving 200-699 final response", tran.getState(), TransactionState.COMPLETED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK request in a non INVITE transaction", ackReceivedEvent);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a OK response back to the TI", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The Tested Implementation passed a retransmitted 200-699 response to the TU.", responseEvent);
            NonInviteClientTransactionsStateMachineTest.assertTrue("The ClientTransaction did not stay long enough in the COMPLETED state.", tran.getState().equals((Object)TransactionState.COMPLETED) || tran.getState().equals((Object)TransactionState.TERMINATED));
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The TI replied with an ACK to a nonINVITE request", ackReceivedEvent);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            NonInviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        NonInviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testTryingCompletedTerminatedScenario() {
        try {
            Request register = this.createTiRegisterRequest();
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
                tran = this.tiSipProvider.getNewClientTransaction(register);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            RequestEvent registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (registerReceivedEvent == null || registerReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The REGISTER request was not received by the RI!");
            }
            NonInviteClientTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            try {
                this.eventCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            if ((long)tran.getRetransmitTimer() > MESSAGES_ARRIVE_FOR) {
                NonInviteClientTransactionsStateMachineTest.sleep((long)tran.getRetransmitTimer() - MESSAGES_ARRIVE_FOR);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The REGISTER request was not retransmitted!", registerReceivedEvent);
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The REGISTER request was not retransmitted!", registerReceivedEvent.getRequest());
            NonInviteClientTransactionsStateMachineTest.assertEquals("REGISTER", registerReceivedEvent.getRequest().getMethod());
            NonInviteClientTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response ok = null;
            try {
                ok = riMessageFactory.createResponse(200, registerReceivedEvent.getRequest());
                this.addStatus(registerReceivedEvent.getRequest(), ok);
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a OK response back to the TI", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200-699 response to the TU!", responseEvent);
            NonInviteClientTransactionsStateMachineTest.assertNotNull("The Tested Implementation did not pass a 200-699 response to the TU!", responseEvent.getResponse());
            NonInviteClientTransactionsStateMachineTest.assertSame("The OK response was not associated with the right transaction", tran, responseEvent.getClientTransaction());
            NonInviteClientTransactionsStateMachineTest.assertSame("A response different from OK was passed to the TU", tran, responseEvent.getClientTransaction());
            NonInviteClientTransactionsStateMachineTest.assertEquals("The ClientTransaction did not pass in the COMPLETED state after receiving 200-699 final response", tran.getState(), TransactionState.COMPLETED);
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The TI sent an ACK request in a non INVITE transaction", ackReceivedEvent);
            try {
                this.eventCollector.collectResponseEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                ackCollector.collectRequestEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            try {
                this.riSipProvider.sendResponse((Response)ok.clone());
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a OK response back to the TI", ex);
            }
            NonInviteClientTransactionsStateMachineTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The Tested Implementation passed a retransmitted 200-699 response to the TU.", responseEvent);
            NonInviteClientTransactionsStateMachineTest.assertTrue("The ClientTransaction did not stay long enough in the COMPLETED state.", tran.getState().equals((Object)TransactionState.COMPLETED) || tran.getState().equals((Object)TransactionState.TERMINATED));
            ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            NonInviteClientTransactionsStateMachineTest.assertNull("The TI replied with an ACK to a nonINVITE request", ackReceivedEvent);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            NonInviteClientTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        NonInviteClientTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(NonInviteClientTransactionsStateMachineTest.class);
    }
}

