/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class NonInviteServerTransactionsStateMachineTest
extends MessageFlowHarness {
    public NonInviteServerTransactionsStateMachineTest(String name) {
        super(name);
    }

    public void testTryingProceedingCompletedScenario() {
        try {
            Request register = this.createRiRegisterRequest();
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (registerReceivedEvent == null || registerReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial register request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(registerReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NonInviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            NonInviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            NonInviteServerTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            Response trying = null;
            try {
                trying = tiMessageFactory.createResponse(100, registerReceivedEvent.getRequest());
                tran.sendResponse(trying);
            }
            catch (Exception ex) {
                throw new TiUnexpectedError("Failed to send a TRYING response", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            NonInviteServerTransactionsStateMachineTest.assertEquals("The transaction did not pass into the PROCEEDING state upon transmission of a 1xx response.", TransactionState.PROCEEDING, tran.getState());
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("The TRYING response has not been sent by the TI.", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI", 100 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteServerTransactionsStateMachineTest.assertNull("Retransmitted REGISTERs should not be passed to the TU", registerReceivedEvent);
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been resent by the TI upon reception of a retransmitted REGISTER request", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of a retransmitted REGISTER", 100 == responseEvent.getResponse().getStatusCode());
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ((ToHeader)ringing.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                NonInviteServerTransactionsStateMachineTest.fail("The TI failed to send a RINGING response");
            }
            NonInviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain PROCEEDING after transmitting a RINGING response", TransactionState.PROCEEDING, tran.getState());
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("The RINGING response was not received by the RI", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI", 180 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteServerTransactionsStateMachineTest.assertNull("Retransmitted REGISTERs should not be passed to the TU", registerReceivedEvent);
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("No RINGING response has been sent by the TI upon reception of an REGISTER request", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from RINGING was sent by the TI upon reception of a retransmitted REGISTER", 180 == responseEvent.getResponse().getStatusCode());
            NonInviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the PROCEEDING state.", TransactionState.PROCEEDING, tran.getState());
            Response ok = null;
            try {
                ok = tiMessageFactory.createResponse(200, tran.getRequest());
                ((ToHeader)ok.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a busy_here response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ok);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                NonInviteServerTransactionsStateMachineTest.fail("The TI failed to send a OK response");
            }
            NonInviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a BUSY_HERE response", TransactionState.COMPLETED, tran.getState());
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("The OK response was not received by the RI", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteServerTransactionsStateMachineTest.assertNull("Retransmitted REGISTERs should not be passed to the TU", registerReceivedEvent);
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("No OK response has been sent by the TI upon reception of a retransmitted REGISTER request", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI upon reception of a retransmitted invite REGISTER", 200 == responseEvent.getResponse().getStatusCode());
            NonInviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the COMPLETED state.", TransactionState.COMPLETED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            NonInviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        NonInviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testTryingCompletedScenario() {
        try {
            Request register = this.createRiRegisterRequest();
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            RequestEvent registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (registerReceivedEvent == null || registerReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial REGISTER request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(registerReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NonInviteServerTransactionsStateMachineTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            NonInviteServerTransactionsStateMachineTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            NonInviteServerTransactionsStateMachineTest.assertEquals(TransactionState.TRYING, tran.getState());
            Response trying = null;
            try {
                trying = tiMessageFactory.createResponse(100, registerReceivedEvent.getRequest());
                tran.sendResponse(trying);
            }
            catch (Exception ex) {
                throw new TiUnexpectedError("Failed to send a TRYING response", ex);
            }
            NonInviteServerTransactionsStateMachineTest.assertEquals("The transaction did not pass into the PROCEEDING state upon transmission of a 1xx response.", TransactionState.PROCEEDING, tran.getState());
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            ResponseEvent responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("The TRYING response has not been sent by the TI.", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI", 100 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteServerTransactionsStateMachineTest.assertNull("Retransmitted REGISTERs should not be passed to the TU", registerReceivedEvent);
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("No TRYING response has been resent by the TI upon reception of a retransmitted REGISTER request", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from 100 was sent by the TI upon reception of a retransmitted REGISTER", 100 == responseEvent.getResponse().getStatusCode());
            Response ok = null;
            try {
                ok = tiMessageFactory.createResponse(200, tran.getRequest());
                ((ToHeader)ok.getHeader("To")).setTag(Integer.toString(((Object)((Object)this)).hashCode()));
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a busy_here response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ok);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                NonInviteServerTransactionsStateMachineTest.fail("The TI failed to send a OK response");
            }
            NonInviteServerTransactionsStateMachineTest.assertEquals("The Transaction did not remain COMPLETED after transmitting a BUSY_HERE response", TransactionState.COMPLETED, tran.getState());
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("The OK response was not received by the RI", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI", 200 == responseEvent.getResponse().getStatusCode());
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(register);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            registerReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            NonInviteServerTransactionsStateMachineTest.assertNull("Retransmitted REGISTERs should not be passed to the TU", registerReceivedEvent);
            NonInviteServerTransactionsStateMachineTest.waitForMessage();
            responseEvent = responseCollector.extractCollectedResponseEvent();
            NonInviteServerTransactionsStateMachineTest.assertNotNull("No OK response has been sent by the TI upon reception of a retransmitted REGISTER request", responseEvent);
            NonInviteServerTransactionsStateMachineTest.assertTrue("A response different from OK was sent by the TI upon reception of a retransmitted invite REGISTER", 200 == responseEvent.getResponse().getStatusCode());
            NonInviteServerTransactionsStateMachineTest.assertEquals("The server transaction left the COMPLETED state.", TransactionState.COMPLETED, tran.getState());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            NonInviteServerTransactionsStateMachineTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        NonInviteServerTransactionsStateMachineTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(NonInviteServerTransactionsStateMachineTest.class);
    }
}

