/*
 * Decompiled with CFR 0.152.
 */
package test.tck.msgflow;

import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import junit.framework.Test;
import junit.framework.TestSuite;
import test.tck.TckInternalError;
import test.tck.TiUnexpectedError;
import test.tck.msgflow.MessageFlowHarness;
import test.tck.msgflow.SipEventCollector;

public class ServerTransactionTest
extends MessageFlowHarness {
    public ServerTransactionTest(String name) {
        super(name);
    }

    public void testSendResponse() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            SipEventCollector responseCollector = new SipEventCollector();
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                this.riSipProvider.sendRequest(invite);
            }
            catch (SipException ex) {
                throw new TckInternalError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with a TI SipProvider", ex);
            }
            ServerTransactionTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The initial invite request was not received by the TI!");
            }
            ServerTransaction tran = null;
            try {
                tran = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ServerTransactionTest.fail(ex.getClass().getName() + "was thrown while trying to " + "create the server transaction");
            }
            ServerTransactionTest.assertNotNull("tiSipProvider.getNewServerTransaction() returned null", tran);
            Response ringing = null;
            try {
                ringing = tiMessageFactory.createResponse(180, tran.getRequest());
                ringing.setHeader((Header)this.createTiContact());
            }
            catch (ParseException ex) {
                throw new TiUnexpectedError("A ParseException was thrown while trying to create a ringing response using TI", ex);
            }
            try {
                responseCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to register a SipListener with an RI SipProvider", ex);
            }
            try {
                tran.sendResponse(ringing);
            }
            catch (SipException ex) {
                ex.printStackTrace();
                ServerTransactionTest.fail("The TI failed to send a RINGING response");
            }
            responseCollector.extractCollectedResponseEvent();
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            ServerTransactionTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        ServerTransactionTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public void testCancel() {
        try {
            Request invite = this.createRiInviteRequest(null, null, null);
            ClientTransaction tran = null;
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                tran = this.riSipProvider.getNewClientTransaction(invite);
                tran.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send request!", ex);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            ServerTransactionTest.waitForMessage();
            RequestEvent inviteReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            ServerTransaction st = this.tiSipProvider.getNewServerTransaction(inviteReceivedEvent.getRequest());
            Request inviteRequest = inviteReceivedEvent.getRequest();
            Dialog dialog = st.getDialog();
            ServerTransactionTest.assertNotNull("Dialog ID must be valid", dialog);
            if (inviteReceivedEvent == null || inviteReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The invite request was not received by the TI!");
            }
            ServerTransactionTest.assertEquals(TransactionState.CALLING, tran.getState());
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            try {
                Response resp = tiMessageFactory.createResponse(100, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), resp);
                st.sendResponse(resp);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a trying response back to the TI", ex);
            }
            ServerTransactionTest.waitForMessage();
            ResponseEvent responseEvent = this.eventCollector.extractCollectedResponseEvent();
            ServerTransactionTest.assertNotNull("Response must be seen", responseEvent);
            ServerTransactionTest.assertEquals((String)"Must see 100 trying response", (int)responseEvent.getResponse().getStatusCode(), (int)100);
            Request riCancel = tran.createCancel();
            try {
                this.eventCollector.collectRequestEvent(this.tiSipProvider);
                ClientTransaction riCancelTrans = this.riSipProvider.getNewClientTransaction(riCancel);
                riCancelTrans.sendRequest();
            }
            catch (SipException ex) {
                throw new TiUnexpectedError("A SipExceptionOccurred while trying to send CANCEL!", ex);
            }
            ServerTransactionTest.waitForMessage();
            RequestEvent cancelReceivedEvent = this.eventCollector.extractCollectedRequestEvent();
            if (cancelReceivedEvent == null || cancelReceivedEvent.getRequest() == null) {
                throw new TiUnexpectedError("The CANCEL request was not received by the TI!");
            }
            ServerTransactionTest.assertNotNull("Cancel dialog must be non null", cancelReceivedEvent.getDialog() != null);
            ServerTransactionTest.assertSame("Cancel dialog must match Invite", cancelReceivedEvent.getDialog(), dialog);
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            Response tiCancelOk = null;
            try {
                tiCancelOk = tiMessageFactory.createResponse(200, cancelReceivedEvent.getRequest());
                this.addStatus(cancelReceivedEvent.getRequest(), tiCancelOk);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TI could not send a CANCEL OK response back to the RI", ex);
            }
            ServerTransaction cancelTx = cancelReceivedEvent.getServerTransaction();
            ServerTransactionTest.assertNotNull("Must have valid cancel tx", cancelTx);
            ServerTransactionTest.assertTrue("Cancel tx must not be the same as the invite Tx", cancelTx != st);
            ServerTransactionTest.assertTrue("Method must be cancel ", cancelTx.getRequest().getMethod().equals("CANCEL"));
            ServerTransactionTest.assertTrue("Branch must match invite branch", ((ViaHeader)cancelTx.getRequest().getHeader("Via")).getBranch().equals(((ViaHeader)inviteRequest.getHeader("Via")).getBranch()));
            cancelTx.sendResponse(tiCancelOk);
            ServerTransactionTest.waitForMessage();
            responseEvent = this.eventCollector.extractCollectedResponseEvent();
            if (responseEvent == null || responseEvent.getResponse() == null) {
                throw new TiUnexpectedError("The CANCEL OK response was not received by the RI!");
            }
            ServerTransactionTest.assertEquals((String)"Must see a 200", (int)this.eventCollector.extractCollectedResponseEvent().getResponse().getStatusCode(), (int)200);
            try {
                this.eventCollector.collectResponseEvent(this.riSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TiUnexpectedError("Failed to register a SipListener with TI", ex);
            }
            SipEventCollector ackCollector = new SipEventCollector();
            try {
                ackCollector.collectRequestEvent(this.tiSipProvider);
            }
            catch (TooManyListenersException ex) {
                throw new TckInternalError("Failed to regiest a SipListener with an RI SipProvider", ex);
            }
            Response tiInviteTerminated = null;
            try {
                tiInviteTerminated = tiMessageFactory.createResponse(487, inviteReceivedEvent.getRequest());
                this.addStatus(inviteReceivedEvent.getRequest(), tiInviteTerminated);
                st.sendResponse(tiInviteTerminated);
            }
            catch (Throwable ex) {
                throw new TckInternalError("The TCK could not send a INVITE 487 response back to the TI", ex);
            }
            ServerTransactionTest.waitForMessage();
            ServerTransactionTest.assertEquals((String)"Must see a 487", (int)this.eventCollector.extractCollectedResponseEvent().getResponse().getStatusCode(), (int)487);
            ServerTransactionTest.waitForMessage();
            RequestEvent ackReceivedEvent = ackCollector.extractCollectedRequestEvent();
            ServerTransactionTest.assertNull("The TI MUST NOT see the ACK", ackReceivedEvent);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            ServerTransactionTest.fail(exc.getClass().getName() + ": " + exc.getMessage());
        }
        ServerTransactionTest.assertTrue(new Exception().getStackTrace()[0].toString(), true);
    }

    public static Test suite() {
        return new TestSuite(ServerTransactionTest.class);
    }
}

